/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.math;

import java.io.Serializable;
import java.util.StringTokenizer;

import org.vcell.util.Compare;
import org.vcell.util.EqualsUtil;
import org.vcell.util.Issue.IssueSource;
import org.vcell.util.Matchable;
import org.vcell.util.TokenMangler;

import cbit.vcell.geometry.GeometryClass;
import cbit.vcell.parser.Expression;
import cbit.vcell.parser.ExpressionBindingException;
import cbit.vcell.parser.ExpressionException;
import cbit.vcell.parser.NameScope;
import cbit.vcell.parser.SymbolTable;
import cbit.vcell.parser.SymbolTableEntry;
import cbit.vcell.units.VCUnitDefinition;
/**
 * This class was generated by a SmartGuide.
 * 
 */
@SuppressWarnings("serial")
public abstract class Variable extends CommentedObject implements SymbolTableEntry, Serializable, Matchable, VCMLProvider, IssueSource {
	private String name = null;
	private transient int symbolTableIndex = -1;
	private Domain domain = null;  // global if null
	public static final String COMBINED_IDENTIFIER_SEPARATOR = "::";

    void rename(String newName) {
		this.name = newName;
    }

    public static class Domain implements Matchable, Serializable {
		private String name = null;
		
		public Domain(String argName){
			String nameWithPeriodsMangled = argName.replace('.','_');
			if (!nameWithPeriodsMangled.equals(TokenMangler.fixTokenStrict(nameWithPeriodsMangled))){
				throw new RuntimeException("unexpected character sequence in domain name "+argName);
			}
			this.name = argName;
		}
		public Domain(GeometryClass geometryClass){
			this(geometryClass.getName());
		}
		public Domain(SubDomain subDomain) {
			this(subDomain.getName());
		}
		public String getName(){
			return this.name;
		}
		public boolean compareEqual(Matchable object) {
			if (object instanceof Domain){
				Domain domain = (Domain)object;

				if (!getName().equals(domain.getName())){
					return false;
				}
				return true;
			}
			return false;
		}
		@Override
		public String toString(){
			return super.toString();
		}
	}
	
/**
 * This method was created by a SmartGuide.
 * @param name java.lang.String
 */
protected Variable (String argName, Domain argDomain ) {
	if (argName == null) {
		throw new IllegalArgumentException("Variable does not have a name");
	}
	String nameWithPeriodsMangled = argName.replace('.','_');
	if (!nameWithPeriodsMangled.equals(TokenMangler.fixTokenStrict(nameWithPeriodsMangled))){
		throw new RuntimeException("unexpected character sequence in variable name "+argName);
	}
	this.name = argName;
	this.domain = argDomain;
}
/**
 * This method was created in VisualAge.
 * @param symbolTable cbit.vcell.parser.SymbolTable
 */
public void bind(SymbolTable symbolTable) throws ExpressionBindingException {
	if (getExpression()!=null){
		getExpression().bindExpression(symbolTable);
	}
}

public static String getNameFromCombinedIdentifier(String combinedIdentifier){
	String name = combinedIdentifier;
	if (name.contains(COMBINED_IDENTIFIER_SEPARATOR)){
		StringTokenizer tokenizer = new StringTokenizer(name,COMBINED_IDENTIFIER_SEPARATOR,false);
		@SuppressWarnings("unused")
		String domainString = tokenizer.nextToken(); // throw away
		name = tokenizer.nextToken();
	}
	return name;
}

public static Domain getDomainFromCombinedIdentifier(String combinedIdentifier){
	if (combinedIdentifier.contains(COMBINED_IDENTIFIER_SEPARATOR)){
		StringTokenizer tokenizer = new StringTokenizer(combinedIdentifier,COMBINED_IDENTIFIER_SEPARATOR,false);
		String domainName = tokenizer.nextToken();
		if (!domainName.equals("null")){
			return new Domain(domainName);
		}else{
			return null;
		}
	}else{
		return null;
	}
}

@Override
public final boolean compareEqual(Matchable object){
	return super.compareEqual(object) && compareEqual(object,false);	
}

public abstract boolean compareEqual(Matchable object, boolean bIgnoreMissingDomains);

/**
 * This method was created in VisualAge.
 * @return boolean
 * @param object java.lang.Object
 */
protected boolean compareEqual0(Matchable object, boolean bIgnoreMissingDomain) {
	Boolean tc = EqualsUtil.typeCompare(this, object);
	if (tc != null) {
		return tc;
	}
	Variable var = (Variable)object;

	//
	// compare names
	//
	if (!getName().equals(var.getName())){
		return false;
	}

	//
	// compare domains
	//
	if (!bIgnoreMissingDomain){
		if (!Compare.isEqualOrNull(getDomain(),var.getDomain())){
			return false;
		}
	}else{
		if (getDomain()!=null && var.getDomain()!=null){
			if (!Compare.isEqual(getDomain(),var.getDomain())){
				return false;
			}
		}
	}

	return true;
}
/**
 * This method was created in VisualAge.
 * @return double
 */
public double getConstantValue() throws ExpressionException {
	throw new ExpressionException("constant value not supported");
}
/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.parser.Expression
 * @exception java.lang.Exception The exception description.
 */
public Expression getExpression() {
	return null;
}
/**
 * This method was created in VisualAge.
 * @return int
 */
public int getIndex() {
	return symbolTableIndex;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String getName() {
	return name;
}
/**
 * Insert the method's description here.
 * Creation date: (7/31/2003 10:31:25 AM)
 * @return cbit.vcell.parser.NameScope
 */
public NameScope getNameScope() {
	return null;
}

@Override
public boolean hasNameScope() {
	return false;
}

/**
 * Insert the method's description here.
 * Creation date: (3/31/2004 3:02:23 PM)
 * @return cbit.vcell.units.VCUnitDefinition
 */
public VCUnitDefinition getUnitDefinition() {
	return null;
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public abstract String getVCML() throws MathException;

/**
 * This method was created by a SmartGuide.
 * @return boolean
 * @exception java.lang.Exception The exception description.
 */
public boolean isConstant() {
	return false;
}	
/**
 * This method was created in VisualAge.
 * @param symbolTableIndex int
 */
public void setIndex(int symbolTableIndex) {
	this.symbolTableIndex = symbolTableIndex;
}
/**
 * This method was created in VisualAge.
 * @return java.lang.String
 */
public String toString() {
	return getClass().getSimpleName()+" <"+getQualifiedName()+">";
}
public Domain getDomain() {
	return this.domain;
}
public void setDomain(Domain domain) {
	this.domain = domain;
}
public String getQualifiedName(){
	if (getDomain()!=null){
		return getDomain().getName() + COMBINED_IDENTIFIER_SEPARATOR +getName();
	}else{
		return getName();
	}
}
}
