/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.mapping;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.vcell.model.rbm.MolecularType;
import org.vcell.util.*;

import cbit.vcell.mapping.SimulationContext.Application;
import cbit.vcell.mapping.SpeciesContextSpec.SpeciesContextSpecParameter;
import cbit.vcell.model.Model;
import cbit.vcell.model.Model.ModelParameter;
import cbit.vcell.model.Model.RbmModelContainer;
import cbit.vcell.model.Parameter;
import cbit.vcell.model.ReactionRule;
import cbit.vcell.model.ReactionStep;
import cbit.vcell.model.SpeciesContext;
import cbit.vcell.model.Structure;
import cbit.vcell.parser.Expression;
import cbit.vcell.parser.ExpressionException;
import cbit.vcell.units.VCUnitDefinition;
/**
 * This class was generated by a SmartGuide.
 *  
 */
public  class ReactionContext implements Serializable, Matchable, PropertyChangeListener, VetoableChangeListener {
	private final static Logger lg = LogManager.getLogger(ReactionContext.class);

	protected transient java.beans.VetoableChangeSupport vetoPropertyChange;
	protected transient java.beans.PropertyChangeSupport propertyChange;
	private ReactionSpec[] fieldReactionSpecs = new ReactionSpec[0];
	private ReactionRuleSpec[] fieldReactionRuleSpecs = new ReactionRuleSpec[0];
	private SpeciesContextSpec[] fieldSpeciesContextSpecs = new SpeciesContextSpec[0];
	private Model fieldModel = null;
	private SimulationContext simContext = null;

ReactionContext(ReactionContext reactionContext, SimulationContext argSimulationContext) {
	this.fieldModel = reactionContext.fieldModel;
	this.simContext = argSimulationContext;
	fieldReactionSpecs = new ReactionSpec[reactionContext.fieldReactionSpecs.length];
	for (int i = 0; i < reactionContext.fieldReactionSpecs.length; i++){
		fieldReactionSpecs[i] = new ReactionSpec(reactionContext.fieldReactionSpecs[i], argSimulationContext);
	}
	fieldReactionRuleSpecs = new ReactionRuleSpec[reactionContext.fieldReactionRuleSpecs.length];
	for (int i = 0; i < reactionContext.fieldReactionRuleSpecs.length; i++){
		fieldReactionRuleSpecs[i] = new ReactionRuleSpec(reactionContext.fieldReactionRuleSpecs[i]);
	}
	fieldSpeciesContextSpecs = new SpeciesContextSpec[reactionContext.fieldSpeciesContextSpecs.length];
	for (int i = 0; i < reactionContext.fieldSpeciesContextSpecs.length; i++){
		fieldSpeciesContextSpecs[i] = new SpeciesContextSpec(reactionContext.fieldSpeciesContextSpecs[i],simContext);
	}	
	refreshDependencies();
}


ReactionContext (Model argModel, SimulationContext argSimulationContext) {
	this.fieldModel = argModel;
	if (argModel != null){
		argModel.addPropertyChangeListener(this);
	}
	this.simContext = argSimulationContext;
	refreshDependencies();
	refreshAll();
}


/**
 * The addPropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().addPropertyChangeListener(listener);
}


/**
 * The addVetoableChangeListener method was generated to support the vetoPropertyChange field.
 */
public synchronized void addVetoableChangeListener(java.beans.VetoableChangeListener listener) {
	getVetoPropertyChange().addVetoableChangeListener(listener);
}


/**
 * This method was created in VisualAge.
 * @return boolean
 * @param object java.lang.Object
 */
public boolean compareEqual(Matchable object) {
	ReactionContext reactContext = null;
	if (!(object instanceof ReactionContext)){
		return false;
	}else{
		reactContext = (ReactionContext)object;
	}

	if (!Compare.isEqual(fieldModel,reactContext.fieldModel)){
		return false;
	}
	
	if (!Compare.isEqual(fieldSpeciesContextSpecs, reactContext.fieldSpeciesContextSpecs)){
		return false;
	}
	
	if (!Compare.isEqual(fieldReactionSpecs, reactContext.fieldReactionSpecs)){
		return false;
	}
	
	if (!Compare.isEqual(fieldReactionRuleSpecs, reactContext.fieldReactionRuleSpecs)){
		return false;
	}
	
	return true;
}

/**
 * The firePropertyChange method was generated to support the propertyChange field.
 */
public void firePropertyChange(java.lang.String propertyName, java.lang.Object oldValue, java.lang.Object newValue) {
	getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
}

/**
 * The fireVetoableChange method was generated to support the vetoPropertyChange field.
 */
public void fireVetoableChange(java.lang.String propertyName, java.lang.Object oldValue, java.lang.Object newValue) throws java.beans.PropertyVetoException {
	getVetoPropertyChange().fireVetoableChange(propertyName, oldValue, newValue);
}

/**
 * Insert the method's description here.
 * Creation date: (11/1/2005 9:44:36 AM)
 * @param issueVector java.util.Vector
 */
public void gatherIssues(IssueContext issueContext, List<Issue> issueVector) {
	for (int i = 0; fieldSpeciesContextSpecs!=null && i < fieldSpeciesContextSpecs.length; i++){
		fieldSpeciesContextSpecs[i].gatherIssues(issueContext,issueVector);
	}
	for (int i = 0; fieldReactionSpecs!=null && i < fieldReactionSpecs.length; i++){
		fieldReactionSpecs[i].gatherIssues(issueContext,issueVector, this);
	}
	for (int i = 0; fieldReactionRuleSpecs!=null && i < fieldReactionRuleSpecs.length; i++){
		fieldReactionRuleSpecs[i].gatherIssues(issueContext,issueVector, this);
	}
}


/**
 * Gets the model property (cbit.vcell.model.Model) value.
 * @return The model property value.
 * @see #setModel
 */
public Model getModel() {
	return fieldModel;
}

/**
 * Accessor for the propertyChange field.
 */
protected java.beans.PropertyChangeSupport getPropertyChange() {
	if (propertyChange == null) {
		propertyChange = new java.beans.PropertyChangeSupport(this);
	};
	return propertyChange;
}


public ReactionSpec getReactionSpec(ReactionStep reactionStep) {
	for (int i=0;fieldReactionSpecs!=null && i<fieldReactionSpecs.length;i++){
		if (fieldReactionSpecs[i].getReactionStep() == reactionStep){
			return fieldReactionSpecs[i];
		}
	}
	return null;
}

public ReactionRuleSpec getReactionRuleSpec(ReactionRule reactionRule) {
	for (int i=0;fieldReactionRuleSpecs!=null && i<fieldReactionRuleSpecs.length;i++){
		if (fieldReactionRuleSpecs[i].getReactionRule() == reactionRule){
			return fieldReactionRuleSpecs[i];
		}
	}
	return null;
}


/**
 * Gets the reactionSpecs property (cbit.vcell.mapping.ReactionSpec[]) value.
 * @return The reactionSpecs property value.
 * @see #setReactionSpecs
 */
public ReactionSpec[] getReactionSpecs() {
	return fieldReactionSpecs;
}

public ReactionRuleSpec[] getReactionRuleSpecs() {
	return fieldReactionRuleSpecs;
}

/**
 * Insert the method's description here.
 * Creation date: (4/4/2004 10:41:23 AM)
 * @return cbit.vcell.mapping.SimulationContext
 */
public SimulationContext getSimulationContext() {
	return simContext;
}


/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.mapping.SpeciesContextSpec
 * @param speciesContext cbit.vcell.model.SpeciesContext
 */
public SpeciesContextSpec getSpeciesContextSpec(SpeciesContext speciesContext) {
	for (int i=0;i<fieldSpeciesContextSpecs.length;i++){
		SpeciesContextSpec scs = fieldSpeciesContextSpecs[i];
		if (scs.getSpeciesContext() == speciesContext){
			return scs;
		}
	}
	return null;
}			

/**
 * Gets the speciesContextSpecs property (cbit.vcell.mapping.SpeciesContextSpec[]) value.
 * @return The speciesContextSpecs property value.
 * @see #setSpeciesContextSpecs
 */
public SpeciesContextSpec[] getSpeciesContextSpecs() {
	return fieldSpeciesContextSpecs;
}


/**
 * Gets the speciesContextSpecs index property (cbit.vcell.mapping.SpeciesContextSpec) value.
 * @return The speciesContextSpecs property value.
 * @param index The index value into the property array.
 * @see #setSpeciesContextSpecs
 */
public SpeciesContextSpec getSpeciesContextSpecs(int index) {
	return getSpeciesContextSpecs()[index];
}

/**
 * Accessor for the vetoPropertyChange field.
 */
protected java.beans.VetoableChangeSupport getVetoPropertyChange() {
	if (vetoPropertyChange == null) {
		vetoPropertyChange = new java.beans.VetoableChangeSupport(this);
	};
	return vetoPropertyChange;
}


/**
 * The hasListeners method was generated to support the propertyChange field.
 */
public synchronized boolean hasListeners(java.lang.String propertyName) {
	return getPropertyChange().hasListeners(propertyName);
}


	/**
	 * This method gets called when a bound property is changed.
	 * @param evt A PropertyChangeEvent object describing the event source 
	 *   	and the property that has changed.
	 */
public void propertyChange(java.beans.PropertyChangeEvent evt) {
	if (evt.getSource().equals(getModel()) && evt.getPropertyName().equals(Model.PROPERTY_NAME_REACTION_STEPS)) {
		refreshAll();
	}
	if (evt.getSource().equals(getModel()) && evt.getPropertyName().equals(RbmModelContainer.PROPERTY_NAME_REACTION_RULE_LIST)){
		refreshAll();
	}
	if(evt.getSource().equals(getModel()) && evt.getPropertyName().equals(Model.PROPERTY_NAME_SPECIES_CONTEXT_SPECIES_PATTERN)) {
		refreshSpeciesContextSpecsSpeciesPatterns();	// only for springsalad, because we care about the sites (site attributes spec, internal link spec)
	}
	if (evt.getSource().equals(getModel()) && evt.getPropertyName().equals(RbmModelContainer.PROPERTY_NAME_MOLECULAR_TYPE_LIST)){
		;	// do nothing
	}
	if (evt.getSource().equals(getModel()) && evt.getPropertyName().equals(Model.PROPERTY_NAME_SPECIES_CONTEXTS)){
		refreshAll();
	}
	if (evt.getSource().equals(getModel()) && evt.getPropertyName().equals(MolecularType.PROPERTY_NAME_COMPONENT_LIST)) {
		if(evt.getOldValue() instanceof MolecularType) {
			refreshSpeciesContextSpecs((MolecularType)evt.getOldValue());
		} else {
			throw new RuntimeException("evt.getOldValue() must be a MolecularType");
		}

	}
}

private void refreshAll()
{
	try {
		refreshSpeciesContextSpecs();
		refreshReactionSpecs();
		refreshReactionRuleSpecs();
		if (simContext!=null){
			refreshSpeciesContextSpecBoundaryUnits(simContext.getGeometryContext().getStructureMappings());
		}
	}catch (Exception e){
		lg.error(e.getMessage(), e);
	}		
	return;
}


/**
 * This method was created in VisualAge.
 */
public void refreshDependencies() {
	removePropertyChangeListener(this);
	addPropertyChangeListener(this);
	
	fieldModel.removePropertyChangeListener(this);
	fieldModel.addPropertyChangeListener(this);
	fieldModel.removeVetoableChangeListener(this);
	fieldModel.addVetoableChangeListener(this);

	//fieldModel.refreshDependencies();

	for (int i=0;i<fieldSpeciesContextSpecs.length;i++){
		fieldSpeciesContextSpecs[i].setSimulationContext(simContext);
		fieldSpeciesContextSpecs[i].refreshDependencies();
	}
	refreshSpeciesContextSpecBoundaryUnits(simContext.getGeometryContext().getStructureMappings());
	for (int i=0;i<fieldReactionSpecs.length;i++){
		fieldReactionSpecs[i].refreshDependencies();
	}
}


/**
 * This method was created by a SmartGuide.
 */
private void refreshReactionSpecs() throws java.beans.PropertyVetoException {

	//
	// if any reactionStep deleted, remove reactionSpec (reaction mapping)
	//
	boolean bChanged = false;
	ArrayList<ReactionSpec> reactionSpecList = null;
	if (fieldReactionSpecs!=null){
		reactionSpecList = new ArrayList<ReactionSpec>(Arrays.asList(fieldReactionSpecs));
	}else{
		reactionSpecList = new ArrayList<ReactionSpec>();
	}
	for (int i=0;fieldReactionSpecs!=null && i<fieldReactionSpecs.length;i++){
		ReactionSpec reactionSpec = fieldReactionSpecs[i];
		ReactionStep reactionStep = getModel().getReactionStep(reactionSpec.getReactionStep().getName());
		//
		// No longer in database or name changed. Discard reaction mapping
		//
		if (reactionStep == null) {
			reactionSpecList.remove(reactionSpec);
			bChanged = true;
			continue;
		}

		//
		// Reaction was different instance (edited or from database) 
		// Keep same mapping, point to new reaction instance
		//
		if (reactionStep != reactionSpec.getReactionStep()){
			reactionSpec.setReactionStep(reactionStep);
			continue;
		}
	}

	//
	// update reactionSpec list if any reactionStep was added
	//
	ReactionStep reactionSteps[] = fieldModel.getReactionSteps();
	for (int i=0;i<reactionSteps.length;i++){
		ReactionStep reactionStep = reactionSteps[i];
		if (getReactionSpec(reactionStep) == null) {
			ReactionSpec rSpec = new ReactionSpec(reactionStep, simContext);
			reactionSpecList.add(rSpec);
			bChanged = true;
		}
	}

	if (bChanged){
		ReactionSpec[] newReactionSpecs = reactionSpecList.toArray(new ReactionSpec[reactionSpecList.size()]);
		setReactionSpecs(newReactionSpecs);
	}
}


/**
 * This method was created by a SmartGuide.
 */
private void refreshReactionRuleSpecs() throws java.beans.PropertyVetoException {

	//
	// if any reactionStep deleted, remove reactionSpec (reaction mapping)
	//
	boolean bChanged = false;
	ArrayList<ReactionRuleSpec> reactionRuleSpecList = null;
	if (fieldReactionRuleSpecs!=null){
		reactionRuleSpecList = new ArrayList<ReactionRuleSpec>(Arrays.asList(fieldReactionRuleSpecs));
	}else{
		reactionRuleSpecList = new ArrayList<ReactionRuleSpec>();
	}
	for (int i=0;fieldReactionRuleSpecs!=null && i<fieldReactionRuleSpecs.length;i++){
		ReactionRuleSpec reactionRuleSpec = fieldReactionRuleSpecs[i];
		ReactionRule reactionRule = getModel().getRbmModelContainer().getReactionRule(reactionRuleSpec.getReactionRule().getName());
		//
		// No longer in database or name changed. Discard reactionRule mapping
		//
		if (reactionRule == null) {
			reactionRuleSpecList.remove(reactionRuleSpec);
			bChanged = true;
			continue;
		}

		//
		// ReactionRule was different instance (edited or from database) 
		// Keep same mapping, point to new reaction instance
		//
		if (reactionRule != reactionRuleSpec.getReactionRule()){
			reactionRuleSpec.setReactionRule(reactionRule);
			continue;
		}
	}

	//
	// update reactionSpec list if any reactionStep was added
	//
	for (ReactionRule reactionRule : fieldModel.getRbmModelContainer().getReactionRuleList()){
		if (getReactionRuleSpec(reactionRule) == null) {
			ReactionRuleSpec rSpec = new ReactionRuleSpec(reactionRule);
			reactionRuleSpecList.add(rSpec);
			bChanged = true;
		}
	}

	if (bChanged){
		ReactionRuleSpec[] newReactionRuleSpecs = reactionRuleSpecList.toArray(new ReactionRuleSpec[reactionRuleSpecList.size()]);
		setReactionRuleSpecs(newReactionRuleSpecs);
	}
}


/**
 * Insert the method's description here.
 * Creation date: (9/15/2004 4:10:23 PM)
 */
void refreshSpeciesContextSpecBoundaryUnits(StructureMapping structureMappings[]) {
	for (int i = 0; i < fieldSpeciesContextSpecs.length; i++){
		SpeciesContextSpec scs = fieldSpeciesContextSpecs[i];
		VCUnitDefinition dirichletUnit = scs.getSpeciesContext().getUnitDefinition();
		VCUnitDefinition neumannUnit = scs.computeFluxUnit();
		for (int j = 0; j < structureMappings.length; j++){
			if (structureMappings[j].getStructure().equals(scs.getSpeciesContext().getStructure())){
				try {
					StructureMapping fm = structureMappings[j]; //null;
//					if (structureMappings[j] instanceof FeatureMapping){
//						fm = (FeatureMapping)structureMappings[j];
//					}else if (structureMappings[j] instanceof MembraneMapping){
//						//
//						// if a membrane, use boundary condition type from the enclosed volume compartment
//						// (e.g. Plasma membrane uses cytosol boundary condition types).
//						//
//						Feature insideFeature = ((MembraneMapping)structureMappings[j]).getMembrane().getInsideFeature();
//						for (int k = 0; k < structureMappings.length; k++){
//							if (structureMappings[k].getStructure() == insideFeature){
//								fm = (FeatureMapping)structureMappings[k];
//							}
//						}
//					}
					//
					// SpeciesContextSpec is a volume species mapped to this resolved Feature
					//
					//
					// for the XM direction
					//
					{
					SpeciesContextSpec.SpeciesContextSpecParameter xmParm = scs.getBoundaryXmParameter();
					if (fm.getBoundaryConditionTypeXm().isDIRICHLET() && !xmParm.getUnitDefinition().compareEqual(dirichletUnit)){
						xmParm.setUnitDefinition(dirichletUnit);
					}else if (fm.getBoundaryConditionTypeXm().isNEUMANN() && !xmParm.getUnitDefinition().compareEqual(neumannUnit)){
						xmParm.setUnitDefinition(neumannUnit);
					}
					}
					//
					// for the XP direction
					//
					{
					SpeciesContextSpec.SpeciesContextSpecParameter xpParm = scs.getBoundaryXpParameter();
					if (fm.getBoundaryConditionTypeXp().isDIRICHLET() && !xpParm.getUnitDefinition().compareEqual(dirichletUnit)){
						xpParm.setUnitDefinition(dirichletUnit);
					}else if (fm.getBoundaryConditionTypeXp().isNEUMANN() && !xpParm.getUnitDefinition().compareEqual(neumannUnit)){
						xpParm.setUnitDefinition(neumannUnit);
					}
					}
					//
					// for the YM direction
					//
					{
					SpeciesContextSpec.SpeciesContextSpecParameter ymParm = scs.getBoundaryYmParameter();
					if (fm.getBoundaryConditionTypeYm().isDIRICHLET() && !ymParm.getUnitDefinition().compareEqual(dirichletUnit)){
						ymParm.setUnitDefinition(dirichletUnit);
					}else if (fm.getBoundaryConditionTypeYm().isNEUMANN() && !ymParm.getUnitDefinition().compareEqual(neumannUnit)){
						ymParm.setUnitDefinition(neumannUnit);
					}
					}
					//
					// for the YP direction
					//
					{
					SpeciesContextSpec.SpeciesContextSpecParameter ypParm = scs.getBoundaryYpParameter();
					if (fm.getBoundaryConditionTypeYp().isDIRICHLET() && !ypParm.getUnitDefinition().compareEqual(dirichletUnit)){
						ypParm.setUnitDefinition(dirichletUnit);
					}else if (fm.getBoundaryConditionTypeYp().isNEUMANN() && !ypParm.getUnitDefinition().compareEqual(neumannUnit)){
						ypParm.setUnitDefinition(neumannUnit);
					}
					}
					//
					// for the ZM direction
					//
					{
					SpeciesContextSpec.SpeciesContextSpecParameter zmParm = scs.getBoundaryZmParameter();
					if (fm.getBoundaryConditionTypeZm().isDIRICHLET() && !zmParm.getUnitDefinition().compareEqual(dirichletUnit)){
						zmParm.setUnitDefinition(dirichletUnit);
					}else if (fm.getBoundaryConditionTypeZm().isNEUMANN() && !zmParm.getUnitDefinition().compareEqual(neumannUnit)){
						zmParm.setUnitDefinition(neumannUnit);
					}
					}
					//
					// for the ZP direction
					//
					{
					SpeciesContextSpec.SpeciesContextSpecParameter zpParm = scs.getBoundaryZpParameter();
					if (fm.getBoundaryConditionTypeZp().isDIRICHLET() && !zpParm.getUnitDefinition().compareEqual(dirichletUnit)){
						zpParm.setUnitDefinition(dirichletUnit);
					}else if (fm.getBoundaryConditionTypeZp().isNEUMANN() && !zpParm.getUnitDefinition().compareEqual(neumannUnit)){
						zpParm.setUnitDefinition(neumannUnit);
					}
					}
				}catch (java.beans.PropertyVetoException e){
					lg.error(e);
				}
			}
		}
	}
}


/**
 * This method was created by a SmartGuide.
 */
private void refreshSpeciesContextSpecs() throws MappingException {

	//
	// if any speciesContext or structures deleted, remove speciesContext specification
	//
	SpeciesContextSpec newSpeciesContextSpecs[] = fieldSpeciesContextSpecs;
	for (int i=0;i<newSpeciesContextSpecs.length;i++){
		SpeciesContextSpec scs = newSpeciesContextSpecs[i];
		SpeciesContext speciesContext = getModel().getSpeciesContext(scs.getSpeciesContext().getName());
		if (speciesContext == null || !speciesContext.compareEqual(scs.getSpeciesContext())) {
			newSpeciesContextSpecs = ArrayUtils.removeFirstInstanceOfElement(newSpeciesContextSpecs,scs);
			i--;
			continue;
		}else if (speciesContext != scs.getSpeciesContext()){
			scs.setSpeciesContextReference(speciesContext);
		}
		Structure structure = getModel().getStructure(scs.getSpeciesContext().getStructure().getName());
		if (structure == null || structure != scs.getSpeciesContext().getStructure()) {
			newSpeciesContextSpecs = ArrayUtils.removeFirstInstanceOfElement(newSpeciesContextSpecs,scs);
			i--;
			continue;
		}
		if (fieldModel.getSpeciesContext(speciesContext.getName()) != scs.getSpeciesContext()) {
			throw new MappingException("GeometryContext.refreshSpeciesContextSpecs(), speciesContext doesn't match");
		}
	}

	//
	// update speciesContext mapping list if any speciesContext or structures were added
	//
	Structure[] structures = fieldModel.getStructures();
    for(Structure structure : structures){
        SpeciesContext[] speciesContexts = fieldModel.getSpeciesContexts(structure);
        for(SpeciesContext sc : speciesContexts){
            if(getSpeciesContextSpec(sc) == null){
                newSpeciesContextSpecs = ArrayUtils.addElement(newSpeciesContextSpecs, new SpeciesContextSpec(sc, getSimulationContext()));
            }
        }
    }
	if (newSpeciesContextSpecs != fieldSpeciesContextSpecs){
		try {
			setSpeciesContextSpecs(newSpeciesContextSpecs);
		}catch (java.beans.PropertyVetoException e){
			throw new MappingException(e.getMessage(), e);
		}
	}
	if(Application.SPRINGSALAD == simContext.getApplicationType()) {
		for(SpeciesContextSpec scs : fieldSpeciesContextSpecs) {
			scs.initializeForSpringSaLaD(null);
		}
	}
}
private void refreshSpeciesContextSpecsSpeciesPatterns() {
	if(Application.SPRINGSALAD == simContext.getApplicationType()) {
		for(SpeciesContextSpec scs : fieldSpeciesContextSpecs) {
			scs.initializeForSpringSaLaD(null);
		}
	}
}
private void refreshSpeciesContextSpecs(MolecularType mt) {
	if(Application.SPRINGSALAD == simContext.getApplicationType()) {
		for(SpeciesContextSpec scs : fieldSpeciesContextSpecs) {
			scs.initializeForSpringSaLaD(mt);
		}
	}

}


/**
 * The removePropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().removePropertyChangeListener(listener);
}


/**
 * The removePropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void removePropertyChangeListener(java.lang.String propertyName, java.beans.PropertyChangeListener listener) {
	getPropertyChange().removePropertyChangeListener(propertyName, listener);
}


/**
 * The removeVetoableChangeListener method was generated to support the vetoPropertyChange field.
 */
public synchronized void removeVetoableChangeListener(java.beans.VetoableChangeListener listener) {
	getVetoPropertyChange().removeVetoableChangeListener(listener);
}


/**
 * The removeVetoableChangeListener method was generated to support the vetoPropertyChange field.
 */
public synchronized void removeVetoableChangeListener(java.lang.String propertyName, java.beans.VetoableChangeListener listener) {
	getVetoPropertyChange().removeVetoableChangeListener(propertyName, listener);
}


/**
 * Sets the model property (cbit.vcell.model.Model) value.
 * @param model The new value for the property.
 * @see #getModel
 */
public void setModel(Model model) throws MappingException, java.beans.PropertyVetoException {
	Model oldValue = fieldModel;
	fieldModel = model;

	if (oldValue != null){
		oldValue.removePropertyChangeListener(this);
		oldValue.removeVetoableChangeListener(this);

	}
	if (fieldModel != null){
		fieldModel.addPropertyChangeListener(this);
		fieldModel.addVetoableChangeListener(this);
	}
	refreshSpeciesContextSpecs();
	refreshReactionSpecs();
	refreshReactionRuleSpecs();
	firePropertyChange("model", oldValue, model);
}


/**
 * Sets the reactionSpecs property (cbit.vcell.mapping.ReactionSpec[]) value.
 * @param reactionSpecs The new value for the property.
 * @exception java.beans.PropertyVetoException The exception description.
 * @see #getReactionSpecs
 */
public void setReactionSpecs(ReactionSpec[] reactionSpecs) throws java.beans.PropertyVetoException {
	ReactionSpec[] oldValue = fieldReactionSpecs;
	fireVetoableChange("reactionSpecs", oldValue, reactionSpecs);
	fieldReactionSpecs = reactionSpecs;
	firePropertyChange("reactionSpecs", oldValue, reactionSpecs);
}


public void setReactionRuleSpecs(ReactionRuleSpec[] reactionRuleSpecs) throws java.beans.PropertyVetoException {
	ReactionRuleSpec[] oldValue = fieldReactionRuleSpecs;
	fireVetoableChange("reactionRuleSpecs", oldValue, reactionRuleSpecs);
	fieldReactionRuleSpecs = reactionRuleSpecs;
	firePropertyChange("reactionRuleSpecs", oldValue, reactionRuleSpecs);
}


/**
 * Sets the speciesContextSpecs property (cbit.vcell.mapping.SpeciesContextSpec[]) value.
 * @param speciesContextSpecs The new value for the property.
 * @exception java.beans.PropertyVetoException The exception description.
 * @see #getSpeciesContextSpecs
 */
public void setSpeciesContextSpecs(SpeciesContextSpec[] speciesContextSpecs) throws java.beans.PropertyVetoException {
	SpeciesContextSpec[] oldValue = fieldSpeciesContextSpecs;
	fireVetoableChange("speciesContextSpecs", oldValue, speciesContextSpecs);
	for (int i = 0; i < oldValue.length; i++){
		oldValue[i].simulationContext = null;
	}
	fieldSpeciesContextSpecs = speciesContextSpecs;
	for (int i = 0; i < fieldSpeciesContextSpecs.length; i++){
		fieldSpeciesContextSpecs[i].simulationContext = simContext;
	}
	firePropertyChange("speciesContextSpecs", oldValue, speciesContextSpecs);
}

public void convertSpeciesIniCondition(boolean bUseConcentration) throws ExpressionException, PropertyVetoException, MappingException
{
	for(SpeciesContextSpec scs : getSpeciesContextSpecs())
	{
		SpeciesContextSpecParameter iniConParam = scs.getInitialConcentrationParameter();
		SpeciesContextSpecParameter iniPartParam = scs.getInitialCountParameter();
		if (bUseConcentration && iniPartParam.getExpression() != null)
		{
			Expression covertedConcentration = scs.convertParticlesToConcentration(iniPartParam.getExpression());
			iniConParam.setExpression(covertedConcentration);
			iniPartParam.setExpression(null);
		}
		else if (!bUseConcentration && iniConParam.getExpression() != null)
		{
			Expression covertedAmount = scs.convertConcentrationToParticles(iniConParam.getExpression());
			iniPartParam.setExpression(covertedAmount);
			iniConParam.setExpression(null);
		}
	}
}

public void vetoableChange(java.beans.PropertyChangeEvent evt) throws java.beans.PropertyVetoException {
	
	if (evt.getSource() == getModel() && evt.getPropertyName().equals(Model.PROPERTY_NAME_MODEL_PARAMETERS)) {
		// check for speciesContextSpec proxy parameters, if any exists, veto 
		
		ModelParameter[] newModelParams = (ModelParameter[])evt.getNewValue();
		ModelParameter[] oldModelParams = (ModelParameter[])evt.getOldValue();
		ModelParameter modelParam = null;
        for(ModelParameter oldModelParam : oldModelParams){
            if(!ArrayUtils.arrayContains(newModelParams, oldModelParam)){
                modelParam = oldModelParam;
            }
        }
		// use this missing model parameter (to be deleted) to determine if it is used in any speciesContextSpec parameters. 
		Vector<String> referencedSCSVector = new Vector<String>();
		if (modelParam != null) {
			for (int i=0;i<getSpeciesContextSpecs().length;i++){
				Parameter[] scsParams = getSpeciesContextSpecs(i).getParameters();
                for(Parameter scsParam : scsParams){
                    if(scsParam.getExpression() != null &&
                            scsParam.getExpression().hasSymbol(modelParam.getName()) &&
                            (getSpeciesContextSpecs(i).getProxyParameter(modelParam.getName()) != null)){
                        referencedSCSVector.add(getSpeciesContextSpecs(i).getSpeciesContext().getName());
                        break;
                    }
                }
			}
			// if there are any speciesContextSpecs referencing the global, list them all in error msg.
			if (!referencedSCSVector.isEmpty()) {
				String msg = "Model Parameter '" + modelParam.getName() + "' is used in the expression of the following speciesContext(s): ";
				for (int i = 0; i < referencedSCSVector.size(); i++) {
					msg = msg + "'" + referencedSCSVector.elementAt(i) + "'";
					if (i < referencedSCSVector.size()-1) {
						msg = msg + ", "; 
					} else {
						msg = msg + " ";
					}
				}
				msg = msg + " in application '" + getSimulationContext().getName() + "'. \n\nCannot delete '" + modelParam.getName() + "'.";
				throw new PropertyVetoException(msg,evt);
			}
		}
	}
}

}
