/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.mapping;

import java.beans.PropertyVetoException;
import java.util.List;

import org.vcell.util.Issue;
import org.vcell.util.Issue.IssueCategory;
import org.vcell.util.IssueContext;
import org.vcell.util.Matchable;
import org.vcell.util.NumberUtils;
import org.vcell.util.TokenMangler;

import cbit.vcell.geometry.CompartmentSubVolume;
import cbit.vcell.geometry.Geometry;
import cbit.vcell.geometry.SubVolume;
import cbit.vcell.geometry.SurfaceClass;
import cbit.vcell.model.Membrane;
import cbit.vcell.model.ModelUnitSystem;
import cbit.vcell.parser.Expression;
import cbit.vcell.parser.ExpressionException;
import cbit.vcell.units.VCUnitDefinition;
/**
 * This class was generated by a SmartGuide.
 * 
 */
public class MembraneMapping extends StructureMapping implements java.beans.VetoableChangeListener {
	//private Expression surfaceToVolumeExpression = new Expression(1.0);
	//private Expression volumeFractionExpression = new Expression(0.2);

	//private double fieldSpecificCapacitance_pF_squm = 0.01;   // cell membrane is typically 1uF/sqcm (from Hille page 9) = 0.01pF/squm
	//private cbit.vcell.parser.Expression fieldInitialVoltage = new Expression(0.0);
	private boolean fieldCalculateVoltage = false;

public MembraneMapping(MembraneMapping membraneMapping, SimulationContext argSimulationContext,Geometry newGeometry, ModelUnitSystem argModelUnitSystem) {
	super(membraneMapping, argSimulationContext,newGeometry, argModelUnitSystem);
	fieldCalculateVoltage = membraneMapping.fieldCalculateVoltage;

	addVetoableChangeListener(this);
}

public MembraneMapping(Membrane membrane, SimulationContext argSimulationContext, ModelUnitSystem argModelUnitSystem) {
	super(membrane, argSimulationContext, argModelUnitSystem);
	double volume = 50000.0;
	double radius = Math.pow(  ((3.0*volume) / (4.0*Math.PI)), 1.0/3.0);
	double area = 4.0*Math.PI*Math.pow(radius, 2.0);
	String sArea = NumberUtils.formatNumber(area, 4);
	area = Double.parseDouble(sArea);
	try {
		VCUnitDefinition lengthUnitDefn = modelUnitSystem.getLengthUnit();
		setParameters(new StructureMappingParameter[] {
						new StructureMappingParameter(getInitialVoltageName(), new Expression(0.0), ROLE_InitialVoltage, modelUnitSystem.getVoltageUnit()),
						new StructureMappingParameter(DefaultNames[ROLE_SpecificCapacitance], new Expression(1.0), ROLE_SpecificCapacitance, modelUnitSystem.getCapacitanceUnit().divideBy(modelUnitSystem.getAreaUnit())),
						new StructureMappingParameter(DefaultNames[ROLE_SurfaceToVolumeRatio], /*new Expression(0)*/ null, ROLE_SurfaceToVolumeRatio, lengthUnitDefn.getInverse()),
						new StructureMappingParameter(DefaultNames[ROLE_VolumeFraction], /*new Expression(0)*/ null, ROLE_VolumeFraction,modelUnitSystem.getInstance_DIMENSIONLESS()),
						new StructureMappingParameter(DefaultNames[ROLE_Size], new Expression(area), ROLE_Size, modelUnitSystem.getAreaUnit()),
						new StructureMappingParameter(DefaultNames[ROLE_AreaPerUnitArea], /*new Expression(1)*/ null, ROLE_AreaPerUnitArea,modelUnitSystem.getInstance_DIMENSIONLESS()),
						new StructureMappingParameter(DefaultNames[ROLE_AreaPerUnitVolume], /*new Expression(1)*/ null, ROLE_AreaPerUnitVolume, lengthUnitDefn.getInverse())
		});
	}catch (java.beans.PropertyVetoException e){
		throw new RuntimeException(e.getMessage(), e);
	}
	addVetoableChangeListener(this);
}

/**
 * This method was created in VisualAge.
 * @return boolean
 * @param obj java.lang.Object
 */
public boolean compareEqual(Matchable obj) {

	MembraneMapping mm = null;
	if (!(obj instanceof MembraneMapping)){
		return false;
	}
	mm = (MembraneMapping)obj;

	if (!compareEqual0(mm)){
		return false;
	}

	//if (!Compare.isEqual(surfaceToVolumeExpression,mm.surfaceToVolumeExpression)){
		//return false;
	//}

	//if (!Compare.isEqual(volumeFractionExpression,mm.volumeFractionExpression)){
		//return false;
	//}
	
	//if (!Compare.isEqual(fieldInitialVoltage,mm.fieldInitialVoltage)){
		//return false;
	//}

	//if (fieldSpecificCapacitance_pF_squm != mm.fieldSpecificCapacitance_pF_squm){
		//return false;
	//}

	if (fieldCalculateVoltage != mm.fieldCalculateVoltage){
		return false;
	}
	return true;
}

/**
 * Gets the calculateVoltage property (boolean) value.
 * @return The calculateVoltage property value.
 * @see #setCalculateVoltage
 */
public boolean getCalculateVoltage() {
	return fieldCalculateVoltage;
}
/**
 * This method was created by a SmartGuide.
 * @return double
 */
private String getInitialVoltageName() {
	return TokenMangler.fixToken(getMembrane().getMembraneVoltage().getName())+"_init";
}

public StructureMappingParameter getInitialVoltageParameter() {
	return getParameterFromRole(ROLE_InitialVoltage);
}
/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.model.Membrane
 */
public Membrane getMembrane() {
	return (Membrane)getStructure();
}
/**
 * Accessor for the propertyChange field.
 */
protected java.beans.PropertyChangeSupport getPropertyChange() {
	if (propertyChange == null) {
		propertyChange = new java.beans.PropertyChangeSupport(this);
	};
	return propertyChange;
}

public StructureMappingParameter getSpecificCapacitanceParameter() {
	return getParameterFromRole(ROLE_SpecificCapacitance);
}
/**
 * This method was created by a SmartGuide.
 * @return double
 */
public StructureMappingParameter getSurfaceToVolumeParameter() {
	return getParameterFromRole(ROLE_SurfaceToVolumeRatio);
}


/**
 * This method was created by a SmartGuide.
 * @return double
 */
public StructureMappingParameter getAreaPerUnitVolumeParameter() {
	return getParameterFromRole(ROLE_AreaPerUnitVolume);
}

/**
 * This method was created by a SmartGuide.
 * @return double
 */
public StructureMappingParameter getAreaPerUnitAreaParameter() {
	return getParameterFromRole(ROLE_AreaPerUnitArea);
}

@Override
public StructureMappingParameter getUnitSizeParameter() {
	if (getGeometryClass() instanceof SubVolume){
		return getAreaPerUnitVolumeParameter();
	}else if (getGeometryClass() instanceof SurfaceClass){
		return getAreaPerUnitAreaParameter();
	}
	return null;
}

/**
 * This method was created in VisualAge.
 * @return cbit.vcell.parser.Expression
 */
@Override
public Expression getNormalizedConcentrationCorrection(SimulationContext simulationContext, UnitFactorProvider unitFactorProvider) throws ExpressionException, MappingException {
	Expression exp = getSizeCorrection(simulationContext);
	if (getGeometryClass() instanceof CompartmentSubVolume || getGeometryClass() instanceof SubVolume){
		Expression unitFactor = unitFactorProvider.getUnitFactor(modelUnitSystem.getVolumeSubstanceUnit().divideBy(modelUnitSystem.getMembraneSubstanceUnit()));
		exp = Expression.mult(unitFactor, exp).simplifyJSCL();
	}
	return exp;
}

@Override
public Expression getStructureSizeCorrection(SimulationContext simulationContext, UnitFactorProvider unitFactorProvider) throws ExpressionException, MappingException {
	return getSizeCorrection(simulationContext);
}

private Expression getSizeCorrection(SimulationContext simulationContext) throws ExpressionException, MappingException {
	if (getGeometryClass() instanceof CompartmentSubVolume){
		if (simulationContext.getGeometryContext().isAllSizeSpecifiedPositive()) {
			//
			// everything mapped to micro-molar : need surface/volume fraction and KMOLE
			//
			Expression exp = new Expression(getSizeParameter(),simulationContext.getNameScope());
			return exp;
		} else {
			throw new MappingException("\nIn non-spatial application '" + simulationContext.getName() + "', " +
					"size of structure '" + getStructure().getName() + "' must be assigned a " +
					"positive value if referenced in the model.\n\nPlease go to 'Structure Mapping' tab to check the size.");
		}
	}else if (getGeometryClass() instanceof SubVolume){
		//
		// everything mapped to micro-molar : need surface/volume fraction and KMOLE
		//
		Expression exp = new Expression(getAreaPerUnitVolumeParameter(),simulationContext.getNameScope());
		return exp;
	}else if (getGeometryClass() instanceof SurfaceClass){
		//
		// everything mapped to molecules/sq-um : just need area/area fraction
		//
		Expression exp = new Expression(getAreaPerUnitAreaParameter(),simulationContext.getNameScope());
		return exp;
	}else{
		throw new RuntimeException("structure "+getStructure().getName()+" not mapped");
	}
}

/**
 * This method was created by a SmartGuide.
 * @return double
 */
public StructureMappingParameter getVolumeFractionParameter() {
	return getParameterFromRole(ROLE_VolumeFraction);
}
/**
 * The hasListeners method was generated to support the propertyChange field.
 */
public synchronized boolean hasListeners(String propertyName) {
	return getPropertyChange().hasListeners(propertyName);
}
/**
 * Insert the method's description here.
 * Creation date: (2/19/2002 1:08:12 PM)
 */
public void refreshDependencies() {
	super.refreshDependencies();
	addVetoableChangeListener(this);
}

/**
 * Sets the calculateVoltage property (boolean) value.
 * @param calculateVoltage The new value for the property.
 * @see #getCalculateVoltage
 */
public void setCalculateVoltage(boolean calculateVoltage) {
	boolean oldValue = fieldCalculateVoltage;
	fieldCalculateVoltage = calculateVoltage;
	firePropertyChange("calculateVoltage", new Boolean(oldValue), new Boolean(calculateVoltage));
}
/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String toString() {
	return getClass().getName()+"@"+Integer.toHexString(hashCode())+" "+getMembrane().getName();
}
	/**
	 * This method gets called when a constrained property is changed.
	 *
	 * @param     evt a <code>PropertyChangeEvent</code> object describing the
	 *   	      event source and the property that has changed.
	 * @exception PropertyVetoException if the recipient wishes the property
	 *              change to be rolled back.
	 */
public void vetoableChange(java.beans.PropertyChangeEvent evt) throws java.beans.PropertyVetoException {
	if (evt.getPropertyName().equals("specificCapacitance_pF_squm")){
		Double newValue = (Double)evt.getNewValue();
		if (newValue.doubleValue()<0.0){
			throw new java.beans.PropertyVetoException("specificCapacitance (pF/squm) cannot be negative, value="+newValue.doubleValue(),evt);
		}
	}
	if (evt.getPropertyName().equals("initialVoltage")){
		if (evt.getNewValue()==null){
			throw new java.beans.PropertyVetoException("initialVoltage cannot be 'null'",evt);
		}
	}
}

public void gatherIssues(IssueContext issueContext, List<Issue> issueVector) {
	super.gatherIssues(issueContext, issueVector);
	if (simulationContext.getGeometry().getDimension() == 0) {
		if (!simulationContext.getGeometryContext().isAllSizeSpecifiedPositive()) {
			
			String tooltip = "\nIn non-spatial application, size of structure '" + getStructure().getName() + 
					"' must be assigned a positive value if referenced in the model.";
			String message = "In non-spatial application, size of structure '" + getStructure().getName() + "' must be assigned a positive value.";
			issueVector.add(new Issue(this, issueContext, IssueCategory.StructureMappingSizeParameterNotSet, message, Issue.SEVERITY_WARNING));
		}
	}
}

}
