/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.geometry;


import org.vcell.util.Extent;
import org.vcell.util.Origin;
import org.vcell.util.document.KeyValue;
import org.vcell.util.document.VCDocument;
import org.vcell.util.document.VCDocument.VCDocumentType;
import org.vcell.util.document.VCDocumentInfo;
import org.vcell.util.document.VCellSoftwareVersion;
import org.vcell.util.document.Version;
import org.vcell.util.document.VersionableType;

/**
 * This class was generated by a SmartGuide.
 * 
 */
public class GeometryInfo implements VCDocumentInfo {
	private  int dimension;
	private  Origin origin = null;
	private  Extent extent = null;
	private  KeyValue imageRef = null;
	private  Version version = null;
	private  VCellSoftwareVersion softwareVersion = null;

/**
 * This method was created in VisualAge.
 */
public GeometryInfo(Version versionNew,int dimensionNew,Extent extentNew,Origin originNew,KeyValue imageRefNew,VCellSoftwareVersion softwareVersion) {
	this.dimension = dimensionNew;
	this.extent = extentNew;
	this.origin = originNew;
	this.imageRef = imageRefNew;
	this.version = versionNew;
	this.softwareVersion = softwareVersion;
}


/**
 * Insert the method's description here.
 * Creation date: (1/25/01 12:24:41 PM)
 * @return boolean
 * @param object java.lang.Object
 */
public boolean equals(Object object) {
	if (object instanceof GeometryInfo){
		if (!getVersion().getVersionKey().equals(((GeometryInfo)object).getVersion().getVersionKey())){
			return false;
		}
		return true;
	}
	return false;
}


/**
 * This method was created in VisualAge.
 * @return int
 */
public int getDimension() {
	return dimension;
}


/**
 * This method was created in VisualAge.
 * @return cbit.util.Origin
 */
public Extent getExtent() {
	return extent;
}


/**
 * This method was created in VisualAge.
 * @return cbit.sql.KeyValue
 */
public KeyValue getImageRef() {
	return imageRef;
}


/**
 * This method was created in VisualAge.
 * @return cbit.util.Origin
 */
public Origin getOrigin() {
	return origin;
}


/**
 * This method was created in VisualAge.
 * @return cbit.sql.Version
 */
public Version getVersion() {
	return version;
}


/**
 * Insert the method's description here.
 * Creation date: (1/25/01 12:28:06 PM)
 * @return int
 */
public int hashCode() {
	return getVersion().getVersionKey().hashCode();
}


/**
 * This method was created in VisualAge.
 * @return java.lang.String
 */
public String toString() {
	return "GeometryInfo(dim="+dimension+", origin="+origin+", extent="+extent+", imageRef="+imageRef+", version="+version+", softwareVersion="+softwareVersion+")";
}


public VersionableType getVersionType() {	
	return VersionableType.Geometry;
}


public VCellSoftwareVersion getSoftwareVersion() {
	return softwareVersion;
}
public VCDocumentType getVCDocumentType(){
	return VCDocument.VCDocumentType.GEOMETRY_DOC;
}

}
