/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.geometry;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;

import org.vcell.util.Compare;
import org.vcell.util.Extent;
import org.vcell.util.Issue;
import org.vcell.util.Issue.IssueOrigin;
import org.vcell.util.IssueContext;
import org.vcell.util.Matchable;
import org.vcell.util.Origin;
import org.vcell.util.document.KeyValue;
import org.vcell.util.document.VCDocument;
import org.vcell.util.document.Version;
import org.vcell.util.document.Versionable;

import cbit.image.ImageException;
import cbit.image.VCImage;
import cbit.vcell.geometry.surface.GeometrySurfaceDescription;
import cbit.vcell.parser.ExpressionException;
/**
 * This interface was generated by a SmartGuide.
 * 
 */
@SuppressWarnings("serial")
public class Geometry implements VCDocument, Versionable, IssueOrigin {
	private Version version = null;
	protected transient java.beans.PropertyChangeSupport propertyChange;
	protected transient java.beans.VetoableChangeSupport vetoPropertyChange;
	private java.lang.String fieldName = new String();
	private java.lang.String fieldDescription = new String();
	private GeometrySpec fieldGeometrySpec = null;
	private GeometryUnitSystem fieldGeometryUnitSystem = new GeometryUnitSystem();

	private GeometrySurfaceDescription fieldGeometrySurfaceDescription = null;

/**
 * @param name java.lang.String
 */
public Geometry(Version aVersion, int aDimension) {
	this.version = aVersion;
	if (aVersion!=null){
		this.fieldName = aVersion.getName();
		this.fieldDescription = aVersion.getAnnot();
	}
	fieldGeometrySpec = new GeometrySpec(aVersion, aDimension);
	if (aDimension>0){
		fieldGeometrySurfaceDescription = new GeometrySurfaceDescription(this);
	}
}


/**
 * @param name java.lang.String
 */
public Geometry(Version aVersion, VCImage aVCImage) {
	this.version = aVersion;
	if (aVersion!=null){
		this.fieldName = aVersion.getName();
		this.fieldDescription = aVersion.getAnnot();
	}
	fieldGeometrySpec = new GeometrySpec(aVersion, aVCImage);
	fieldGeometrySurfaceDescription = new GeometrySurfaceDescription(this);
}

public Geometry(Geometry geometry) {
	this.version = geometry.version;
	this.fieldName = geometry.fieldName;
	this.fieldDescription = geometry.fieldDescription;
	this.fieldGeometryUnitSystem = geometry.fieldGeometryUnitSystem;
	fieldGeometrySpec = new GeometrySpec(geometry.getGeometrySpec());
	if (geometry.getDimension() > 0) {
		fieldGeometrySurfaceDescription = new GeometrySurfaceDescription(this);
	}

}
/**
 * @param name java.lang.String
 */
public Geometry(Geometry geometry, VCImage aVCImage) {
	this.version = geometry.version;
	this.fieldName = geometry.fieldName;
	this.fieldDescription = geometry.fieldDescription;
	this.fieldGeometryUnitSystem = geometry.fieldGeometryUnitSystem;
	fieldGeometrySpec = new GeometrySpec(geometry.getGeometrySpec());
	try {
		getGeometrySpec().setImage(aVCImage);
	}catch (PropertyVetoException e){
		throw new RuntimeException(e.getMessage(), e);
	}
	fieldGeometrySurfaceDescription = new GeometrySurfaceDescription(this);
}


/**
 * @param name java.lang.String
 */
public Geometry(String aName, int aDimension) {
	this.version = null;
	this.fieldName = aName;
	fieldGeometrySpec = new GeometrySpec(aName, aDimension);
	if (aDimension>0){
		fieldGeometrySurfaceDescription = new GeometrySurfaceDescription(this);
	}
}


/**
 * @param name java.lang.String
 */
public Geometry(String aName, VCImage aVCImage) {
	this.version = null;
	this.fieldName = aName;
	fieldGeometrySpec = new GeometrySpec(aName, aVCImage);
	fieldGeometrySurfaceDescription = new GeometrySurfaceDescription(this);
}


/**
 * The addPropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().addPropertyChangeListener(listener);
}

/**
 * The addVetoableChangeListener method was generated to support the vetoPropertyChange field.
 */
public synchronized void addVetoableChangeListener(java.beans.VetoableChangeListener listener) {
	getVetoPropertyChange().addVetoableChangeListener(listener);
}

public GeometryUnitSystem getUnitSystem() {
	return fieldGeometryUnitSystem;
}

/**
 * Insert the method's description here.
 * Creation date: (4/24/2003 3:31:17 PM)
 */
public void clearVersion() {
	version = null;
	SubVolume[] svArr = getGeometrySpec().getSubVolumes();
	for(int i =0;i < svArr.length;i+= 1){
		svArr[i].clearKey();
	}
}

public GeometryClass[] getGeometryClasses() {
	ArrayList<GeometryClass> gcList = new ArrayList<GeometryClass>();
	SubVolume[] subVolumes = fieldGeometrySpec.getSubVolumes();
	for (int i = 0; i < subVolumes.length; i++) {
		gcList.add(subVolumes[i]);
	}
	if (fieldGeometrySurfaceDescription != null){
		SurfaceClass[] surfaceClasses = fieldGeometrySurfaceDescription.getSurfaceClasses();
		if (surfaceClasses != null) {
			for (int i = 0; i < surfaceClasses.length; i++) {
				gcList.add(surfaceClasses[i]);
			}
		}
	}
	return gcList.toArray(new GeometryClass[gcList.size()]);
}

public GeometryClass getGeometryClass(String name) {
	for (SubVolume sv : fieldGeometrySpec.getSubVolumes()) {
		if (sv.getName().equals(name)) {
			return sv;
		}
	}
	if (fieldGeometrySurfaceDescription != null){
		SurfaceClass[] surfaceClasses = fieldGeometrySurfaceDescription.getSurfaceClasses();
		if (surfaceClasses != null){
			for (SurfaceClass sc : fieldGeometrySurfaceDescription.getSurfaceClasses()) {
				if (sc.getName().equals(name)) {
					return sc;
				}
			}
		}
	}
	return null;
}

/**
 * This method was created in VisualAge.
 * @return boolean
 * @param object java.lang.Object
 */
public boolean compareEqual(Matchable object) {
	if (object == null || !(object instanceof Geometry)){
		return false;
	}
	Geometry geometry = (Geometry) object;
	if (!Compare.isEqual(getName(), geometry.getName())){
		return false;
	}
	if (!Compare.isEqual(getDescription(), geometry.getDescription())){
		return false;
	}
	if (!Compare.isEqualOrNull(getGeometrySurfaceDescription(), geometry.getGeometrySurfaceDescription())){
		return false;
	}
	return(getGeometrySpec().compareEqual(geometry.getGeometrySpec()));
}


/**
 * The firePropertyChange method was generated to support the propertyChange field.
 */
public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
}


/**
 * The fireVetoableChange method was generated to support the vetoPropertyChange field.
 */
public void fireVetoableChange(java.lang.String propertyName, java.lang.Object oldValue, java.lang.Object newValue) throws java.beans.PropertyVetoException {
	getVetoPropertyChange().fireVetoableChange(propertyName, oldValue, newValue);
}


/**
 * Insert the method's description here.
 * Creation date: (3/18/2004 1:54:51 PM)
 * @param newVersion cbit.sql.Version
 */
public void forceNewVersionAnnotation(Version newVersion) throws PropertyVetoException {
	if (getVersion().getVersionKey().equals(newVersion.getVersionKey())) {
		setVersion(newVersion);
	} else {
		throw new RuntimeException("Geometry.forceNewVersionAnnotation failed : version keys not equal");
	}
}


/**
 * Gets the description property (java.lang.String) value.
 * @return The description property value.
 * @see #setDescription
 */
public java.lang.String getDescription() {
	return fieldDescription;
}


/**
 * This method was created by a SmartGuide.
 * @return int
 */
public int getDimension() {
	return(getGeometrySpec().getDimension());
}


/**
 * Insert the method's description here.
 * Creation date: (5/28/2004 3:13:20 PM)
 * @return int
 */
public VCDocumentType getDocumentType() {
	return VCDocumentType.GEOMETRY_DOC;
}


/**
 * This method was created by a SmartGuide.
 * @return int
 */
public Extent getExtent() {
	return(getGeometrySpec().getExtent());
}


/**
 * Gets the geometrySpec property (cbit.vcell.geometry.GeometrySpec) value.
 * @return The geometrySpec property value.
 */
public GeometrySpec getGeometrySpec() {
	return fieldGeometrySpec;
}


/**
 * Gets the geometrySurfaceDescription property (cbit.vcell.geometry.surface.GeometrySurfaceDescription) value.
 * @return The geometrySurfaceDescription property value.
 */
public GeometrySurfaceDescription getGeometrySurfaceDescription() {
	return fieldGeometrySurfaceDescription;
}


/**
 * This method was created in VisualAge.
 * @return KeyValue
 */
public KeyValue getKey() {
	if(version != null){
		return version.getVersionKey();
	}
	return null;
}


/**
 * Gets the name property (java.lang.String) value.
 * @return The name property value.
 * @see #setName
 */
public java.lang.String getName() {
	return fieldName;
}


/**
 * This method was created by a SmartGuide.
 * @return int
 */
public Origin getOrigin() {
	return(getGeometrySpec().getOrigin());
}


/**
 * Accessor for the propertyChange field.
 */
protected java.beans.PropertyChangeSupport getPropertyChange() {
	if (propertyChange == null) {
		propertyChange = new java.beans.PropertyChangeSupport(this);
	};
	return propertyChange;
}


/**
 * This method was created in VisualAge.
 * @return cbit.util.Version
 */
public Version getVersion() {
	return version;
}


/**
 * Accessor for the vetoPropertyChange field.
 */
protected java.beans.VetoableChangeSupport getVetoPropertyChange() {
	if (vetoPropertyChange == null) {
		vetoPropertyChange = new java.beans.VetoableChangeSupport(this);
	};
	return vetoPropertyChange;
}


/**
 * This method was created in VisualAge.
 */
public void refreshDependencies() {
	getGeometrySpec().refreshDependencies();
	if (getGeometrySurfaceDescription()!=null){
		getGeometrySurfaceDescription().refreshDependencies();
	}
}


/**
 * The removePropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().removePropertyChangeListener(listener);
}


/**
 * The removeVetoableChangeListener method was generated to support the vetoPropertyChange field.
 */
public synchronized void removeVetoableChangeListener(java.beans.VetoableChangeListener listener) {
	getVetoPropertyChange().removeVetoableChangeListener(listener);
}


/**
 * Sets the description property (java.lang.String) value.
 * @param description The new value for the property.
 * @exception java.beans.PropertyVetoException The exception description.
 * @see #getDescription
 */
public void setDescription(java.lang.String description) throws java.beans.PropertyVetoException {
	String oldValue = fieldDescription;
	fireVetoableChange("description", oldValue, description);
	fieldDescription = description;
	firePropertyChange("description", oldValue, description);
}


/**
 * Sets the name property (java.lang.String) value.
 * @param name The new value for the property.
 * @exception java.beans.PropertyVetoException The exception description.
 * @see #getName
 */
public void setName(java.lang.String name) throws java.beans.PropertyVetoException {
	String oldValue = fieldName;
	fireVetoableChange("name", oldValue, name);
	fieldName = name;
	firePropertyChange("name", oldValue, name);
}


/**
 * Insert the method's description here.
 * Creation date: (11/14/00 3:49:12 PM)
 * @param version cbit.sql.Version
 */
private void setVersion(Version newVersion) throws PropertyVetoException {
	this.version = newVersion;
	if (newVersion != null){
		setName(newVersion.getName());
		setDescription(newVersion.getAnnot());
	}
}


/**
 * This method was created in VisualAge.
 * @return java.lang.String
 */
public String toString() {
	return "geometry"+"@"+Integer.toHexString(hashCode())+"("+((version!=null)?(version.toString()):getName())+")";
}

public void precomputeAll(GeometryThumbnailImageFactory geometryThumbnailImageFactory) throws GeometryException, ImageException, ExpressionException {
	precomputeAll(geometryThumbnailImageFactory, true, false);
}

public void precomputeAll(GeometryThumbnailImageFactory geometryThumbnailImageFactory, boolean bUpdateSampledImage, boolean bForcePrecomputeSurfaces) throws GeometryException, ImageException, ExpressionException {
	if (bUpdateSampledImage) {
		getGeometrySpec().updateSampledImage(geometryThumbnailImageFactory);
	}
	if (getDimension()>0 && (bForcePrecomputeSurfaces || getGeometrySurfaceDescription().getGeometricRegions()==null)) {
		getGeometrySurfaceDescription().updateAll();					
	}
	
	if (bUpdateSampledImage) {
		getGeometrySpec().fireAll();
	}
	if (getDimension()>0) {
		getGeometrySurfaceDescription().fireAll();
	}
}

@Override
public void gatherIssues(IssueContext issueContext, List<Issue> issueList) {
}

}
