/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.microscopy.gui;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import cbit.gui.graph.GraphEvent;
import cbit.gui.graph.GraphModel;
import cbit.vcell.geometry.GeometryException;
import cbit.vcell.geometry.GeometrySpec;
import cbit.vcell.geometry.SubVolume;
import cbit.vcell.graph.GeometryClassLegendShape;
import cbit.vcell.graph.GeometryContextGeometryShape;
import cbit.vcell.graph.SubVolumeContainerShape;
import cbit.vcell.mapping.GeometryContext;
import cbit.vcell.mapping.SimulationContext;
/**
 * This class was generated by a SmartGuide.
 * 
 * @author schaff
 * @version $Revision: 1.0 $
 */
public class StructureMappingCartoon extends GraphModel implements PropertyChangeListener {
	private SimulationContext simulationContext = null;
	//private GeometryContext geometryContext = null;
	private SubVolumeContainerShape subVolumeContainerShape = null;

/**
 * This method was created by a SmartGuide.
 */
public StructureMappingCartoon(){
}


/**
 * This method was created in VisualAge.
 * @return cbit.vcell.model.Model
 */
public GeometryContext getGeometryContext() {
	if (getSimulationContext() != null){
		return getSimulationContext().getGeometryContext();
	}else{
		return null;
	}
}


/**
 * Insert the method's description here.
 * Creation date: (5/14/2003 12:05:03 PM)
 * @return cbit.vcell.mapping.SimulationContext
 */
private SimulationContext getSimulationContext() {
	return simulationContext;
}


/**
 * Insert the method's description here.
 * Creation date: (6/5/00 11:01:33 PM)
 * @param event java.beans.PropertyChangeEvent
 * @see java.beans.PropertyChangeListener#propertyChange(PropertyChangeEvent)
 */
public void propertyChange(PropertyChangeEvent event) {
	try {
		refreshAll();
	}catch (Exception e){
		e.printStackTrace(System.out);
	}
}


/**
 * This method was created by a SmartGuide.
 */
@Override
public void refreshAll() {
	clearAllShapes();
	if (getSimulationContext() == null){
		fireGraphChanged(new GraphEvent(this));
		return;
	}
	GeometryContextGeometryShape geometryShape = new GeometryContextGeometryShape(this,getGeometryContext().getGeometry());
//	GeometryContextStructureShape structureShape = new GeometryContextStructureShape(this,getGeometryContext().getModel());
//	GeometryContextContainerShape containerShape = new GeometryContextContainerShape(this,getGeometryContext(),structureShape,geometryShape);
//	addShape(containerShape);
	addShape(geometryShape);
//	addShape(structureShape);
	getGeometryContext().removePropertyChangeListener(this);
	getGeometryContext().addPropertyChangeListener(this);
	//
	// create all StructureShapes
	//
//	Structure structures[] = getGeometryContext().getModel().getStructures();
//	for (int i=0;i<structures.length;i++){
//		if (structures[i] instanceof Feature){
//			//addShape(new FeatureShape((Feature)structures[i],getGeometryContext().getModel(),this));
//			StructureMappingFeatureShape smShape = new StructureMappingFeatureShape((Feature)structures[i],getGeometryContext().getModel(),this);
//			addShape(smShape);
//			containerShape.addChildShape(smShape);
//			structures[i].removePropertyChangeListener(this);
//			structures[i].addPropertyChangeListener(this);
//		}	
//	}

	// create all SubvolumeLegendShapes (for legend)
	//
	GeometrySpec geometrySpec = getGeometryContext().getGeometry().getGeometrySpec();
	SubVolume subVolumes[] = geometrySpec.getSubVolumes();
	for (int i=0;i<subVolumes.length;i++){
		cbit.vcell.geometry.SubVolume subvolume = subVolumes[i];
		GeometryClassLegendShape subvolumeLegendShape = new GeometryClassLegendShape(subvolume,getGeometryContext().getGeometry(),this,10);
		addShape(subvolumeLegendShape);
		geometryShape.addChildShape(subvolumeLegendShape);
	}	

	//--------------------------------------------------
	if((subVolumeContainerShape == null) || (subVolumeContainerShape.getModelObject() != getGeometryContext().getGeometry())){
		subVolumeContainerShape = new SubVolumeContainerShape(getGeometryContext().getGeometry(), this);			
	}
	subVolumeContainerShape.removeAllChildren();
	addShape(subVolumeContainerShape);
	geometryShape.addChildShape(subVolumeContainerShape);
	
	//--------------------------------------------------
	
	//// create all SubvolumeShapes (for image)
	////
	//for (int i=0;i<subVolumes.length;i++){
		//cbit.vcell.geometry.SubVolume subvolume = (cbit.vcell.geometry.SubVolume)subVolumes[i];
		//SubvolumeShape subvolumeShape = new SubvolumeShape(subvolume,getGeometryContext().getGeometry(),this);
		//addShape(subvolumeShape);
		//subVolumeContainerShape.addChildShape(subvolumeShape);
	//}
	
	//
	// create all FeatureMappingShapes
	//
//	StructureMapping structureMappings[] = getGeometryContext().getStructureMappings();
//	for (int i=0;i<structureMappings.length;i++){
//		StructureMapping structureMapping = structureMappings[i];
//		if (structureMapping instanceof FeatureMapping){
//			FeatureMapping featureMapping = (FeatureMapping)structureMapping;
//			if (featureMapping.getSubVolume()!=null){
//				FeatureShape featureShape = (FeatureShape)getShapeFromModelObject(featureMapping.getFeature());
//				SubvolumeLegendShape subvolumeLegendShape = (SubvolumeLegendShape)getShapeFromModelObject(featureMapping.getSubVolume());
//				FeatureMappingShape fmShape = new FeatureMappingShape(featureMapping,featureShape,subvolumeLegendShape,this);
////FeatureMappingShape fmShape = new FeatureMappingShape(featureMapping,featureShape,featureMapping.getSubVolume(),imageShape,this);
//				addShape(fmShape);
//				containerShape.addChildShape(fmShape);
//			}
//		}
//	}	
	//
	// assign children to shapes according to heirarchy in Model
	//
//	int nullParentCount=0;
//	Enumeration enum_shape = getShapes();
//	while (enum_shape.hasMoreElements()){
//		Shape shape = (Shape)enum_shape.nextElement();
//		//
//		// for each featureShape, find corresponding featureShape
//		//
//		if (shape instanceof FeatureShape){
//			FeatureShape fs = (FeatureShape)shape;
//			Membrane membrane = fs.getFeature().getMembrane();
//			if (membrane!=null){
//				//
//				// add this feature as child to parent feature
//				//
//				Feature parentFeature = membrane.getOutsideFeature();
//				FeatureShape parentFeatureShape = (FeatureShape)getShapeFromModelObject(parentFeature);
//				if (!parentFeatureShape.contains(fs)){
//					parentFeatureShape.addChildShape(fs);
//				}
//			}else{
//				if (!structureShape.contains(fs)){
//					structureShape.addChildShape(fs);
//				}
//				nullParentCount++;
//			}		
//		}	
//	}	
	fireGraphChanged(new GraphEvent(this));
}


/**
 * This method was created in VisualAge.
 * @param aSimulationContext SimulationContext
 * @throws GeometryException
 * @throws Exception
 */
public void setSimulationContext(SimulationContext aSimulationContext) throws GeometryException, Exception {
	
	if(this.simulationContext != null){
		this.simulationContext.getGeometryContext().removePropertyChangeListener(this);
		this.simulationContext.getGeometry().removePropertyChangeListener(this);
		this.simulationContext.getGeometry().getGeometrySpec().removePropertyChangeListener(this);
		this.simulationContext.removePropertyChangeListener(this);
	}
	//
	this.simulationContext = aSimulationContext;
	//
	if (this.simulationContext != null){
		this.simulationContext.getGeometryContext().addPropertyChangeListener(this);
		this.simulationContext.getGeometry().addPropertyChangeListener(this);
		this.simulationContext.getGeometry().getGeometrySpec().addPropertyChangeListener(this);
		this.simulationContext.addPropertyChangeListener(this);
	}
	//
	refreshAll();
}
}
