/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.client.desktop.geometry;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
/**
 * Insert the type's description here.
 * Creation date: (5/11/2004 4:50:11 PM)
 * @author: Ion Moraru
 */
public class GeometryEditor extends JPanel {
	IvjEventHandler ivjEventHandler = new IvjEventHandler();
	private org.vcell.util.gui.JToolBarToggleButton ivjgeoEditorToggleButton = null;
	private JToolBar ivjGeometryToolBar = null;
	private org.vcell.util.gui.JToolBarToggleButton ivjSurfaceViewerToggleButton = null;
	private cbit.vcell.geometry.Geometry fieldGeometry = null;
	private cbit.vcell.client.GeometryWindowManager fieldGeometryWindowManager = null;

class IvjEventHandler implements java.awt.event.ActionListener {
		public void actionPerformed(java.awt.event.ActionEvent e) {
			if (e.getSource() == GeometryEditor.this.getgeoEditorToggleButton()) 
				connEtoC1(e);
			if (e.getSource() == GeometryEditor.this.getSurfaceViewerToggleButton()) 
				connEtoC2(e);
		};
	};
public GeometryEditor() {
	super();
	initialize();
}
/**
 * connEtoC1:  (geoEditorToggleButton.action.actionPerformed(java.awt.event.ActionEvent) --> GeometryEditor.showGeometryEditor(Z)V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC1(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.showGeometryEditor(this.getGeometryEditorButtonSelected());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoC2:  (SurfaceViewerToggleButton.action.actionPerformed(java.awt.event.ActionEvent) --> GeometryEditor.showSurfaceViewer(Z)V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC2(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.showSurfaceViewer(this.getSurfaceViewerButtonSelected());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM1:  (GeometryEditor.initialize() --> geoEditorToggleButton.selected)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM1() {
	try {
		// user code begin {1}
		// user code end
		getgeoEditorToggleButton().setSelected(true);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * Return the geoEditorToggleButton property value.
 * @return cbit.gui.JToolBarToggleButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private org.vcell.util.gui.JToolBarToggleButton getgeoEditorToggleButton() {
	if (ivjgeoEditorToggleButton == null) {
		try {
			ivjgeoEditorToggleButton = new org.vcell.util.gui.JToolBarToggleButton();
			ivjgeoEditorToggleButton.setName("geoEditorToggleButton");
			ivjgeoEditorToggleButton.setPreferredSize(new java.awt.Dimension(75, 25));
			ivjgeoEditorToggleButton.setText("Geometry Editor");
			ivjgeoEditorToggleButton.setMinimumSize(new java.awt.Dimension(50, 25));
			ivjgeoEditorToggleButton.setMaximumSize(new java.awt.Dimension(100, 25));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjgeoEditorToggleButton;
}
/**
 * Gets the geometry property (cbit.vcell.geometry.Geometry) value.
 * @return The geometry property value.
 * @see #setGeometry
 */
public cbit.vcell.geometry.Geometry getGeometry() {
	return fieldGeometry;
}
/**
 * Comment
 */
private boolean getGeometryEditorButtonSelected() {
	return getgeoEditorToggleButton().isSelected();
}
/**
 * Return the GeometryToolBar property value.
 * @return javax.swing.JToolBar
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JToolBar getGeometryToolBar() {
	if (ivjGeometryToolBar == null) {
		try {
			ivjGeometryToolBar = new javax.swing.JToolBar();
			ivjGeometryToolBar.setName("GeometryToolBar");
			ivjGeometryToolBar.setFloatable(false);
			getGeometryToolBar().add(getgeoEditorToggleButton(), getgeoEditorToggleButton().getName());
			ivjGeometryToolBar.addSeparator();
			getGeometryToolBar().add(getSurfaceViewerToggleButton(), getSurfaceViewerToggleButton().getName());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjGeometryToolBar;
}
/**
 * Gets the geometryWindowManager property (cbit.vcell.client.GeometryWindowManager) value.
 * @return The geometryWindowManager property value.
 * @see #setGeometryWindowManager
 */
public cbit.vcell.client.GeometryWindowManager getGeometryWindowManager() {
	return fieldGeometryWindowManager;
}
/**
 * Comment
 */
private boolean getSurfaceViewerButtonSelected() {
	return getSurfaceViewerToggleButton().isSelected();
}
/**
 * Return the SurfaceViewerToggleButton property value.
 * @return cbit.gui.JToolBarToggleButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private org.vcell.util.gui.JToolBarToggleButton getSurfaceViewerToggleButton() {
	if (ivjSurfaceViewerToggleButton == null) {
		try {
			ivjSurfaceViewerToggleButton = new org.vcell.util.gui.JToolBarToggleButton();
			ivjSurfaceViewerToggleButton.setName("SurfaceViewerToggleButton");
			ivjSurfaceViewerToggleButton.setPreferredSize(new java.awt.Dimension(75, 25));
			ivjSurfaceViewerToggleButton.setText("Surface Viewer");
			ivjSurfaceViewerToggleButton.setMaximumSize(new java.awt.Dimension(100, 25));
			ivjSurfaceViewerToggleButton.setMinimumSize(new java.awt.Dimension(50, 25));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjSurfaceViewerToggleButton;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(java.lang.Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	exception.printStackTrace(System.out);
}
/**
 * Initializes connections
 * @exception java.lang.Exception The exception description.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() throws java.lang.Exception {
	// user code begin {1}
	// user code end
	getgeoEditorToggleButton().addActionListener(ivjEventHandler);
	getSurfaceViewerToggleButton().addActionListener(ivjEventHandler);
}
/**
 * Initialize the class.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	try {
		// user code begin {1}
		// user code end
		setName("GeometryEditor");
		setLayout(new java.awt.BorderLayout());
		setSize(233, 38);
		add(getGeometryToolBar(), "Center");
		initConnections();
		connEtoM1();
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
	// user code begin {2}
	// user code end
}
/**
 * main entrypoint - starts the part when it is run as an application
 * @param args java.lang.String[]
 */
public static void main(java.lang.String[] args) {
	try {
		JFrame frame = new javax.swing.JFrame();
		GeometryEditor aGeometryEditor;
		aGeometryEditor = new GeometryEditor();
		frame.setContentPane(aGeometryEditor);
		frame.setSize(aGeometryEditor.getSize());
		frame.addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				System.exit(0);
			};
		});
		frame.show();
		java.awt.Insets insets = frame.getInsets();
		frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
		frame.setVisible(true);
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of javax.swing.JPanel");
		exception.printStackTrace(System.out);
	}
}
/**
 * Sets the geometry property (cbit.vcell.geometry.Geometry) value.
 * @param geometry The new value for the property.
 * @see #getGeometry
 */
public void setGeometry(cbit.vcell.geometry.Geometry geometry) {
	cbit.vcell.geometry.Geometry oldValue = fieldGeometry;
	fieldGeometry = geometry;
	firePropertyChange("geometry", oldValue, geometry);
}

/**
 * Sets the geometryWindowManager property (cbit.vcell.client.GeometryWindowManager) value.
 * @param geometryWindowManager The new value for the property.
 * @see #getGeometryWindowManager
 */
public void setGeometryWindowManager(cbit.vcell.client.GeometryWindowManager geometryWindowManager) {
	cbit.vcell.client.GeometryWindowManager oldValue = fieldGeometryWindowManager;
	fieldGeometryWindowManager = geometryWindowManager;
	firePropertyChange("geometryWindowManager", oldValue, geometryWindowManager);
}
/**
 * Comment
 */
public void setToggleButtonSelected(String whichButton, boolean bSelected) {
	if (whichButton.equals("Geometry Editor")) {
		getgeoEditorToggleButton().setSelected(bSelected);
	} else if (whichButton.equals("Surface Viewer")) {
		getSurfaceViewerToggleButton().setSelected(bSelected);
	} 
}
/**
 * Comment
 */
private void showGeometryEditor(boolean bSelected) {
	if (getGeometryWindowManager() == null) {
		return;
	} else {
		getGeometryWindowManager().geometryEditorButtonPressed(bSelected);
	}
}
/**
 * Comment
 */
private void showSurfaceViewer(boolean bSelected) {
	if (getGeometryWindowManager() == null) {
		return;
	} else {
		getGeometryWindowManager().surfaceViewerButtonPressed(bSelected);
	}
}
/**
 * 
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private static void getBuilderData() {
/*V1.1
**start of data**
	D0CB838494G88G88GECFBB0B6GGGGGGGGGGGG8CGGGE2F5E9ECE4E5F2A0E4E1F4E135BA8BD0DBD7F61EB459529937F1DAB735332476F8F106DD13AC6D12145DF59B6F0EF757C9185651BA935A41996F46CDE8A7593A93326B26F467C9820C92FFF00CB75E46094946C940A6983031B111BF0040E0BE92C88112752EF9200790C8FA72531391B6B6BD771EF71F1E24A7C13C29E64E3CF74F3D775C733B671CFB1F384AA32BCB0D26CA0EB316F24A6F0C1163AA9BB86E65767D1FB1DC73C7868B
	27793D87301F4B5CD5824FAE6813078D168A6E2FE74B21FD855A6B078C1637607DG7735D95789F8C932CEAD74BD9128FEB075BADDB2DBE797EDCF756E0667DE00D14011E756C7E47D3BFA8FA9783B95BC8323096316D513B18F769ED6F0BBE0CCB960FA81C62BF1FC841E4840BDAD4D4A38AB77E5F2C5CFCA26BD040E06A603FCE5EE31722C62DEB3E6541035FEC879A4F3CEC15B87C004B7F36E8BE760E9F5CCFB4E0F0FF9653A6B63024FD7B76E738A81394EAD0426E5B1D86791C43FA0CB33ADAD1714378E37
	D796A52E6A98213D372F1C526238C2201BC5F157C5321E9B5E67G169FE378F3C1025F816F65478D162A63CC46F39FD99599C6EE7E9D372551DF32AF090C4D47D1365163D1997326361AFECD6D1196A6FACF073E8DGDBGF6829C2AB5D81A815E26FEF02FFC8C1E2DE3F23B68770B0156E0304D67167AC437600377169668D1F0034238A839B98EED1D57DB2B43CFAA40F97F72056721CEB2CFB23BE78DBE4295FC6BFE53AE9D1D94E45EB4B9EAD1971335D11D605A877A122D1DD69B6B1731EB8FF35A35B7DDFB
	46DC2A3376765FBFE3CED768E4EB565ED6CBEC7D6F5487B6433BD1718F4497D17C510F23F87451B90AA76DD3503762E3669BA3FB99AF3DA5EB380A063F5255430A6FAFB595FF0CBCD456457372A8753B0BF538669E15170D946F56601117F60AA76DB468AB82C07F3AEF066C5951936057G4B8132G72G8A810ACFB09F4B17CFAC52479C3CA437053DBE37A0F1B8773E702F60A9C4E4096F8E04E4BEB0AE8C7112179F7389A1CE9973C01868E0ACE65EAA6A7B633046A5A1A0C83C6C9583C01D079DABC8A19C13
	995ECF46C8826DF5F97D82AC608FF20CEEF678GBCFDFCC87EB46866E5A1BA827BF34344A65779A1208884609D75728F91222F4375864BA9GDBBD5343496B04DE0FA08584DFCBCB2FA8CE0703AEA289373C1E6879980D9DA3709E2CE7BA7E8E0D5D79505E2152193A7E26060E4DBBCE586725D93647F608A4AE17B4B01F79598873995B1E07395AE77ED257E7C62EBEE32EEAC0DFE9EE085FBB2FD11A04AFEC5FA50EA459CBA58D7AFB690B470A2FA6DD437C87525F2B5A2A7AA63155A870BC87105E40F43C76FA
	957AEC9B9F9218175AA5F0B0419D55B872795D60A1C51F042FD205FF227BB7D4D91E24E3F200FE81C0C92341D28B608218EBE4BA6D8E0E262073074A9B2BDBB7DDCBEF1DBDDF62DA284B2F4E107CA5DC07B4EA9302C2408DAFA125EF4D8CD9D7595F9322BAA7136203908F5AE18306D47CA3B3E44F7232ACF94742326094E4599B70C47B9F23EB0542E341E8A8E1EB7D7D8C11D51C01F8200E7F7E8C59CB63E2A0A0D0232AD3147E0DF4AF8BBE418FCC370B61000C78A7A3E4BFCC8B33CAAC7947C899C7E201AFCC
	6292569359BC51E7D0727A41D5C8E8630A9A49BEEF6DBB2451D18660C8DD34891E850DEC4F4E3C4F766C519BDF67B6DC8D1A74F24E0A35771A2CA7F13FB9CEC677AC7274782CBE6FBF20B1C54107105726F9B2B72E24D17688BFC76884017E5DG69A7599EE93DC17AD99CD2B6C73B687321AAD59D575D2CA0B6912E0585885FA4607528FAEB3A79E6DC5F1022C36CBFF71368502709150ED3C4075CB5D6AF66GBFF9GAF1DC4BD561EC2BD9451F19B55F16950A67BAF67940E5B280CC3FAF3929BF73149E099E9
	0A520BB4E9695507D4FACD380FF31A94FA4A386653E4DC21BA2EC8695FFD9A79BCFADACB6F5BB29BF777E90C876927F1FC36B28E6D73CA8D7199DA1BCE715779C8DDE8867C3E25653203876DE36D390E668FB2BE7FB42BB11FF5905BD51CB1D82A81AE1EE17E75749ED6E3AE1F4E64B224AD66E4F574489964E36ECC543FEAC7E74C689B6BEE11B557C3DF5E99669739B735F92EB59492473DB445AAB6754CE97D8FF13E395761B96115C2F2B7840888333FB4C778A5B9D8C1ABB5C94D355D0A2C5BE05DC34D86CB
	EEB3417F2B33D2433B83F0CBGB2G4C145E32EB0DA4FED0872D4307C310A6C449AF382B09E66B7899390E462A3AD65A5DC15EEB189DD6C4C8BD921A94E7E277CA7567B5C32CDEDCF3602232FE5EA3EBB86B7C6FCDFA75FB5A3EC993F796F5DAFDB62A5B8DCFEFB5ED81C0B9DFD66514E1CC56D9A607CBA2710717BC8D48570D765F4053A34831EC3505E5D98CB88532A5C1401A4F990F7F7D8E637128AD03EBAE1A56651140F605375DADD19E17791B4C9984A80FEBA546639598333C05596285371EAD72DA58F9
	6B45378EAA3AF40625899EAABB2FB0A3A82AD46C7CD9C835B34CBB748913FFC3A8D67E47265FC379E3C869082F505DAF337A5A81B453D43A910A77863C321777F9EF8855B508DFA31753B80514D0078F3F2B35F3B9FF0F2E8E177E1B4734619354DD61A7D19DD69B361A2C86E6671F4ACC4EFA2B41B2E9E5BA2ABCCF1EB42F2831E07758E14A0B2E2D6D819093F3FCF642F9E735B5DA1B65D8936BB4BC87748C90DEB6D9634FAA1FD2FC3EB57E2C325541F4D988FD3D67D86D7A5CBC09D959504E83588ED08CF078
	3C41E2BD4FE245EBF3A739854E865D81A859833C4F991354D90DFE0B2C8BF9D8E9675C526A8B75F062DA3C9EC64E474AAE4735F15E3904F9F5F16D95F17350BE7FF568FDCEFB0F6089FBA1D03BC4515746CBAE51637189E8AB259ED8BA202D87324FE37D1F8F4F17GB0369FF6917FA3393064820B6137BA35B1FC7D3EDB26B7126CE16B8564734A05287FD5747FDC0961E9C662CF6950178B309960A5000A0B10CB819C97192D4E5FBE37102DE830F4096D006B021C5D9EDFD7293AFD658EEDE2149632C970E26C
	BC14315CCCE4CC033E8C0075G79G45G07DA419FDB190C775DEEDDC8C675983998B957A5703BB8B93F3D201CD7DAE367211F3CA3B0BF11DB593962EA684EF870A74C0B67A12BD5EF5EDB72C2F7BC7A6BFD30603C0D2DFA361DAFA136AD003E1DG95ED6037G8EG9F4032B6E65B67EFFF32C87F454C1FE8D56433B0014F4569736789736275195D96BB8F6F85FEC46B3ACD50D7G00388CBB41F16D603F6D4C4E8383A4A7DA5576EFE91B64DCECBF6FC8F61E3E93A06BA44AD87C252E91FF4EC7BB3EB81F7CBC
	7933F97D73E4513C7EF97235797D08879A5A5BA756EF62D21FB7DF67744E1B6FD05E1F7855BECABB9492C25431EC3C4CABFDAF4A2476C9B8F776C3E4D164BE40CDDC33A8E3BAE4313D01E379E5F47EFFB95D330012E2D8AC58B8404E83A36D6CBCD06BA439FA9934B381B6283E721E0B79E63E462EAFA96F1C4DE029842836C57BF06F1515119A4F8A789100A0C09AC0260D6D39555C02793DA312A23F7F39B1392DD79A75ED3D4AC84EB2A1B1AC0D8B7176FC48F8C86D0B6E6FEED97093556318EF5279B29417C2
	02BFBCC667E3DF32790F9B13798C5A75187406E2D74704A47A4132B86FCDF3F2D9FFED56177508B9392C9F1A97167504B9392C274D8B4BFA411CDA561FCADA9FEED46344EF8466EF1BB4BED5203C6F00E7C98744360EE89F523BBF942B3BC6855FAFEB5669EBD0E578131264BADDD6222F537BCB126B74411205F57AD0C9F21DBEDC3230CE9FABC92D53A361D89D1CD4704F7511BBA89FBFAB06E528CDBB48FEFFD53DEB2A05368D4087302483EBCC0CA7FFB3C368CDC0D5834BB80342B8A7F712395F3533395BE0
	FC91C0A560CF8138BA59F969150F08FE59C10485A03471938344466BBB756F03B76B60711C311A46286D1DF84E58256233A83ED8034773C7A34513F665A503A5F2096548E6DAB397C0FB270A7B6584416D6E02F3C897430DFBD8AE2DD6F1BF2438DEE83BD5DCA52D2DA250DE5645625B5E32647EF530CC5F3F5EAE534FC56F15254EC5B5E5497C8279BBABB0F9B3D41E7FF308491B2B628607193C9BD55C2343CC36C295770DDBCC8745G286BF77A5937530AEE03252B1B79508BF504C7B5A711DB141616B6115C
	897622C3E2CE927A4B1579CB3AD9CE7A8BCAB3975A1B818A3B5979A672A1BB5FE4BD3406DB91503F235A663AE562AE23AF9D3D2C7956B5355504EB7E444E569C057E951789EE1FC3FBB7C1FC390F43FA8C7BDBE37A095EEBE27AC3B17D045F9F9B357DEBE37ACBB573D13627BEE03295BF154D799E3DBB69F76CED0ACCA5BD78DC36FD2531701BB74CE823EDB447DB214F55436C7613C1E65F499E165F9F22FBE4B934F38172D57C5FD2BC391764FA715E93714D4E4554F179BD293F75AC57694FD5579ED8549A3B
	9668577B96D44A31D8E9F7913D86A5E1C210A4416D745EA07555C8AF5153A40D8FD570DE5B4B6259C18F2919E55834693D64BF8F175A08AA0B68789B9EB59E76A64A057337FAC8AC05C06A75077DF4B5DC6BD59ACF2CFD30E77A58DA4785BA160F440DED277BD806F1CBG90B7C6F1D9504E85C05E665B233CF90799EF5B7B92F9C39A4F51BD3E937ACB7A995D9F53BDDE8FEDEBBF334B7B7DF776ED3F618E67CDFD61F9188F84BB715D49FE4C87C6959F20F8D903475835D20DDDCB20EFFBBF3B279A33915DF559
	A156834C81AC87488158ECE7F17E7132FAEE01BA56A586FBA19178B4219B65FB41FEE77FF9785EAE96A3F23E738DAE77AB362477BB5B6DCA0CF0A877494F2FB412A74A77EA87116F9474B9GE40025G2B81F29DCC3EDD3BEAD1BEF21758AA4B7C78A43D1DE742117B54A81A948968433F98A03CCE78C4B85A102FB34C57768D32181B87EB94B988EE67E0D5AA1BAA3CA35D15BD64FC6491C43C5B0C39B5E3E34E7A4937A3F66AF18A10B9F9985B407A9F2DA17247DC88475141FBEABE661E5ABA00775472G5BE7
	5F3A4429EB3EB271AEBC8342CC157A314066851510BFGD41FE92A2DEAEC2AE176DBBD237D2FD2736BF769FE43A310B6003227AB4F62038F981146BF7DD6CB2362811F4918044696E56E3601E88E447C375A434E011503AC37EE7A1DB67FD49D376B661F1D3F3BE16A9DC4FA4141A85DDCFF1599F513539D550DC5C8211B26FAC5B7B86F594B51F94F0D9DC9BE2F21DE190873AE74C6673DB03498DB208E6E9DE6BA4898E4F69D6B0B52DAF5EB71BCBC509F1D7719389819B18ECC5B49BCFC17B56F2B7A3F4CBB93
	7D981B7B7F3A864610E9DB72DAD832695742911BFEADFC5B167A5E65AB36645F797F54267D4E0FB1F04ACE76F88158FEA740E12741D28FE0F3327877F68779FEC67E0914987BBA5C9EF256A37FBE12597A3F6CC8AEEBE967427FD95A5BC93EF70E0990087C04BE43D7F692FB49E210A21533FFA751116475CC4AB8141D7DBB09CF7B04890AC6FFAC98A432CF703ED0749E6920131C8B5B85729D05452699016D7F436B3E469DBEF25134DFE77F9398F5623EDF6A0C6E7F3D9C2B314AAE133C015FBAC4FF1DF74CDF
	973E6E2F634764BA81A2F774D2CA8D4F389FD738597FA4B7B8D99E4EF3507A845A15AEE6171D170E43F3081FD2B2AE2683EA99C0BAA4B1A8C83272810C7EF3C031770F86B8D5CF673BBEC8C6832CFB99762DFDEC8A8E62AE5E236E17359EED4EBE857CF439D2573A4AB72FC112EB2F405888C0BAC08E40A600ED2ACCFF54D51DC2A6BCAED1FF13F8EFC0C6FE168FEB79A982DA651F2666C759F77664FEBAEBDF58CF6F22E7A7817C4BB59BD46EA77E58CE7CC91C1888896AFED8EA2FD0F15DA107987212FB8D5449
	D9D79571B3603799608A008C1086309AA087A06FD3261BF79D29F403874AF85DBC68CED5DF956A688957FA5A31D79BE350FD143EFCFAFED33F83533FAFB8E1E04003E72C75B4279683ED62E8087B9E45D58EA1CE392B9ECCF1D7BD38307EFFB1289FA77EE7B0B1CE181C7AF1225C290D93486B3A61C47E33079379373912735F63DA18FF17CB1F7F4FDD097CDFF56973AF38347CAB7F01D468CA6A25B96203743C07F7E0FDFC0077509C00726538593938FE085DDB709FEA3E778FFB5D72A4628FC776C471DD8261
	09E3E72D275C5A6F3571007F2F3716FD9D1ED9AFF325B2370FDD0FD521B74B5CDE25A82D422AB4A4F1EFA6168F2DFF764F4FE6DD35D51AB8D3B7D7B6C9F96866CAE78813112092F1FAC257385B1CC9E9B546345CB12D1E94FD64DE9673C24D3C365E5CF94FF8521AB5F79877D55EF0B4AF60FEDFD5CE74DCBEE2309C9DE17B7ABFF6FD1CECDFC38CF67AF91FCF66FD532D81B70947ED3332904D75996504FE080DD1BA31EFDDB961FBCAB3677FGD0CB878812F5B6043491GGBCB1GGD0CB818294G94G88G
	88GECFBB0B612F5B6043491GGBCB1GG8CGGGGGGGGGGGGGGGGGE2F5E9ECE4E5F2A0E4E1F4E1D0CB8586GGGG81G81GBAGGG6E91GGGG
**end of data**/
}
}
