/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.client.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.prefs.Preferences;

import javax.swing.*;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

import cbit.vcell.client.data.ExportedDataViewer;
import org.apache.commons.io.FileUtils;
import org.vcell.util.gui.GeneralGuiUtils;
import org.vcell.client.logicalwindow.LWTopFrame;
import org.vcell.documentation.VcellHelpViewer;
import org.vcell.imagej.ImageJHelper;
import org.vcell.util.*;
import org.vcell.util.document.User;
import org.vcell.util.document.UserLoginInfo;
import org.vcell.util.document.VCDocument;
import org.vcell.util.document.VCDocument.VCDocumentType;
import org.vcell.util.document.VCellSoftwareVersion;
import org.vcell.util.document.VersionFlag;
import org.vcell.util.gui.DialogUtils;
import org.vcell.util.gui.LinearDefiniteProgressDialog;
import org.vcell.util.gui.ProgressDialog;
import org.vcell.util.gui.SimpleUserMessage;
import org.vcell.util.gui.VCFileChooser;
import org.vcell.util.gui.VCellIcons;
import org.vcell.util.gui.exporter.FileFilters;
import org.vcell.util.importer.PathwayImportPanel.PathwayImportOption;

import cbit.util.xml.XmlUtil;
import cbit.vcell.biomodel.BioModel;
import cbit.vcell.biomodel.meta.VCMetaData;
import cbit.vcell.client.ChildWindowManager;
import cbit.vcell.client.ClientRequestManager;
import cbit.vcell.client.DocumentWindowManager;
import cbit.vcell.client.PopupGenerator;
import cbit.vcell.client.RequestManager;
import cbit.vcell.client.TopLevelWindowManager;
import cbit.vcell.client.UserMessage;
import cbit.vcell.client.constants.GuiConstants;
import cbit.vcell.client.server.ConnectionStatus;
import cbit.vcell.client.server.ReconnectListener;
import cbit.vcell.client.server.Reconnector;
import cbit.vcell.client.task.AsynchClientTask;
import cbit.vcell.client.task.ClientTaskDispatcher;
import cbit.vcell.client.task.LaunchVirtualFRAP;
import cbit.vcell.desktop.LoginDelegate;
import cbit.vcell.desktop.LoginManager;
import cbit.vcell.model.ReactionStep;
import cbit.vcell.model.TransformMassActions;
import cbit.vcell.model.TransformMassActions.TransformedReaction;
import cbit.vcell.model.gui.TransformMassActionPanel;
import cbit.vcell.resource.OperatingSystemInfo;
import cbit.vcell.resource.PropertyLoader;
import cbit.vcell.resource.ResourceUtil;

/**
 * This type was generated by a SmartGuide.
 */
@SuppressWarnings("serial")
public class DocumentWindow extends LWTopFrame implements TopLevelWindow, ReconnectListener {

	@SuppressWarnings("unused") //PENDING Window Manager redesign
	private final static String HelpViewerContextObject = "HelpViewerWindow";  // this object instance is the context for the help ChildWindow

	private final ChildWindowManager childWindowManager;

	private JMenuItem ivjAbout_BoxMenuItem = null;
	private JMenuItem ivjChange_UserMenuItem = null;
	private JMenuItem ivjUpdate_UserMenuItem = null;
	private JMenuItem ivjCloseMenuItem = null;
	private JMenuBar ivjDocumentWindowJMenuBar = null;
	private IvjEventHandler ivjEventHandler = new IvjEventHandler();
	private JMenuItem ivjExitMenuItem = null;
	private JMenu ivjFileMenu = null;
	private JMenu ivjHelpMenu = null;
	private JMenu ivjNewMenuItem = null;
	private JMenu ivjOpenMenuItem = null;
	//private JMenu recentMenuItem = new JMenu("Open Recent...");
	private JMenuItem ivjReconnectMenuItem = null;
//	private JMenuItem ivjImageJServiceMenuItem = null;
	private JMenuItem ivjSave_AsMenuItem = null;
	private JMenuItem ivjSave_AsLocalMenuItem = null;
	private JMenuItem ivjSave_VersionMenuItem = null;
	private JMenuItem ivjSaveMenuItem = null;
	private JMenu ivjServerMenu = null;
	private JCheckBoxMenuItem ivjStatusbarMenuItem = null;
	private JPanel ivjStatusBarPane = null;
	//--------------------------------------
	private JSeparator ivjJSeparator6 = null;
	private JMenuItem ivjJMenuItemNewBioModel = null;
	private JMenuItem ivjJMenuItemOpenBioModel = null;
	private JMenuItem ivjJMenuItemOpenGeometry = null;
	private JMenuItem ivjJMenuItemOpenLocal = null;
	private JMenuItem ivjJMenuItemOpenMathModel = null;
	private JProgressBar ivjJProgressBarMemory = null;
	private DocumentWindowManager fieldWindowManager = null;
	private JMenuItem ivjJMenuItemExport = null;
	private JMenuItem menuItemImport = null;
	private JProgressBar ivjJProgressBarConnection = null;
	private JMenuItem ivjJMenuItemCompare = null;
	private JMenuItem ivjJMenuItemRevert = null;
	private JMenuItem ivjGeometryMenu = null;
	private JMenuItem ivjMathFromBioMenuItem = null;
	private JMenu ivjMathMenu = null;
	private JMenuItem ivjNonSpatialMenuItem = null;
	private JMenuItem ivjSpatialExistingMenuItem = null;
	private JMenuItem ivjSpatialCreateNewMenuItem = null;
//	private JMenuItem ivjEdit_Annotation_JMenuItem = null;
	private JMenuItem ivjTestingFrameworkMenuItem = null;
	private JMenuItem ivjJMenuItemOnlineHelp = null;
	private JMenuItem ivjJMenuItemOnlineSupport = null;
	private JMenuItem ivjJMenuItemDiscussionGroup = null;
	private JMenuItem ivjJMenuItemManagePermissions = null;
	private JMenuItem ivjJMenuItemOnlinePublish = null;
	private JMenuItem jMenuItemGrantPermissionsToVCellSupport = null;

	private JMenuItem ivjJMenuItemEmailSupport = null;
	private JMenuItem newHelpMenuItem = null;
//	private JMenuItem ivjRunBNGMenuItem = null;
	private JMenuItem ivjRunVFrapMenuItem = null;
	//Added Oct. 17th, 2007. To put a tool menu in
	private JMenu toolMenu = null;
	private JMenuItem transMAMenuItem = null;
	private JMenuItem viewJobsMenuItem = null;
	private JMenuItem jMenuItemPermissions  = null;
	private JLabel warningText = null;
	private JLabel iconText = null;
	private JDialog viewSpeciesDialog = null;

	private JMenuItem exportedDataViewer = null;

	private JMenuItem menuItemImportPathwayWebLocation = null;
	private JMenuItem menuItemImportPathwayFile = null;
	private JMenuItem menuItemImportPathwayExample = null;

class IvjEventHandler implements java.awt.event.ActionListener, java.awt.event.ItemListener, java.awt.event.MouseListener {
		public void actionPerformed(java.awt.event.ActionEvent e) {
			try {
				if (e.getSource() == DocumentWindow.this.getAbout_BoxMenuItem())
					DocumentWindow.this.showAboutBox();
				if (e.getSource() == DocumentWindow.this.getCloseMenuItem())
					DocumentWindow.this.closeWindow();
				if (e.getSource() == DocumentWindow.this.getExitMenuItem())
					DocumentWindow.this.exitApplication();
				if (e.getSource() == DocumentWindow.this.getJMenuItemNewBioModel())
					DocumentWindow.this.newDocument(e);
				if (e.getSource() == DocumentWindow.this.getJMenuItemOpenBioModel())
					DocumentWindow.this.openDocument(e);
				if (e.getSource() == DocumentWindow.this.getJMenuItemOpenLocal())
					importExternalDocument();
				if (e.getSource() == DocumentWindow.this.getJMenuItemOpenMathModel())
					DocumentWindow.this.openDocument(e);
				if (e.getSource() == DocumentWindow.this.getSaveMenuItem())
					DocumentWindow.this.saveDocument(true);
				if (e.getSource() == DocumentWindow.this.getSave_AsMenuItem())
					DocumentWindow.this.saveDocumentAsNew();
				if (e.getSource() == DocumentWindow.this.getSave_AsLocalMenuItem())
					saveAsLocal();
				try {
					if (e.getSource() == DocumentWindow.this.getJMenuItemImport())
						DocumentWindow.this.importExternalDocument();
					if (e.getSource() == DocumentWindow.this.menuItemImportPathwayWebLocation)
						DocumentWindow.this.importPathway(PathwayImportOption.Web_Location);
					else if (e.getSource() == DocumentWindow.this.menuItemImportPathwayFile)
						DocumentWindow.this.importPathway(PathwayImportOption.File);
					else if (e.getSource() == DocumentWindow.this.menuItemImportPathwayExample)
						DocumentWindow.this.importPathway(PathwayImportOption.Example);
				} catch (Throwable throwable) {
					DocumentWindow.this.handleException(throwable);
				}
				if (e.getSource() == DocumentWindow.this.getSave_VersionMenuItem())
					DocumentWindow.this.saveDocument(false);
				if (e.getSource() == DocumentWindow.this.getChange_UserMenuItem())
					DocumentWindow.this.showLoginDialog();
				if (e.getSource() == DocumentWindow.this.getChange_ProxyMenuItem())
					setProxy();
				if (e.getSource() == DocumentWindow.this.getReconnectMenuItem())
					DocumentWindow.this.reconnect();
//			if (e.getSource() == DocumentWindow.this.getImageJServiceMenuItem())
//				startStopImageJService();
				if (e.getSource() == DocumentWindow.this.getJMenuItemRevert())
					DocumentWindow.this.revertToSaved();
				if (e.getSource() == DocumentWindow.this.getJMenuItemCompare())
					DocumentWindow.this.compareWithSaved();
				if (e.getSource() == DocumentWindow.this.getNonSpatialMenuItem())
					DocumentWindow.this.newDocument(e);
				if (e.getSource() == DocumentWindow.this.getMathFromBioMenuItem())
					DocumentWindow.this.newDocument(e);
				if (e.getSource() == DocumentWindow.this.getSpatialExistingMenuItem())
					newDocument(e);
				if (e.getSource() == DocumentWindow.this.getSpatialCreateNewMenuItem())
					newDocument(e);
				if (e.getSource() == DocumentWindow.this.getJMenuItemExport())
					DocumentWindow.this.exportDocument();
//			if (e.getSource() == DocumentWindow.this.getEdit_Annotation_JMenuItem())
//				connEtoC36(e);
				if (e.getSource() == DocumentWindow.this.getTestingFrameworkMenuItem())
					DocumentWindow.this.showTestingFrameworkWindow();
				if (e.getSource() == DocumentWindow.this.getJMenuItemOnlineHelp())
					DocumentWindow.this.invokeOnlineHelp();
				if (e.getSource() == DocumentWindow.this.getJMenuItemOnlineSupport())
					onlineSupport(e);
				if (e.getSource() == DocumentWindow.this.getJMenuItemDiscussionGroup())
					discussionGroup(e);
				if (e.getSource() == DocumentWindow.this.getJMenuItemManagePermissions())
					managePermissions(e);
				if (e.getSource() == DocumentWindow.this.getJMenuItemOnlinePublish())
					onlinePublish(e);

				if (e.getSource() == DocumentWindow.this.getJMenuItemEmailSupport())
					emailSupport(e);
				if (e.getSource() == DocumentWindow.this.getNewHelpMenuItem())
					showVCellHelpWindow();
//			if (e.getSource() == DocumentWindow.this.getRunBNGMenuItem())
//				connEtoC26(e);
				if (e.getSource() == DocumentWindow.this.getRunVFrapItem())
					startVirtualFRAP();
				if (e.getSource() == DocumentWindow.this.getTransMAMenuItem())
					showTransMADialog();
				if (e.getSource() == DocumentWindow.this.getViewJobsMenuItem())
					showViewJobsDialog();
				if (e.getSource() == DocumentWindow.this.getJMenuItemFieldData())
					DocumentWindow.this.jMenuItemFieldData_ActionPerformed(e);
				if (e.getSource() == DocumentWindow.this.getUpdate_UserMenuItem()){
					getWindowManager().getRequestManager().updateUserRegistration(getWindowManager(), false);
				}
				if (e.getSource() == DocumentWindow.this.getPermissionsMenuItem()) {
					getWindowManager().getRequestManager().accessPermissions(DocumentWindow.this, getWindowManager().getVCDocument());
				}
				if (e.getSource() == DocumentWindow.this.getGrantPermissionsToVCellSupportMenuItem()) {
					RequestManager rm = getWindowManager().getRequestManager();
					if(rm instanceof ClientRequestManager) {
						ClientRequestManager crm = (ClientRequestManager)rm;
						crm.accessPermissionsEx(DocumentWindow.this, getWindowManager().getVCDocument(), true);
					} else {
						rm.accessPermissions(DocumentWindow.this, getWindowManager().getVCDocument());
					}
				}
				if (e.getSource() == DocumentWindow.this.getExportedDataViewer()){
					DocumentWindow.this.showViewExportedDataDialog();
				}
			}
			catch (Throwable throwable){
				handleException(throwable);
			}

		};

		public void itemStateChanged(java.awt.event.ItemEvent e) {
			if (e.getSource() == DocumentWindow.this.getStatusbarMenuItem())
				try {
					// user code begin {1}
					// user code end
					DocumentWindow.this.viewStatusBar();
					// user code begin {2}
					// user code end
				} catch (Throwable ivjExc) {
					// user code begin {3}
					// user code end
					handleException(ivjExc);
				}
		}

		@Override
		public void mouseClicked(MouseEvent e) {
		}
		@Override
		public void mouseEntered(MouseEvent e) {
		}
		@Override
		public void mouseExited(MouseEvent e) {
		}
		@Override
		public void mousePressed(MouseEvent e) {
		}
		@Override
		public void mouseReleased(MouseEvent e) {
			if(e.getSource() == DocumentWindow.this.getIconBar()) {
				onNotificationsIconClick();
			}
		};
	};
	private JMenuItem ivjJMenuItemFieldData = null;
//	private JMenuItem jMenuItemMIRIAM = null;
	private JMenuItem jMenuItemPreferences = null;

/**
 * DocumentWindow constructor comment.
 */
public DocumentWindow() {
	super();
	initialize();
	childWindowManager = new ChildWindowManager(this);
}

@Override
public String menuDescription() {
	return getTitle( );
}

/**
 * Comment
 */
private void closeWindow() {
		getWindowManager().closeWindow();
}


/**
 * Comment
 */
private void compareWithSaved() {
	getWindowManager().compareWithSaved();
}


	private void setProxy(){
	try {
		NetworkProxyPreferences.setProxyPrefs(this, (restartMsg) -> DialogUtils.showInfoDialog(this, restartMsg) );
		if(getTopLevelWindowManager()==null || getTopLevelWindowManager().getRequestManager()==null ||
			getTopLevelWindowManager().getRequestManager().getDocumentManager()==null){
			DialogUtils.showInfoDialog(this, "Update Proxy settings by restarting VCell or using menu Server->'change user' or Server->reconnect");
		}else if(getTopLevelWindowManager().getRequestManager().getDocumentManager().getUser() == null){
			showLoginDialog();
		}else{
			reconnect();
		}
	} catch (UtilCancelException e) {
		return;
	}
}



	private void showVCellHelpWindow() {
	VcellHelpViewer.showStandaloneViewer();
	//PENDING Window Manager redesign

//	ChildWindow helpWindow = childWindowManager.getChildWindowFromContext(HelpViewerContextObject);
//	if (helpWindow!=null){
//		helpWindow.show();
//	}else{
//		VcellHelpViewer vcellHelpViewer = new VcellHelpViewer(VcellHelpViewer.VCELL_DOC_URL);
//		showHierarchy("create",vcellHelpViewer);
//		String title = "Virtual Cell Help" + " -- VCell " + DocumentWindowAboutBox.getVERSION_NO() + " (build " + DocumentWindowAboutBox.getBUILD_NO() + ")";
//		helpWindow = childWindowManager.addChildWindow(vcellHelpViewer, HelpViewerContextObject, title);
//		showHierarchy("acw",vcellHelpViewer);
//		vcellHelpViewer.setCloseMyParent(helpWindow);
//		helpWindow.setPreferredSize(new Dimension(VcellHelpViewer.DEFAULT_HELP_DIALOG_WIDTH,VcellHelpViewer.DEFAULT_HELP_DIALOG_HEIGHT));
//		helpWindow.pack();
//		helpWindow.setIsCenteredOnParent();
//		showHierarchy("bshow",vcellHelpViewer);
//		helpWindow.show();
//		showHierarchy("shown",vcellHelpViewer);
//	}
}

@SuppressWarnings("unused") //Pending Window Manager redesign
private void showHierarchy(String when, VcellHelpViewer vcellHelpViewer ) {
	/*
		System.out.println(when);
		Container ctn = vcellHelpViewer.getParent();
		while (ctn != null) {
			System.out.println(ctn + ": " + ctn.getName() + " : " + ctn.getClass().getName());
			ctn = ctn.getParent();
		}
	*/
}

	private void onlineSupport(java.awt.event.ActionEvent arg1) {
	try {
		this.invokeOnlineSupport();
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
}
private void discussionGroup(java.awt.event.ActionEvent arg1) {
	try {
		this.invokeDiscussionGroup();
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
}
private void managePermissions(java.awt.event.ActionEvent arg1) {
	try {
		this.invokeManagePermissions();
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
}
private void onlinePublish(java.awt.event.ActionEvent arg1) {
	try {
		this.invokeOnlinePublish();
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
}

private void emailSupport(java.awt.event.ActionEvent arg1) {
	try {
	Desktop desktop;
	if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.MAIL) ) {
		URI mailto = new URI("mailto:vcell_support@uchc.edu");		// "mailto:john@example.com?subject=Hello%20World"
		desktop.mail(mailto);
	} else {
		throw new RuntimeException("Desktop doesn't support mailto");
	}
	} catch(URISyntaxException | IOException ex) {
		handleException(ex);
	}
	
	
	
}

///**
// * connEtoC26:  (RunBNGMenuItem.action.actionPerformed(java.awt.event.ActionEvent) --> DocumentWindow.launchBNG()V)
// * @param arg1 java.awt.event.ActionEvent
// */
///* WARNING: THIS METHOD WILL BE REGENERATED. */
//private void connEtoC26(java.awt.event.ActionEvent arg1) {
//	try {
//		// user code begin {1}
//		// user code end
//		this.showBNGWindow();
//		// user code begin {2}
//		// user code end
//	} catch (java.lang.Throwable ivjExc) {
//		// user code begin {3}
//		// user code end
//		handleException(ivjExc);
//	}
//}


	/**
 * connEtoC36:  (Edit_Annotation_JMenuItem.action.actionPerformed(java.awt.event.ActionEvent) --> DocumentWindow.showEditAnnotationWindow()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC36(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.showEditAnnotationWindow();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}



	/**
 * Comment
 */
private void exitApplication() {
	getWindowManager().exitApplication();
}


/**
 * Comment
 */
private void exportDocument() {
	getWindowManager().exportDocument(null);
}


/**
 * Return the About_BoxMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getAbout_BoxMenuItem() {
	if (ivjAbout_BoxMenuItem == null) {
		try {
			ivjAbout_BoxMenuItem = new javax.swing.JMenuItem();
			ivjAbout_BoxMenuItem.setName("About_BoxMenuItem");
			ivjAbout_BoxMenuItem.setText("About VCell");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAbout_BoxMenuItem;
}


private void startVirtualFRAP(){
	final DocumentWindowManager dwm = getWindowManager();
	final Hashtable<String,Object> ht = new Hashtable<>();
	ClientTaskDispatcher.dispatch(this, ht,LaunchVirtualFRAP.taskList(dwm), true,false,false,null,false);
}

/**
 * Return the tool menu.
 * @return javax.swing.JMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private JMenu getToolMenu() {
	if (toolMenu == null) {
		try {
			toolMenu = new javax.swing.JMenu();
			//getImageJServiceMenuItem().setText(createImageJServiceMenuText());
			toolMenu.addMenuListener(new MenuListener() {
				@Override
				public void menuSelected(MenuEvent e) {
//					getImageJServiceMenuItem().setText(createImageJServiceMenuText());
				}
				@Override
				public void menuDeselected(MenuEvent e) {
				}
				@Override
				public void menuCanceled(MenuEvent e) {
				}
			});

			toolMenu.setName("ToolMenu");
			toolMenu.setText("Tools");
//			toolMenu.add(getRunBNGMenuItem());
			toolMenu.add(new JSeparator());
			toolMenu.add(getRunVFrapItem());
			toolMenu.add(getExportedDataViewer());
//			toolMenu.add(getImageJServiceMenuItem());	// moved here from Tools
		    toolMenu.add(new JSeparator());
//			toolMenu.add(new JSeparator());
			toolMenu.add(getTransMAMenuItem());
//			toolMenu.add(getViewJobsMenuItem());		// moved to Server
		} catch (Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	return toolMenu;
}

/**
 * Return the getTransMAMenuItem.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getTransMAMenuItem() {
	if (transMAMenuItem == null) {
		try {
			transMAMenuItem = new javax.swing.JMenuItem();
			transMAMenuItem.setName("TransMA");
			transMAMenuItem.setText("Transform to Stochastic Capable");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return transMAMenuItem;
}

private javax.swing.JMenuItem getViewJobsMenuItem() {
	if (viewJobsMenuItem == null) {
		try {
			viewJobsMenuItem = new javax.swing.JMenuItem();
			viewJobsMenuItem.setName("ViewJobs");
			viewJobsMenuItem.setText("View Simulation Jobs");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return viewJobsMenuItem;
}

/**
 * Return the Change_UserMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getChange_UserMenuItem() {
	if (ivjChange_UserMenuItem == null) {
		try {
			ivjChange_UserMenuItem = new javax.swing.JMenuItem();
			ivjChange_UserMenuItem.setName("Change_UserMenuItem");
			ivjChange_UserMenuItem.setText("Change User...");
			ivjChange_UserMenuItem.setEnabled(true);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjChange_UserMenuItem;
}

private JMenuItem ivjChange_ProxyMenuItem;
private javax.swing.JMenuItem getChange_ProxyMenuItem() {
	if (ivjChange_ProxyMenuItem == null) {
		try {
			ivjChange_ProxyMenuItem = new javax.swing.JMenuItem();
			ivjChange_ProxyMenuItem.setName("Change_ProxyMenuItem");
			ivjChange_ProxyMenuItem.setText("Set Proxy...");
			ivjChange_ProxyMenuItem.setEnabled(true);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjChange_ProxyMenuItem;
}


private javax.swing.JMenuItem getUpdate_UserMenuItem() {
	if (ivjUpdate_UserMenuItem == null) {
		try {
			ivjUpdate_UserMenuItem = new javax.swing.JMenuItem();
			ivjUpdate_UserMenuItem.setName("Update_UserMenuItem");
			ivjUpdate_UserMenuItem.setText("Update Registration Info...");
			ivjUpdate_UserMenuItem.setEnabled(false);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjUpdate_UserMenuItem;
}

/**
 * Return the CloseMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getCloseMenuItem() {
	if (ivjCloseMenuItem == null) {
		try {
			ivjCloseMenuItem = new javax.swing.JMenuItem();
			ivjCloseMenuItem.setName("CloseMenuItem");
			ivjCloseMenuItem.setText("Close");
			ivjCloseMenuItem.setAccelerator(GeneralGuiUtils.CLOSE_WINDOW_KEY_STROKE);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjCloseMenuItem;
}

/**
 * Return the DocumentWindowJMenuBar property value.
 * @return javax.swing.JMenuBar
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuBar getDocumentWindowJMenuBar() {
	if (ivjDocumentWindowJMenuBar == null) {
		try {
			ivjDocumentWindowJMenuBar = new javax.swing.JMenuBar();
			ivjDocumentWindowJMenuBar.setName("DocumentWindowJMenuBar");
			ivjDocumentWindowJMenuBar.add(getFileMenu());
			ivjDocumentWindowJMenuBar.add(getServerMenu());
			ivjDocumentWindowJMenuBar.add(createWindowMenu(true));
			ivjDocumentWindowJMenuBar.add(getToolMenu());
			ivjDocumentWindowJMenuBar.add(getHelpMenu());
			ivjDocumentWindowJMenuBar.add(Box.createHorizontalGlue());
			ivjDocumentWindowJMenuBar.add(createWindowMenu(false));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjDocumentWindowJMenuBar;
}

/**
 * Return the Edit_Annotation_JMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
//private javax.swing.JMenuItem getEdit_Annotation_JMenuItem() {
//	if (ivjEdit_Annotation_JMenuItem == null) {
//		try {
//			ivjEdit_Annotation_JMenuItem = new javax.swing.JMenuItem();
//			ivjEdit_Annotation_JMenuItem.setName("Edit_Annotation_JMenuItem");
//			ivjEdit_Annotation_JMenuItem.setText("Edit Annotation...");
//			// user code begin {1}
//			// user code end
//		} catch (java.lang.Throwable ivjExc) {
//			// user code begin {2}
//			// user code end
//			handleException(ivjExc);
//		}
//	}
//	return ivjEdit_Annotation_JMenuItem;
//}

/**
 * Return the ExitMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getExitMenuItem() {
	if (ivjExitMenuItem == null) {
		try {
			ivjExitMenuItem = new javax.swing.JMenuItem();
			ivjExitMenuItem.setName("ExitMenuItem");
			ivjExitMenuItem.setText("Exit");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjExitMenuItem;
}

/**
 * Return the FileMenu property value.
 * @return javax.swing.JMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenu getFileMenu() {
	if (ivjFileMenu == null) {
		try {
			ivjFileMenu = new javax.swing.JMenu();
			ivjFileMenu.setName("FileMenu");
			ivjFileMenu.setText("File");
			ivjFileMenu.add(getNewMenuItem());
			ivjFileMenu.add(getOpenMenuItem());
			//ivjFileMenu.add(recentMenuItem); gcw pending
			ivjFileMenu.add(getCloseMenuItem());
			ivjFileMenu.add(new JSeparator());
			ivjFileMenu.add(getSaveMenuItem());
			ivjFileMenu.add(getSave_VersionMenuItem());
			ivjFileMenu.add(getSave_AsMenuItem());
			ivjFileMenu.add(getSave_AsLocalMenuItem());
			ivjFileMenu.add(new JSeparator());
			ivjFileMenu.add(getJMenuItemRevert());
			ivjFileMenu.add(getJMenuItemCompare());
			ivjFileMenu.add(new JSeparator());
			ivjFileMenu.add(getPermissionsMenuItem());
//			ivjFileMenu.add(getJMenuItemMIRIAM());
//			ivjFileMenu.add(getJMenuItemPreferences());
//			ivjFileMenu.add(getEdit_Annotation_JMenuItem());
			ivjFileMenu.add(new JSeparator());
			ivjFileMenu.add(getJMenuItemFieldData());
			ivjFileMenu.add(getTestingFrameworkMenuItem());
			ivjFileMenu.add(new JSeparator());
			ivjFileMenu.add(getJMenuItemImport());
			ivjFileMenu.add(getJMenuItemExport());
			ivjFileMenu.add(new JSeparator());
			//ivjFileMenu.add(getJMenuImportPathway());
			ivjFileMenu.add(new JSeparator());
			ivjFileMenu.add(getExitMenuItem());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjFileMenu;
}

private JMenuItem getExportedDataViewer(){
	if(exportedDataViewer == null){
		exportedDataViewer = new JMenuItem();
		exportedDataViewer.setName("Exported Data Viewer");
		exportedDataViewer.setText("Exported Data Viewer");
	}
	return exportedDataViewer;
}

/**
 * Return the GeometryMenu property value.
 * @return javax.swing.JMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getGeometryMenuItem() {
	if (ivjGeometryMenu == null) {
		try {
			ivjGeometryMenu = new javax.swing.JMenuItem();
			ivjGeometryMenu.setName("GeometryMenu");
			ivjGeometryMenu.setText("Geometry");
			ivjGeometryMenu.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					DocumentWindow.showGeometryCreationWarning(DocumentWindow.this);
				}
			});
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjGeometryMenu;
}

public static void showGeometryCreationWarning(Component parentComponent){
	DialogUtils.showWarningDialog(parentComponent,
			"Geometries are now viewed/edited/created within BioModels or MathModels.\n"+
			"\nBioModel geometries are viewed/edited from a BioModel document within an Application in the 'Geometry' section.\n"+
			" \nMathModel geometries are viewed/edited from a MathModel document by pressing the 'Geometry Viewer' button.");

}
/**
 * Return the HelpMenu property value.
 * @return javax.swing.JMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenu getHelpMenu() {
	if (ivjHelpMenu == null) {
		try {
			ivjHelpMenu = new javax.swing.JMenu();
			ivjHelpMenu.setName("HelpMenu");
			ivjHelpMenu.setText("Help");
			ivjHelpMenu.add(getNewHelpMenuItem());
			ivjHelpMenu.add(getJMenuItemOnlineHelp());
			//ivjHelpMenu.add(getJMenuItemOnlineSupport());
			ivjHelpMenu.add(getJMenuItemDiscussionGroup());
			ivjHelpMenu.add(getJMenuItemManagePermissions());
			ivjHelpMenu.add(getJMenuItemOnlinePublish());
			ivjHelpMenu.add(getJMenuItemEmailSupport());
			ivjHelpMenu.add(getGrantPermissionsToVCellSupportMenuItem());
			ivjHelpMenu.add(getJMenuItemPreferences());

//			ivjHelpMenu.add(getSeparator());
//			ivjHelpMenu.add(getPermissionsMenuItem());

			ivjHelpMenu.add(getJSeparator6());
			ivjHelpMenu.add(getMntmLicenseInformation());
			ivjHelpMenu.add(getAbout_BoxMenuItem());
//			ivjHelpMenu.add(getSeparator());
			ivjHelpMenu.add(getStatusbarMenuItem());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjHelpMenu;
}

/**
 * Return the JMenuItemCompare property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getJMenuItemCompare() {
	if (ivjJMenuItemCompare == null) {
		try {
			ivjJMenuItemCompare = new javax.swing.JMenuItem();
			ivjJMenuItemCompare.setName("JMenuItemCompare");
			ivjJMenuItemCompare.setText("Compare with Saved");
			ivjJMenuItemCompare.setEnabled(false);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJMenuItemCompare;
}

/**
 * Return the JMenuItemExport property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getJMenuItemExport() {
	if (ivjJMenuItemExport == null) {
		try {
			ivjJMenuItemExport = new javax.swing.JMenuItem();
			ivjJMenuItemExport.setName("JMenuItemExport");
			ivjJMenuItemExport.setText("Export...");
			ivjJMenuItemExport.setActionCommand(GuiConstants.ACTIONCMD_EXPORT);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJMenuItemExport;
}

/**
 * Return the JMenuItemFieldData property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getJMenuItemFieldData() {
	if (ivjJMenuItemFieldData == null) {
		try {
			ivjJMenuItemFieldData = new javax.swing.JMenuItem();
			ivjJMenuItemFieldData.setName("JMenuItemFieldData");
			ivjJMenuItemFieldData.setText("Field Data...");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJMenuItemFieldData;
}


private JMenuItem getJMenuItemImport() {
	if (menuItemImport == null) {
		try {
			menuItemImport = new JMenuItem();
			menuItemImport.setName("JMenuItemImport");
			menuItemImport.setText("Import...");
		} catch (Throwable throwable) {
			handleException(throwable);
		}
	}
	return menuItemImport;
}

/**
 * Return the JMenuItemNewBioModel property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getJMenuItemNewBioModel() {
	if (ivjJMenuItemNewBioModel == null) {
		try {
			ivjJMenuItemNewBioModel = new javax.swing.JMenuItem();
			ivjJMenuItemNewBioModel.setName("JMenuItemNewBioModel");
			ivjJMenuItemNewBioModel.setText("BioModel");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJMenuItemNewBioModel;
}


/**
 * Return the Help_TopicsMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getJMenuItemOnlineHelp() {
	if (ivjJMenuItemOnlineHelp == null) {
		try {
			ivjJMenuItemOnlineHelp = new javax.swing.JMenuItem();
			ivjJMenuItemOnlineHelp.setName("JMenuItemOnlineHelp");
			ivjJMenuItemOnlineHelp.setText("VCell Website");		// "Online Resources"
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJMenuItemOnlineHelp;
}
private javax.swing.JMenuItem getJMenuItemOnlineSupport() {
	if (ivjJMenuItemOnlineSupport == null) {
		try {
			ivjJMenuItemOnlineSupport = new javax.swing.JMenuItem();
			ivjJMenuItemOnlineSupport.setName("JMenuItemOnlineSupport");
			ivjJMenuItemOnlineSupport.setText("VCell Support on the Web");
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	return ivjJMenuItemOnlineSupport;
}
private javax.swing.JMenuItem getJMenuItemDiscussionGroup() {
	if (ivjJMenuItemDiscussionGroup == null) {
		try {
			ivjJMenuItemDiscussionGroup = new javax.swing.JMenuItem();
			ivjJMenuItemDiscussionGroup.setName("JMenuItemDiscussionGroup");
			ivjJMenuItemDiscussionGroup.setText("VCell Open Discussion Forum");
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	return ivjJMenuItemDiscussionGroup;
}
private javax.swing.JMenuItem getJMenuItemManagePermissions() {
	if (ivjJMenuItemManagePermissions == null) {
		try {
			ivjJMenuItemManagePermissions = new javax.swing.JMenuItem();
			ivjJMenuItemManagePermissions.setName("JMenuItemManagePermissions");
			ivjJMenuItemManagePermissions.setText("How to Change Permissions");
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	return ivjJMenuItemManagePermissions;
}
private javax.swing.JMenuItem getJMenuItemOnlinePublish() {
	if (ivjJMenuItemOnlinePublish == null) {
		try {
			ivjJMenuItemOnlinePublish = new javax.swing.JMenuItem();
			ivjJMenuItemOnlinePublish.setName("JMenuItemOnlinePublish");
			ivjJMenuItemOnlinePublish.setText("How to Publish a Model ");
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	return ivjJMenuItemOnlinePublish;
}
private javax.swing.JMenuItem getJMenuItemEmailSupport() {
	if (ivjJMenuItemEmailSupport == null) {
		try {
			ivjJMenuItemEmailSupport = new javax.swing.JMenuItem();
			ivjJMenuItemEmailSupport.setName("JMenuItemEmailSupport");
			ivjJMenuItemEmailSupport.setText("Contact VCell Support");
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	return ivjJMenuItemEmailSupport;
}

private javax.swing.JMenuItem getNewHelpMenuItem() {
	if (newHelpMenuItem == null) {
		try {
			newHelpMenuItem = new javax.swing.JMenuItem();
			newHelpMenuItem.setName("newHelpMenuItem");
			newHelpMenuItem.setText("VCell Help");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return newHelpMenuItem;
}

/**
 * Return the JMenuItemOpenBioModel property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getJMenuItemOpenBioModel() {
	if (ivjJMenuItemOpenBioModel == null) {
		try {
			ivjJMenuItemOpenBioModel = new javax.swing.JMenuItem();
			ivjJMenuItemOpenBioModel.setName("JMenuItemOpenBioModel");
			ivjJMenuItemOpenBioModel.setText("BioModel...");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJMenuItemOpenBioModel;
}

private javax.swing.JMenuItem getJMenuItemOpenLocal() {
	if (ivjJMenuItemOpenLocal == null) {
		try {
			ivjJMenuItemOpenLocal = new javax.swing.JMenuItem();
			ivjJMenuItemOpenLocal.setName("JMenuItemOpenLocal");
			ivjJMenuItemOpenLocal.setText("Local...");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJMenuItemOpenLocal;
}

/**
 * Return the JMenuItemOpenGeometry property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getJMenuItemOpenGeometry() {
	if (ivjJMenuItemOpenGeometry == null) {
		try {
			ivjJMenuItemOpenGeometry = new javax.swing.JMenuItem();
			ivjJMenuItemOpenGeometry.setName("JMenuItemOpenGeometry");
			ivjJMenuItemOpenGeometry.setText("Geometry...");
			ivjJMenuItemOpenGeometry.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					DocumentWindow.showGeometryCreationWarning(DocumentWindow.this);
				}
			});
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJMenuItemOpenGeometry;
}

/**
 * Return the JMenuItemOpenMathModel property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getJMenuItemOpenMathModel() {
	if (ivjJMenuItemOpenMathModel == null) {
		try {
			ivjJMenuItemOpenMathModel = new javax.swing.JMenuItem();
			ivjJMenuItemOpenMathModel.setName("JMenuItemOpenMathModel");
			ivjJMenuItemOpenMathModel.setText("MathModel...");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJMenuItemOpenMathModel;
}

/**
 * Return the JMenuItemRevert property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getJMenuItemRevert() {
	if (ivjJMenuItemRevert == null) {
		try {
			ivjJMenuItemRevert = new javax.swing.JMenuItem();
			ivjJMenuItemRevert.setName("JMenuItemRevert");
			ivjJMenuItemRevert.setText("Revert to Saved");
			ivjJMenuItemRevert.setEnabled(false);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJMenuItemRevert;
}

/**
 * Return the JProgressBarConnection property value.
 * @return javax.swing.JProgressBar
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JProgressBar getJProgressBarConnection() {
	if (ivjJProgressBarConnection == null) {
		try {
			ivjJProgressBarConnection = new javax.swing.JProgressBar();
			ivjJProgressBarConnection.setName("JProgressBarConnection");
			ivjJProgressBarConnection.setString("NOT CONNECTED");
			ivjJProgressBarConnection.setStringPainted(true);
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	return ivjJProgressBarConnection;
}

/**
 * Return the JProgressBarMemory property value.
 * @return javax.swing.JProgressBar
 */
private javax.swing.JProgressBar getJProgressBarMemory() {
	if (ivjJProgressBarMemory == null) {
		try {
			ivjJProgressBarMemory = new javax.swing.JProgressBar();
			ivjJProgressBarMemory.setName("JProgressBarMemory");
			ivjJProgressBarMemory.setMinimum(0);
			ivjJProgressBarMemory.setStringPainted(true);
			ivjJProgressBarMemory.setToolTipText("Java Memory Usage");
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	return ivjJProgressBarMemory;
}

/**
 * Return the JSeparator6 property value.
 * @return javax.swing.JSeparator
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JSeparator getJSeparator6() {
	if (ivjJSeparator6 == null) {
		try {
			ivjJSeparator6 = new javax.swing.JSeparator();
			ivjJSeparator6.setName("JSeparator6");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJSeparator6;
}

/**
 * Comment
 */

/**
 * Return the MathFromBioMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getMathFromBioMenuItem() {
	if (ivjMathFromBioMenuItem == null) {
		try {
			ivjMathFromBioMenuItem = new javax.swing.JMenuItem();
			ivjMathFromBioMenuItem.setName("MathFromBioMenuItem");
			ivjMathFromBioMenuItem.setText("From BioModel");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjMathFromBioMenuItem;
}


/**
 * Return the MathMenu property value.
 * @return javax.swing.JMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenu getMathMenu() {
	if (ivjMathMenu == null) {
		try {
			ivjMathMenu = new javax.swing.JMenu();
			ivjMathMenu.setName("MathMenu");
			ivjMathMenu.setText("MathModel");
			ivjMathMenu.add(getNonSpatialMenuItem());
			ivjMathMenu.add(getSpatialExistingMenuItem());
			ivjMathMenu.add(getSpatialCreateNewMenuItem());
			ivjMathMenu.add(getMathFromBioMenuItem());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjMathMenu;
}

/**
 * Return the NewMenuItem property value.
 * @return javax.swing.JMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenu getNewMenuItem() {
	if (ivjNewMenuItem == null) {
		try {
			ivjNewMenuItem = new javax.swing.JMenu();
			ivjNewMenuItem.setName("NewMenuItem");
			ivjNewMenuItem.setText("New");
			ivjNewMenuItem.add(getJMenuItemNewBioModel());
			ivjNewMenuItem.add(getMathMenu());
			ivjNewMenuItem.add(getGeometryMenuItem());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjNewMenuItem;
}

/**
 * Return the BlankMathMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getNonSpatialMenuItem() {
	if (ivjNonSpatialMenuItem == null) {
		try {
			ivjNonSpatialMenuItem = new javax.swing.JMenuItem();
			ivjNonSpatialMenuItem.setName("NonSpatialMenuItem");
			ivjNonSpatialMenuItem.setText("Non-Spatial");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjNonSpatialMenuItem;
}

/**
 * Return the OpenMenuItem property value.
 * @return javax.swing.JMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenu getOpenMenuItem() {
	if (ivjOpenMenuItem == null) {
		try {
			ivjOpenMenuItem = new javax.swing.JMenu();
			ivjOpenMenuItem.setName("OpenMenuItem");
			ivjOpenMenuItem.setText("Open");
			ivjOpenMenuItem.setEnabled(false);
			ivjOpenMenuItem.add(getJMenuItemOpenBioModel());
			ivjOpenMenuItem.add(getJMenuItemOpenMathModel());
			ivjOpenMenuItem.add(getJMenuItemOpenGeometry());
			ivjOpenMenuItem.add(getJMenuItemOpenLocal());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjOpenMenuItem;
}

/**
 * Return the ReconnectMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getReconnectMenuItem() {
	if (ivjReconnectMenuItem == null) {
		try {
			ivjReconnectMenuItem = new javax.swing.JMenuItem();
			ivjReconnectMenuItem.setName("ReconnectMenuItem");
			ivjReconnectMenuItem.setText("Reconnect (Refresh)");
			ivjReconnectMenuItem.setEnabled(false);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjReconnectMenuItem;
}

private static String createImageJServiceMenuText() {
	if(ImageJHelper.serviceExists()) {
		return "Stop FIJI (ImageJ) Service ("+ImageJHelper.getServiceURI().getPort()+")";
	}
	return "Start FIJI (ImageJ) Service";
}
//private javax.swing.JMenuItem getImageJServiceMenuItem() {
//	if (ivjImageJServiceMenuItem == null) {
//		try {
//			ivjImageJServiceMenuItem = new javax.swing.JMenuItem();
//			ivjImageJServiceMenuItem.setName("ivjImageJServiceMenuItem");
//			ivjImageJServiceMenuItem.setEnabled(true);
//			// user code begin {1}
//			// user code end
//		} catch (java.lang.Throwable ivjExc) {
//			// user code begin {2}
//			// user code end
//			handleException(ivjExc);
//		}
//	}
//	return ivjImageJServiceMenuItem;
//}

private static final String IMAGEJ_PLUGIN_PATH = "IMAGEJ_PLUGIN_PATH";

private void startStopImageJService() {
	if(ImageJHelper.serviceExists()) {
		try {
			ImageJHelper.stopService();
		} catch (Exception e) {
			e.printStackTrace();
			DialogUtils.showErrorDialog(this, "Error stopping ImageJ Service: "+e.getMessage());
		}
	}else {
		final String VC_PLUG_CONTINUE = "Continue";
		final String CANCEL = "Cancel";
		final String NEW_IJ_PLUGIN = "Install new plugin...";
		final String CHANGE_IJ_PLUGIN = "Update plugin or Change path...";
		Preferences prefs = Preferences.userNodeForPackage(DocumentWindow.class);
		String imageJVCellPluginVersion = "vcell-imagej-helper-"+TokenMangler.fixTokenStrict(VCellSoftwareVersion.fromSystemProperty().getSoftwareVersionString())+".jar";
		String imageJPluginPath = prefs.get(IMAGEJ_PLUGIN_PATH, null);
		URL imageJVCellPluginURL = null;
		try {
			imageJVCellPluginURL = new URL(PropertyLoader.getRequiredProperty(PropertyLoader.imageJVcellPluginURL)+"/"+imageJVCellPluginVersion);
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
			DialogUtils.showErrorDialog(this, "Error download URL: "+e1.getMessage());
			return;
		}
		String downLoadOption = NEW_IJ_PLUGIN;
//		File ijPluginFile = null;
		File[] existingVCPlugins = new File[] {};
		Boolean bSame = null;
		if(imageJPluginPath != null){
			existingVCPlugins = (new File(imageJPluginPath)).listFiles(new FilenameFilter() {
				@Override
				public boolean accept(File dir, String name) {
					// TODO Auto-generated method stub
					return name.startsWith("vcell-imagej-helper-") && name.endsWith(".jar");
				}
			});
			if(existingVCPlugins.length > 1) {
				StringBuffer sb = new StringBuffer();
				for (int i = 0; i < existingVCPlugins.length; i++) {
					sb.append((i!=0?"\n":"")+existingVCPlugins[i].getName());
				}
				DialogUtils.showWarningDialog(this, "Found "+existingVCPlugins.length+" installed VCell Imagej plugins:\n"+
						sb.toString()+"\nRemove the "+existingVCPlugins.length+" plugins from ImageJ directory and start service again.\nPlugin path="+imageJPluginPath);
				return;
			}
			if(existingVCPlugins.length == 1) {
				downLoadOption = CHANGE_IJ_PLUGIN;
				if(imageJVCellPluginVersion.equals(existingVCPlugins[0].getName())) {
					bSame = true;
				}else {
					bSame = false;
				}
			}
		}
		String[] options = (existingVCPlugins.length==0?new String[] {downLoadOption,CANCEL}:new String[] {VC_PLUG_CONTINUE,downLoadOption,CANCEL});
		String result = DialogUtils.showWarningDialog(this, 
			 "Start VCell's FIJI Service",
				"VCell's FIJI (ImageJ) service allows scripts running in FIJI to communicate with VCell "+
						"allowing query, control, and transfer of model/simulation data between VCell and FIJI.\n"+
						"(see Help->'VCell Help' then search 'start imagej service')\n"+
						(existingVCPlugins.length == 0?"Install FIJI (https://imagej.net/Fiji) before starting this service.":
							"Current plugin path:\n"+existingVCPlugins[0].getAbsolutePath()+"\n"+"Available version="+imageJVCellPluginVersion)
						,options, CANCEL);
		if(NEW_IJ_PLUGIN.equals(result) || CHANGE_IJ_PLUGIN.equals(result)) {
			File selectedDir = null;
			if(OperatingSystemInfo.getInstance().isMac()) {
				Frame f = (Frame)GeneralGuiUtils.findTypeParentOfComponent(this, Frame.class);
				System.setProperty("apple.awt.fileDialogForDirectories", "true");
				FileDialog fdiag = new FileDialog(f);
				fdiag.setMultipleMode(false);
				if(existingVCPlugins.length == 1) {
					fdiag.setDirectory(existingVCPlugins[0].getParentFile().getParentFile().getAbsolutePath());
					fdiag.setDirectory(existingVCPlugins[0].getParentFile().getAbsolutePath());
				}
				fdiag.setVisible(true);
				File[] files = fdiag.getFiles();
				if(files == null || files.length == 0) {
					return;
				}
				selectedDir = files[0];
			}else {
				VCFileChooser vcf = new VCFileChooser((existingVCPlugins.length == 0?ResourceUtil.getUserHomeDir():existingVCPlugins[0].getParentFile().getParentFile()));
				vcf.setMultiSelectionEnabled(false);
				if(existingVCPlugins.length == 1) {
					vcf.setSelectedFile(existingVCPlugins[0].getParentFile());	
				}
				vcf.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				int returnVal = vcf.showOpenDialog(this);
				if(returnVal != JFileChooser.APPROVE_OPTION) {
					return;
				}
				selectedDir = vcf.getSelectedFile();
			}
			try {
				if(!selectedDir.getName().equals("plugins")) {
					String pluginWarn = DialogUtils.showOKCancelWarningDialog(this, "Unexpected plugins directory warning", "path "+selectedDir.getAbsolutePath()+"\nexpected to end with 'plugins'");
					if(pluginWarn == null || !pluginWarn.equals(SimpleUserMessage.OPTION_OK)) {
						return;
					}
				}
				final File pluginDestination = new File(selectedDir,imageJVCellPluginVersion);
				FileUtils.copyURLToFile(imageJVCellPluginURL, pluginDestination);
				prefs.put(IMAGEJ_PLUGIN_PATH, selectedDir.getAbsolutePath());
				if(existingVCPlugins.length != 0 && bSame!=null && !bSame) {
					if(!existingVCPlugins[0].delete()) {
						throw new Exception("Couldn't delete old plugin "+existingVCPlugins[0].getAbsolutePath()+".  Please stop Imagej and manually remove the old plugin file.");
					}
				}
				DialogUtils.showInfoDialog(this, "VCell ImageJ plugin installed at:\n"+pluginDestination.getAbsolutePath());
			} catch (Exception e) {
				e.printStackTrace();
				DialogUtils.showErrorDialog(this, e.getMessage());
				return;
			}
		}else if(!VC_PLUG_CONTINUE.equals(result)){
			return;
		}
		try {
			ImageJHelper.startService(null);
		} catch (Exception e) {
			e.printStackTrace();
			DialogUtils.showErrorDialog(this, "error starting ImageJ Service: "+e.getMessage());
		}
	}
	
}

///**
// * Return the RunBNGMenuItem property value.
// * @return javax.swing.JMenuItem
// */
///* WARNING: THIS METHOD WILL BE REGENERATED. */
//private javax.swing.JMenuItem getRunBNGMenuItem() {
//	if (ivjRunBNGMenuItem == null) {
//		try {
//			ivjRunBNGMenuItem = new javax.swing.JMenuItem();
//			ivjRunBNGMenuItem.setName("RunBNGMenuItem");
//			ivjRunBNGMenuItem.setText("Launch BioNetGen");
//			// user code begin {1}
//			// user code end
//		} catch (java.lang.Throwable ivjExc) {
//			// user code begin {2}
//			// user code end
//			handleException(ivjExc);
//		}
//	}
//	return ivjRunBNGMenuItem;
//}

private JMenuItem getRunVFrapItem() {
	if (ivjRunVFrapMenuItem == null) {
		try {
			ivjRunVFrapMenuItem = new JMenuItem();
			ivjRunVFrapMenuItem.setName("RunVFrapMenuItem");
			ivjRunVFrapMenuItem.setText("Launch Virtual FRAP");
		} catch (Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	return ivjRunVFrapMenuItem;
}

/**
 * Return the Save_AsMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getSave_AsMenuItem() {
	if (ivjSave_AsMenuItem == null) {
		try {
			ivjSave_AsMenuItem = new javax.swing.JMenuItem();
			ivjSave_AsMenuItem.setName("Save_AsMenuItem");
			ivjSave_AsMenuItem.setText("Save As...");
			ivjSave_AsMenuItem.setEnabled(true);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjSave_AsMenuItem;
}

private javax.swing.JMenuItem getSave_AsLocalMenuItem() {
	if (ivjSave_AsLocalMenuItem == null) {
		try {
			ivjSave_AsLocalMenuItem = new javax.swing.JMenuItem();
			ivjSave_AsLocalMenuItem.setName("Save_AsLocalMenuItem");
			ivjSave_AsLocalMenuItem.setText("Save As Local...");
			ivjSave_AsLocalMenuItem.setEnabled(true);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjSave_AsLocalMenuItem;
}

/**
 * Return the Save_VersionMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getSave_VersionMenuItem() {
	if (ivjSave_VersionMenuItem == null) {
		try {
			ivjSave_VersionMenuItem = new javax.swing.JMenuItem();
			ivjSave_VersionMenuItem.setName("Save_VersionMenuItem");
			ivjSave_VersionMenuItem.setText("Save New Version");
			ivjSave_VersionMenuItem.setEnabled(false);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjSave_VersionMenuItem;
}

/**
 * Return the SaveMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenuItem getSaveMenuItem() {
	if (ivjSaveMenuItem == null) {
		try {
			ivjSaveMenuItem = new javax.swing.JMenuItem();
			ivjSaveMenuItem.setName("SaveMenuItem");
			ivjSaveMenuItem.setText("Save");
			ivjSaveMenuItem.setEnabled(false);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjSaveMenuItem;
}

private javax.swing.JMenuItem getPermissionsMenuItem() {
	if (jMenuItemPermissions == null) {
		try {
			jMenuItemPermissions = new javax.swing.JMenuItem();
			jMenuItemPermissions.setText("Permissions...");
			jMenuItemPermissions.setEnabled(false);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return jMenuItemPermissions;
}
private javax.swing.JMenuItem getGrantPermissionsToVCellSupportMenuItem() {
	if (jMenuItemGrantPermissionsToVCellSupport == null) {
		try {
			jMenuItemGrantPermissionsToVCellSupport = new javax.swing.JMenuItem();
			jMenuItemGrantPermissionsToVCellSupport.setText("Grant Permissions To VCell Support...");
			jMenuItemGrantPermissionsToVCellSupport.setEnabled(false);
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	return jMenuItemGrantPermissionsToVCellSupport;
}

/**
 * Return the ServerMenu property value.
 * @return javax.swing.JMenu
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JMenu getServerMenu() {
	if (ivjServerMenu == null) {
		try {
			ivjServerMenu = new javax.swing.JMenu();
//			//getImageJServiceMenuItem().setText(createImageJServiceMenuText());
//			ivjServerMenu.addMenuListener(new MenuListener() {
//				@Override
//				public void menuSelected(MenuEvent e) {
//					getImageJServiceMenuItem().setText(createImageJServiceMenuText());
//				}
//				@Override
//				public void menuDeselected(MenuEvent e) {
//				}
//				@Override
//				public void menuCanceled(MenuEvent e) {
//				}
//			});
			ivjServerMenu.setName("ServerMenu");
			ivjServerMenu.setText("Account");
			ivjServerMenu.add(getChange_UserMenuItem());
			ivjServerMenu.add(getChange_ProxyMenuItem());
			ivjServerMenu.add(getUpdate_UserMenuItem());
			ivjServerMenu.add(getReconnectMenuItem());
//			ivjServerMenu.add(getImageJServiceMenuItem());		// moved to Tools
			ivjServerMenu.add(new JSeparator());
			ivjServerMenu.add(getViewJobsMenuItem());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjServerMenu;
}

/**
 * Return the SpatialMenuItem property value.
 * @return javax.swing.JMenuItem
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private static final String MATHMODEL_SPATIAL_EXISTING = "Spatial from database geometry";
private javax.swing.JMenuItem getSpatialExistingMenuItem() {
	if (ivjSpatialExistingMenuItem == null) {
		try {
			ivjSpatialExistingMenuItem = new javax.swing.JMenuItem();
			ivjSpatialExistingMenuItem.setName("SpatialMenuItem");
			ivjSpatialExistingMenuItem.setText(MATHMODEL_SPATIAL_EXISTING);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjSpatialExistingMenuItem;
}

private static final String MATHMODEL_SPATIAL_CREATENEW = "Spatial from new geometry";
private JMenuItem mntmLicenseInformation;
private JSeparator separator;

private javax.swing.JMenuItem getSpatialCreateNewMenuItem() {
	if (ivjSpatialCreateNewMenuItem == null) {
		try {
			ivjSpatialCreateNewMenuItem = new javax.swing.JMenuItem();
			ivjSpatialCreateNewMenuItem.setName("SpatialMenuItem");
			ivjSpatialCreateNewMenuItem.setText(MATHMODEL_SPATIAL_CREATENEW);
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	return ivjSpatialCreateNewMenuItem;
}

/**
 * Return the StatusbarMenuItem property value.
 * @return javax.swing.JCheckBoxMenuItem
 */
private javax.swing.JCheckBoxMenuItem getStatusbarMenuItem() {
	if (ivjStatusbarMenuItem == null) {
		try {
			ivjStatusbarMenuItem = new javax.swing.JCheckBoxMenuItem();
			ivjStatusbarMenuItem.setName("StatusbarMenuItem");
			ivjStatusbarMenuItem.setSelected(true);
			ivjStatusbarMenuItem.setText("Status Bar");
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	return ivjStatusbarMenuItem;
}

/**
 * Return the StatusBarPane property value.
 * @return javax.swing.JPanel
 */
private javax.swing.JPanel getStatusBarPane() {
	if (ivjStatusBarPane == null) {
		try {
			ivjStatusBarPane = new javax.swing.JPanel();
			ivjStatusBarPane.setName("StatusBarPane");
			ivjStatusBarPane.setLayout(new GridBagLayout());

			int gridx = 0;
			GridBagConstraints gbc = new GridBagConstraints();
			gbc.gridx = gridx;
			gbc.gridy = 0;
			gbc.weighty = 1;
			gbc.fill = GridBagConstraints.VERTICAL;
			gbc.insets = new Insets(4, 4, 4, 4);
			ivjStatusBarPane.add(getJProgressBarConnection(), gbc);

			gridx++;
			gbc = new GridBagConstraints();
			gbc.gridx = gridx;
			gbc.gridy = 0;
			gbc.insets = new Insets(2, 5, 2, 2);
			ivjStatusBarPane.add(getIconBar(), gbc);

			gridx++;
			gbc = new GridBagConstraints();
			gbc.gridx = gridx;
			gbc.gridy = 0;
			gbc.weightx = 1;
			gbc.fill = GridBagConstraints.HORIZONTAL;
			gbc.insets = new Insets(4, 4, 4, 4);
			ivjStatusBarPane.add(getWarningBar(), gbc);

			gridx++;
			gbc = new GridBagConstraints();
			gbc.gridx = gridx;
			gbc.gridy = 0;
			gbc.weighty = 1;
			gbc.fill = GridBagConstraints.VERTICAL;
			gbc.insets = new Insets(4, 4, 4, 4);
			ivjStatusBarPane.add(getJProgressBarMemory(), gbc);

		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	return ivjStatusBarPane;
}

public JLabel getWarningBar() {
	if (warningText == null) {
		try {
			warningText = new JLabel();
			warningText.setName("");
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	return warningText;
}
public JLabel getIconBar() {
	if (iconText == null) {
		try {
			iconText = new JLabel();
			iconText.setName("");
			iconText.setIcon(VCellIcons.noteRedIcon);
			iconText.setToolTipText("View VCell Administrator Notification");
		} catch (java.lang.Throwable ivjExc) {
			handleException(ivjExc);
		}
	}
	return iconText;
}

//private static final String notificationsUrl = "//cfs05.cam.uchc.edu/vcell/apache_webroot/htdocs/webstart/VCell_alert/VCell_Alert.html";
private static final String notificationsUrl = "https://vcell.org/webstart/VCell_alert/VCell_Alert.html";
private void checkForNotifications() {
	int code = HttpURLConnection.HTTP_BAD_REQUEST;
	try {
		URL u = new URL(notificationsUrl);
		HttpURLConnection huc = (HttpURLConnection)u.openConnection (); 
		huc.setRequestMethod("HEAD");  // probably cheaper than  huc.setRequestMethod ("GET"); 
		huc.connect(); 
		code = huc.getResponseCode();
	} catch (IOException e) {
		// we just eat the exception
//		e.printStackTrace();
		code = HttpURLConnection.HTTP_INTERNAL_ERROR;
	}
	if(code != HttpURLConnection.HTTP_OK) {
		getIconBar().setEnabled(false);
		getIconBar().setVisible(false);
	} else {
		getIconBar().setEnabled(true);
		getIconBar().setVisible(true);
		
		Timer blinkTimer = new Timer(500, new ActionListener() {
			private int count = 0;
			private int maxCount = 110;								// 55 seconds
			public void actionPerformed(ActionEvent e) {
				if (count >= maxCount) {
					getIconBar().setIcon(VCellIcons.noteRedIcon);	// must remain on the noteRedIcon
					((Timer) e.getSource()).stop();
				} else {
					if(count %2 == 0) {
						getIconBar().setIcon(VCellIcons.noteRedIcon);
					} else {
						getIconBar().setIcon(VCellIcons.noteWhiteIcon);
					}
					count++;
				}
			}
		});
		blinkTimer.start();
	}
}
private void onNotificationsIconClick() {
//	PopupGenerator.showInfoDialog(DocumentWindow.this, "VCell admin notification message");
	invokeShowNotifications();
}

// version display in a dialog box - not working for complicated html files
//private void invokeShowNotifications() {
//
//	URL u = null;
//	try {
//		u = new URL(notificationsUrl);
//	} catch (MalformedURLException e1) {
//		e1.printStackTrace();
//	}
//	if(u == null) {
//		return;
//	}
//	
//	// the proper way to deal with closing the stream is by using a try-with-resources statement like below
//	try (InputStream inputStream = u.openStream(); ) {
//
//		String theString = IOUtils.toString(inputStream, StandardCharsets.UTF_8);
//		if(theString != null && !theString.isEmpty()) {
////			theString = "<html><header></header><body>aaaaaa<br>bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb<br><br>ccc<br>ddd</body></html>";
//			JPanel notificationPanel = getNotificationPanel(theString);
//			
//			JOptionPane pane = new JOptionPane(notificationPanel, JOptionPane.PLAIN_MESSAGE, 0, null, new Object[] {"Close"});
//			JDialog viewNotificationDialog = pane.createDialog(DocumentWindow.this, "VCell Notification");
//			viewNotificationDialog.setModal(false);
//			viewNotificationDialog.setResizable(true);
//			viewNotificationDialog.setVisible(true);
//
//		}
//
//	} catch (IOException e) {
//		e.printStackTrace();
//	}
//}
//
//private JPanel getNotificationPanel(String notification) {
//	
//	JPanel notificationPanel = new JPanel();
//	notificationPanel.setLayout(new GridBagLayout());
//	notificationPanel.setBackground(Color.white);
//	
//	JTextPane annotationTextArea = new JTextPane();
//	annotationTextArea.setContentType("text/html");
//	annotationTextArea.setEditable(false);
//	annotationTextArea.setText(notification);
//
//	JScrollPane annotationPane = new JScrollPane(annotationTextArea);
//
//	int gridy = 0;
//	GridBagConstraints gbc = new java.awt.GridBagConstraints();
//	gbc = new java.awt.GridBagConstraints();
//	gbc.gridx = 0; 
//	gbc.gridy = gridy;
//	gbc.weightx = 1.0;
//	gbc.weighty = 1.0;
//	gbc.insets = new Insets(1, 3, 1, 2);
//	gbc.fill = java.awt.GridBagConstraints.BOTH;
//	gbc.anchor = GridBagConstraints.NORTHWEST;
//	notificationPanel.add(annotationPane, gbc);
//
//	return notificationPanel;
//}

// version using the browser
private void invokeShowNotifications() {
	
	DialogUtils.browserLauncher(this, notificationsUrl, "Please visit '" + notificationsUrl + "' for server administrator notifications.");

//	PopupGenerator.browserLauncher(this, BeanUtils.getDynamicClientProperties().getProperty(PropertyLoader.VC_TUT_PERMISSION_URL),
//		"Please visit "+BeanUtils.getDynamicClientProperties().getProperty(PropertyLoader.VC_TUT_PERMISSION_URL)+" for instructions on how to change permissions to your Model");
}

/**
 * Return the TestingFrameworkMenuItem property value.
 * @return javax.swing.JMenuItem
 */
private javax.swing.JMenuItem getTestingFrameworkMenuItem() {
	if (ivjTestingFrameworkMenuItem == null) {
		try {
			ivjTestingFrameworkMenuItem = new javax.swing.JMenuItem();
			ivjTestingFrameworkMenuItem.setName("TestingFrameworkMenuItem");
			ivjTestingFrameworkMenuItem.setText("Testing Framework ...");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjTestingFrameworkMenuItem;
}


/**
 * Insert the method's description here.
 * Creation date: (5/24/2004 3:38:47 PM)
 * @return cbit.vcell.client.desktop.TopLevelWindowManager
 */
public TopLevelWindowManager getTopLevelWindowManager() {
	return getWindowManager();
}

/**
 * Gets the windowManager property (cbit.vcell.client.desktop.DocumentWindowManager) value.
 * @return The windowManager property value.
 * @see #setWindowManager
 */
private DocumentWindowManager getWindowManager() {
	return fieldWindowManager;
}

/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(java.lang.Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	exception.printStackTrace(System.out);
}

private void importExternalDocument() {
	getWindowManager().openDocument(VCDocumentType.EXTERNALFILE_DOC);
}

private void importPathway(PathwayImportOption pathwayImportOption) {
	getWindowManager().importPathway(pathwayImportOption);
}


/**
 * Initializes connections
 * @exception java.lang.Exception The exception description.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() throws java.lang.Exception {
	// user code begin {1}
	// user code end
	getAbout_BoxMenuItem().addActionListener(ivjEventHandler);
	getStatusbarMenuItem().addItemListener(ivjEventHandler);
	getCloseMenuItem().addActionListener(ivjEventHandler);
	getExitMenuItem().addActionListener(ivjEventHandler);
	getJMenuItemNewBioModel().addActionListener(ivjEventHandler);
	getJMenuItemOpenBioModel().addActionListener(ivjEventHandler);
	getJMenuItemOpenMathModel().addActionListener(ivjEventHandler);
	getJMenuItemOpenLocal().addActionListener(ivjEventHandler);
	getSaveMenuItem().addActionListener(ivjEventHandler);
	getSave_AsMenuItem().addActionListener(ivjEventHandler);
	getSave_AsLocalMenuItem().addActionListener(ivjEventHandler);
	getJMenuItemImport().addActionListener(ivjEventHandler);
	getSave_VersionMenuItem().addActionListener(ivjEventHandler);
	getChange_UserMenuItem().addActionListener(ivjEventHandler);
	getChange_ProxyMenuItem().addActionListener(ivjEventHandler);
	getUpdate_UserMenuItem().addActionListener(ivjEventHandler);
	getReconnectMenuItem().addActionListener(ivjEventHandler);
//	getImageJServiceMenuItem().addActionListener(ivjEventHandler);
	getJMenuItemRevert().addActionListener(ivjEventHandler);
	getJMenuItemCompare().addActionListener(ivjEventHandler);
	getNonSpatialMenuItem().addActionListener(ivjEventHandler);
	getMathFromBioMenuItem().addActionListener(ivjEventHandler);
	getSpatialExistingMenuItem().addActionListener(ivjEventHandler);
	getSpatialCreateNewMenuItem().addActionListener(ivjEventHandler);
	getJMenuItemExport().addActionListener(ivjEventHandler);
//	getEdit_Annotation_JMenuItem().addActionListener(ivjEventHandler);
	getTestingFrameworkMenuItem().addActionListener(ivjEventHandler);
	getJMenuItemOnlineHelp().addActionListener(ivjEventHandler);
	getJMenuItemOnlineSupport().addActionListener(ivjEventHandler);
	getJMenuItemDiscussionGroup().addActionListener(ivjEventHandler);
	getJMenuItemManagePermissions().addActionListener(ivjEventHandler);
	getJMenuItemOnlinePublish().addActionListener(ivjEventHandler);
	getGrantPermissionsToVCellSupportMenuItem().addActionListener(ivjEventHandler);

	getJMenuItemEmailSupport().addActionListener(ivjEventHandler);
	getNewHelpMenuItem().addActionListener(ivjEventHandler);
//	getRunBNGMenuItem().addActionListener(ivjEventHandler);
	getRunVFrapItem().addActionListener(ivjEventHandler);
	getTransMAMenuItem().addActionListener(ivjEventHandler);
	getViewJobsMenuItem().addActionListener(ivjEventHandler);
	getJMenuItemFieldData().addActionListener(ivjEventHandler);
	getPermissionsMenuItem().addActionListener(ivjEventHandler);
	
	getIconBar().addMouseListener(ivjEventHandler);
	getExportedDataViewer().addActionListener(ivjEventHandler);
}

/**
 * Initialize the class.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	try {
		setName("DocumentWindow");
		setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
		setIconImage(VCellIcons.getJFrameImageIcon());
		setJMenuBar(getDocumentWindowJMenuBar());
		setSize(460, 536);
		setTitle("DocumentWindow");
		getContentPane().add(getStatusBarPane(), BorderLayout.SOUTH);
		initConnections();
		checkForNotifications();
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
	// user code begin {2}
	// user code end
}

/**
 * Comment
 */
private void invokeOnlineHelp() {

	PopupGenerator.browserLauncher(this, BeanUtils.getDynamicClientProperties().getProperty(PropertyLoader.VCELL_URL),
		"Please visit "+BeanUtils.getDynamicClientProperties().getProperty(PropertyLoader.VCELL_URL)+" for Online Help");
}
private void invokeOnlineSupport() {

	PopupGenerator.browserLauncher(this, BeanUtils.getDynamicClientProperties().getProperty(PropertyLoader.VC_SUPPORT_URL),
		"Please visit "+BeanUtils.getDynamicClientProperties().getProperty(PropertyLoader.VC_SUPPORT_URL)+" for Online Support");
}
private void invokeDiscussionGroup() {

	PopupGenerator.browserLauncher(this, BeanUtils.getDynamicClientProperties().getProperty(PropertyLoader.VC_GOOGLE_DISCUSS_URL),
		"Please visit "+BeanUtils.getDynamicClientProperties().getProperty(PropertyLoader.VC_GOOGLE_DISCUSS_URL)+" for Discussion Group");
}
private void invokeManagePermissions() {

	PopupGenerator.browserLauncher(this, BeanUtils.getDynamicClientProperties().getProperty(PropertyLoader.VC_TUT_PERMISSION_URL),
		"Please visit "+BeanUtils.getDynamicClientProperties().getProperty(PropertyLoader.VC_TUT_PERMISSION_URL)+" for instructions on how to change permissions to your Model");
}
private void invokeOnlinePublish() {

	PopupGenerator.browserLauncher(this, BeanUtils.getDynamicClientProperties().getProperty(PropertyLoader.ACKNOWLEGE_PUB__WEB_URL),
		"Please visit "+BeanUtils.getDynamicClientProperties().getProperty(PropertyLoader.ACKNOWLEGE_PUB__WEB_URL)+" for instructions on how to Publish your Model");
}



/**
 * Comment
 */
private void jMenuItemFieldData_ActionPerformed(java.awt.event.ActionEvent actionEvent) {

	getWindowManager().showFieldDataWindow();
}


/**
 * Comment
 */
private void newDocument(java.awt.event.ActionEvent actionEvent) {
	AsynchClientTask[] taskArray = null;
	if (actionEvent.getActionCommand().equals("BioModel")) {
		taskArray = getWindowManager().newDocument(new VCDocument.DocumentCreationInfo(VCDocumentType.BIOMODEL_DOC, VCDocument.BIO_OPTION_DEFAULT));
	} else if (actionEvent.getActionCommand().equals("Non-Spatial")) {
		taskArray = getWindowManager().newDocument(new VCDocument.DocumentCreationInfo(VCDocumentType.MATHMODEL_DOC, VCDocument.MATH_OPTION_NONSPATIAL));
	} else if (actionEvent.getActionCommand().equals(MATHMODEL_SPATIAL_EXISTING)) {
		taskArray = getWindowManager().newDocument(new VCDocument.DocumentCreationInfo(VCDocumentType.MATHMODEL_DOC, VCDocument.MATH_OPTION_SPATIAL_EXISTS));
	} else if (actionEvent.getActionCommand().equals(MATHMODEL_SPATIAL_CREATENEW)) {
		getWindowManager().newDocument(new VCDocument.DocumentCreationInfo(VCDocumentType.MATHMODEL_DOC, VCDocument.MATH_OPTION_SPATIAL_NEW));
		return;
	} else if (actionEvent.getActionCommand().equals("From BioModel")) {
		taskArray = getWindowManager().newDocument(new VCDocument.DocumentCreationInfo(VCDocumentType.MATHMODEL_DOC, VCDocument.MATH_OPTION_FROMBIOMODELAPP));
	}else {
		return;
	}
	Hashtable<String, Object> hash = new Hashtable<String, Object>();
	hash.put(ClientRequestManager.GUI_PARENT, (Component)this);
	hash.put("requestManager", getWindowManager().getRequestManager());
	ClientTaskDispatcher.dispatch(this, hash, taskArray, false);
}

/**
 * Comment
 */
private void openDocument(java.awt.event.ActionEvent actionEvent) {
	if (actionEvent.getActionCommand().equals("BioModel...")) {
		getWindowManager().openDocument(VCDocumentType.BIOMODEL_DOC);
	} else if (actionEvent.getActionCommand().equals("MathModel...")) {
		getWindowManager().openDocument(VCDocumentType.MATHMODEL_DOC);
	} else if (actionEvent.getActionCommand().equals("Geometry...")) {
		getWindowManager().openDocument(VCDocumentType.GEOMETRY_DOC);
	}
}


/**
 * Comment
 */
private void reconnect() {
	getWindowManager().reconnect();
}


/**
 * Comment
 */
private void revertToSaved() {
	getWindowManager().revertToSaved();
}


/**
 * Comment
 */
private void saveDocument(boolean replace) {
	getWindowManager().saveDocument(replace);
}


/**
 * Comment
 */
private void saveDocumentAsNew() {
	getWindowManager().saveDocumentAsNew();
}

private void saveAsLocal(){
	getWindowManager().exportDocument(FileFilters.FILE_FILTER_VCML);
}

/**
 * Sets the windowManager property (cbit.vcell.client.desktop.DocumentWindowManager) value.
 * @param windowManager The new value for the property.
 * @see #getWindowManager
 */
public void setWindowManager(DocumentWindowManager windowManager) {
	if (fieldWindowManager == windowManager) {
		return;
	}
	DocumentWindowManager oldValue = fieldWindowManager;
	fieldWindowManager = windowManager;
	firePropertyChange("windowManager", oldValue, windowManager);//May 2009,found it doesn't fire to any where.

//	if (windowManager.getTaskBar() != null) {
//		windowManager.getTaskBar().setBackground(getStatusBarPane().getBackground());
//		getStatusBarPane().add(windowManager.getTaskBar(), BorderLayout.CENTER);
//	}
}


/**
 * Insert the method's description here.
 * Creation date: (5/24/2004 11:39:07 AM)
 * @param c java.awt.Component
 */
public void setWorkArea(Component c) {
	getContentPane().add(c, BorderLayout.CENTER);
}


public static void showAboutBox(Component parent) {
	String version = "";
	String build = "";
	try {
		version = "Version " + DocumentWindowAboutBox.getVERSION_NO();
		build = DocumentWindowAboutBox.getEDITION() + " edition, build no. " + DocumentWindowAboutBox.getBUILD_NO();
	} catch (Exception exc) {
		System.out.println("Failed to parse vcell.softwareVersion: " + exc.getMessage());
		exc.printStackTrace(System.out);
	}
	/* Create the AboutBox dialog */
	DocumentWindowAboutBox aDocumentWindowAboutBox = new DocumentWindowAboutBox(version,build);
	DialogUtils.showComponentCloseDialog(parent, aDocumentWindowAboutBox, "About VCell");
}

private void showAboutBox() {
	showAboutBox(this);
}


///**
// * Comment
// */
//private void  showBNGWindow() {
//	getWindowManager().showBNGWindow();
//}

/**
 * Comment
 */
private void showEditAnnotationWindow() {

	try {
		if (getWindowManager() != null) {
			VCDocument vcDoc = getWindowManager().getVCDocument();
			if (vcDoc != null) {
				try{
					// initialize fields - different for biomodel and mathmodel, geometry
					String oldAnnotation = null;
					if (vcDoc instanceof BioModel) {
						oldAnnotation = ((BioModel)vcDoc).getVCMetaData().getFreeTextAnnotation((BioModel)vcDoc);
					} else {
						oldAnnotation = vcDoc.getDescription();
					}
					// show the editor
					String newAnnotation = DialogUtils.showAnnotationDialog(this, oldAnnotation);
					if (org.vcell.util.BeanUtils.triggersPropertyChangeEvent(oldAnnotation, newAnnotation)) {
						// if VCDocument is a Biomodel, set the vcMetadata, else edit VCDoc.description for now
						if (vcDoc instanceof BioModel) {
							// update free text annotation in VCMetaData
							VCMetaData vcMetaData = ((BioModel)vcDoc).getVCMetaData();
							vcMetaData.setFreeTextAnnotation((BioModel)vcDoc, newAnnotation);
						} else {
							// Update VCDocument annotation
							vcDoc.setDescription(newAnnotation);
						}
					}
				}catch(UtilCancelException e){
					//Do Nothing
				}
			}else{
				throw new Exception("No Document to Edit");
			}
		}
	} catch (Throwable exc) {
		exc.printStackTrace(System.out);
		PopupGenerator.showErrorDialog(this, "Failed to edit annotation!\n"+exc.getMessage(), exc);
	}
}


/**
 * Comment
 */
private void showLoginDialog() {

	final LoginManager loginManager = new LoginManager();

	LoginDelegate loginDelegate = new LoginDelegate(){

		public void userCancel() {
			loginManager.close();
			PopupGenerator.showInfoDialog(DocumentWindow.this,
					"Note:  The Login dialog can be accessed any time under the 'Server' main menu as 'Change User...'");
		}
		public void registerRequest() {
			loginManager.close();
			System.out.println("LoginManager.registerRequest()");
			getWindowManager().getRequestManager().updateUserRegistration(getWindowManager(), true);
		}

		public void login(String userid, UserLoginInfo.DigestedPassword digestedPassword) {
			System.out.println("LoginManager.login("+userid+",xxx)");
			getWindowManager().connectAs(userid, digestedPassword);
		}

		public void lostPasswordRequest(String userid) {
			System.out.println("LoginManager.lostPasswordRequest("+userid+")");
			getWindowManager().getRequestManager().sendLostPassword(getWindowManager(), userid);
		}
	};

	loginManager.showLoginDialog(this, getWindowManager(), loginDelegate);
}


/**
 * Comment
 */
private void showTestingFrameworkWindow() {
	getWindowManager().showTestingFrameworkWindow();
}


private void enableOpenMenuItems(boolean bEnableServerOps){
	getOpenMenuItem().setEnabled(true);
	getJMenuItemOpenBioModel().setEnabled(bEnableServerOps);
	getJMenuItemOpenMathModel().setEnabled(bEnableServerOps);
	getJMenuItemOpenGeometry().setEnabled(bEnableServerOps);
	getJMenuItemOpenLocal().setEnabled(true);
}
/**
 * Insert the method's description here.
 * Creation date: (5/10/2004 4:32:17 PM)
 */
public void updateConnectionStatus(ConnectionStatus connStatus) {

	// other updates
	String status = "";
	User user = getWindowManager().getUser();
	boolean isTestUser = (user!=null)?(user.isTestAccount()):(false);
	switch (connStatus.getStatus()) {
		case ConnectionStatus.NOT_CONNECTED: {
			status = "";
			getJProgressBarConnection().setString("NOT CONNECTED");
			getJProgressBarConnection().setValue(0);
			getChange_UserMenuItem().setEnabled(true);
			getUpdate_UserMenuItem().setEnabled(false);
			getReconnectMenuItem().setEnabled(false);
			getViewJobsMenuItem().setEnabled(false);
			
			enableOpenMenuItems(false);

			getSaveMenuItem().setEnabled(false);
			getSave_AsMenuItem().setEnabled(false);
			getSave_AsLocalMenuItem().setEnabled(true);
			getSave_VersionMenuItem().setEnabled(false);
			getJMenuItemRevert().setEnabled(false);
			getJMenuItemCompare().setEnabled(false);
			//getJMenuItemServer().setEnabled(true);
			getTestingFrameworkMenuItem().setVisible(isTestUser);
			getTestingFrameworkMenuItem().setEnabled(false);
			getJMenuItemFieldData().setEnabled(false);
			getPermissionsMenuItem().setEnabled(false);
			getGrantPermissionsToVCellSupportMenuItem().setEnabled(false);
			checkForReconnecting(connStatus);
			break;
		}
		case ConnectionStatus.CONNECTED: {
			status = "Server: " + connStatus.getApihost()+":"+connStatus.getApiport() + " User: " + connStatus.getUserName();
			getJProgressBarConnection().setString("CONNECTED (" + connStatus.getUserName() + ")");
			getJProgressBarConnection().setValue(100);
			getChange_UserMenuItem().setEnabled(true);
			getUpdate_UserMenuItem().setEnabled(true);
			getReconnectMenuItem().setEnabled(true);
			getViewJobsMenuItem().setEnabled(true);

			enableOpenMenuItems(true);

			boolean bVersionedDocument = getWindowManager() != null &&  getWindowManager().getVCDocument() != null
							&& getWindowManager().getVCDocument().getVersion() != null;
			getSaveMenuItem().setEnabled(
				bVersionedDocument && !(
					getWindowManager().getVCDocument().getVersion().getFlag().compareEqual(VersionFlag.Archived) ||
					getWindowManager().getVCDocument().getVersion().getFlag().compareEqual(VersionFlag.Published)
				)
			);
			getSave_AsMenuItem().setEnabled(true);
			getSave_AsLocalMenuItem().setEnabled(true);
			getSave_VersionMenuItem().setEnabled(bVersionedDocument);
			getJMenuItemRevert().setEnabled(bVersionedDocument);
			getJMenuItemCompare().setEnabled(bVersionedDocument);
			//getJMenuItemServer().setEnabled(true);
			getTestingFrameworkMenuItem().setVisible(isTestUser);
			getTestingFrameworkMenuItem().setEnabled(true);
			getJMenuItemFieldData().setEnabled(true);
//			getJMenuItemMIRIAM().setEnabled(true);
			getJMenuItemPreferences().setEnabled(true);
			getTransMAMenuItem().setEnabled(
					getWindowManager() != null &&
					getWindowManager().getVCDocument() != null &&
					getWindowManager().getVCDocument() instanceof BioModel
			);
			getViewJobsMenuItem().setEnabled(true);
			//getJMenuImportPathway().setEnabled(getWindowManager().getVCDocument() instanceof BioModel);
			getPermissionsMenuItem().setEnabled(bVersionedDocument && getWindowManager().getVCDocument().getVersion().getOwner().equals(getWindowManager().getUser()));
			getGrantPermissionsToVCellSupportMenuItem().setEnabled(bVersionedDocument && getWindowManager().getVCDocument().getVersion().getOwner().equals(getWindowManager().getUser()));
			break;
		}
		case ConnectionStatus.INITIALIZING: {
			status = "Server: " + connStatus.getApihost()+":"+connStatus.getApiport() + " User: " + connStatus.getUserName();
			getJProgressBarConnection().setString("INITIALIZING...");
			getJProgressBarConnection().setValue(0);
			getChange_UserMenuItem().setEnabled(false);
			getUpdate_UserMenuItem().setEnabled(false);
			getReconnectMenuItem().setEnabled(false);
			enableOpenMenuItems(false);
			getSave_AsLocalMenuItem().setEnabled(true);
			getSaveMenuItem().setEnabled(false);
			getSave_AsMenuItem().setEnabled(false);
			getSave_AsLocalMenuItem().setEnabled(true);
			getSave_VersionMenuItem().setEnabled(false);
			getJMenuItemRevert().setEnabled(false);
			getJMenuItemCompare().setEnabled(false);
			//getJMenuItemServer().setEnabled(false);
			getTestingFrameworkMenuItem().setVisible(isTestUser);
			getTestingFrameworkMenuItem().setEnabled(isTestUser);
			getJMenuItemFieldData().setEnabled(false);
//			getJMenuItemMIRIAM().setEnabled(false);
			getJMenuItemPreferences().setEnabled(false);
			getPermissionsMenuItem().setEnabled(false);
			getGrantPermissionsToVCellSupportMenuItem().setEnabled(false);
			break;
		}
		case ConnectionStatus.DISCONNECTED: {
			status = "Server: " + connStatus.getApihost()+":"+connStatus.getApiport() + " User: " + connStatus.getUserName();
			getJProgressBarConnection().setString("DISCONNECTED");
			getJProgressBarConnection().setValue(0);
			getChange_UserMenuItem().setEnabled(true);
			getUpdate_UserMenuItem().setEnabled(false);
			getReconnectMenuItem().setEnabled(true);
			enableOpenMenuItems(false);
			getSave_AsLocalMenuItem().setEnabled(true);
			getSaveMenuItem().setEnabled(false);
			getSave_AsMenuItem().setEnabled(false);
			getSave_VersionMenuItem().setEnabled(false);
			getJMenuItemRevert().setEnabled(false);
			getJMenuItemCompare().setEnabled(false);
			//getJMenuItemServer().setEnabled(true);
			getTestingFrameworkMenuItem().setVisible(isTestUser);
			getTestingFrameworkMenuItem().setEnabled(false);
			getJMenuItemFieldData().setEnabled(false);
//			getJMenuItemMIRIAM().setEnabled(false);
			getJMenuItemPreferences().setEnabled(false);
			getPermissionsMenuItem().setEnabled(false);
			getGrantPermissionsToVCellSupportMenuItem().setEnabled(false);
			checkForReconnecting(connStatus);
			break;
		}
	}
	getJProgressBarConnection().setToolTipText(status);
}

private void checkForReconnecting(ConnectionStatus connStatus) {
	Reconnector rc = connStatus.getReconnector();
	if (rc.isActive()) {
		rc.addListener(this);
	}
}

@Override
public void refactorCountdown(long seconds) {
	if (seconds > 0) {
		getJProgressBarConnection().setString("RECONNECT in " + seconds-- + " s");
	}
}

/**
 * Insert the method's description here.
 * Creation date: (5/7/2004 11:51:20 AM)
 */
public void updateMemoryStatus(long freeBytes, long totalBytes) {
	DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance();
	df.setMaximumFractionDigits(1);
	String usedMB = df.format((totalBytes - freeBytes)/1000000.0);
	String totalMB = df.format(totalBytes/1000000.0);
	getJProgressBarMemory().setValue((int)(100 * (totalBytes - freeBytes) / totalBytes));
	getJProgressBarMemory().setString(usedMB + "MB / " + totalMB + "MB");
}


/**
 * Insert the method's description here.
 * Creation date: (5/10/2004 4:32:17 PM)
 */
public void updateWhileInitializing(int i) {
	// extra animation while initializing connection
	getJProgressBarConnection().setValue(i);
}


private void viewStatusBar() {
	/* Hide or show the statusbar */
	getStatusBarPane().setVisible(getStatusbarMenuItem().isSelected());
}

/**
 * This method initializes jMenuItemMIRIAM
 *
 * @return javax.swing.JMenuItem
 */
//private JMenuItem getJMenuItemMIRIAM() {
//	if (jMenuItemMIRIAM == null) {
//		jMenuItemMIRIAM = new JMenuItem();
//		jMenuItemMIRIAM.setText("Model Annotation ...");
//		jMenuItemMIRIAM.addActionListener(new java.awt.event.ActionListener() {
//			public void actionPerformed(java.awt.event.ActionEvent e) {
//				if(getTopLevelWindowManager() instanceof BioModelWindowManager){
//					((BioModelWindowManager)getTopLevelWindowManager()).showMIRIAMWindow();
//				}else{
//					PopupGenerator.showInfoDialog(DocumentWindow.this, "Sorry, Currently only BioModels have a MIRIAM editor.");
//				}
//			}
//		});
//	}
//	return jMenuItemMIRIAM;
//}

private JMenuItem getJMenuItemPreferences() {
	if (jMenuItemPreferences == null) {
		jMenuItemPreferences = new JMenuItem();
		jMenuItemPreferences.setText("VCell Properties ...");
		jMenuItemPreferences.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				getTopLevelWindowManager().showPreferencesWindow();
			}
		});
	}
	return jMenuItemPreferences;
}

public void showTransMADialog()
{
	String disclaimer = "Transforming reactions to stochastic capable cannot be undone. You may want to make a copy of the model.\nAlso some existing applications may need to be recreated in order to maintain consistency.\nLast but not least, stochastic transfomation may not be mathematically equivalent to the orignal model. \nDo you wish to proceed?";
	JTextArea ta = new JTextArea(disclaimer);
	ta.setEditable(false);
	int userChoice = PopupGenerator.showComponentOKCancelDialog(this, ta, "Model Transformation Warning");
	if(userChoice != JOptionPane.OK_OPTION) {
		return;
	}
	BioModel biomodel = null;
	if (getWindowManager().getVCDocument() instanceof BioModel) {
		biomodel = (BioModel)getWindowManager().getVCDocument();
	}
	TransformMassActionPanel transMAPanel = new TransformMassActionPanel();
	TransformMassActions transformMassActions = new TransformMassActions();

	Hashtable<String, Object> hashTable = new Hashtable<> ();
	hashTable.put("biomodel", biomodel);
	hashTable.put("window", this);
	
	ProgressDialog progressDialog = new LinearDefiniteProgressDialog(this);

	AsynchClientTask task1 = new AsynchClientTask("transform", AsynchClientTask.TASKTYPE_NONSWING_BLOCKING) {
		@Override
		public void run(Hashtable<String, Object> hashTable) throws Exception {
			BioModel biomodel = (BioModel)hashTable.get("biomodel");
			if(biomodel == null) {
				throw new RuntimeException("Biomodel cannot be null");
			}
			try {
				transMAPanel.setModel(biomodel.getModel());
				ReactionStep[] origReactions = biomodel.getModel().getReactionSteps();
				transformMassActions.initializeTransformation(origReactions);
				for (int i = 0; i < origReactions.length; i++) {
					progressDialog.setProgress(i * 100 / origReactions.length);
					TransformedReaction[] transReactionSteps = transformMassActions.getTransformedReactionSteps();
					boolean[] isTransformable = transformMassActions.getIsTransformable();

					transReactionSteps[i] = transformMassActions.transformOne(origReactions[i]);	// here all the work is done
					if (transReactionSteps[i].getTransformType() == TransformedReaction.TRANSFORMABLE) {
						isTransformable[i] = true;
					} else {
						isTransformable[i] = false;
					}
				}
				progressDialog.setProgress(100);
				transMAPanel.setTransformation(transformMassActions);
			} catch(Throwable e) {
				System.out.println(e.getMessage());
			}
			System.out.println("done");
		}
	};
	
	AsynchClientTask task2 = new AsynchClientTask("starting exporting", AsynchClientTask.TASKTYPE_SWING_NONBLOCKING) {
		@Override
		public void run(Hashtable<String, Object> hashTable) throws Exception {
			// if we hit Cancel on the ProgressDialog, this task won't get executed
			Component requester = (Component)hashTable.get("window");
			int choice = DialogUtils.showComponentOKCancelDialog(requester, transMAPanel, "Transform to Stochastic Capable Model");
			if(choice == JOptionPane.OK_OPTION) {
				try {
					transMAPanel.saveTransformedReactions();
				} catch(Exception e) {
					PopupGenerator.showWarningDialog(getTopLevelWindowManager(), null, new UserMessage(e.getMessage(), new String[]{"Ok"},"Ok"), null);
				}
			}
		}
	};
	
	AsynchClientTask[] tasks = new AsynchClientTask[] { task1, task2 };
	boolean bShowProgressPopup = true;
	boolean bKnowProgress = true;
	boolean cancelable = true;
	boolean bInputBlocking = false;		// default: false
	ClientTaskDispatcher.dispatch(this, hashTable, tasks, progressDialog,
			bShowProgressPopup, bKnowProgress, cancelable, null, bInputBlocking,
			ClientTaskDispatcher.StopStrategy.THREAD_KILL);
}

public void showViewJobsDialog() {
	System.out.println("ViewJobs menu item pressed.");
	// https://vcellapi.cam.uchc.edu/simtask?submitLow=&submitHigh=&startRow=1&maxRows=100&serverId=&computeHost+value%3D=&simId=&jobId=&taskId=&hasData=all&queued=on&dispatched=on&running=on
	DocumentWindowManager dwm = getWindowManager();
	ViewJobsPanel panel = new ViewJobsPanel(dwm);
	panel.setPreferredSize(new Dimension(1000,600));

	if(viewSpeciesDialog != null) {		// uncomment these 3 lines to allow only one instance of the dialog
		viewSpeciesDialog.dispose();
	}
	
	JOptionPane pane = new JOptionPane(panel, JOptionPane.PLAIN_MESSAGE, 0, null, new Object[] {"Close"});
	viewSpeciesDialog = pane.createDialog(this, "View Simulation Jobs Status");
	viewSpeciesDialog.setModal(false);
	viewSpeciesDialog.setResizable(true);
	viewSpeciesDialog.setVisible(true);
	
//	ClientRequestManager.idToNameConversion(getWindowManager().getVCDocument());

}

public void showViewExportedDataDialog() {
	DocumentWindowManager dwm = getWindowManager();
	ExportedDataViewer exportedDataViewer = new ExportedDataViewer();
	exportedDataViewer.setPreferredSize(new Dimension(1000, 600));

	if(viewSpeciesDialog != null) {		// uncomment these 3 lines to allow only one instance of the dialog
		viewSpeciesDialog.dispose();
	}

	JOptionPane pane = new JOptionPane(exportedDataViewer, JOptionPane.PLAIN_MESSAGE, 0, null, new Object[] {"Close"});
	viewSpeciesDialog = pane.createDialog(this, "View Exported Data");
	viewSpeciesDialog.setModal(false);
	viewSpeciesDialog.setResizable(true);
	viewSpeciesDialog.setVisible(true);
}

	private JMenuItem getMntmLicenseInformation() {
		if (mntmLicenseInformation == null) {
			mntmLicenseInformation = new JMenuItem("VCell License Information");
			mntmLicenseInformation.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					Integer year = 2013;
					try{
						int tempYear = Integer.parseInt((new SimpleDateFormat("yyyy")).format(Calendar.getInstance().getTime()));
						if(tempYear > year && tempYear < 2100){//sanity check
							year = tempYear;
						}
					}catch(Exception e){
						e.printStackTrace();
					}
					final String OK = "OK";
					final String SAVE_LICENSE = "Save VCell license";
					final String SAVE_THIRD_PARTY = "Save third party licenses";
					String licenseStr =
							"The Virtual Cell is free software distributed under the following MIT licensing terms:\n\n"+
							"Copyright (c) 1998-"+year+" University of Connecticut Health Center\n\n" +
							"Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the \"Software\"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:\n\n" +
							"The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.\n\n"+
							"THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n\n";

					if (OperatingSystemInfo.getInstance().isWindows()) {
						licenseStr += "The Virtual Cell Windows Edition is licensed under the GNU General Public License Version 3\n\n";
					}

					String result = DialogUtils.showWarningDialog(DocumentWindow.this, "VCell Licensing Information", licenseStr, new String[] {OK,SAVE_THIRD_PARTY,SAVE_LICENSE,}, OK);
					if(result != null && (result.equals(SAVE_THIRD_PARTY) || result.equals(SAVE_LICENSE))){
						JFileChooser saveLicenseJFC = new JFileChooser();
						int returnVal = saveLicenseJFC.showSaveDialog(DocumentWindow.this);
					    if(returnVal == JFileChooser.APPROVE_OPTION) {
					       File outFile = saveLicenseJFC.getSelectedFile();
					       try{
					    	   if(result.equals(SAVE_THIRD_PARTY)){
					    		   ResourceUtil.writeResourceToFile("/"+System.getProperty(PropertyLoader.vcellThirdPartyLicense), outFile);
					    	   }else if (result.equals(SAVE_LICENSE)){
					    		   XmlUtil.writeXMLStringToFile(licenseStr, outFile.getAbsolutePath(), false);
					    	   }
					       }catch(Exception e){
					    	   e.printStackTrace();
					    	   DialogUtils.showErrorDialog(DocumentWindow.this, "Error saving license info: "+e.getMessage());
					       }
					    }
					}
				}
			});
		}
		return mntmLicenseInformation;
	}
	private JSeparator getSeparator() {
		if (separator == null) {
			separator = new JSeparator();
		}
		return separator;
	}

	public ChildWindowManager getChildWindowManager() {
		return childWindowManager;
	}
}
