/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.client.data;
import cbit.rmi.event.DataJobEvent;
import cbit.rmi.event.DataJobListener;
import cbit.rmi.event.ExportEvent;
import cbit.rmi.event.ExportListener;
import cbit.vcell.client.DataViewerManager;
import cbit.vcell.client.desktop.biomodel.DocumentEditorSubPanel;
import cbit.vcell.export.gui.ExportMonitorPanel;
import cbit.vcell.simdata.DataManager;
import cbit.vcell.solver.SimulationModelInfo;
/**
 * Insert the type's description here.
 * Creation date: (6/14/2004 9:48:35 PM)
 * @author: Ion Moraru
 */
@SuppressWarnings("serial")
public abstract class DataViewer extends DocumentEditorSubPanel implements ExportListener, DataJobListener {
	public static final String PROP_SIM_MODEL_INFO = "simulationModelInfo";
	private DataViewerManager fieldDataViewerManager = null;
	private SimulationModelInfo fieldSimulationModelInfo = null;

	/**
 * Insert the method's description here.
 * Creation date: (3/31/2006 8:22:43 AM)
 */
public void dataJobMessage(DataJobEvent dje) {

	//Override this method if you are interested in receiveing events generated by
	//the dataserver.  (e.g. statistics job progress, timeseries job progress etc...)

	System.out.println("DataJobEvent jobID="+dje.getVcDataJobID()+" eventType="+dje.getEventTypeID());
}


/**
 * Insert the method's description here.
 * Creation date: (6/15/2004 1:55:39 AM)
 * @param event cbit.rmi.event.ExportEvent
 */
public void exportMessage(ExportEvent event) {
	if(getExportMonitorPanel() != null) {//is null for ODEDataViewer
		getExportMonitorPanel().addExportEvent(event, event.getDataIdString());
	}
}

/**
 * Gets the dataViewerManager property (cbit.vcell.client.DataViewerManager) value.
 * @return The dataViewerManager property value.
 * @see #setDataViewerManager
 */
public DataViewerManager getDataViewerManager() {
	return fieldDataViewerManager;
}


/**
 * Method generated to support the promotion of the exportMonitorPanel attribute.
 * @return cbit.vcell.export.ExportMonitorPanel
 */
public abstract ExportMonitorPanel getExportMonitorPanel();


/**
 * Gets the simulationModelInfo property (cbit.vcell.client.data.SimulationModelInfo) value.
 * @return The simulationModelInfo property value.
 * @see #setSimulationModelInfo
 */
public SimulationModelInfo getSimulationModelInfo() {
	return fieldSimulationModelInfo;
}


/**
 * Sets the dataViewerManager property (cbit.vcell.client.DataViewerManager) value.
 * @param dataViewerManager The new value for the property.
 * @exception java.beans.PropertyVetoException The exception description.
 * @see #getDataViewerManager
 */
public void setDataViewerManager(DataViewerManager dataViewerManager) throws java.beans.PropertyVetoException {
	DataViewerManager oldValue = fieldDataViewerManager;
	fieldDataViewerManager = dataViewerManager;
	firePropertyChange("dataViewerManager", oldValue, dataViewerManager);
}


/**
 * Sets the simulationModelInfo property (cbit.vcell.client.data.SimulationModelInfo) value.
 * @param simulationModelInfo The new value for the property.
 * @see #getSimulationModelInfo
 */
public void setSimulationModelInfo(SimulationModelInfo simulationModelInfo) {
	SimulationModelInfo oldValue = fieldSimulationModelInfo;
	fieldSimulationModelInfo = simulationModelInfo;
	firePropertyChange(PROP_SIM_MODEL_INFO, oldValue, simulationModelInfo);
}

public void showTimePlotMultipleScans(DataManager dataManager){};

@Override
protected void onSelectedObjectsChange(Object[] selectedObjects) {
	// TODO
	
}
}
