/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.image.gui;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Vector;

import javax.swing.SwingConstants;

import org.vcell.util.DataAccessException;
import org.vcell.util.Range;

import cbit.image.SourceDataInfo;
/**
 * This class was generated by a SmartGuide.
 * 
 */
public class ImageContainerPanel extends javax.swing.JPanel implements ActionListener, ItemListener, java.beans.PropertyChangeListener {
	private javax.swing.JPanel ivjAxisPanel = null;
	private javax.swing.JButton ivjButton1 = null;
	private javax.swing.JButton ivjButton2 = null;
	private ImageContainer ivjImageContainer = null;
	private javax.swing.JLabel ivjLabel1 = null;
	private javax.swing.JLabel ivjLabel2 = null;
	private javax.swing.JLabel ivjSliceLabel = null;
	private javax.swing.JPanel ivjSlicePanel = null;
	private javax.swing.JRadioButton ivjXAxisCheckbox = null;
	private javax.swing.JRadioButton ivjYAxisCheckbox = null;
	private javax.swing.JRadioButton ivjZAxisCheckbox = null;
	private ImageContainerPanelTool ivjImageContainerPanelTool = null;
	private javax.swing.JLabel ivjStatusLabel = null;
	protected transient java.beans.PropertyChangeSupport propertyChange;
	private ScalePanel ivjScalePanel1 = null;
	private Vector dataSetHistory = new Vector(0);
	private Vector scaleSettingsHistory = new Vector(0);
	private int index = 0;
	private javax.swing.JButton ivjButton3 = null;
	private javax.swing.JButton ivjButton4 = null;
	private javax.swing.ButtonGroup ivjButtonGroup1 = null;
	private boolean fieldSpatialPlotEnabled = false;
	private ImageContainer fieldImageContainer = null;
	private ImagePaneScroller ivjImagePaneScroller = null;

/**
 * Constructor
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public ImageContainerPanel() {
	super();
	initialize();
}


/**
 * ImageContainerPanel constructor comment.
 * @param layout java.awt.LayoutManager
 */
public ImageContainerPanel(java.awt.LayoutManager layout) {
	super(layout);
}


/**
 * Method to handle events for the ActionListener interface.
 * @param e java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void actionPerformed(java.awt.event.ActionEvent e) {
	// user code begin {1}
	// user code end
	if (e.getSource() == getButton2()) 
		connEtoM1(e);
	if (e.getSource() == getButton1()) 
		connEtoM2(e);
	if (e.getSource() == getButton4()) 
		connEtoM14(e);
	if (e.getSource() == getButton3()) 
		connEtoM15(e);
	// user code begin {2}
	// user code end
}

/**
 * The addPropertyChangeListener method was generated to support the propertyChange field.
 * @param listener java.beans.PropertyChangeListener
 */
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().addPropertyChangeListener(listener);
}


/**
 * Comment
 */
public void checkScaleSettingsHistory() throws DataAccessException {
	String newDataSet = getImageContainer().getDataID();
	if (scaleSettingsHistory.capacity() != 0) scaleSettingsHistory.setElementAt(getScalePanel1().getScaleRange(), index);
	if (dataSetHistory.contains(newDataSet)) {
		getScalePanel1().setScaleRange((Range)scaleSettingsHistory.elementAt(dataSetHistory.indexOf(newDataSet)));
	} else {
		dataSetHistory.addElement(newDataSet);
		Range defaultManualRange = new Range(0.0, Math.pow(10, (int)((Math.log(getScalePanel1().getDataRange().getMax())) / Math.log(10)) + 1));
		getScalePanel1().setScaleRange(defaultManualRange);
		scaleSettingsHistory.addElement(defaultManualRange);
	}
	index = dataSetHistory.indexOf(newDataSet);
	return;
}


/**
 * conn9:  (ImageContainer.this --> SliceLabel.text)
 * @param value cbit.image.ImageContainer
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn9(ImageContainer value) {
	try {
		// user code begin {1}
		// user code end
		if ((getImageContainer() != null)) {
			getSliceLabel().setText(String.valueOf(getImageContainer().getSlice()));
		}
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * connEtoC1:  (ImageContainerPanelTool.clickedPoint --> ImageContainerPanel.firePropertyChange(Ljava.lang.String;Ljava.lang.Object;Ljava.lang.Object;)V)
 * @param arg1 java.beans.PropertyChangeEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC1(java.beans.PropertyChangeEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.firePropertyChange("imageContainerPanelToolClickedPoint", arg1.getOldValue(), arg1.getNewValue());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoC2:  (ImageContainerPanelTool.endLine --> ImageContainerPanel.firePropertyChange(Ljava.lang.String;Ljava.lang.Object;Ljava.lang.Object;)V)
 * @param arg1 java.beans.PropertyChangeEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC2(java.beans.PropertyChangeEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.firePropertyChange("imageContainerPanelToolEndLine", arg1.getOldValue(), arg1.getNewValue());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoC3:  ( (ImageContainer,dataRange --> ScalePanel1,dataRange).normalResult --> ImageContainerPanel.checkScaleSettingsHistory()V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC3() {
	try {
		// user code begin {1}
		// user code end
		this.checkScaleSettingsHistory();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoC4:  ( (ImageContainer,this --> ScalePanel1,dataRange).normalResult --> ImageContainerPanel.checkScaleSettingsHistory()V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC4() {
	try {
		// user code begin {1}
		// user code end
		this.checkScaleSettingsHistory();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoC5:  (ImageContainerPanelTool.sliceNumber --> ImageContainerPanel.firePropertyChange(Ljava.lang.String;Ljava.lang.Object;Ljava.lang.Object;)V)
 * @param arg1 java.beans.PropertyChangeEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC5(java.beans.PropertyChangeEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.firePropertyChange("imageContainerPanelToolSliceNumber", arg1.getOldValue(), arg1.getNewValue());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoC6:  (ImageContainerPanelTool.slicePlane --> ImageContainerPanel.firePropertyChange(Ljava.lang.String;Ljava.lang.Object;Ljava.lang.Object;)V)
 * @param arg1 java.beans.PropertyChangeEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC6(java.beans.PropertyChangeEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.firePropertyChange("imageContainerPanelToolSlicePlane", arg1.getOldValue(), arg1.getNewValue());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoC7:  ( (ScalePanel1,scaleRange --> ImageContainerPanel,refreshScaling()V).normalResult --> ImageContainerPanel.updateScaleSettingsHistory()V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC7() {
	try {
		// user code begin {1}
		// user code end
		this.updateScaleSettingsHistory();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoC8:  (ImageContainer.pixels --> ImageContainerPanel.refreshImage()V)
 * @param arg1 java.beans.PropertyChangeEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC8(java.beans.PropertyChangeEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.refreshImage();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoC9:  (ImageContainer.this --> ImageContainerPanel.refreshImage()V)
 * @param value cbit.image.gui.ImageContainer
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC9(ImageContainer value) {
	try {
		// user code begin {1}
		// user code end
		this.refreshImage();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoM1:  (Button2.action.actionPerformed(java.awt.event.ActionEvent) --> ImageContainerPanelTool.decrementSlice()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM1(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getImageContainerPanelTool().decrementSlice();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * connEtoM10:  (ScalePanel1.scaleRange --> ImageContainerPanel.refreshScaling()V)
 * @param arg1 java.beans.PropertyChangeEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM10(java.beans.PropertyChangeEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.refreshScaling();
		connEtoC7();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * connEtoM11:  (ScalePanel1.autoMode --> ImageContainerPanel.refreshScaling()V)
 * @param arg1 java.beans.PropertyChangeEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM11(java.beans.PropertyChangeEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.refreshScaling();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoM12:  (ScalePanel1.colorMode --> ImageContainerPanel.refreshScaling()V)
 * @param arg1 java.beans.PropertyChangeEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM12(java.beans.PropertyChangeEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.refreshScaling();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoM13:  (ScalePanel1.colorMode --> ImageContainer.colorMode)
 * @param arg1 java.beans.PropertyChangeEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM13(java.beans.PropertyChangeEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getImageContainer().setColorMode(getScalePanel1().getColorMode());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoM14:  (Button4.action.actionPerformed(java.awt.event.ActionEvent) --> ImageContainerPanelTool.decrementSlice10()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM14(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getImageContainerPanelTool().decrementSlice10();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoM15:  (Button3.action.actionPerformed(java.awt.event.ActionEvent) --> ImageContainerPanelTool.incrementSlice10()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM15(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getImageContainerPanelTool().incrementSlice10();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoM16:  (ImageContainerPanel.initialize() --> ButtonGroup1.add(Ljavax.swing.AbstractButton;)V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM16() {
	try {
		// user code begin {1}
		// user code end
		getButtonGroup1().add(getXAxisCheckbox());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoM17:  (ImageContainerPanel.initialize() --> ButtonGroup1.add(Ljavax.swing.AbstractButton;)V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM17() {
	try {
		// user code begin {1}
		// user code end
		getButtonGroup1().add(getZAxisCheckbox());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoM18:  (ImageContainerPanel.initialize() --> ButtonGroup1.add(Ljavax.swing.AbstractButton;)V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM18() {
	try {
		// user code begin {1}
		// user code end
		getButtonGroup1().add(getYAxisCheckbox());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoM2:  (Button1.action.actionPerformed(java.awt.event.ActionEvent) --> ImageContainerPanelTool.incrementSlice()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM2(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getImageContainerPanelTool().incrementSlice();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * connEtoM3:  (ZAxisCheckbox.item.itemStateChanged(java.awt.event.ItemEvent) --> ImageContainerPanelTool.setAxisZ()V)
 * @param arg1 java.awt.event.ItemEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM3(java.awt.event.ItemEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getImageContainerPanelTool().setAxisZ();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * connEtoM4:  (XAxisCheckbox.item.itemStateChanged(java.awt.event.ItemEvent) --> ImageContainerPanelTool.setAxisX()V)
 * @param arg1 java.awt.event.ItemEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM4(java.awt.event.ItemEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getImageContainerPanelTool().setAxisX();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * connEtoM5:  (YAxisCheckbox.item.itemStateChanged(java.awt.event.ItemEvent) --> ImageContainerPanelTool.setAxisY()V)
 * @param arg1 java.awt.event.ItemEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM5(java.awt.event.ItemEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getImageContainerPanelTool().setAxisY();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * connEtoM6:  (ScalePanel1.autoMode --> ImageContainer.autoMode)
 * @param arg1 java.beans.PropertyChangeEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM6(java.beans.PropertyChangeEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getImageContainer().setAutoMode(getScalePanel1().getAutoMode());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoM7:  (ImageContainer.realBounds --> ScalePanel1.realBounds)
 * @param arg1 java.beans.PropertyChangeEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM7(java.beans.PropertyChangeEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		if ((getImageContainer() != null)) {
			getScalePanel1().setDataRange(getImageContainer().getDataRange());
		}
		connEtoC3();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * connEtoM8:  (ImageContainer.this --> ScalePanel1.realBounds)
 * @param value cbit.image.ImageContainer
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM8(ImageContainer value) {
	try {
		// user code begin {1}
		// user code end
		if ((getImageContainer() != null)) {
			getScalePanel1().setDataRange(getImageContainer().getDataRange());
		}
		connEtoC4();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * connEtoM9:  (ScalePanel1.inputMinMax --> ImageContainer.inputMinMax)
 * @param arg1 java.beans.PropertyChangeEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM9(java.beans.PropertyChangeEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getImageContainer().setScaleRange(getScalePanel1().getScaleRange());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * The firePropertyChange method was generated to support the propertyChange field.
 * @param propertyName java.lang.String
 * @param oldValue java.lang.Object
 * @param newValue java.lang.Object
 */
public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
}


/**
 * Return the AxisPanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getAxisPanel() {
	if (ivjAxisPanel == null) {
		try {
			ivjAxisPanel = new javax.swing.JPanel();
			ivjAxisPanel.setName("AxisPanel");
			ivjAxisPanel.setBorder(new javax.swing.border.EtchedBorder());
			ivjAxisPanel.setLayout(new java.awt.GridBagLayout());

			java.awt.GridBagConstraints constraintsLabel1 = new java.awt.GridBagConstraints();
			constraintsLabel1.gridx = 0; constraintsLabel1.gridy = 0;
			constraintsLabel1.gridwidth = 3;
			constraintsLabel1.ipady = 5;
			getAxisPanel().add(getLabel1(), constraintsLabel1);

			java.awt.GridBagConstraints constraintsZAxisCheckbox = new java.awt.GridBagConstraints();
			constraintsZAxisCheckbox.gridx = 0; constraintsZAxisCheckbox.gridy = 1;
			constraintsZAxisCheckbox.insets = new java.awt.Insets(0, 5, 5, 0);
			getAxisPanel().add(getZAxisCheckbox(), constraintsZAxisCheckbox);

			java.awt.GridBagConstraints constraintsXAxisCheckbox = new java.awt.GridBagConstraints();
			constraintsXAxisCheckbox.gridx = 1; constraintsXAxisCheckbox.gridy = 1;
			constraintsXAxisCheckbox.insets = new java.awt.Insets(0, 0, 5, 0);
			getAxisPanel().add(getXAxisCheckbox(), constraintsXAxisCheckbox);

			java.awt.GridBagConstraints constraintsYAxisCheckbox = new java.awt.GridBagConstraints();
			constraintsYAxisCheckbox.gridx = 2; constraintsYAxisCheckbox.gridy = 1;
			constraintsYAxisCheckbox.insets = new java.awt.Insets(0, 0, 5, 0);
			getAxisPanel().add(getYAxisCheckbox(), constraintsYAxisCheckbox);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAxisPanel;
}

/**
 * Return the Button1 property value.
 * @return javax.swing.JButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JButton getButton1() {
	if (ivjButton1 == null) {
		try {
			ivjButton1 = new javax.swing.JButton();
			ivjButton1.setName("Button1");
			ivjButton1.setText("+1");
			ivjButton1.setPreferredSize(new java.awt.Dimension(31, 25));
			ivjButton1.setFont(new java.awt.Font("dialog", 1, 12));
			ivjButton1.setMinimumSize(new java.awt.Dimension(31, 25));
			ivjButton1.setMargin(new java.awt.Insets(2, 5, 2, 5));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjButton1;
}


/**
 * Return the Button2 property value.
 * @return javax.swing.JButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JButton getButton2() {
	if (ivjButton2 == null) {
		try {
			ivjButton2 = new javax.swing.JButton();
			ivjButton2.setName("Button2");
			ivjButton2.setText("-1");
			ivjButton2.setMargin(new java.awt.Insets(2, 5, 2, 5));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjButton2;
}


/**
 * Return the Button3 property value.
 * @return javax.swing.JButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JButton getButton3() {
	if (ivjButton3 == null) {
		try {
			ivjButton3 = new javax.swing.JButton();
			ivjButton3.setName("Button3");
			ivjButton3.setText("+10");
			ivjButton3.setMargin(new java.awt.Insets(2, 2, 2, 2));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjButton3;
}


/**
 * Return the Button4 property value.
 * @return javax.swing.JButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JButton getButton4() {
	if (ivjButton4 == null) {
		try {
			ivjButton4 = new javax.swing.JButton();
			ivjButton4.setName("Button4");
			ivjButton4.setText("-10");
			ivjButton4.setMargin(new java.awt.Insets(2, 2, 2, 2));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjButton4;
}


/**
 * Return the ButtonGroup1 property value.
 * @return javax.swing.ButtonGroup
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.ButtonGroup getButtonGroup1() {
	if (ivjButtonGroup1 == null) {
		try {
			ivjButtonGroup1 = new javax.swing.ButtonGroup();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjButtonGroup1;
}


/**
 * This method was created in VisualAge.
 * @return java.util.Vector
 */
public Vector getDataSetHistory() {
	return dataSetHistory;
}


/**
 * Return the ImageContainer property value.
 * @return cbit.image.ImageContainer
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public ImageContainer getImageContainer() {
	// user code begin {1}
	// user code end
	return ivjImageContainer;
}

/**
 * Method generated to support the promotion of the imageContainerNormalAxis attribute.
 * @return int
 */
public int getImageContainerNormalAxis() {
		return getImageContainer().getNormalAxis();
}


/**
 * Return the ImageContainerPanelTool property value.
 * @return cbit.image.ImageContainerPanelTool
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ImageContainerPanelTool getImageContainerPanelTool() {
	// user code begin {1}
	// user code end
	return ivjImageContainerPanelTool;
}


/**
 * Method generated to support the promotion of the imageContainerPanelToolBeginLine attribute.
 * @return cbit.vcell.math.CoordinateIndex
 */
public org.vcell.util.CoordinateIndex getImageContainerPanelToolBeginLine() {
		return getImageContainerPanelTool().getBeginLine();
}


/**
 * Method generated to support the promotion of the imageContainerPanelToolClickedPoint attribute.
 * @return cbit.vcell.math.CoordinateIndex
 */
public org.vcell.util.CoordinateIndex getImageContainerPanelToolClickedPoint() {
		return getImageContainerPanelTool().getClickedPoint();
}


/**
 * Method generated to support the promotion of the imageContainerPanelToolEndLine attribute.
 * @return cbit.vcell.math.CoordinateIndex
 */
public org.vcell.util.CoordinateIndex getImageContainerPanelToolEndLine() {
		return getImageContainerPanelTool().getEndLine();
}


/**
 * Method generated to support the promotion of the imageContainerPanelToolSliceNumber attribute.
 * @return int
 */
public int getImageContainerPanelToolSliceNumber() {
		return getImageContainerPanelTool().getSliceNumber();
}


/**
 * Method generated to support the promotion of the imageContainerPanelToolSlicePlane attribute.
 * @return int
 */
public int getImageContainerPanelToolSlicePlane() {
		return getImageContainerPanelTool().getSlicePlane();
}


/**
 * Method generated to support the promotion of the imageContainerSlice attribute.
 * @return int
 */
public int getImageContainerSlice() {
		return getImageContainer().getSlice();
}


/**
 * Return the ImagePane property value.
 * @return cbit.image.ImagePaneScroller
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public cbit.image.gui.ImagePaneScroller getImagePaneScroller() {
	if (ivjImagePaneScroller == null) {
		try {
			ivjImagePaneScroller = new cbit.image.gui.ImagePaneScroller();
			ivjImagePaneScroller.setName("ImagePaneScroller");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjImagePaneScroller;
}

/**
 * Return the Label1 property value.
 * @return javax.swing.JLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JLabel getLabel1() {
	if (ivjLabel1 == null) {
		try {
			ivjLabel1 = new javax.swing.JLabel();
			ivjLabel1.setName("Label1");
			ivjLabel1.setText("Axis:");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjLabel1;
}


/**
 * Return the Label2 property value.
 * @return javax.swing.JLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JLabel getLabel2() {
	if (ivjLabel2 == null) {
		try {
			ivjLabel2 = new javax.swing.JLabel();
			ivjLabel2.setName("Label2");
			ivjLabel2.setText("Slice:");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjLabel2;
}


/**
 * Accessor for the propertyChange field.
 * @return java.beans.PropertyChangeSupport
 */
protected java.beans.PropertyChangeSupport getPropertyChange() {
	if (propertyChange == null) {
		propertyChange = new java.beans.PropertyChangeSupport(this);
	};
	return propertyChange;
}


/**
 * Return the ScalePanel1 property value.
 * @return cbit.image.ScalePanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private cbit.image.gui.ScalePanel getScalePanel1() {
	if (ivjScalePanel1 == null) {
		try {
			ivjScalePanel1 = new cbit.image.gui.ScalePanel();
			ivjScalePanel1.setName("ScalePanel1");
			ivjScalePanel1.setBorder(new javax.swing.border.EtchedBorder());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjScalePanel1;
}

/**
 * Method generated to support the promotion of the scalePanel1Visible attribute.
 * @return boolean
 */
public boolean getScalePanel1Visible() {
		return getScalePanel1().isVisible();
}


/**
 * This method was created in VisualAge.
 * @return java.util.Vector
 */
public Vector getScaleSettingsHistory() {
	return scaleSettingsHistory;
}


/**
 * Return the SliceLabel property value.
 * @return javax.swing.JLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JLabel getSliceLabel() {
	if (ivjSliceLabel == null) {
		try {
			ivjSliceLabel = new javax.swing.JLabel();
			ivjSliceLabel.setName("SliceLabel");
			ivjSliceLabel.setText("0");
			ivjSliceLabel.setHorizontalAlignment(SwingConstants.CENTER);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjSliceLabel;
}


/**
 * Return the SlicePanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getSlicePanel() {
	if (ivjSlicePanel == null) {
		try {
			ivjSlicePanel = new javax.swing.JPanel();
			ivjSlicePanel.setName("SlicePanel");
			ivjSlicePanel.setBorder(new javax.swing.border.EtchedBorder());
			ivjSlicePanel.setLayout(new java.awt.GridBagLayout());

			java.awt.GridBagConstraints constraintsLabel2 = new java.awt.GridBagConstraints();
			constraintsLabel2.gridx = 1; constraintsLabel2.gridy = 0;
			constraintsLabel2.gridwidth = 3;
			constraintsLabel2.ipady = 5;
			getSlicePanel().add(getLabel2(), constraintsLabel2);

			java.awt.GridBagConstraints constraintsButton2 = new java.awt.GridBagConstraints();
			constraintsButton2.gridx = 1; constraintsButton2.gridy = 1;
			constraintsButton2.insets = new java.awt.Insets(0, 0, 5, 0);
			getSlicePanel().add(getButton2(), constraintsButton2);

			java.awt.GridBagConstraints constraintsButton1 = new java.awt.GridBagConstraints();
			constraintsButton1.gridx = 3; constraintsButton1.gridy = 1;
			constraintsButton1.insets = new java.awt.Insets(0, 0, 5, 0);
			getSlicePanel().add(getButton1(), constraintsButton1);

			java.awt.GridBagConstraints constraintsSliceLabel = new java.awt.GridBagConstraints();
			constraintsSliceLabel.gridx = 2; constraintsSliceLabel.gridy = 1;
			constraintsSliceLabel.ipadx = 20;
			constraintsSliceLabel.insets = new java.awt.Insets(0, 0, 5, 0);
			getSlicePanel().add(getSliceLabel(), constraintsSliceLabel);

			java.awt.GridBagConstraints constraintsButton4 = new java.awt.GridBagConstraints();
			constraintsButton4.gridx = 0; constraintsButton4.gridy = 1;
			constraintsButton4.insets = new java.awt.Insets(0, 5, 5, 0);
			getSlicePanel().add(getButton4(), constraintsButton4);

			java.awt.GridBagConstraints constraintsButton3 = new java.awt.GridBagConstraints();
			constraintsButton3.gridx = 4; constraintsButton3.gridy = 1;
			constraintsButton3.insets = new java.awt.Insets(0, 0, 5, 5);
			getSlicePanel().add(getButton3(), constraintsButton3);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjSlicePanel;
}

/**
 * Gets the spatialPlotEnabled property (boolean) value.
 * @return The spatialPlotEnabled property value.
 * @see #setSpatialPlotEnabled
 */
public boolean getSpatialPlotEnabled() {
	return fieldSpatialPlotEnabled;
}


/**
 * Return the StatusLabel property value.
 * @return javax.swing.JLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public javax.swing.JLabel getStatusLabel() {
	if (ivjStatusLabel == null) {
		try {
			ivjStatusLabel = new javax.swing.JLabel();
			ivjStatusLabel.setName("StatusLabel");
			ivjStatusLabel.setText(" ");
			ivjStatusLabel.setMaximumSize(new java.awt.Dimension(25, 25));
			ivjStatusLabel.setPreferredSize(new java.awt.Dimension(25, 25));
			ivjStatusLabel.setMinimumSize(new java.awt.Dimension(25, 25));
			ivjStatusLabel.setHorizontalAlignment(SwingConstants.CENTER);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjStatusLabel;
}

/**
 * Return the XAxisCheckbox property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JRadioButton getXAxisCheckbox() {
	if (ivjXAxisCheckbox == null) {
		try {
			ivjXAxisCheckbox = new javax.swing.JRadioButton();
			ivjXAxisCheckbox.setName("XAxisCheckbox");
			ivjXAxisCheckbox.setText("YZ");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjXAxisCheckbox;
}


/**
 * Return the YAxisCheckbox property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JRadioButton getYAxisCheckbox() {
	if (ivjYAxisCheckbox == null) {
		try {
			ivjYAxisCheckbox = new javax.swing.JRadioButton();
			ivjYAxisCheckbox.setName("YAxisCheckbox");
			ivjYAxisCheckbox.setText("ZX");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjYAxisCheckbox;
}


/**
 * Return the ZAxisCheckbox property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JRadioButton getZAxisCheckbox() {
	if (ivjZAxisCheckbox == null) {
		try {
			ivjZAxisCheckbox = new javax.swing.JRadioButton();
			ivjZAxisCheckbox.setName("ZAxisCheckbox");
			ivjZAxisCheckbox.setSelected(true);
			ivjZAxisCheckbox.setText("XY");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjZAxisCheckbox;
}


/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	System.out.println("--------- UNCAUGHT EXCEPTION --------- in ImageContainerPanel ");
	exception.printStackTrace(System.out);
}

/**
 * Initializes connections
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() throws java.lang.Exception {
	// user code begin {1}
	// user code end
	getScalePanel1().addPropertyChangeListener(this);
	getButton2().addActionListener(this);
	getButton1().addActionListener(this);
	getYAxisCheckbox().addItemListener(this);
	getXAxisCheckbox().addItemListener(this);
	getZAxisCheckbox().addItemListener(this);
	getButton4().addActionListener(this);
	getButton3().addActionListener(this);
}

/**
 * Initialize class
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	try {
		// user code begin {1}
		// user code end
		setName("ImageContainerPanel");
		setLayout(new java.awt.GridBagLayout());
		setSize(455, 433);

		java.awt.GridBagConstraints constraintsAxisPanel = new java.awt.GridBagConstraints();
		constraintsAxisPanel.gridx = 1; constraintsAxisPanel.gridy = 2;
		constraintsAxisPanel.fill = java.awt.GridBagConstraints.HORIZONTAL;
		constraintsAxisPanel.anchor = java.awt.GridBagConstraints.SOUTH;
		constraintsAxisPanel.insets = new java.awt.Insets(0, 5, 5, 5);
		add(getAxisPanel(), constraintsAxisPanel);

		java.awt.GridBagConstraints constraintsSlicePanel = new java.awt.GridBagConstraints();
		constraintsSlicePanel.gridx = 1; constraintsSlicePanel.gridy = 1;
		constraintsSlicePanel.fill = java.awt.GridBagConstraints.HORIZONTAL;
		constraintsSlicePanel.anchor = java.awt.GridBagConstraints.SOUTH;
		constraintsSlicePanel.weighty = 1.0;
		constraintsSlicePanel.insets = new java.awt.Insets(0, 5, 5, 5);
		add(getSlicePanel(), constraintsSlicePanel);

		java.awt.GridBagConstraints constraintsStatusLabel = new java.awt.GridBagConstraints();
		constraintsStatusLabel.gridx = 0; constraintsStatusLabel.gridy = 3;
		constraintsStatusLabel.fill = java.awt.GridBagConstraints.HORIZONTAL;
		constraintsStatusLabel.insets = new java.awt.Insets(4, 4, 4, 4);
		add(getStatusLabel(), constraintsStatusLabel);

		java.awt.GridBagConstraints constraintsScalePanel1 = new java.awt.GridBagConstraints();
		constraintsScalePanel1.gridx = 1; constraintsScalePanel1.gridy = 0;
		constraintsScalePanel1.fill = java.awt.GridBagConstraints.HORIZONTAL;
		constraintsScalePanel1.anchor = java.awt.GridBagConstraints.NORTH;
		constraintsScalePanel1.insets = new java.awt.Insets(5, 5, 5, 5);
		add(getScalePanel1(), constraintsScalePanel1);

		java.awt.GridBagConstraints constraintsImagePaneScroller = new java.awt.GridBagConstraints();
		constraintsImagePaneScroller.gridx = 0; constraintsImagePaneScroller.gridy = 0;
constraintsImagePaneScroller.gridheight = 3;
		constraintsImagePaneScroller.fill = java.awt.GridBagConstraints.BOTH;
		constraintsImagePaneScroller.weightx = 1.0;
		constraintsImagePaneScroller.weighty = 1.0;
		constraintsImagePaneScroller.insets = new java.awt.Insets(4, 5, 5, 0);
		add(getImagePaneScroller(), constraintsImagePaneScroller);
		initConnections();
		connEtoM16();
		connEtoM17();
		connEtoM18();
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the ItemListener interface.
 * @param e java.awt.event.ItemEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void itemStateChanged(java.awt.event.ItemEvent e) {
	// user code begin {1}
	// user code end
	if (e.getSource() == getYAxisCheckbox()) 
		connEtoM5(e);
	if (e.getSource() == getXAxisCheckbox()) 
		connEtoM4(e);
	if (e.getSource() == getZAxisCheckbox()) 
		connEtoM3(e);
	// user code begin {2}
	// user code end
}

/**
 * main entrypoint - starts the part when it is run as an application
 * @param args java.lang.String[]
 */
public static void main(java.lang.String[] args) {
	try {
		java.awt.Frame frame;
		try {
			Class aFrameClass = Class.forName("com.ibm.uvm.abt.edit.TestFrame");
			frame = (java.awt.Frame)aFrameClass.newInstance();
		} catch (java.lang.Throwable ivjExc) {
			frame = new java.awt.Frame();
		}
		ImageContainerPanel aImageContainerPanel;
		aImageContainerPanel = new ImageContainerPanel();
		frame.add("Center", aImageContainerPanel);
		frame.setSize(aImageContainerPanel.getSize());
		frame.setVisible(true);
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of java.awt.Panel");
		exception.printStackTrace(System.out);
	}
}


/**
 * Method to handle events for the PropertyChangeListener interface.
 * @param evt java.beans.PropertyChangeEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void propertyChange(java.beans.PropertyChangeEvent evt) {
	// user code begin {1}
	// user code end
	if (evt.getSource() == getScalePanel1() && (evt.getPropertyName().equals("scaleRange"))) 
		connEtoM10(evt);
	if (evt.getSource() == getScalePanel1() && (evt.getPropertyName().equals("autoMode"))) 
		connEtoM11(evt);
	if (evt.getSource() == getScalePanel1() && (evt.getPropertyName().equals("colorMode"))) 
		connEtoM12(evt);
	if (evt.getSource() == getImageContainer() && (evt.getPropertyName().equals("dataRange"))) 
		connEtoM7(evt);
	if (evt.getSource() == getImageContainer() && (evt.getPropertyName().equals("pixels"))) 
		connEtoC8(evt);
	if (evt.getSource() == getScalePanel1() && (evt.getPropertyName().equals("colorMode"))) 
		connEtoM13(evt);
	if (evt.getSource() == getScalePanel1() && (evt.getPropertyName().equals("scaleRange"))) 
		connEtoM9(evt);
	if (evt.getSource() == getScalePanel1() && (evt.getPropertyName().equals("autoMode"))) 
		connEtoM6(evt);
	if (evt.getSource() == getImageContainerPanelTool() && (evt.getPropertyName().equals("endLine"))) 
		connEtoC2(evt);
	if (evt.getSource() == getImageContainerPanelTool() && (evt.getPropertyName().equals("sliceNumber"))) 
		connEtoC5(evt);
	if (evt.getSource() == getImageContainerPanelTool() && (evt.getPropertyName().equals("slicePlane"))) 
		connEtoC6(evt);
	if (evt.getSource() == getImageContainerPanelTool() && (evt.getPropertyName().equals("clickedPoint"))) 
		connEtoC1(evt);
	// user code begin {2}
	// user code end
}

/**
 * This method was created by a SmartGuide.
 */
public void refreshImage() {
	if (getImageContainer()==null){
		getImagePaneScroller().getImagePaneView().clear();
		return;
	}	
	try {
		int nX = getImageContainer().getDisplayWidth();
		int nY = getImageContainer().getDisplayHeight();
		int nZ = 1;
		SourceDataInfo sourceData = new SourceDataInfo(SourceDataInfo.INT_RGB_TYPE,getImageContainer().getPixels(),new org.vcell.util.Extent(1,1,1),new org.vcell.util.Origin(0,0,0),getImageContainer().getDataRange(),0,nX,1,nY,nX,nZ,nX*nY);
		getImagePaneScroller().getImagePaneModel().setSourceData(sourceData);
	}catch (Exception e){
		getImagePaneScroller().getImagePaneView().clear();
		e.printStackTrace(System.out);
	}		
}


/**
 * This method was created in VisualAge.
 */
public void refreshScaling() {
	getImageContainer().refreshDisplayScale();
	getImageContainer().refreshDisplayPixels();
	refreshImage();
}


/**
 * The removePropertyChangeListener method was generated to support the propertyChange field.
 * @param listener java.beans.PropertyChangeListener
 */
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().removePropertyChangeListener(listener);
}


/**
 * This method was created in VisualAge.
 */
public void repaintImage() {
	getImagePaneScroller().repaint();
}


/**
 * Set the ImageContainer to a new value.
 * @param newValue cbit.image.ImageContainer
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void setImageContainer(ImageContainer newValue) {
	if (ivjImageContainer != newValue) {
		try {
			cbit.image.gui.ImageContainer oldValue = getImageContainer();
			/* Stop listening for events from the current object */
			if (ivjImageContainer != null) {
				ivjImageContainer.removePropertyChangeListener(this);
			}
			ivjImageContainer = newValue;

			/* Listen for events from the new object */
			if (ivjImageContainer != null) {
				ivjImageContainer.addPropertyChangeListener(this);
			}
			conn9(ivjImageContainer);
			connEtoM8(ivjImageContainer);
			connEtoC9(ivjImageContainer);
			// user code begin {1}
			if (getImageContainerPanelTool()!=null){
				getImageContainerPanelTool().setImageContainer(getImageContainer());
			}else{
				setImageContainerPanelTool(new ImageContainerPanelTool(this,getImageContainer()));
			}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	// user code begin {3}
	// user code end
}

/**
 * Set the ImageContainerPanelTool to a new value.
 * @param newValue cbit.image.ImageContainerPanelTool
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void setImageContainerPanelTool(ImageContainerPanelTool newValue) {
	if (ivjImageContainerPanelTool != newValue) {
		try {
			/* Stop listening for events from the current object */
			if (ivjImageContainerPanelTool != null) {
				ivjImageContainerPanelTool.removePropertyChangeListener(this);
			}
			ivjImageContainerPanelTool = newValue;

			/* Listen for events from the new object */
			if (ivjImageContainerPanelTool != null) {
				ivjImageContainerPanelTool.addPropertyChangeListener(this);
			}
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	// user code begin {3}
	// user code end
}

/**
 * Method generated to support the promotion of the scalePanel1Visible attribute.
 * @param arg1 boolean
 */
public void setScalePanel1Visible(boolean arg1) {
		getScalePanel1().setVisible(arg1);
}


/**
 * This method was created in VisualAge.
 * @param text java.lang.String
 */
public void setSliceLabelText(String text) {
	getSliceLabel().setText(text);
}


/**
 * Sets the spatialPlotEnabled property (boolean) value.
 * @param spatialPlotEnabled The new value for the property.
 * @see #getSpatialPlotEnabled
 */
public void setSpatialPlotEnabled(boolean spatialPlotEnabled) {
	boolean oldValue = fieldSpatialPlotEnabled;
	fieldSpatialPlotEnabled = spatialPlotEnabled;
	firePropertyChange("spatialPlotEnabled", new Boolean(oldValue), new Boolean(spatialPlotEnabled));
}


/**
 * This method was created in VisualAge.
 * @param statusText java.lang.String
 */
public void setStatusText(String statusText) {
	getStatusLabel().setText(statusText);
}


/**
 * Comment
 */
public void updateScaleSettingsHistory() {
	if ((scaleSettingsHistory.capacity() != 0) && getImageContainer().getDataID().equals(dataSetHistory.elementAt(index))) scaleSettingsHistory.setElementAt(getScalePanel1().getScaleRange(), index);
	return;
}
}
