CREATE TABLE vc_userinfo(id integer PRIMARY KEY,USERID varchar(255) UNIQUE NOT NULL,PASSWORD varchar(255) NOT NULL,EMAIL varchar(255) NOT NULL,FIRSTNAME varchar(255) NOT NULL,LASTNAME varchar(255) ,TITLE varchar(255) ,COMPANYNAME varchar(255) ,ADDRESS1 varchar(255) ,ADDRESS2 varchar(255) ,CITY varchar(255) ,STATE varchar(255) ,COUNTRY varchar(255) ,ZIP varchar(255) ,NOTIFY varchar(255) NOT NULL,insertDate date NOT NULL,DIGESTPW varchar(255) NOT NULL)
CREATE TABLE vc_group(id integer PRIMARY KEY,groupid integer NOT NULL,userRef integer NOT NULL REFERENCES vc_userinfo(id) ON DELETE CASCADE,isHiddenFromOwner integer NOT NULL,groupMemberHash integer NOT NULL)
CREATE TABLE vc_model(id integer PRIMARY KEY,name varchar(255) NOT NULL,ownerRef integer NOT NULL REFERENCES vc_userinfo(id),privacy integer NOT NULL,versionPRef integer REFERENCES vc_model(id),versionDate date NOT NULL,versionFlag integer NOT NULL,versionAnnot varchar(4000) ,versionBranchID integer NOT NULL,unitSystemXML varchar2(4000) ,rbmLRG clob ,rbmSML varchar2(4000) )
CREATE TABLE vc_celltype(id integer PRIMARY KEY,name varchar(255) NOT NULL,annotation varchar(255) NOT NULL)
CREATE TABLE vc_struct(id integer PRIMARY KEY,strName varchar(255) NOT NULL,structType varchar(10) NOT NULL,parentRef integer ,cellTypeRef integer REFERENCES vc_celltype(id),memVoltName varchar(64) ,negFeatureRef integer REFERENCES vc_struct(id),posFeatureRef integer REFERENCES vc_struct(id))
CREATE TABLE vc_reactstep(id integer PRIMARY KEY,reactType varchar(10) NOT NULL,modelRef integer NOT NULL REFERENCES vc_model(id) ON DELETE CASCADE,structRef integer NOT NULL REFERENCES vc_struct(id),kinetics clob ,name varchar2(255) ,chargeValence integer ,physicsOptions integer ,kineticsLRG clob ,kineticsSML varchar2(4000) ,annotation varchar2(4000) ,sbmlname varchar2(255) )
CREATE TABLE vc_protein(id integer PRIMARY KEY,organism varchar2(1024) ,accessionnumber varchar2(1024) ,swissprotid varchar2(32) UNIQUE NOT NULL,keywords varchar2(1024) ,description varchar2(1024) ,molWeight number )
CREATE TABLE vc_proteinalias(id integer PRIMARY KEY,proteinRef number REFERENCES vc_protein(id) ON DELETE CASCADE NOT NULL,name varchar2(256) NOT NULL,preferred varchar2(1) NOT NULL)
CREATE TABLE vc_compound(id integer PRIMARY KEY,formula varchar2(256) ,casId varchar2(256) ,keggId varchar2(32) UNIQUE NOT NULL)
CREATE TABLE vc_compoundalias(id integer PRIMARY KEY,compoundRef number REFERENCES vc_compound(id) ON DELETE CASCADE NOT NULL,name varchar2(256) NOT NULL,preferred varchar2(1) NOT NULL)
CREATE TABLE vc_enzyme(id integer PRIMARY KEY,reaction varchar2(512) ,ecnumber varchar2(32) UNIQUE NOT NULL,sysname varchar2(512) ,casid varchar2(256) )
CREATE TABLE vc_enzymealias(id integer PRIMARY KEY,enzymeRef number REFERENCES vc_enzyme(id) ON DELETE CASCADE NOT NULL,name varchar2(256) NOT NULL,preferred varchar2(1) NOT NULL)
CREATE TABLE vc_enzymereaction(id integer PRIMARY KEY,reactionId varchar2(32) NOT NULL,enzymeRef number REFERENCES vc_enzyme(id) ON DELETE CASCADE,compoundRef number REFERENCES vc_compound(id) ON DELETE CASCADE NOT NULL,type varchar2(1) NOT NULL,stoich number NOT NULL,parsedECNumber varchar2(32) )
CREATE TABLE vc_dbspecies(id integer PRIMARY KEY,compoundRef integer REFERENCES vc_compound(id),enzymeRef integer REFERENCES vc_enzyme(id),proteinRef integer REFERENCES vc_protein(id), CONSTRAINT com_enz_pro_unique UNIQUE(compoundRef,enzymeRef,proteinRef), CONSTRAINT com_enz_pro_only_1 CHECK(DECODE(compoundref,NULL,0,compoundref,1)+DECODE(enzymeref,NULL,0,enzymeref,1)+DECODE(proteinref,NULL,0,proteinref,1) = 1))
CREATE TABLE vc_specialusers(id integer PRIMARY KEY,SPECIAL varchar(255) NOT NULL,USERREF integer NOT NULL REFERENCES vc_userinfo(id),USERDETAIL varchar(255) )
CREATE TABLE vc_species(id integer PRIMARY KEY,commonName varchar(255) NOT NULL,dbSpeciesRef integer REFERENCES vc_dbspecies(id),annotation varchar(1024) )
CREATE TABLE vc_modelsc(id integer PRIMARY KEY,modelRef integer NOT NULL REFERENCES vc_model(id) ON DELETE CASCADE,speciesRef integer NOT NULL REFERENCES vc_species(id),structRef integer NOT NULL REFERENCES vc_struct(id),name varchar(255) NOT NULL,hasOverride varchar2(1) NOT NULL,speciesPattern varchar2(2000) ,sbmlName varchar(255) )
CREATE TABLE vc_modelstruct(id integer PRIMARY KEY,modelRef integer NOT NULL REFERENCES vc_model(id) ON DELETE CASCADE,structRef integer NOT NULL REFERENCES vc_struct(id))
CREATE TABLE vc_reactpart(id integer PRIMARY KEY,role varchar(10) NOT NULL,stoich integer NOT NULL,reactStepRef integer NOT NULL REFERENCES vc_reactstep(id) ON DELETE CASCADE,scRef integer NOT NULL REFERENCES vc_modelsc(id))
CREATE TABLE vc_diagram(id integer PRIMARY KEY,name varchar(255) NOT NULL,modelRef integer NOT NULL REFERENCES vc_model(id) ON DELETE CASCADE,structRef integer NOT NULL REFERENCES vc_struct(id),language clob ,diagramLRG clob ,diagramSML varchar2(4000) )
CREATE TABLE vc_geomextent(id integer PRIMARY KEY,extentX number NOT NULL,extentY number NOT NULL,extentZ number NOT NULL)
CREATE TABLE vc_image(id integer PRIMARY KEY,name varchar(255) NOT NULL,ownerRef integer NOT NULL REFERENCES vc_userinfo(id),privacy integer NOT NULL,versionPRef integer REFERENCES vc_image(id),versionDate date NOT NULL,versionFlag integer NOT NULL,versionAnnot varchar(4000) ,versionBranchID integer NOT NULL,numX integer NOT NULL,numY integer NOT NULL,numZ integer NOT NULL,extentRef integer NOT NULL REFERENCES vc_geomextent(id))
CREATE TABLE vc_imagedata(id integer PRIMARY KEY,imageRef integer NOT NULL REFERENCES vc_image(id) ON DELETE CASCADE,data blob NOT NULL)
CREATE TABLE vc_browsedata(id integer PRIMARY KEY,imageRef integer NOT NULL REFERENCES vc_image(id) ON DELETE CASCADE,data blob NOT NULL)
CREATE TABLE vc_imageregion(id integer PRIMARY KEY,regionName varchar(255) NOT NULL,imageRef integer NOT NULL REFERENCES vc_image(id) ON DELETE CASCADE,pixelValue integer NOT NULL)
CREATE TABLE vc_geometry(id integer PRIMARY KEY,name varchar(255) NOT NULL,ownerRef integer NOT NULL REFERENCES vc_userinfo(id),privacy integer NOT NULL,versionPRef integer REFERENCES vc_geometry(id),versionDate date NOT NULL,versionFlag integer NOT NULL,versionAnnot varchar(4000) ,versionBranchID integer NOT NULL,dimension integer NOT NULL,originX number NOT NULL,originY number NOT NULL,originZ number NOT NULL,extentRef integer NOT NULL REFERENCES vc_geomextent(id),imageRef integer REFERENCES vc_image(id))
CREATE TABLE vc_subvolume(id integer PRIMARY KEY,name varchar(255) NOT NULL,imageRegionRef integer REFERENCES vc_imageregion(id),geometryRef integer NOT NULL REFERENCES vc_geometry(id) ON DELETE CASCADE,expression varchar(2048) ,handle integer NOT NULL,ordinal integer NOT NULL)
CREATE TABLE vc_surfaceclass(id integer PRIMARY KEY,name varchar(255) NOT NULL,geometryRef integer NOT NULL REFERENCES vc_geometry(id) ON DELETE CASCADE,subVolumeRef1 integer REFERENCES vc_subvolume(id),subVolumeRef2 integer REFERENCES vc_subvolume(id))
CREATE TABLE vc_math(id integer PRIMARY KEY,name varchar(255) NOT NULL,ownerRef integer NOT NULL REFERENCES vc_userinfo(id),privacy integer NOT NULL,versionPRef integer REFERENCES vc_math(id),versionDate date NOT NULL,versionFlag integer NOT NULL,versionAnnot varchar(4000) ,versionBranchID integer NOT NULL,geometryRef integer NOT NULL REFERENCES vc_geometry(id),language clob NOT NULL)
CREATE TABLE vc_simcontext(id integer PRIMARY KEY,name varchar(255) NOT NULL,ownerRef integer NOT NULL REFERENCES vc_userinfo(id),privacy integer NOT NULL,versionPRef integer REFERENCES vc_simcontext(id),versionDate date NOT NULL,versionFlag integer NOT NULL,versionAnnot varchar(4000) ,versionBranchID integer NOT NULL,mathRef integer REFERENCES vc_math(id),modelRef integer NOT NULL REFERENCES vc_model(id),geometryRef integer NOT NULL REFERENCES vc_geometry(id),charSize number ,appComponentsLRG clob ,appComponentsSML varchar2(4000) )
CREATE TABLE vc_speciescontextspec(id integer PRIMARY KEY,specContextRef integer NOT NULL REFERENCES vc_modelsc(id),simContextRef integer NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,bEnableDif integer NOT NULL,bForceConst integer NOT NULL,bForceIndep integer NOT NULL,initCondExp varchar(2048) ,diffRateExp varchar(1024) NOT NULL,boundaryXmExp varchar(255) ,boundaryXpExp varchar(255) ,boundaryYmExp varchar(255) ,boundaryYpExp varchar(255) ,boundaryZmExp varchar(255) ,boundaryZpExp varchar(255) ,initCondCountExp varchar(1024) ,velocityXExp varchar(1024) ,velocityYExp varchar(1024) ,velocityZExp varchar(1024) ,bWellMixed integer ,bForceContinuous integer )
CREATE TABLE vc_structmapping(id integer PRIMARY KEY,subVolumeRef integer REFERENCES vc_subvolume(id),structRef integer NOT NULL REFERENCES vc_struct(id),simContextRef integer NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,bResolved integer NOT NULL,surfToVolExp varchar(1024) ,volFractExp varchar(1024) ,boundaryTypeXm varchar(10) ,boundaryTypeXp varchar(10) ,boundaryTypeYm varchar(10) ,boundaryTypeYp varchar(10) ,boundaryTypeZm varchar(10) ,boundaryTypeZp varchar(10) ,bCalculateV integer ,specificCap number ,initialV varchar(1024) ,sizeExp varchar(1024) ,volPerUnitAreaExp varchar(1024) ,volPerUnitVolExp varchar(1024) ,areaPerUnitAreaExp varchar(1024) ,areaPerUnitVolExp varchar(1024) ,surfaceClassRef integer REFERENCES vc_surfaceclass(id))
CREATE TABLE vc_reactionspec(id integer PRIMARY KEY,reactStepRef integer NOT NULL REFERENCES vc_reactstep(id),simContextRef integer NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,mapping integer NOT NULL)
CREATE TABLE vc_stimulus(id integer PRIMARY KEY,structRef integer NOT NULL REFERENCES vc_struct(id),simContextRef integer NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,name varchar(255) ,stimulusType integer NOT NULL,expression varchar2(4000) ,posX number NOT NULL,posY number NOT NULL,posZ number NOT NULL,params varchar2(4000) )
CREATE TABLE vc_analysistask(id integer PRIMARY KEY,simContextRef integer NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,analysisTaskXML clob NOT NULL,insertDate date NOT NULL)
CREATE TABLE vc_filament(id integer PRIMARY KEY,filamentName varchar(255) NOT NULL,geometryRef integer NOT NULL REFERENCES vc_geometry(id) ON DELETE CASCADE)
CREATE TABLE vc_curve(id integer PRIMARY KEY,curveData clob NOT NULL,filamentRef integer NOT NULL REFERENCES vc_filament(id) ON DELETE CASCADE)
CREATE TABLE vc_simulation(id integer PRIMARY KEY,name varchar(255) NOT NULL,ownerRef integer NOT NULL REFERENCES vc_userinfo(id),privacy integer NOT NULL,versionPRef integer REFERENCES vc_simulation(id),versionDate date NOT NULL,versionFlag integer NOT NULL,versionAnnot varchar(4000) ,versionBranchID integer NOT NULL,parentSimRef integer REFERENCES vc_simulation(id),mathRef integer NOT NULL REFERENCES vc_math(id),mathOverrides clob ,mathOverridesLRG clob ,mathOverridesSML varchar2(4000) ,taskDesc varchar2(4000) ,meshspecx integer ,meshspecy integer ,meshspecz integer ,dataProcInstr varchar2(4000) )
CREATE TABLE vc_simstat(id integer PRIMARY KEY,simRef integer NOT NULL REFERENCES vc_simulation(id) ON DELETE CASCADE,equiv number ,status varchar2(255) ,curatorEquiv integer ,comments varchar2(255) )
CREATE TABLE vc_biomodel(id integer PRIMARY KEY,name varchar(255) NOT NULL,ownerRef integer NOT NULL REFERENCES vc_userinfo(id),privacy integer NOT NULL,versionPRef integer REFERENCES vc_biomodel(id),versionDate date NOT NULL,versionFlag integer NOT NULL,versionAnnot varchar(4000) ,versionBranchID integer NOT NULL,modelRef integer NOT NULL REFERENCES vc_model(id),childSummaryLRG clob ,childSummarySML varchar2(4000) )
CREATE TABLE vc_biomodelsimcontext(id integer PRIMARY KEY,biomodelRef integer NOT NULL REFERENCES vc_biomodel(id) ON DELETE CASCADE,simContextRef integer NOT NULL REFERENCES vc_simcontext(id))
CREATE TABLE vc_biomodelsim(id integer PRIMARY KEY,biomodelRef integer NOT NULL REFERENCES vc_biomodel(id) ON DELETE CASCADE,simRef integer NOT NULL REFERENCES vc_simulation(id))
CREATE TABLE vc_mathmodel(id integer PRIMARY KEY,name varchar(255) NOT NULL,ownerRef integer NOT NULL REFERENCES vc_userinfo(id),privacy integer NOT NULL,versionPRef integer REFERENCES vc_mathmodel(id),versionDate date NOT NULL,versionFlag integer NOT NULL,versionAnnot varchar(4000) ,versionBranchID integer NOT NULL,mathRef integer NOT NULL REFERENCES vc_math(id),childSummaryLRG clob ,childSummarySML varchar2(4000) )
CREATE TABLE vc_mathmodelsim(id integer PRIMARY KEY,mathmodelRef integer NOT NULL REFERENCES vc_mathmodel(id) ON DELETE CASCADE,simRef integer NOT NULL REFERENCES vc_simulation(id))
CREATE TABLE vc_available(id integer PRIMARY KEY,insertDate date NOT NULL ,isAvailable varchar2(5) NOT NULL ,letUserAskForCallback varchar2(5) ,offlineMessage varchar2(512) )
CREATE TABLE vc_userstat(id integer PRIMARY KEY,userRef integer UNIQUE NOT NULL REFERENCES vc_userinfo(id) ON DELETE CASCADE,loginCount number ,lastLogin date ,emailLostPasswordOK varchar2(5) ,wantsOnlineCallback varchar2(5) ,userAgent varchar2(255) ,useMac number ,useWin number ,useLin number )
CREATE TABLE vc_userlog(id integer PRIMARY KEY,userRef integer NOT NULL REFERENCES vc_userinfo(id) ON DELETE CASCADE,eventDate date NOT NULL,logText varchar2(255) NOT NULL,filePath varchar2(255) ,eventType varchar2(10) NOT NULL,swVersion varchar2(10) ,ipAddress varchar2(40) )
CREATE TABLE vc_simcontextstat(id integer PRIMARY KEY,simContextRef integer NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,hasDupReact number ,hasData number ,equiv number ,status varchar2(255) ,oldMath clob ,newMath clob ,curatorEquiv integer ,comments varchar2(255) ,updatedMath integer )
CREATE TABLE vc_simcontextstat2(id integer PRIMARY KEY,simContextRef integer NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,hasData number ,equiv number ,status varchar2(255) ,curatorEquiv integer ,comments varchar2(255) ,equiv_4_8 number ,status_4_8 varchar2(255) )
CREATE TABLE stochtest(id integer PRIMARY KEY,simcontextref integer NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,biomodelref integer NOT NULL REFERENCES vc_biomodel(id) ON DELETE CASCADE,mathref integer NOT NULL REFERENCES vc_math(id) ON DELETE CASCADE,dimension integer NOT NULL,numcompartments integer ,mathtype varchar2(64) )
CREATE TABLE stochtestrun(id integer PRIMARY KEY,stochtestref integer NOT NULL REFERENCES stochtest(id) ON DELETE CASCADE,parentmathtype varchar2(64) NOT NULL,mathtype varchar2(64) NOT NULL,status varchar2(32) NOT NULL,errmsg varchar2(4000) ,conclusion varchar2(4000) ,exclude varchar2(4000) ,networkGenProbs varchar2(4000) )
CREATE TABLE stochtestcompare(id integer PRIMARY KEY,stochtestrunref1 integer NOT NULL REFERENCES stochtestrun(id) ON DELETE CASCADE,stochtestrunref2 integer NOT NULL REFERENCES stochtestrun(id) ON DELETE CASCADE,results varchar2(4000) ,status varchar2(32) ,errmsg varchar2(4000) ,conclusion varchar2(4000) ,smallest_pvalue number ,numexperiments integer ,numfail_95 integer ,numfail_99 integer ,numfail_999 integer )
CREATE TABLE vc_simulationjob(id integer PRIMARY KEY,simRef integer NOT NULL REFERENCES vc_simulation(id) ON DELETE CASCADE,submitDate date NOT NULL,taskID integer NOT NULL,schedulerStatus integer NOT NULL,statusMsg varchar(4000) ,queueDate date ,queuePriority integer ,queueID integer ,startDate date ,computeHost varchar(255) ,latestUpdateDate date NOT NULL,endDate date ,hasData char(1) ,serverID varchar(20) NOT NULL,jobIndex integer ,pbsJobID varchar(100) , CONSTRAINT sim_job_task_unique UNIQUE(simref,jobindex,taskid))
CREATE TABLE vc_biomodelxml(id integer PRIMARY KEY,biomodelRef integer UNIQUE NOT NULL REFERENCES vc_biomodel(id) ON DELETE CASCADE,bmxml clob NOT NULL,changeDate date NOT NULL)
CREATE TABLE vc_mathmodelxml(id integer PRIMARY KEY,mathmodelRef integer UNIQUE NOT NULL REFERENCES vc_mathmodel(id) ON DELETE CASCADE,mmxml clob NOT NULL,changeDate date NOT NULL)
CREATE TABLE vc_geometricregion(id integer PRIMARY KEY,name varchar(255) NOT NULL,regiontype integer NOT NULL,geometryRef integer NOT NULL REFERENCES vc_geometry(id) ON DELETE CASCADE,regionSize number NOT NULL,sizeUnit varchar(50) NOT NULL,volRegion1 integer REFERENCES vc_geometricregion(id) ON DELETE CASCADE,volRegion2 integer REFERENCES vc_geometricregion(id) ON DELETE CASCADE,regionID integer ,subvolumeRef integer REFERENCES vc_subvolume(id) ON DELETE CASCADE)
CREATE TABLE vc_surfacedesc(id integer PRIMARY KEY,geometryRef integer NOT NULL REFERENCES vc_geometry(id) ON DELETE CASCADE,sampleSizeX integer NOT NULL,sampleSizeY integer NOT NULL,sampleSizeZ integer NOT NULL,filterFreq number NOT NULL)
CREATE TABLE vc_userpref(id integer PRIMARY KEY,userRef integer NOT NULL REFERENCES vc_userinfo(id) ON DELETE CASCADE,userPrefKey varchar(128) NOT NULL,userPrefValue varchar(4000) NOT NULL)
CREATE TABLE vc_tftestsuite(id integer PRIMARY KEY,tsVersion varchar2(64) UNIQUE NOT NULL ,vcBuildVersion varchar2(64) NOT NULL,vcNumericsVersion varchar2(64) NOT NULL,creationDate date NOT NULL,changeDate date ,tsAnnotation varchar2(512) ,isLocked integer NOT NULL, CONSTRAINT ts_bld_num_unique UNIQUE(vcBuildVersion,vcNumericsVersion))
CREATE TABLE vc_tftestcase(id integer PRIMARY KEY,testSuiteRef integer NOT NULL REFERENCES vc_tftestsuite(id) ON DELETE CASCADE,mathModelRef integer REFERENCES vc_mathmodel(id),tcSolutionType varchar2(64) NOT NULL ,tcAnnotation varchar2(512) ,creationDate date NOT NULL,bmAppRef integer REFERENCES vc_biomodelsimcontext(id), CONSTRAINT tc_tsr_mm_bm_unq UNIQUE (testSuiteRef,mathModelRef,bmappref), CONSTRAINT tc_tsr_must_mmbm CHECK (not (mathmodelref is null and bmappref is null)  and  not (mathmodelref is not null and bmappref is not null)))
CREATE TABLE vc_tftestcriteria(id integer PRIMARY KEY,testCaseRef integer NOT NULL REFERENCES vc_tftestcase(id) ON DELETE CASCADE,simulationRef integer UNIQUE NOT NULL REFERENCES vc_simulation(id),simDataRef integer ,regressionSimRef integer REFERENCES vc_mathmodelsim(id),maxRelError number ,maxAbsError number ,regressionBMAPPRef integer REFERENCES vc_biomodelsimcontext(id),regressionBMSimRef integer REFERENCES vc_biomodelsim(id),reportStatus varchar2(32) ,reportMessage varchar2(512) , CONSTRAINT tcr_tcr_simr_unique UNIQUE(testCaseRef,simulationRef))
CREATE TABLE vc_tftestresult(id integer PRIMARY KEY,testCriteriaRef integer NOT NULL REFERENCES vc_tftestcriteria(id) ON DELETE CASCADE,varName varchar2(128) NOT NULL,absError number NOT NULL,relError number NOT NULL,maxRef number NOT NULL,minRef number NOT NULL,meanSqrError number NOT NULL,timeAbsError number NOT NULL,indexAbsError integer NOT NULL,timeRelError number NOT NULL,indexRelError integer NOT NULL, CONSTRAINT tres_tcr_vn_unique UNIQUE(testCriteriaRef,varName))
CREATE TABLE vc_softwareversion(id integer PRIMARY KEY,versionableRef integer UNIQUE NOT NULL,softwareVersion varchar2(64) NOT NULL)
CREATE TABLE vc_externaldata(id integer PRIMARY KEY,ownerRef integer NOT NULL REFERENCES vc_userinfo(id),externaldataname varchar(255) NOT NULL,annotation varchar(1024) , CONSTRAINT own_fdn_unique UNIQUE(ownerRef,externaldataname))
CREATE TABLE vc_mathdescextdata(id integer PRIMARY KEY,mathDescRef integer NOT NULL REFERENCES vc_math(id) ON DELETE CASCADE,extDataRef integer NOT NULL REFERENCES vc_externaldata(id), CONSTRAINT md_ed_unq UNIQUE (MATHDESCREF, EXTDATAREF))
CREATE TABLE vc_miriam(id integer PRIMARY KEY,bioModelRef integer REFERENCES vc_biomodel(id) ON DELETE CASCADE,speciesRef integer REFERENCES vc_species(id) ON DELETE CASCADE,structRef integer REFERENCES vc_struct(id) ON DELETE CASCADE,reactStepRef integer REFERENCES vc_reactstep(id) ON DELETE CASCADE,annotation varchar2(4000) ,userNotes varchar2(4000) , CONSTRAINT miriam_only_1 CHECK(DECODE(bioModelRef,NULL,0,bioModelRef,1)+DECODE(speciesRef,NULL,0,speciesRef,1)+DECODE(structRef,NULL,0,structRef,1)+DECODE(reactStepRef,NULL,0,reactStepRef,1) = 1), CONSTRAINT miriam_info_not_null CHECK(DECODE(annotation,NULL,0,structRef,1)+DECODE(userNotes,NULL,0,reactStepRef,1) > 0))
CREATE TABLE vc_apiclient(id integer PRIMARY KEY,clientname varchar(255) NOT NULL,clientId varchar(255) NOT NULL,clientSecret varchar(255) NOT NULL)
CREATE TABLE vc_apiaccesstoken(id integer PRIMARY KEY,accesstoken varchar2(4000) NOT NULL,clientRef integer NOT NULL REFERENCES vc_apiclient(id),userRef integer NOT NULL REFERENCES vc_userinfo(id),creationDate date NOT NULL,expireDate date NOT NULL,status varchar(20) )
CREATE TABLE vc_publication(id integer PRIMARY KEY,title varchar2(4000) ,authors varchar2(4000) ,year integer ,citation varchar2(4000) ,pubmedid varchar2(64) ,doi varchar2(128) ,endnoteid integer ,url varchar2(128) ,wittid integer ,pubDate date )
CREATE TABLE vc_publicationmodellink(id integer PRIMARY KEY,pubRef integer NOT NULL REFERENCES vc_publication(id) ON DELETE CASCADE,biomodelRef integer  REFERENCES vc_biomodel(id) ON DELETE CASCADE,mathmodelRef integer  REFERENCES vc_mathmodel(id) ON DELETE CASCADE)
CREATE TABLE vc_applicationmath(id integer PRIMARY KEY,simContextRef integer REFERENCES vc_simcontext(id) ON DELETE CASCADE,outputFuncLRG clob ,outputFuncSML varchar2(4000) ,mathModelRef integer REFERENCES vc_mathmodel(id) ON DELETE CASCADE, CONSTRAINT math_or_app CHECK(DECODE(simContextRef,NULL,0,simContextRef,1)+DECODE(mathModelRef,NULL,0,mathModelRef,1) = 1))
CREATE TABLE vc_datasymbol(id integer PRIMARY KEY,dataSymbolName varchar2(255) NOT NULL,dataSymbolType varchar2(32) NOT NULL,dataSymbolVCUnitDef varchar2(64) NOT NULL,simContextRef integer NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,fieldDataRef integer REFERENCES vc_externaldata(id),fieldDataVarName varchar2(255) ,fieldDataVarType varchar2(255) ,fieldDataVarTime number )
CREATE TABLE vc_globalmodelparam(id integer PRIMARY KEY,modelRef integer NOT NULL REFERENCES vc_model(id) ON DELETE CASCADE,xmlFragment varchar(4000) NOT NULL)
CREATE TABLE loadmodelstat(id integer PRIMARY KEY,bioModelRef integer REFERENCES vc_biomodel(id) ON DELETE CASCADE,mathModelRef integer REFERENCES vc_mathmodel(id) ON DELETE CASCADE,resultFlag integer ,errorMessage varchar2(255) ,timeStamp varchar2(32) NOT NULL,loadTime integer ,softwareVers varchar2(32) NOT NULL,loadOriginalXMLTime integer ,loadUnresolvedTime integer ,bSameCachedAndNotCachedXML integer ,bSameCachedAndNotCachedObj integer ,bSameSelfXMLCachedRoundtrip integer ,bSameCachedAndNotCachedXMLExc varchar2(255) ,bSameCachedAndNotCachedObjExc varchar2(255) ,bSameSelfXMLCachedRoundtripExc varchar2(255) ,bIssuesErrors varchar2(255) , CONSTRAINT ldmdlstat_only_1 CHECK(DECODE(bioModelRef,NULL,0,bioModelRef,1)+DECODE(mathModelRef,NULL,0,mathModelRef,1) = 1))
CREATE TABLE vc_userlogininfo(id integer PRIMARY KEY,userRef integer NOT NULL REFERENCES vc_userinfo(id) ON DELETE CASCADE,loginCount number NOT NULL,lastLogin date NOT NULL,osarch varchar2(32) NOT NULL,osname varchar2(32) NOT NULL,osvers varchar2(32) NOT NULL,clientVers varchar2(32) NOT NULL,serverVers varchar2(32) NOT NULL,javavers varchar2(32) NOT NULL, CONSTRAINT ulinfo_unique UNIQUE(userRef,osarch,osname,osvers,clientVers,serverVers,javavers))
CREATE TABLE vc_metadata(id integer PRIMARY KEY,bioModelRef integer NOT NULL REFERENCES vc_biomodel(id) ON DELETE CASCADE,vcMetaDataLarge clob ,vcMetaDataSmall varchar2(4000) )
CREATE TABLE vc_simdelfromdisk(deldate varchar2(20) ,userid varchar2(255) NOT NULL,userkey integer ,simid integer ,simpref integer ,simdate varchar2(20) ,simname varchar2(255) NOT NULL,status varchar(10) ,numfiles integer ,totalsize integer )
CREATE SEQUENCE newSeq
