# Guide to contributing to the Virtual Cell

We believe - and we hope you do too - that learning how to code, how to think, and how to contribute to open source can delegate the next generation of coders and creators. We exuberantly welcome contributions to Virtual Cell! This document describes how developers can contribute to the Virtual Cell. Modelers can contribute new models to VCell via multi-platform standalone application downloading from http://vcell.org.

If you have never contributed to an open-source project before and you’re just getting started, consider exploring these resources.

[A Step by Step Guide to Making Your First GitHub Contribution](https://codeburst.io/a-step-by-step-guide-to-making-your-first-github-contribution-5302260a2940)

[How to Contribute to Open Source](https://opensource.guide/how-to-contribute/)


To get some insights about Github terminologies, consider exploring these resources.

[Collaborating With Issues And Pull Requests](https://help.github.com/categories/collaborating-with-issues-and-pull-requests/)


If you are still facing some issues while contributing to the repository, please reach us on [VCell Support](mailto:vcell_support@uchc.edu).

**Note** : Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.


## Coordinating contributions, Issues, and bugs

Before getting started, please contact the lead developers at [vcell_support@uchc.edu](mailto:vcell_support@uchc.edu) to coordinate your planned contributions with other ongoing efforts. VCell Support is open at all junctures, emails about issues, bugs, and enhancements. 

## Setting up your development environment

To contribute to Virtual Cell, please follow README.MD file instructions to the setup development environment. 

## Submitting changes

Please use GitHub pull requests to submit changes. Each submission should include a brief description of the new and/or modified features upon each pull request. Pull requests will be approved after the review by one of the developers.


