% THIS FUNCTION IS PRIVATE AND SHOULD NOT BE CALLED BY OUTSIDE CODE!
%
function [sm] = ChkConn( sm )

    if( sm.in_chkconn )
        return;
    end

    sm.in_chkconn = 1;

    if( sm.handle == -1 )

        sm.handle = CalinsNetMex( 'create', sm.host, sm.port );

        if( isempty( CalinsNetMex( 'connect', sm.handle ) ) )
            error( 'ChkConn: Unable to connect to server.' );
        end

        sm.ver = DoQuery( sm, 'GETVERSION' );

    else

        ok = CalinsNetMex( 'sendstring', sm.handle, sprintf( 'NOOP\n' ) );

        if( isempty( ok ) || isempty( CalinsNetMex( 'readline', sm.handle ) ) )

            if( isempty( CalinsNetMex( 'connect', sm.handle ) ) )
                error( 'ChkConn: Still unable to connect to server.' );
            end
        end
    end

    sm.in_chkconn = 0;
end
