[![DOI](https://zenodo.org/badge/429406115.svg)](https://zenodo.org/badge/latestdoi/429406115)

# Neuropixels trajectory explorer
Neuropixels trajectory explorer with the Allen CCF mouse atlas 

There is also a Waxholm rat atlas version available, though this is not actively maintained.

The program does not require any specific software. It was written and can be run from MATLAB, but included is a standalone version that does not require MATLAB to run.

**Features:**
  * Plan trajectories to target brain regions with one or more Neuropixels probes
  * Interface with New Scale manipulators to have a live visual of trajectories and recorded areas during an experiment
  * Display brain regions alongside data during recording (in Open Ephys or SpikeGLX)

**For a demo, see [this video](https://www.youtube.com/watch?v=54VHDqzowwY&ab_channel=MatteoCarandini) (part of the [2023 UCL Neuropixels Course](https://www.ucl.ac.uk/neuropixels/training/2023-neuropixels-course))**


**For instructions, see the [Wiki](https://github.com/petersaj/neuropixels_trajectory_explorer/wiki)**

**Updates and issues:**
  * **Regularly pull new code:** try to use up-to-date code whenever possible, there are sometimes critical fixes/updates
  * Major changes are logged on the [Wiki change log page](https://github.com/petersaj/neuropixels_trajectory_explorer/wiki/Major-change-log)
  * Issues/bugs/suggestions: please open a github issue by clicking on the 'Issues' tab above and pressing the green 'New issue' button
  * Planned updates are marked as "future upgrades" on the issues page (https://github.com/petersaj/neuropixels_trajectory_explorer/issues). If you would like to be notified when a planned update is completed, click into the issue page for that update and hit "subscribe" in the lower right-hand corner

![](https://github.com/petersaj/neuropixels_trajectory_explorer/blob/main/wiki/front_image.png)
