# Study: Garden path sentences w/ vs. w/o context (machine data)
# Ela Ulakci & Markus Huff
# 
# last mod: 2024-03-22 mh
# 
# Robstness check with "recognizable" (instead of "memorable")
# 
# Set working directory
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))

# Load packages
pacman::p_load(tidyverse,ez,lme4,car,sjPlot,ggpubr,rstatix,stringi,epitools,car)

# Load data
dat_recog <- read_csv("output_recognizability.csv")


dat_recog <- 
  dat_recog %>%
  select(Trial, Prompt_recognizability,value_recognizability)

dat_template <- read_csv("dat_recognizability.csv")
dat_template$value_recognizability <- as.character(dat_template$value_recognizability)

dat_template <- 
  dat_template %>%
  select(ID, Condition, Trial, Prompt_recognizability)

head(dat_recog)
head(dat_template)

dat <- left_join(dat_template, dat_recog)

dat$value_recognizability <- str_remove(dat$value_recognizability,
                                        "Sentence 1")
dat$value_recognizability <- str_remove(dat$value_recognizability,
                                        "Sentence 2")
dat$value_recognizability <- str_remove(dat$value_recognizability,
                                        "from 1")

dat$value_recognizability <- extract_numeric(dat$value_recognizability)
dat$value_recognizability <- as.numeric(dat$value_recognizability)
summary(dat$value_recognizability)

dat %>%
  filter(value_recognizability < 1)

dat %>%
  filter(value_recognizability > 10)


# First checks on the data

dat %>%
  group_by(Condition) %>%
  count()

# Plots

dat %>%
  select(ID, Condition, value_recognizability) %>%
  filter(value_recognizability > 0) %>%
  group_by(Condition) %>%
  mutate(value_recognizability = jitter(value_recognizability, amount = .5)) %>%
  ggboxplot(x = "Condition", y = "value_recognizability") +
  ylab("Recognizability")

# Models

m1 <- lmer(value_recognizability ~ Condition + (1 | ID), dat)
Anova(m1)
tab_model(m1)
