# Study: Garden path sentences w/ vs. w/o context (machine data)
# Ela Ulakci & Markus Huff
# 
# last mod: 2024-03-22 mh
# 
# Robstness check with "linked" (instead of "related")
# 
# Set working directory
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))

# Load packages
pacman::p_load(tidyverse,ez,lme4,car,sjPlot,ggpubr,rstatix,stringi,epitools,car)

# Load data
dat_linked <- read_csv("output_linked.csv")


dat_linked <- 
  dat_linked %>%
  select(Trial, Prompt_linked,value_linked)

dat_template <- read_csv("input_structure.csv")

dat_template <- 
  dat_template %>%
  select(ID, Condition, Trial, Prompt_linked)

head(dat_recog)
head(dat_template)

dat <- left_join(dat_template, dat_linked)

dat$value_linked <- str_remove_all(dat$value_linked,
                                        "Sentence 1")
dat$value_linked <- str_remove_all(dat$value_linked,
                                        "Sentence 2")
dat$value_linked <- str_remove_all(dat$value_linked,
                                        "out of 10")

dat$value_linked <- extract_numeric(dat$value_linked)
dat$value_linked <- as.numeric(dat$value_linked)
summary(dat$value_linked)

dat %>%
  filter(value_recognizability < 1)

dat %>%
  filter(value_recognizability > 10)


# First checks on the data

dat %>%
  group_by(Condition) %>%
  count()

# Descriptives

dat %>%
  group_by(Condition) %>%
  summarize(mean_linked = mean(value_linked, na.rm = T),
            sd_linked = sd(value_linked, na.rm = T))

# Plots

dat %>%
  select(ID, Condition, value_linked) %>%
  filter(value_linked > 0) %>%
  group_by(Condition) %>%
  mutate(value_linked = jitter(value_linked, amount = .5)) %>%
  ggboxplot(x = "Condition", y = "value_linked") +
  ylab("Linked")

# Models

m1 <- lmer(value_linked ~ Condition + (1 | ID), dat)
Anova(m1)
tab_model(m1)

