# funspace - Creating and representing functional trait spaces

---

Estimation of functional spaces based on traits of organisms. The package includes functions to impute missing trait values (with or without considering phylogenetic information), and to create, represent and analyse two dimensional functional spaces based on principal components analysis, other ordination methods, or raw traits. It also allows for mapping a third variable onto the functional space.

## Description of the Data and file structure

We provide the package as a .tar file (filename: funspace_0.1.1.tar). Once the package has been downloaded, it can be directly uploaded in R from Packages >> Install >> Install from >> Package Archive File (.zip, .tar.gz). All the functions and example datasets included in funspace and that are necessary to reproduce the worked example in the paper will be automatically uploaded. Functions and example datasets can be then accessed using the standard syntax funspace:

Detailed descriptions of each function and dataset are also available at: [https://cran.r-project.org/web/packages/funspace/funspace.pdf](https://cran.r-project.org/web/packages/funspace/funspace.pdf)

Data files description

*Note: the following data files will be automatically uploaded when loading funspace in R*.

## 1 - GSPFF\_subset.csv

It contains species-specific trait data for > 2000 species for those traits defining the global spectrum of plant form and function (GSPFF, Díaz et al. Nature, 529, 167–171). The species list is a random subset obtained from Carmona et al. (2021, Nature 597, 683–687).

The file includes:

#### 1.1. - Taxonomic information

Species: species binomial according to the Plant List v.1.1.

#### 1.2. - Species-specific information for leaf and plant traits defining the global spectrum of plant form and function. These are:

la (mm2): individual size of a leaf. Area of a leaf in the one-sided projection.\
ln (mg g-1): leaf notrogen content on a mass basis. Ratio of the quantity of nitrogen in the leaf per respective unit dry mass.\
ph (m): maximum plant height. Maximum height of a whole plant.\
sla (mm2 mg-1): specific leaf area. Ratio of the area of a leaf to its dry mass.\
ssd (mg mm-3): stem specific density. Ratio of the mass of the stem after drying to its volume assessed without drying\
sm (mg): seed mass. Mass of a seed assessed after drying.

Missing data code: NA

## 2 - GSPFF\_missing\_subset.csv

It contains species-specific trait data for > 10,000 species for those traits defining the global spectrum of plant form and function (GSPFF, Díaz et al. Nature, 529, 167–171). The species list is a random subset obtained from Carmona et al. (2021, Nature 597, 683–687). This datasets contains missing values (NAs) and it is necessary to reproduce the data imputation procedure presented in the main text.

The file includes:

#### 2.1. - Taxonomic information

Species: species binomial according to the Plant List v.1.1.

#### 2.2. - Species-specific information for leaf and plant traits defining the global spectrum of plant form and function. These are:

la (mm2): individual size of a leaf. Area of a leaf in the one-sided projection.\
ln (mg g-1): leaf notrogen content on a mass basis. Ratio of the quantity of nitrogen in the leaf per respective unit dry mass.\
ph (m): maximum plant height. Maximum height of a whole plant.\
sla (mm2 mg-1): specific leaf area. Ratio of the area of a leaf to its dry mass.\
ssd (mg mm-3): stem specific density. Ratio of the mass of the stem after drying to its volume assessed without drying\
sm (mg): seed mass. Mass of a seed assessed after drying.

Missing data code: NA

## 3 - GSPFF\_missing\_tax.csv

It contains taxonomic information for the species in 'GSPFF_missing_subset.csv'. This dataset is necessary for reproducing Fig. 3 in the main text (see Boxes in the main text).

The file contains:

#### 3.1. - Taxonomic information

Species: species binomial according to the Plant List v.1.1.\
genus: the genus to which each species belongs.\
family: the family to which each species belongs.\
order: the order to which each species belongs.

## 4 - GSPFF\_missing\_phylo.tree

It contains the phylogenetic tree for the >10,000 species included in 'GSPFF_missing_subset.csv', and it is necessary to reproduce the data imputation procedure presented in the main text.

It can be loaded in R using the code ape::read.tree().

## Sharing/access Information

funspace R package is also available in CRAN: [https://cran.r-project.org/package=funspace](https://cran.r-project.org/package=funspace)

funspace can be also installed as follows:

1 - Packages >> Install >> Install from >> Repository (CRAN)

2 - By executing the code install.packages('funspace') in the R console followed by library(funspace) to upload the package.
