import tempfile
from unittest import TestCase

import tests.saved_test_data
from aspire.apple.apple import Apple
from aspire.utils import importlib_path


class ApplePickerTestCase(TestCase):
    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testPickCenters(self):
        # 487 particles with the following centers
        centers = {
            (149, 621),
            (151, 3887),
            (153, 735),
            (157, 1299),
            (159, 1001),
            (163, 1685),
            (215, 2717),
            (223, 3245),
            (235, 3887),
            (237, 735),
            (239, 2367),
            (241, 2193),
            (245, 181),
            (247, 321),
            (255, 2601),
            (257, 1925),
            (261, 1367),
            (281, 3079),
            (295, 1455),
            (305, 883),
            (319, 2471),
            (325, 3677),
            (331, 1721),
            (343, 3381),
            (345, 1253),
            (353, 1855),
            (355, 1885),
            (355, 3621),
            (365, 1123),
            (371, 957),
            (379, 3471),
            (387, 2929),
            (391, 365),
            (391, 1577),
            (393, 2591),
            (407, 767),
            (437, 2427),
            (437, 3097),
            (445, 2005),
            (455, 257),
            (457, 725),
            (465, 689),
            (477, 1137),
            (479, 3267),
            (483, 2887),
            (487, 1461),
            (495, 3461),
            (505, 3613),
            (517, 3325),
            (523, 1957),
            (525, 3769),
            (531, 3151),
            (533, 2605),
            (535, 1289),
            (535, 2889),
            (543, 615),
            (545, 1037),
            (547, 2053),
            (549, 2427),
            (555, 227),
            (581, 3553),
            (593, 1647),
            (601, 2943),
            (605, 1435),
            (661, 2547),
            (667, 2389),
            (673, 3701),
            (689, 3105),
            (693, 739),
            (697, 2633),
            (699, 3609),
            (715, 189),
            (717, 3073),
            (717, 3199),
            (725, 3489),
            (727, 1191),
            (745, 2477),
            (747, 583),
            (747, 3297),
            (755, 1773),
            (783, 3777),
            (785, 509),
            (787, 1589),
            (807, 2033),
            (813, 2333),
            (815, 2615),
            (827, 2997),
            (827, 3401),
            (847, 2879),
            (851, 3083),
            (859, 1241),
            (859, 1945),
            (859, 3255),
            (863, 1837),
            (873, 377),
            (885, 2017),
            (889, 669),
            (897, 2643),
            (909, 2139),
            (909, 2829),
            (911, 1851),
            (925, 493),
            (925, 3507),
            (933, 1849),
            (935, 1401),
            (939, 333),
            (953, 2895),
            (953, 3061),
            (963, 889),
            (965, 2305),
            (983, 1749),
            (985, 1859),
            (987, 709),
            (991, 1535),
            (995, 3197),
            (1007, 1659),
            (1007, 2167),
            (1015, 2363),
            (1023, 209),
            (1025, 1073),
            (1025, 3625),
            (1033, 2973),
            (1049, 1239),
            (1075, 2871),
            (1075, 3317),
            (1087, 2759),
            (1087, 3503),
            (1111, 2497),
            (1115, 1605),
            (1115, 1687),
            (1127, 3697),
            (1139, 927),
            (1143, 2513),
            (1165, 1003),
            (1167, 841),
            (1169, 3797),
            (1191, 3389),
            (1195, 653),
            (1209, 779),
            (1217, 3149),
            (1227, 2519),
            (1235, 941),
            (1235, 1571),
            (1235, 2137),
            (1237, 3297),
            (1243, 1979),
            (1245, 2381),
            (1249, 451),
            (1249, 2823),
            (1251, 3037),
            (1257, 2275),
            (1265, 149),
            (1267, 1335),
            (1287, 221),
            (1321, 361),
            (1327, 1689),
            (1347, 3311),
            (1359, 2351),
            (1361, 1111),
            (1361, 1521),
            (1367, 2551),
            (1369, 2845),
            (1369, 3603),
            (1371, 3055),
            (1379, 813),
            (1387, 1965),
            (1423, 613),
            (1431, 1761),
            (1441, 983),
            (1449, 2203),
            (1457, 225),
            (1463, 1139),
            (1467, 2915),
            (1469, 1547),
            (1479, 1367),
            (1481, 3091),
            (1495, 2739),
            (1497, 3311),
            (1507, 531),
            (1509, 849),
            (1511, 1721),
            (1513, 3787),
            (1525, 737),
            (1531, 2387),
            (1535, 2853),
            (1547, 1649),
            (1551, 1953),
            (1553, 949),
            (1565, 3569),
            (1581, 3575),
            (1583, 2975),
            (1587, 929),
            (1605, 2461),
            (1623, 781),
            (1643, 609),
            (1647, 273),
            (1651, 1545),
            (1651, 2455),
            (1655, 2443),
            (1657, 2389),
            (1663, 1961),
            (1689, 817),
            (1693, 1255),
            (1703, 885),
            (1707, 3405),
            (1709, 361),
            (1715, 165),
            (1739, 2757),
            (1741, 375),
            (1741, 1391),
            (1757, 1099),
            (1767, 2507),
            (1767, 2633),
            (1795, 679),
            (1795, 1283),
            (1805, 2133),
            (1805, 3423),
            (1809, 2281),
            (1815, 2793),
            (1821, 863),
            (1823, 295),
            (1861, 2649),
            (1875, 3387),
            (1887, 2599),
            (1895, 3385),
            (1905, 861),
            (1905, 1029),
            (1909, 1305),
            (1911, 1937),
            (1917, 2829),
            (1917, 3527),
            (1941, 3297),
            (1941, 3341),
            (1943, 3053),
            (1953, 367),
            (1953, 1557),
            (1955, 1823),
            (1961, 2677),
            (1965, 2397),
            (1969, 3535),
            (1987, 1693),
            (1989, 919),
            (1993, 551),
            (1997, 2605),
            (2011, 3561),
            (2023, 2833),
            (2025, 1167),
            (2033, 3703),
            (2037, 3281),
            (2037, 3705),
            (2047, 783),
            (2051, 2999),
            (2055, 3857),
            (2081, 667),
            (2097, 965),
            (2111, 1049),
            (2113, 2289),
            (2117, 1079),
            (2131, 3587),
            (2133, 1657),
            (2141, 2491),
            (2149, 2735),
            (2159, 3247),
            (2167, 247),
            (2177, 821),
            (2179, 3037),
            (2187, 1339),
            (2201, 729),
            (2215, 1747),
            (2241, 2253),
            (2241, 3907),
            (2245, 2329),
            (2245, 2467),
            (2269, 1327),
            (2271, 935),
            (2281, 1541),
            (2287, 3335),
            (2297, 3167),
            (2299, 3055),
            (2303, 263),
            (2327, 3475),
            (2329, 3085),
            (2337, 759),
            (2357, 2871),
            (2359, 1859),
            (2377, 2679),
            (2383, 1427),
            (2389, 3125),
            (2389, 3507),
            (2401, 871),
            (2403, 3623),
            (2411, 507),
            (2417, 2563),
            (2421, 699),
            (2429, 2173),
            (2453, 307),
            (2463, 1437),
            (2469, 3051),
            (2473, 909),
            (2487, 1873),
            (2501, 3493),
            (2505, 2477),
            (2507, 2619),
            (2519, 1977),
            (2527, 1999),
            (2529, 1489),
            (2529, 2007),
            (2537, 201),
            (2547, 1273),
            (2565, 3041),
            (2585, 1869),
            (2593, 621),
            (2615, 2575),
            (2621, 1065),
            (2623, 1909),
            (2625, 485),
            (2637, 173),
            (2637, 1597),
            (2643, 491),
            (2649, 1427),
            (2653, 983),
            (2653, 1597),
            (2655, 2051),
            (2655, 3481),
            (2659, 3723),
            (2665, 3855),
            (2667, 1605),
            (2671, 831),
            (2679, 2751),
            (2687, 649),
            (2693, 2587),
            (2695, 1631),
            (2697, 667),
            (2701, 533),
            (2701, 3553),
            (2703, 1737),
            (2709, 2365),
            (2721, 1187),
            (2729, 3335),
            (2733, 2209),
            (2741, 2207),
            (2747, 2821),
            (2755, 1451),
            (2765, 1729),
            (2769, 2719),
            (2769, 3407),
            (2779, 3061),
            (2789, 2779),
            (2791, 693),
            (2793, 1239),
            (2795, 3699),
            (2825, 1903),
            (2829, 3755),
            (2831, 2011),
            (2835, 2219),
            (2849, 3883),
            (2879, 433),
            (2899, 1081),
            (2921, 2261),
            (2935, 2587),
            (2937, 867),
            (2959, 1267),
            (2961, 1473),
            (2969, 643),
            (2973, 3093),
            (2975, 963),
            (2977, 2255),
            (2977, 3147),
            (2997, 3771),
            (3009, 3501),
            (3029, 1609),
            (3037, 1089),
            (3055, 239),
            (3061, 3739),
            (3063, 807),
            (3075, 2871),
            (3077, 1807),
            (3079, 3439),
            (3085, 1461),
            (3087, 503),
            (3093, 2329),
            (3109, 3341),
            (3115, 687),
            (3123, 1265),
            (3125, 851),
            (3129, 285),
            (3131, 355),
            (3131, 2941),
            (3159, 3761),
            (3165, 1403),
            (3169, 1071),
            (3185, 627),
            (3185, 2113),
            (3199, 959),
            (3211, 405),
            (3215, 3505),
            (3219, 709),
            (3223, 3297),
            (3229, 539),
            (3241, 1141),
            (3249, 1889),
            (3251, 2703),
            (3267, 1237),
            (3271, 2591),
            (3285, 1777),
            (3287, 1675),
            (3287, 2099),
            (3321, 547),
            (3321, 2833),
            (3331, 3485),
            (3337, 3313),
            (3341, 2603),
            (3351, 3393),
            (3363, 2387),
            (3365, 3215),
            (3365, 3465),
            (3367, 1755),
            (3367, 2281),
            (3369, 405),
            (3377, 3209),
            (3381, 2533),
            (3389, 723),
            (3393, 915),
            (3399, 2143),
            (3413, 1841),
            (3425, 2485),
            (3435, 1071),
            (3437, 3577),
            (3441, 1535),
            (3441, 2683),
            (3445, 1825),
            (3447, 587),
            (3463, 821),
            (3469, 1493),
            (3471, 703),
            (3473, 2509),
            (3477, 1987),
            (3483, 1847),
            (3485, 3909),
            (3487, 1455),
            (3491, 2185),
            (3499, 621),
            (3509, 2907),
            (3529, 2843),
            (3537, 2295),
            (3559, 1233),
            (3559, 1581),
            (3569, 1457),
            (3573, 863),
            (3575, 2453),
            (3579, 1729),
            (3581, 2733),
            (3583, 2115),
            (3587, 993),
            (3591, 3533),
            (3591, 3653),
            (3613, 2051),
            (3653, 2847),
            (3657, 2239),
            (3677, 1031),
            (3677, 1115),
            (3677, 1337),
            (3693, 1231),
            (3695, 1639),
            (3709, 2993),
            (3729, 1467),
            (3735, 2253),
            (3755, 3401),
            (3763, 3583),
            (3781, 2341),
            (3783, 3089),
            (3807, 1549),
            (3809, 1191),
            (3819, 3711),
            (3823, 2679),
            (3829, 2807),
            (3843, 1429),
            (3847, 1959),
            (3877, 3063),
            (3899, 1647),
            (3901, 3227),
            (3907, 1485),
            (3909, 2347),
            (3919, 2633),
            (3921, 2415),
            (3933, 2957),
            (3943, 3577),
        }

        with tempfile.TemporaryDirectory() as tmpdir_name:
            apple_picker = Apple(
                particle_size=78,
                min_particle_size=19,
                max_particle_size=156,
                minimum_overlap_amount=7,
                tau1=729,
                tau2=7292,
                output_dir=tmpdir_name,
            )
            with importlib_path(tests.saved_test_data, "sample.mrc") as mrc_path:
                centers_found = apple_picker.process_micrograph_centers(mrc_path)
                for center_found in centers_found:
                    _x, _y = tuple(center_found)
                    if (_x, _y) not in centers:
                        self.fail("({}, {}) not an expected center.".format(_x, _y))
                    else:
                        centers.remove((_x, _y))

                if centers:
                    self.fail("Not all expected centers were found!")

    def testEmptyCenters(self):
        """
        Test we handle case were no centers are found.
        """
        with tempfile.TemporaryDirectory() as tmpdir_name:
            apple_picker = Apple(
                particle_size=78,
                min_particle_size=90,
                max_particle_size=90,
                output_dir=tmpdir_name,
            )

            with importlib_path(tests.saved_test_data, "sample.mrc") as mrc_path:
                centers_found = apple_picker.process_micrograph_centers(mrc_path)

        self.assertTrue(len(centers_found) == 0)
