# dataset registry for ASPIRE example data.
registry = {
    "emdb_2660.map": "49aecfd4efce09afc937d1786bbed6f18c2a353c73a4e16a643a304342d0660e",
    "emdb_8012.map": "85a1c9ab958b1dd051d011515212d58decaf2537351b9c016acd3e5852e30d63",
    "emdb_2984.map": "0194f44cb28f2a8daa5d477d25852de9cc81ed093487de181ee4b30b0d77ef90",
    "emdb_8511.map": "1f03ec4a0cadb407b6b972c803ffe1e97ff5087d4c2ce9fec2c404747a7fb3fe",
    "emdb_3645.map": "a574dba9657d44665b87f368f7379e97b1a33fe6ac2540478a3707f5ea840f12",
    "emdb_4905.map": "fe9ce303b43b11ccf253c8786b339cea3273ef70ff49dd6099155d576181f3c2",
    "emdb_10835.map": "dec12cdda4c36253a15f6f8105416020855bd51eb860ac5eb04b37b000ac9156",
    "emdb_5778.map": "877cbe37b86561c3dfb255aa2308fefcdd8f51f91928b17c2ef5c8dd3afaaef7",
    "emdb_6287.map": "81463aa6d024c80efcd19aa9b5ac58f3b3464af56e1ef0f104bd25071acc9204",
    "emdb_2824.map": "7682e1ef6e5bc9f2de9edcf824a03e454ef9cb1ca33bc12920633559f7f826e4",
    "emdb_14621.map": "b45774245c2bd5e1a44e801b8fb1705a44d5850631838d060294be42e34a6900",
    "emdb_2484.map": "6a324e23352bea101c191d5e854026162a5a9b0b8fc73ac5a085cc22038e1999",
    "emdb_6458.map": "645208af6d36bbd3d172c549e58d387b81142fd320e064bc66105be0eae540d1",
    "simulated_channelspin.npz": "c0752674acb85417f6a77a28ac55280c1926c73fda9e25ce0a9940728b1dfcc8",
}

registry_urls = {
    "emdb_2660.map": "https://ftp.ebi.ac.uk/pub/databases/emdb/structures/EMD-2660/map/emd_2660.map.gz",
    "emdb_8012.map": "https://ftp.ebi.ac.uk/pub/databases/emdb/structures/EMD-8012/map/emd_8012.map.gz",
    "emdb_2984.map": "https://ftp.ebi.ac.uk/pub/databases/emdb/structures/EMD-2984/map/emd_2984.map.gz",
    "emdb_8511.map": "https://ftp.ebi.ac.uk/pub/databases/emdb/structures/EMD-8511/map/emd_8511.map.gz",
    "emdb_3645.map": "https://ftp.ebi.ac.uk/pub/databases/emdb/structures/EMD-3645/map/emd_3645.map.gz",
    "emdb_4905.map": "https://ftp.ebi.ac.uk/pub/databases/emdb/structures/EMD-4905/map/emd_4905.map.gz",
    "emdb_10835.map": "https://ftp.ebi.ac.uk/pub/databases/emdb/structures/EMD-10835/map/emd_10835.map.gz",
    "emdb_5778.map": "https://ftp.ebi.ac.uk/pub/databases/emdb/structures/EMD-5778/map/emd_5778.map.gz",
    "emdb_6287.map": "https://ftp.ebi.ac.uk/pub/databases/emdb/structures/EMD-6287/map/emd_6287.map.gz",
    "emdb_2824.map": "https://ftp.ebi.ac.uk/pub/databases/emdb/structures/EMD-2824/map/emd_2824.map.gz",
    "emdb_14621.map": "https://ftp.ebi.ac.uk/pub/databases/emdb/structures/EMD-14621/map/emd_14621.map.gz",
    "emdb_2484.map": "https://ftp.ebi.ac.uk/pub/databases/emdb/structures/EMD-2484/map/emd_2484.map.gz",
    "emdb_6458.map": "https://ftp.ebi.ac.uk/pub/databases/emdb/structures/EMD-6458/map/emd_6458.map.gz",
    "simulated_channelspin.npz": "https://zenodo.org/records/8186548/files/example_FakeKV_dataset.npz",
}

file_to_method_map = {
    "emdb_2660.map": "emdb_2660",
    "emdb_8012.map": "emdb_8012",
    "emdb_2984.map": "emdb_2984",
    "emdb_8511.map": "emdb_8511",
    "emdb_3645.map": "emdb_3645",
    "emdb_4905.map": "emdb_4905",
    "emdb_10835.map": "emdb_10835",
    "emdb_5778.map": "emdb_5778",
    "emdb_6287.map": "emdb_6287",
    "emdb_2824.map": "emdb_2824",
    "emdb_14621.map": "emdb_14621",
    "emdb_2484.map": "emdb_2484",
    "emdb_6458.map": "emdb_6458",
    "simulated_channelspin.npz": "simulated_channelspin",
}
