temps <- c(278.0, 287.0, 295.0, 303.0, 312.0, 321.0, 329.0, 338.0, 346.0, 355.0, 365.0, 375.0, 385.0, 396.0, 406.0,
           416.0, 427.0, 437.0, 448.0, 459.0, 470.0, 482.0, 493.0, 505.0, 517.0, 528.0, 539.0, 551.0, 562.0, 573.0,
           584.0, 595.0)

ifile1 <- read.table("result.txt")
ifile2 <- read.table("result_delayed.txt")


png("chignolin1.png", height=21, width=16, units='cm', res=600, pointsize=6)
for(i in 1:16) {
  if(i == 1) {
    par(fig=c(0,0.5,0.8,1))
  } else if(i <= 8) {
    par(fig=c(0,0.5,0.8-0.09*(i-1),1-0.09*(i-1)), new=T)
  } else {
    par(fig=c(0.5,1,1.52-0.09*(i-1),1.72-0.09*(i-1)), new=T)
  }
  if(i==8 | i == 16) {
    plot(ifile2[,1]/100+100, ifile2[,i+1], type="p", pch=20, xlim=c(0,1000), ylim=c(0,50), axes=F,
         xlab="time (ns)", ylab="free energy (kJ/mol)", col="red")
    box()
    axis(1, col="blue", col.axis="blue", at=0:10*100)
  } else if (i==1 | i == 9) {
    plot(ifile2[,1]/100+100, ifile2[,i+1], type="p", pch=20, xlim=c(0,1000), ylim=c(0,50), axes=F,
         xlab="", ylab="", col="red")
    box()
    axis(3, col="red", col.axis="red", at=1:10*100, labels=0:9*100)
  } else {
    if(i%%2==0) {
      plot(ifile2[,1]/100+100, ifile2[,i+1], type="p", pch=20, xlim=c(0,1000), ylim=c(0,50), axes=F,
           xlab="", ylab="free energy (kJ/mol)", col="red")
      box()
    } else {
      plot(ifile2[,1]/100+100, ifile2[,i+1], type="p", pch=20, xlim=c(0,1000), ylim=c(0,50), axes=F,
           xlab="", ylab="", col="red")
      box()
    }
  }
  axis(2, at=0:6*10)
  for(j in 1:9) {
    lines(c(ifile2[j,1]/100, ifile2[j,1]/100)+100, c(ifile2[j,i+1]+ifile2[j,i+33],ifile2[j,i+1]-ifile2[j,i+65]), col="red")
    lines(c(ifile2[j,1]/100+92, ifile2[j,1]/100+108), c(ifile2[j,i+1]+ifile2[j,i+33],ifile2[j,i+1]+ifile2[j,i+33]), col="red")
    lines(c(ifile2[j,1]/100+92, ifile2[j,1]/100+108), c(ifile2[j,i+1]-ifile2[j,i+65],ifile2[j,i+1]-ifile2[j,i+65]), col="red")
  }
  lines(ifile2[,1]/100+100, ifile2[,i+1], col="red")
  text(2:10*100-25, rep(40,10), ifile2[1:10,97+i], col="red", cex=0.8)
  text(2:10*100,    rep(40,10), "/", cex=0.8, col="red")
  text(2:10*100+25, rep(40,10), ifile2[1:10,129+i], col="red", cex=0.8)
  points(ifile1[,1]/100, ifile1[,i+1], pch=20, col="blue")
  for(j in 1:10) {
    lines(c(ifile1[j,1]/100, ifile1[j,1]/100), c(ifile1[j,i+1]+ifile1[j,i+33],ifile1[j,i+1]-ifile1[j,i+65]), col="blue")
    lines(c(ifile1[j,1]/100-8, ifile1[j,1]/100+8), c(ifile1[j,i+1]+ifile1[j,i+33],ifile1[j,i+1]+ifile1[j,i+33]), col="blue")
    lines(c(ifile1[j,1]/100-8, ifile1[j,1]/100+8), c(ifile1[j,i+1]-ifile1[j,i+65],ifile1[j,i+1]-ifile1[j,i+65]), col="blue")
  }
  lines(ifile1[,1]/100, ifile1[,i+1], col="blue")
  text(40, 45, labels=paste(temps[i], "K"))
  text(1:10*100-25, rep(35,10), ifile1[1:10,97+i], col="blue", cex=0.8)
  text(1:10*100,    rep(35,10), "/", cex=0.8, col="blue")
  text(1:10*100+25, rep(35,10), ifile1[1:10,129+i], col="blue", cex=0.8)
}
dev.off()

png("chignolin2.png", height=21, width=16, units='cm', res=600, pointsize=6)
for(i in 1:16) {
  ii <- i + 16
  if(i == 1) {
    par(fig=c(0,0.5,0.8,1))
  } else if(i <= 8) {
    par(fig=c(0,0.5,0.8-0.09*(i-1),1-0.09*(i-1)), new=T)
  } else {
    par(fig=c(0.5,1,1.52-0.09*(i-1),1.72-0.09*(i-1)), new=T)
  }
  if(i==8 | i == 16) {
    plot(ifile2[,1]/100+100, ifile2[,ii+1], type="p", pch=20, xlim=c(0,1000), ylim=c(0,50), axes=F,
         xlab="time (ns)", ylab="free energy (kJ/mol)", col="red")
    box()
    axis(1, col="blue", col.axis="blue", at=0:10*100)
  } else if (i==1 | i == 9) {
    plot(ifile2[,1]/100+100, ifile2[,ii+1], type="p", pch=20, xlim=c(0,1000), ylim=c(0,50), axes=F,
         xlab="", ylab="", col="red")
    box()
    axis(3, col="red", col.axis="red", at=1:10*100, labels=0:9*100)
  } else {
    if(i%%2==0) {
      plot(ifile2[,1]/100+100, ifile2[,ii+1], type="p", pch=20, xlim=c(0,1000), ylim=c(0,50), axes=F,
           xlab="", ylab="free energy (kJ/mol)", col="red")
      box()
    } else {
      plot(ifile2[,1]/100+100, ifile2[,ii+1], type="p", pch=20, xlim=c(0,1000), ylim=c(0,50), axes=F,
           xlab="", ylab="", col="red")
      box()
    }
  }
  axis(2, at=0:6*10)
  for(j in 1:9) {
    lines(c(ifile2[j,1]/100, ifile2[j,1]/100)+100, c(ifile2[j,ii+1]+ifile2[j,ii+33],ifile2[j,ii+1]-ifile2[j,ii+65]), col="red")
    lines(c(ifile2[j,1]/100+92, ifile2[j,1]/100+108), c(ifile2[j,ii+1]+ifile2[j,ii+33],ifile2[j,ii+1]+ifile2[j,ii+33]), col="red")
    lines(c(ifile2[j,1]/100+92, ifile2[j,1]/100+108), c(ifile2[j,ii+1]-ifile2[j,ii+65],ifile2[j,ii+1]-ifile2[j,ii+65]), col="red")
  }
  lines(ifile2[,1]/100+100, ifile2[,ii+1], col="red")
  if(i>5) {
    text(2:10*100-25, rep(7,10), ifile2[1:10,97+i], col="red", cex=0.8)
    text(2:10*100,    rep(7,10), "/", cex=0.8, col="red")
    text(2:10*100+25, rep(7,10), ifile2[1:10,129+i], col="red", cex=0.8)
  } else {
    text(2:10*100-25, rep(40,10), ifile2[1:10,97+i], col="red", cex=0.8)
    text(2:10*100,    rep(40,10), "/", cex=0.8, col="red")
    text(2:10*100+25, rep(40,10), ifile2[1:10,129+i], col="red", cex=0.8)
  }
  points(ifile1[,1]/100, ifile1[,ii+1], pch=20, col="blue")
  for(j in 1:10) {
    lines(c(ifile1[j,1]/100, ifile1[j,1]/100), c(ifile1[j,ii+1]+ifile1[j,ii+33],ifile1[j,ii+1]-ifile1[j,ii+65]), col="blue")
    lines(c(ifile1[j,1]/100-8, ifile1[j,1]/100+8), c(ifile1[j,ii+1]+ifile1[j,ii+33],ifile1[j,ii+1]+ifile1[j,ii+33]), col="blue")
    lines(c(ifile1[j,1]/100-8, ifile1[j,1]/100+8), c(ifile1[j,ii+1]-ifile1[j,ii+65],ifile1[j,ii+1]-ifile1[j,ii+65]), col="blue")
  }
  lines(ifile1[,1]/100, ifile1[,ii+1], col="blue")
  text(40, 45, labels=paste(temps[ii], "K"))
  if(i>5) {
    text(1:10*100-25, rep(2,10), ifile1[1:10,97+i], col="blue", cex=0.8)
    text(1:10*100,    rep(2,10), "/", cex=0.8, col="blue")
    text(1:10*100+25, rep(2,10), ifile1[1:10,129+i], col="blue", cex=0.8)
  } else {
    text(1:10*100-25, rep(35,10), ifile1[1:10,97+i], col="blue", cex=0.8)
    text(1:10*100,    rep(35,10), "/", cex=0.8, col="blue")
    text(1:10*100+25, rep(35,10), ifile1[1:10,129+i], col="blue", cex=0.8)
  }
}
dev.off()

