ifile <- read.table("combined.txt")
residence <- ifile[,1]
meanres <- mean(residence)
genres <- rexp(n=length(residence), rate=1/meanres)
png("test.png", height=6, width=5, units='cm', res=600, pointsize=6)
hist(genres, col=rgb(0,0,1,0.5), xlab="time from A to B (steps)", main="", breaks=50, xlim=c(0,10000000), ylim=c(0,80))
hist(residence, col=rgb(1,0,0,0.5), add=T, breaks=50, xlim=c(0,10000000), ylim=c(0,80))
dev.off()
print(length(residence))
print(ks.test(residence, genres))


