#!/usr/bin/python3

import numpy as np

def V(x, temp):
  V = -1.0*np.exp(-(x-0.3)**2/0.005) - 1.1*np.exp(-(x-0.5)**2/0.005) - 1.2*np.exp(-(x-0.7)**2/0.005)
  if x < 0.0:
    V = V + 10.0*x**2
  if x > 1.0:
    V = V + 10.0*(x-1.0)**2
  return(V)

temps = [0.1, 0.1*1.1, 0.1*1.1**2, 0.1*1.1**3, 0.1*1.1**4, 0.1*1.1**5]
for l in range(100):
  order = [0, 1, 2, 3, 4, 5]
  x = [np.random.uniform(), np.random.uniform(), np.random.uniform(), np.random.uniform(), np.random.uniform(), np.random.uniform()]
  oldx = []
  froma = [0, 0, 0, 0, 0, 0]
  for i in range(6):
    oldx.append(x[i])
    if x[i] < 0.4: froma[i] = 1
  atob = [0, 0, 0, 0, 0, 0]
  btoa = [0, 0, 0, 0, 0, 0]
  atoc = [0, 0, 0, 0, 0, 0]
  ctoa = [0, 0, 0, 0, 0, 0]
  ofilename = str(l) + ".txt"
  ofile = open(ofilename, "w")
  for i in range(100):
    for j in range(10000):
      for k in range(6):
        newx = x[k] + 0.02*(np.random.uniform()-0.5)
        pot = V(x[k], temps[order[k]])
        newpot = V(newx, temps[order[k]])
        if newpot < pot:
          x[k] = newx
        else:
          metro = np.exp((pot-newpot)/temps[order[k]])
          if np.random.uniform() < metro:
            x[k] = newx
    if i%2 == 0:
      metro = np.exp((V(x[1], temps[order[1]])-V(x[0], temps[order[0]]))*(1.0/temps[order[1]]-1.0/temps[order[0]]))
      if metro > 1.0:
        order[0], order[1] = order[1], order[0]
      elif np.random.uniform() < metro:
        order[0], order[1] = order[1], order[0]
      metro = np.exp((V(x[3], temps[order[3]])-V(x[2], temps[order[2]]))*(1.0/temps[order[3]]-1.0/temps[order[2]]))
      if metro > 1.0:
        order[2], order[3] = order[3], order[2]
      elif np.random.uniform() < metro:
        order[2], order[3] = order[3], order[2]
      metro = np.exp((V(x[5], temps[order[5]])-V(x[4], temps[order[4]]))*(1.0/temps[order[5]]-1.0/temps[order[4]]))
      if metro > 1.0:
        order[4], order[5] = order[5], order[4]
      elif np.random.uniform() < metro:
        order[4], order[5] = order[5], order[4]
    else:
      metro = np.exp((V(x[2], temps[order[2]])-V(x[1], temps[order[1]]))*(1.0/temps[order[2]]-1.0/temps[order[1]]))
      if metro > 1.0:
        order[1], order[2] = order[2], order[1]
      elif np.random.uniform() < metro:
        order[1], order[2] = order[2], order[1]
      metro = np.exp((V(x[4], temps[order[4]])-V(x[3], temps[order[3]]))*(1.0/temps[order[4]]-1.0/temps[order[3]]))
      if metro > 1.0:
        order[3], order[4] = order[4], order[3]
      elif np.random.uniform() < metro:
        order[3], order[4] = order[4], order[3]
    for k in range(6):
      if oldx[k] < 0.4 and x[k] > 0.4:
        atob[k] = atob[k] + 1
      if oldx[k] > 0.4 and x[k] < 0.4:
        btoa[k] = btoa[k] + 1
        if froma[k] == 0:
          ctoa[k] = ctoa[k] + 1
          froma[k] = 1
      if oldx[k] < 0.6 and x[k] > 0.6:
        if froma[k] == 1:
          atoc[k] = atoc[k] + 1
          froma[k] = 0
      ofile.write("%i %f " % (order[k], x[k]))
    for k in range(6):
      oldx[k] = x[k]
    ofile.write("\n")
  ofile.close()
  print("AtoB: ", end="")
  for k in range(6):
    print("%i " % atob[k], end="")
  print("BtoA: ", end="")
  for k in range(6):
    print("%i " % btoa[k], end="")
  print("AtoC: ", end="")
  for k in range(6):
    print("%i " % atoc[k], end="")
  print("CtoA: ", end="")
  for k in range(6):
    print("%i " % ctoa[k], end="")
  print("")

