temps <- c(278.0, 287.0, 295.0, 303.0, 312.0, 321.0, 329.0, 338.0, 346.0, 355.0, 365.0, 375.0, 385.0, 396.0, 406.0,
           416.0, 427.0, 437.0, 448.0, 459.0, 470.0, 482.0, 493.0, 505.0, 517.0, 528.0, 539.0, 551.0, 562.0, 573.0,
           584.0, 595.0)

ifile <- read.table("assigned.txt")
ifile2 <- read.table("dmxrmsdmd")

png("chignolin2.png", height=21, width=16, units='cm', res=600, pointsize=6)
for(i in 1:16) {
  if(i == 1) {
    par(fig=c(0,0.5,0.8,1))
  } else if(i <= 8) {
    par(fig=c(0,0.5,0.8-0.09*(i-1),1-0.09*(i-1)), new=T)
  } else {
    par(fig=c(0.5,1,1.52-0.09*(i-1),1.72-0.09*(i-1)), new=T)
  }
  if(i==8 | i == 16) {
    plot(1:100000/100, ifile2[,2*(i-1)+2], type="p", pch=20, cex=0.1, xlim=c(0,1000), ylim=c(0,1.3), axes=F, xlab="time (ns)", ylab="RMSD (nm)", col=c("blue","red")[ifile[,2*(i-1)+2]+1])
    axis(1)
    axis(2, at=0:2*0.5)
    box()
  } else {
    if(i%%2==0) {
      plot(1:100000/100, ifile2[,2*(i-1)+2], type="p", pch=20, cex=0.1, xlim=c(0,1000), ylim=c(0,1.3), axes=F, xlab="", ylab="RMSD (nm)", col=c("blue","red")[ifile[,2*(i-1)+2]+1])
    } else {
      plot(1:100000/100, ifile2[,2*(i-1)+2], type="p", pch=20, cex=0.1, xlim=c(0,1000), ylim=c(0,1.3), axes=F, xlab="", ylab="", col=c("blue","red")[ifile[,2*(i-1)+2]+1])
    }
    axis(2, at=1:2*0.5)
    box()
  }
}
dev.off()

png("chignolin3.png", height=21, width=16, units='cm', res=600, pointsize=6)
for(i in 1:16) {
  ii <- i+16
  if(i == 1) {
    par(fig=c(0,0.5,0.8,1))
  } else if(i <= 8) {
    par(fig=c(0,0.5,0.8-0.09*(i-1),1-0.09*(i-1)), new=T)
  } else {
    par(fig=c(0.5,1,1.52-0.09*(i-1),1.72-0.09*(i-1)), new=T)
  }
  if(i==8 | i == 16) {
    plot(1:100000/100, ifile2[,2*(ii-1)+2], type="p", pch=20, cex=0.1, xlim=c(0,1000), ylim=c(0,1.3), axes=F, xlab="time (ns)", ylab="RMSD (nm)", col=c("blue","red")[ifile[,2*(ii-1)+2]+1])
    axis(1)
    axis(2, at=0:2*0.5)
    box()
  } else {
    if(i%%2==0) {
      plot(1:100000/100, ifile2[,2*(ii-1)+2], type="p", pch=20, cex=0.1, xlim=c(0,1000), ylim=c(0,1.3), axes=F, xlab="", ylab="RMSD (nm)", col=c("blue","red")[ifile[,2*(ii-1)+2]+1])
    } else {
      plot(1:100000/100, ifile2[,2*(ii-1)+2], type="p", pch=20, cex=0.1, xlim=c(0,1000), ylim=c(0,1.3), axes=F, xlab="", ylab="", col=c("blue","red")[ifile[,2*(ii-1)+2]+1])
    }
    axis(2, at=1:2*0.5)
    box()
  }
}
dev.off()
