#!/bin/bash
MYDIR=`pwd`
RUN_FILE=`pwd`/$(basename $(pwd))_pt.$$
SCRATCH='$SCRATCHDIR'
GMX="/storage/praha1/home/beranekjan/install/gromacs20223_plumed280/gromacs_compiled/bin/gmx_mpi"

echo "#!/bin/bash" >> $RUN_FILE
echo "#PBS -l walltime=24:00:00" >> $RUN_FILE
echo "#PBS -l select=1:ncpus=32:mem=128gb:scratch_local=200gb:ngpus=2:gpu_cap=cuda75 -q gpu" >> $RUN_FILE
echo "export LD_LIBRARY_PATH=\$LD_LIBRARY_PATH:/storage/praha1/home/beranekjan/install/plumed280/plumed_compiled/lib/" >> $RUN_FILE
echo "#module add openmpi-3.1.2-gcc-cuda" >> $RUN_FILE
echo "#module add cuda/cuda-11.1.0-gcc-8.3.0-g47kwyz" >> $RUN_FILE

echo "trap \"cp -r \$SCRATCHDIR $MYDIR\" TERM EXIT" >> $RUN_FILE
echo "cp -r $MYDIR/* \$SCRATCHDIR/  || exit 1" >> $RUN_FILE
echo "cd \$SCRATCHDIR || exit 2 " >> $RUN_FILE

#img="singularity run --nv -B \$SCRATCHDIR:/work --pwd /work /storage/brno3-cerit/home/ljocha/singularity/kurecka-gromacs-2022-1.sif"
ntomp=1
ntmpi=32

for i in 278 287 295 303 312 321 329 338 346 355 365 375 385 396 406 416 427 437 448 459 470 482 493 505 517 528 539 551 562 573 584 595
do
echo "$GMX grompp -f t$i/nvt.mdp -c t$i/npt.gro -p t$i/topol.top -o t$i/md1.tpr -maxwarn 666" >> $RUN_FILE
echo "rm mdout.mdp" >> $RUN_FILE
done

echo 'unset $(env | grep PBS | cut -f1 -d=)'  >> $RUN_FILE
echo "mpirun -n $ntmpi $GMX mdrun -ntomp $ntomp -deffnm md1 -multidir \
 t278 t287 t295 t303 t312 t321 t329 t338 t346 t355 t365 t375 t385 t396 t406 t416 \
 t427 t437 t448 t459 t470 t482 t493 t505 t517 t528 t539 t551 t562 t573 t584 t595 \
 -replex 500 -pin on" >> $RUN_FILE

echo "cp -r * $MYDIR/ " >> $RUN_FILE
echo "trap - TERM EXIT" >> $RUN_FILE
echo '[ -n \"\$SCRATCHDIR\" ] && rm -rf \$SCRATCHDIR/*' >> $RUN_FILE

qsub $RUN_FILE

