import numpy as np
import scipy as sp
from scipy.stats import f

temps = np.array([278.0, 287.0, 295.0, 303.0, 312.0, 321.0, 329.0, 338.0, 346.0, 355.0, 365.0, 375.0, 385.0, 396.0, 406.0,
                  416.0, 427.0, 437.0, 448.0, 459.0, 470.0, 482.0, 493.0, 505.0, 517.0, 528.0, 539.0, 551.0, 562.0, 573.0,
                  584.0, 595.0])

ifile = np.loadtxt("assigned.txt")

fromA = np.zeros(32)
fromB = np.zeros(32)
prev = np.zeros((32,32))+0.0
pops = np.zeros(32)
for k in range(ifile.shape[0]):
  for i in range(32):
    if (ifile[k,2*i+1] == 1.0):
      pops[int(ifile[k,2*i])] = pops[int(ifile[k,2*i])] + 1.0
    for j in range(32):
      if int(ifile[k,2*j]) == i:
        if prev[i,j] == 0.0 and ifile[k,2*j+1] == 1.0:
          fromA[i] = fromA[i] + 1
        if prev[i,j] == 1.0 and ifile[k,2*j+1] == 0.0:
          fromB[i] = fromB[i] + 1
        prev[i,j] = ifile[k,2*j+1]
  if k%10000 == 0:
    print(k, end=" ")
    for l in range(32):
      K = (pops[l]*fromA[l])/((float(k+1)-pops[l])*fromB[l])
      print("%4.2f" % (-8.314*temps[l]*np.log(K)/1000.0), end=" ")
    for l in range(32):
      print("%4.2f" % (8.314*temps[l]*sp.log(f.ppf(q=(1-0.05/2), dfn=2*fromB[l], dfd=2*fromA[l]))/1000.0), end=" ")
    for l in range(32):
      print("%4.2f" % (-8.314*temps[l]*sp.log(f.ppf(q=0.05/2, dfn=2*fromB[l], dfd=2*fromA[l]))/1000.0), end=" ")
    for l in range(32):
      print("%i" % fromA[l], end=" ")
    for l in range(32):
      print("%i" % fromB[l], end=" ")
    print("")
print(k, end=" ")
for l in range(32):
  K = (pops[l]*fromA[l])/((float(k+1)-pops[l])*fromB[l])
  print("%4.2f" % (-8.314*temps[l]*np.log(K)/1000.0), end=" ")
for l in range(32):
  print("%4.2f" % (8.314*temps[l]*sp.log(f.ppf(q=(1-0.05/2), dfn=2*fromB[l], dfd=2*fromA[l]))/1000.0), end=" ")
for l in range(32):
  print("%4.2f" % (-8.314*temps[l]*sp.log(f.ppf(q=0.05/2, dfn=2*fromB[l], dfd=2*fromA[l]))/1000.0), end=" ")
for l in range(32):
  print("%i" % fromA[l], end=" ")
for l in range(32):
  print("%i" % fromB[l], end=" ")
print("")
