import os

temps = [300,308,317,325,334,343,353,362,372,382,393,403,414,426,437,449,461,474,487,500]

for temp in temps:
  command = "mkdir t"+str(temp)
  print(command)
  os.system(command)
  command = "cp acealanme.top t"+str(temp)+"/"
  print(command)
  os.system(command)
  command = "cp -r amber14sb_OL15.ff t"+str(temp)+"/"
  print(command)
  os.system(command)
  command = "cp npt1.gro t"+str(temp)+"/"
  print(command)
  os.system(command)
  command = "cp runit.sh t"+str(temp)+"/"
  print(command)
  os.system(command)
  ofile = open("t"+str(temp)+"/nvt.mdp", "w")
  ofile.write("title                   = OPLS Lysozyme NVT equilibration \n")
  ofile.write("; Run parameters\n")
  ofile.write("integrator              = md        ; leap-frog integrator\n")
  ofile.write("nsteps                  = 500000    ; 2 * 500000 = 1 ns\n")
  ofile.write("dt                      = 0.002     ; 2 fs\n")
  ofile.write("; Output control\n")
  ofile.write("nstxout                 = 500       ; save coordinates every 1.0 ps\n")
  ofile.write("nstvout                 = 500       ; save velocities every 1.0 ps\n")
  ofile.write("nstenergy               = 500       ; save energies every 1.0 ps\n")
  ofile.write("nstlog                  = 500       ; update log file every 1.0 ps\n")
  ofile.write("; Bond parameters\n")
  ofile.write("continuation            = no        ; first dynamics run\n")
  ofile.write("constraint_algorithm    = lincs     ; holonomic constraints \n")
  ofile.write("constraints             = h-bonds   ; bonds involving H are constrained\n")
  ofile.write("lincs_iter              = 1         ; accuracy of LINCS\n")
  ofile.write("lincs_order             = 4         ; also related to accuracy\n")
  ofile.write("; Nonbonded settings \n")
  ofile.write("cutoff-scheme           = Verlet    ; Buffered neighbor searching\n")
  ofile.write("ns_type                 = grid      ; search neighboring grid cells\n")
  ofile.write("nstlist                 = 10        ; 20 fs, largely irrelevant with Verlet\n")
  ofile.write("rcoulomb                = 1.0       ; short-range electrostatic cutoff (in nm)\n")
  ofile.write("rvdw                    = 1.0       ; short-range van der Waals cutoff (in nm)\n")
  ofile.write("DispCorr                = EnerPres  ; account for cut-off vdW scheme\n")
  ofile.write("; Electrostatics\n")
  ofile.write("coulombtype             = PME       ; Particle Mesh Ewald for long-range electrostatics\n")
  ofile.write("pme_order               = 4         ; cubic interpolation\n")
  ofile.write("fourierspacing          = 0.16      ; grid spacing for FFT\n")
  ofile.write("; Temperature coupling is on\n")
  ofile.write("tcoupl                  = V-rescale             ; modified Berendsen thermostat\n")
  ofile.write("tc-grps                 = Protein Non-Protein   ; two coupling groups - more accurate\n")
  ofile.write("tau_t                   = 0.1     0.1           ; time constant, in ps\n")
  ofile.write("ref_t                   = %i     %i           ; reference temperature, one for each group, in K\n" % (temp,temp))
  ofile.write("; Pressure coupling is off\n")
  ofile.write("pcoupl                  = no        ; no pressure coupling in NVT\n")
  ofile.write("; Periodic boundary conditions\n")
  ofile.write("pbc                     = xyz       ; 3-D PBC\n")
  ofile.write("; Velocity generation\n")
  ofile.write("gen_vel                 = yes       ; assign velocities from Maxwell distribution\n")
  ofile.write("gen_temp                = %i       ; temperature for Maxwell distribution\n" % temp)
  ofile.write("gen_seed                = -1        ; generate a random seed\n")
  ofile.close()

