#!/usr/bin/python3

import os

temps = [300.0, 308.0, 317.0, 325.0, 334.0, 343.0, 353.0, 362.0, 372.0, 382.0, 393.0, 403.0, 414.0, 426.0, 437.0, 449.0, 461.0, 474.0, 487.0, 500.0]

i = 0
for temp in temps:
  dirname = str.split(str(temp), ".")[0]
  command = "mkdir dir-"+str(i)
  print(command)
  os.system(command)
  command = "cp ../temp/t"+dirname+"/nvt1.gro dir-"+str(i)+"/md0.gro"
  print(command)
  os.system(command)
  command = "cp plumed.dat dir-"+str(i)+"/"
  print(command)
  os.system(command)
  ofile = open("dir-"+str(i)+"/nvt.mdp", "w")
  ofile.write("integrator              = md        ; leap-frog integrator\n")
  ofile.write("nsteps                  = 5000000   ; 2 * 5000000 = 10 ns\n")
  ofile.write("dt                      = 0.002     ; 2 fs\n")
  ofile.write("nstxout                 = 500       ; save coordinates every 1.0 ps\n")
  ofile.write("nstvout                 = 500       ; save velocities every 1.0 ps\n")
  ofile.write("nstenergy               = 500       ; save energies every 1.0 ps\n")
  ofile.write("nstlog                  = 500       ; update log file every 1.0 ps\n")
  ofile.write("continuation            = yes       ; Restarting after NVT \n")
  ofile.write("constraint_algorithm    = lincs     ; holonomic constraints \n")
  ofile.write("constraints             = h-bonds   ; bonds involving H are constrained\n")
  ofile.write("lincs_iter              = 1         ; accuracy of LINCS\n")
  ofile.write("lincs_order             = 4         ; also related to accuracy\n")
  ofile.write("cutoff-scheme           = Verlet    ; Buffered neighbor searching\n")
  ofile.write("ns_type                 = grid      ; search neighboring grid cells\n")
  ofile.write("nstlist                 = 10        ; 20 fs, largely irrelevant with Verlet scheme\n")
  ofile.write("rcoulomb                = 1.0       ; short-range electrostatic cutoff (in nm)\n")
  ofile.write("rvdw                    = 1.0       ; short-range van der Waals cutoff (in nm)\n")
  ofile.write("DispCorr                = EnerPres  ; account for cut-off vdW scheme\n")
  ofile.write("coulombtype             = PME       ; Particle Mesh Ewald for long-range electrostatics\n")
  ofile.write("pme_order               = 4         ; cubic interpolation\n")
  ofile.write("fourierspacing          = 0.16      ; grid spacing for FFT\n")
  ofile.write("tcoupl                  = V-rescale             ; modified Berendsen thermostat\n")
  ofile.write("tc-grps                 = Protein Non-Protein   ; two coupling groups - more accurate\n")
  ofile.write("tau_t                   = 0.1     0.1           ; time constant, in ps\n")
  ofile.write("ref_t                   = %3.0f     %3.0f           ; reference temperature, one for each group, in K\n" % (temp, temp))
  ofile.write("pcoupl                  = no                    ; Pressure coupling on in NPT\n")
  ofile.write("pbc                     = xyz       ; 3-D PBC\n")
  ofile.write("gen_vel                 = no        ; Velocity generation is off \n")
  ofile.close()
  i = i + 1

