#!/bin/bash
MYDIR=`pwd`
RUN_FILE=`pwd`/mtd.$$
SCRATCH='$SCRATCHDIR'

echo "#!/bin/sh" >> $RUN_FILE
echo "#PBS -l walltime=24:00:00" >> $RUN_FILE
echo "#PBS -l select=1:ncpus=20:mem=64gb:scratch_local=100gb" >> $RUN_FILE

echo "trap \"cp -r \$SCRATCHDIR $MYDIR\" TERM EXIT" >> $RUN_FILE
echo "cp -r $MYDIR/* \$SCRATCHDIR/  || exit 1" >> $RUN_FILE
echo "cd \$SCRATCHDIR || exit 2 " >> $RUN_FILE

echo "module add gromacs/2021.4-gcc-8.3.0-plumed-3xeq7fb" >> $RUN_FILE
ntomp=1
ntmpi=20

for i in `seq 0 19`;
do
echo "gmx_mpi_d grompp -f dir-$i/nvt.mdp -c dir-$i/md0.gro -p acealanme.top -o dir-$i/md1.tpr -maxwarn 666" >> $RUN_FILE
echo "rm mdout.mdp" >> $RUN_FILE
done

#echo 'unset $(env | grep PBS | cut -f1 -d=)'  >>$RUN_FILE
echo "mpirun -n $ntmpi gmx_mpi_d mdrun -ntomp $ntomp -deffnm md1 -multidir \
 dir-0 dir-1 dir-2 dir-3 dir-4 dir-5 dir-6 dir-7 dir-8 dir-9 \
 dir-10 dir-11 dir-12 dir-13 dir-14 dir-15 dir-16 dir-17 dir-18 dir-19 \
 -replex 500 -pin on -plumed plumed.dat" >> $RUN_FILE

echo "cp -r * $MYDIR/ " >> $RUN_FILE
echo "trap - TERM EXIT" >> $RUN_FILE
echo "[ -n \"\$SCRATCHDIR\" ] && rm -rf \$SCRATCHDIR/*" >> $RUN_FILE

qsub $RUN_FILE
