import numpy as np
import scipy as sp
from scipy.stats import f

temps = np.array([300.0, 308.0, 317.0, 325.0, 334.0, 343.0, 353.0, 362.0, 372.0,
                  382.0, 393.0, 403.0, 414.0, 426.0, 437.0, 449.0, 461.0, 474.0,
                  487.0, 500.0])

ifile = np.loadtxt("demuxed.txt")

fromA = np.zeros(20)
fromB = np.zeros(20)
prev = np.zeros((20,20))-1.0
pops = np.zeros(20)
for k in range(ifile.shape[0]):
  for i in range(20):
    if (ifile[k,2*i+2] > 0.0 and ifile[k,2*i+2] < 2.0):
      pops[int(ifile[k,2*i+1])] = pops[int(ifile[k,2*i+1])] + 1.0
    for j in range(20):
      if int(ifile[k,2*j+1]) == i:
        if (prev[i,j] < 0.0 or prev[i,j] > 2.0) and (ifile[k,2*j+2] > 0.1 and ifile[k,2*j+2] < 2.0):
          fromA[i] = fromA[i] + 1
        if (prev[i,j] > 0.1 and prev[i,j] < 2.0) and (ifile[k,2*j+2] < 0.0 or ifile[k,2*j+2] > 2.0):
          fromB[i] = fromB[i] + 1
        prev[i,j] = ifile[k,2*j+2]
  if k%1000 == 0:
    print(k, end=" ")
    for l in range(20):
      K = (pops[l]*fromA[l])/((float(k+1)-pops[l])*fromB[l])
      print("%4.2f" % (-8.314*temps[l]*np.log(K)/1000.0), end=" ")
    for l in range(20):
      print("%4.2f" % (8.314*temps[l]*sp.log(f.ppf(q=(1-0.05/2), dfn=2*fromB[l], dfd=2*fromA[l]))/1000.0), end=" ")
    for l in range(20):
      print("%4.2f" % (-8.314*temps[l]*sp.log(f.ppf(q=0.05/2, dfn=2*fromB[l], dfd=2*fromA[l]))/1000.0), end=" ")
    for l in range(20):
      print("%i" % fromA[l], end=" ")
    for l in range(20):
      print("%i" % fromB[l], end=" ")
    print("")
print(k, end=" ")
for l in range(20):
  K = (pops[l]*fromA[l])/((float(k+1)-pops[l])*fromB[l])
  print("%4.2f" % (-8.314*temps[l]*np.log(pops[l]/float(k+1))/1000.0), end=" ")
for l in range(20):
  print("%4.2f" % (8.314*temps[l]*sp.log(f.ppf(q=(1-0.05/2), dfn=2*fromB[l], dfd=2*fromA[l]))/1000.0), end=" ")
for l in range(20):
  print("%4.2f" % (-8.314*temps[l]*sp.log(f.ppf(q=0.05/2, dfn=2*fromB[l], dfd=2*fromA[l]))/1000.0), end=" ")
for l in range(20):
  print("%i" % fromA[l], end=" ")
for l in range(20):
  print("%i" % fromB[l], end=" ")
print("")
