V <- function(x, temp) {
  V <- -1.0*exp(-(x-0.3)**2/0.005) - 1.1*exp(-(x-0.5)**2/0.005) - 1.2*exp(-(x-0.7)**2/0.005)
  return(V)
}

temps <- c(0.1, 0.1*1.1, 0.1*1.1**2, 0.1*1.1**3, 0.1*1.1**4, 0.1*1.1**5)
x <- 0:1000/1000
p1 <- exp(-V(x)/temps[1])
p2 <- exp(-V(x)/temps[2])
p3 <- exp(-V(x)/temps[3])
p4 <- exp(-V(x)/temps[4])
p5 <- exp(-V(x)/temps[5])
p6 <- exp(-V(x)/temps[6])
dg1_1 <- -temps[1]*log(sum(p1[x>0.4 & x<0.6])/sum(p1[x<0.4]))
dg2_1 <- -temps[2]*log(sum(p2[x>0.4 & x<0.6])/sum(p2[x<0.4]))
dg3_1 <- -temps[3]*log(sum(p3[x>0.4 & x<0.6])/sum(p3[x<0.4]))
dg4_1 <- -temps[4]*log(sum(p4[x>0.4 & x<0.6])/sum(p4[x<0.4]))
dg5_1 <- -temps[5]*log(sum(p5[x>0.4 & x<0.6])/sum(p5[x<0.4]))
dg6_1 <- -temps[6]*log(sum(p6[x>0.4 & x<0.6])/sum(p6[x<0.4]))
dg1_2 <- -temps[1]*log(sum(p1[x>0.6])/sum(p1[x<0.4]))
dg2_2 <- -temps[2]*log(sum(p2[x>0.6])/sum(p2[x<0.4]))
dg3_2 <- -temps[3]*log(sum(p3[x>0.6])/sum(p3[x<0.4]))
dg4_2 <- -temps[4]*log(sum(p4[x>0.6])/sum(p4[x<0.4]))
dg5_2 <- -temps[5]*log(sum(p5[x>0.6])/sum(p5[x<0.4]))
dg6_2 <- -temps[6]*log(sum(p6[x>0.6])/sum(p6[x<0.4]))


dgss1 <- c()
dgss2 <- c()
dgetss1 <- c()
dgetss2 <- c()
dgebss1 <- c()
dgebss2 <- c()

for(k in 0:99) {
  ifilename <- paste(toString(k), ".txt", sep="")
  ifile <- read.table(ifilename)
  cv <- rep(0.5, times=6)
  for(i in 1:nrow(ifile)) {
    dem <- rep(0, times=6)
    dem[ifile[i,1]+1] <- ifile[i,2]
    dem[ifile[i,3]+1] <- ifile[i,4]
    dem[ifile[i,5]+1] <- ifile[i,6]
    dem[ifile[i,7]+1] <- ifile[i,8]
    dem[ifile[i,9]+1] <- ifile[i,10]
    dem[ifile[i,11]+1] <- ifile[i,12]
    cv <- rbind(cv, dem)
  }
  ons1 <- rep(0, 6)
  offs1 <- rep(0, 6)
  ons2 <- rep(0, 6)
  offs2 <- rep(0, 6)
  for(tempi in 1:6) {
    for(ri in 0:5) {
      tob <- rep(-1, 6)
      toc <- rep(-1, 6)
      for(ti in 1:nrow(ifile)) {
        x <- ifile[ti,2*ri+2]
        tempis <- ifile[ti,2*ri+1]+1
        if(tempis==tempi) {
          if(tob[tempis]==-1 & x < 0.4) tob[tempis] <- 1
          if(tob[tempis]==-1 & x > 0.4) tob[tempis] <- 0
          if(toc[tempis]==-1 & x < 0.4) toc[tempis] <- 1
          if(toc[tempis]==-1 & x > 0.6) toc[tempis] <- 0
          if(x > 0.4 & tob[tempis]==1) {
            ons1[tempis] <- ons1[tempis] + 1
            tob[tempis] <- 0
          }
          if(x < 0.4 & tob[tempis]==0) {
            offs1[tempis] <- offs1[tempis] + 1
            tob[tempis] <- 1
          }
          if(x > 0.6 & toc[tempis]==1) {
            ons2[tempis] <- ons2[tempis] + 1
            toc[tempis] <- 0
          }
          if(x < 0.4 & toc[tempis]==0) {
            offs2[tempis] <- offs2[tempis] + 1
            toc[tempis] <- 1
          }
        }
      }
    }
  }
  x <- -10:110/100
  dgs1 <- c()
  dgets1 <- c()
  dgebs1 <- c()
  dgs2 <- c()
  dgets2 <- c()
  dgebs2 <- c()
  for(tempi in 1:6) {
    prob <- 0*x
    for(ti in 1:nrow(cv)){
      if((cv[ti,tempi] > -0.1) & (cv[ti,tempi] < 1.1)) {
        prob[100*(cv[ti,tempi]+0.1)] <- prob[100*(cv[ti,tempi]+0.1)] + 1
      }
    }
    dgs1 <- c(dgs1, -temps[tempi]*log((ons1[tempi]*sum(prob[x>0.4 & x<0.6]))/(offs1[tempi]*sum(prob[x<0.4]))))
    dgets1 <- c(dgets1,  temps[tempi]*log(qf(p=0.975, df1=2*offs1[tempi], df2=2*ons1[tempi])))
    dgebs1 <- c(dgebs1, -temps[tempi]*log(qf(p=0.025, df1=2*offs1[tempi], df2=2*ons1[tempi])))
    dgs2 <- c(dgs2, -temps[tempi]*log((ons2[tempi]*sum(prob[x>0.6]))/(offs2[tempi]*sum(prob[x<0.4]))))
    dgets2 <- c(dgets2,  temps[tempi]*log(qf(p=0.975, df1=2*offs2[tempi], df2=2*ons2[tempi])))
    dgebs2 <- c(dgebs2, -temps[tempi]*log(qf(p=0.025, df1=2*offs2[tempi], df2=2*ons2[tempi])))
  }
  dgss1 <- rbind(dgss1, dgs1)
  dgetss1 <- rbind(dgetss1, dgets1)
  dgebss1 <- rbind(dgebss1, dgebs1)
  dgss2 <- rbind(dgss2, dgs2)
  dgetss2 <- rbind(dgetss2, dgets2)
  dgebss2 <- rbind(dgebss2, dgebs2)
}


dgreal1 <- c(dg1_1,dg2_1,dg3_1,dg4_1,dg5_1,dg6_1)
dgreal2 <- c(dg1_2,dg2_2,dg3_2,dg4_2,dg5_2,dg6_2)

for(l in 1:6) {
  ofilename <- paste("dgs1_", toString(l), ".png", sep="")
  png(ofilename)
  plot(1:100, dgss1[,l], pch=20, cex=2, col="orange", ylim=c(-0.5,0.5))
  lines(1:100, 0*(1:100)+dgreal1[l])
  good <- 0
  bad <- 0
  for(k in 1:100) {
    if(!is.nan(dgebss1[k,l]) & !is.nan(dgetss1[k,l])) {
      if(((dgss1[k,l]-dgebss1[k,l]) < dgreal1[l]) & ((dgss1[k,l]+dgetss1[k,l]) > dgreal1[l])) {
        good <- good + 1
        lines(c(k,k), c(dgss1[k,l]-dgebss1[k,l], dgss1[k,l]+dgetss1[k,l]))
      } else {
        bad <- bad + 1
        lines(c(k,k), c(dgss1[k,l]-dgebss1[k,l], dgss1[k,l]+dgetss1[k,l]), col="red")
      }
    }
  }
  dev.off()
  print(c("B", good, bad))
}

for(l in 1:6) {
  ofilename <- paste("dgs2_", toString(l), ".png", sep="")
  png(ofilename)
  plot(1:100, dgss2[,l], pch=20, cex=2, col="orange", ylim=c(-0.5,0.5))
  lines(1:100, 0*(1:100)+dgreal2[l])
  good <- 0
  bad <- 0
  for(k in 1:100) {
    if(!is.nan(dgebss2[k,l]) & !is.nan(dgetss2[k,l])) {
      if(((dgss2[k,l]-dgebss2[k,l]) < dgreal2[l]) & ((dgss2[k,l]+dgetss2[k,l]) > dgreal2[l])) {
        good <- good + 1
        lines(c(k,k), c(dgss2[k,l]-dgebss2[k,l], dgss2[k,l]+dgetss2[k,l]))
      } else {
        bad <- bad + 1
        lines(c(k,k), c(dgss2[k,l]-dgebss2[k,l], dgss2[k,l]+dgetss2[k,l]), col="red")
      }
    }
  }
  dev.off()
  print(c("C", good, bad))
}


