#!/usr/bin/python3

import numpy as np

def V(x, temp):
  V = -1.0*np.exp(-(x-0.3)**2/0.01) - 1.1*np.exp(-(x-0.7)**2/0.01)
  if x < 0.0:
    V = V + 10.0*x**2
  if x > 1.0:
    V = V + 10.0*(x-1.0)**2
  return(V)

temps = [0.1, 0.1*1.05, 0.1*1.05**2, 0.1*1.05**3, 0.1*1.05**4, 0.1*1.05**5,
         0.1*1.05**6, 0.1*1.05**7, 0.1*1.05**8, 0.1*1.05**9]
for l in range(100):
  order = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
  x = [np.random.uniform(), np.random.uniform(), np.random.uniform(), np.random.uniform(), np.random.uniform(),
       np.random.uniform(), np.random.uniform(), np.random.uniform(), np.random.uniform(), np.random.uniform()]
  oldx = []
  for i in range(10): oldx.append(x[i])
  atob = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
  btoa = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
  ofilename = str(l) + ".txt"
  ofile = open(ofilename, "w")
  for i in range(200):
    for j in range(10000):
      for k in range(10):
        newx = x[k] + 0.02*(np.random.uniform()-0.5)
        pot = V(x[k], temps[order[k]])
        newpot = V(newx, temps[order[k]])
        if newpot < pot:
          x[k] = newx
        else:
          metro = np.exp((pot-newpot)/temps[order[k]])
          if np.random.uniform() < metro:
            x[k] = newx
    if i%2 == 0:
      metro = np.exp((V(x[1], temps[order[1]])-V(x[0], temps[order[0]]))*(1.0/temps[order[1]]-1.0/temps[order[0]]))
      if metro > 1.0:
        order[0], order[1] = order[1], order[0]
      elif np.random.uniform() < metro:
        order[0], order[1] = order[1], order[0]
      metro = np.exp((V(x[3], temps[order[3]])-V(x[2], temps[order[2]]))*(1.0/temps[order[3]]-1.0/temps[order[2]]))
      if metro > 1.0:
        order[2], order[3] = order[3], order[2]
      elif np.random.uniform() < metro:
        order[2], order[3] = order[3], order[2]
      metro = np.exp((V(x[5], temps[order[5]])-V(x[4], temps[order[4]]))*(1.0/temps[order[5]]-1.0/temps[order[4]]))
      if metro > 1.0:
        order[4], order[5] = order[5], order[4]
      elif np.random.uniform() < metro:
        order[4], order[5] = order[5], order[4]
      metro = np.exp((V(x[7], temps[order[7]])-V(x[6], temps[order[6]]))*(1.0/temps[order[7]]-1.0/temps[order[6]]))
      if metro > 1.0:
        order[6], order[7] = order[7], order[6]
      elif np.random.uniform() < metro:
        order[6], order[7] = order[7], order[6]
      metro = np.exp((V(x[9], temps[order[9]])-V(x[8], temps[order[8]]))*(1.0/temps[order[9]]-1.0/temps[order[8]]))
      if metro > 1.0:
        order[8], order[9] = order[9], order[8]
      elif np.random.uniform() < metro:
        order[8], order[9] = order[9], order[8]
    else:
      metro = np.exp((V(x[2], temps[order[2]])-V(x[1], temps[order[1]]))*(1.0/temps[order[2]]-1.0/temps[order[1]]))
      if metro > 1.0:
        order[1], order[2] = order[2], order[1]
      elif np.random.uniform() < metro:
        order[1], order[2] = order[2], order[1]
      metro = np.exp((V(x[4], temps[order[4]])-V(x[3], temps[order[3]]))*(1.0/temps[order[4]]-1.0/temps[order[3]]))
      if metro > 1.0:
        order[3], order[4] = order[4], order[3]
      elif np.random.uniform() < metro:
        order[3], order[4] = order[4], order[3]
      metro = np.exp((V(x[6], temps[order[6]])-V(x[5], temps[order[5]]))*(1.0/temps[order[6]]-1.0/temps[order[5]]))
      if metro > 1.0:
        order[5], order[6] = order[6], order[5]
      elif np.random.uniform() < metro:
        order[5], order[6] = order[6], order[5]
      metro = np.exp((V(x[8], temps[order[8]])-V(x[7], temps[order[7]]))*(1.0/temps[order[8]]-1.0/temps[order[7]]))
      if metro > 1.0:
        order[7], order[8] = order[8], order[7]
      elif np.random.uniform() < metro:
        order[7], order[8] = order[8], order[7]
    for k in range(10):
      if oldx[k] < 0.5 and x[k] > 0.5:
        atob[k] = atob[k] + 1
      if oldx[k] > 0.5 and x[k] < 0.5:
        btoa[k] = btoa[k] + 1
      ofile.write("%i %f " % (order[k], x[k]))
    for k in range(10):
      oldx[k] = x[k]
    ofile.write("\n")
  ofile.close()
  print("AtoB: ", end="")
  for k in range(10):
    print("%i " % atob[k], end="")
  print("BtoA: ", end="")
  for k in range(10):
    print("%i " % btoa[k], end="")
  print("")

