V <- function(x, temp) {
  V <- -1.0*exp(-(x-0.3)**2/0.01) - 1.1*exp(-(x-0.7)**2/0.01)
  return(V)
}

temps <- c(0.1, 0.1*1.05, 0.1*1.05**2, 0.1*1.05**3, 0.1*1.05**4, 0.1*1.05**5, 0.1*1.05**6, 0.1*1.05**7, 0.1*1.05**8, 0.1*1.05**9)

x <- 0:1000/1000
p1 <- exp(-V(x)/temps[1])
p2 <- exp(-V(x)/temps[2])
p3 <- exp(-V(x)/temps[3])
p4 <- exp(-V(x)/temps[4])
p5 <- exp(-V(x)/temps[5])
p6 <- exp(-V(x)/temps[6])
p7 <- exp(-V(x)/temps[7])
p8 <- exp(-V(x)/temps[8])
p9 <- exp(-V(x)/temps[9])
p10 <- exp(-V(x)/temps[10])
dg1 <- -temps[1]*log(sum(p1[x>0.5])/sum(p1[x<0.5]))
dg2 <- -temps[2]*log(sum(p2[x>0.5])/sum(p2[x<0.5]))
dg3 <- -temps[3]*log(sum(p3[x>0.5])/sum(p3[x<0.5]))
dg4 <- -temps[4]*log(sum(p4[x>0.5])/sum(p4[x<0.5]))
dg5 <- -temps[5]*log(sum(p5[x>0.5])/sum(p5[x<0.5]))
dg6 <- -temps[6]*log(sum(p6[x>0.5])/sum(p6[x<0.5]))
dg7 <- -temps[7]*log(sum(p7[x>0.5])/sum(p7[x<0.5]))
dg8 <- -temps[8]*log(sum(p8[x>0.5])/sum(p8[x<0.5]))
dg9 <- -temps[9]*log(sum(p9[x>0.5])/sum(p9[x<0.5]))
dg10 <- -temps[10]*log(sum(p10[x>0.5])/sum(p10[x<0.5]))

dgss <- c()
dgetss <- c()
dgebss <- c()
for(k in 0:99) {
  ifilename <- paste(toString(k), ".txt", sep="")
  ifile <- read.table(ifilename)
  cv <- rep(0.5, times=10)
  for(i in 1:nrow(ifile)) {
    dem <- rep(0, times=10)
    dem[ifile[i,1]+1] <- ifile[i,2]
    dem[ifile[i,3]+1] <- ifile[i,4]
    dem[ifile[i,5]+1] <- ifile[i,6]
    dem[ifile[i,7]+1] <- ifile[i,8]
    dem[ifile[i,9]+1] <- ifile[i,10]
    dem[ifile[i,11]+1] <- ifile[i,12]
    dem[ifile[i,13]+1] <- ifile[i,14]
    dem[ifile[i,15]+1] <- ifile[i,16]
    dem[ifile[i,17]+1] <- ifile[i,18]
    dem[ifile[i,19]+1] <- ifile[i,20]
    cv <- rbind(cv, dem)
  }
  ons <- rep(0, 10)
  offs <- rep(0, 10)
  for(tempi in 1:10) {
    for(ri in 0:9) {
      froma <- rep(-1, 10)
      for(ti in 1:nrow(ifile)) {
        x <- ifile[ti,2*ri+2]
        tempis <- ifile[ti,2*ri+1]+1
        if(tempis==tempi) {
          if(froma[tempis]==-1 & x < 0.5) froma[tempis] <- 1
          if(froma[tempis]==-1 & x > 0.5) froma[tempis] <- 0
          if(x > 0.5 & froma[tempis]==1) {
            ons[tempis] <- ons[tempis] + 1
            froma[tempis] <- 0
          }
          if(x < 0.5 & froma[tempis]==0) {
            offs[tempis] <- offs[tempis] + 1
            froma[tempis] <- 1
          }
        }
      }
    }
  }
  x <- -10:110/100
  dgs <- c()
  dgets <- c()
  dgebs <- c()
  for(tempi in 1:10) {
    prob <- 0*x
    for(ti in 1:nrow(cv)){
      if((cv[ti,tempi] > -0.1) & (cv[ti,tempi] < 1.1)) {
        prob[100*(cv[ti,tempi]+0.1)] <- prob[100*(cv[ti,tempi]+0.1)] + 1
      }
    }
    dgs <- c(dgs, -temps[tempi]*log((ons[tempi]*sum(prob[x>0.5]))/(offs[tempi]*sum(prob[x<0.5]))))
    dgets <- c(dgets,  temps[tempi]*log(qf(p=0.975, df1=2*offs[tempi], df2=2*ons[tempi])))
    dgebs <- c(dgebs, -temps[tempi]*log(qf(p=0.025, df1=2*offs[tempi], df2=2*ons[tempi])))
  }
  dgss <- rbind(dgss, dgs)
  dgetss <- rbind(dgetss, dgets)
  dgebss <- rbind(dgebss, dgebs)
}

dgreal <- c(dg1,dg2,dg3,dg4,dg5,dg6,dg7,dg8,dg9,dg10)

for(l in 1:10) {
  ofilename <- paste("dgs", toString(l), ".png", sep="")
  png(ofilename)
  plot(1:100, dgss[,l], pch=20, cex=2, col="orange", ylim=c(-0.5,0.5))
  lines(1:100, 0*(1:100)+dgreal[l])
  good <- 0
  bad <- 0
  for(k in 1:100) {
    if(!is.nan(dgebss[k,l]) & !is.nan(dgetss[k,l])) {
      if(((dgss[k,l]-dgebss[k,l]) < dgreal[l]) & ((dgss[k,l]+dgetss[k,l]) > dgreal[l])) {
        good <- good + 1
        lines(c(k,k), c(dgss[k,l]-dgebss[k,l], dgss[k,l]+dgetss[k,l]))
      } else {
        bad <- bad + 1
        lines(c(k,k), c(dgss[k,l]-dgebss[k,l], dgss[k,l]+dgetss[k,l]), col="red")
      }
    }
  }
  dev.off()
  print(c(good, bad))
}

