temps <- 1:5
k1 <- 0.01*exp(-4/temps)
km1 <- 0.01*exp(-6/temps)
K <- k1/km1
k1s <- c()
pUF <- rep(0.25, 4)
pFU <- pUF*K[2:5]/K[1:4]
nsteps <- 2000
Ksc <- c()
Ks <- c()
for(j in 1:100) {
  ids <- 1:5
  states <- rep("u", 5)
  inA <- rep(0, 5)
  nA <- rep(0, 5)
  nB <- rep(0, 5)
  fromu <- rep(1, 5)
  for(i in 1:nsteps) {
    if(states[1] == "u") {
      tau <- rexp(1, k1[1])
      if(tau < 1) {
        states[1] <- "f"
        inA[1] <- inA[1]+tau
      } else {
        inA[1] <- inA[1]+1
      }
    }
    if(states[2] == "u") {
      tau <- rexp(1, k1[2])
      if(tau < 1) {
        states[2] <- "f"
        inA[2] <- inA[2]+tau
      } else {
        inA[2] <- inA[2]+1
      }
    }
    if(states[3] == "u") {
      tau <- rexp(1, k1[3])
      if(tau < 1) {
        states[3] <- "f"
        inA[3] <- inA[3]+tau
      } else {
        inA[3] <- inA[3]+1
      }
    }
    if(states[4] == "u") {
      tau <- rexp(1, k1[4])
      if(tau < 1) {
        states[4] <- "f"
        inA[4] <- inA[4]+tau
      } else {
        inA[4] <- inA[4]+1
      }
    }
    if(states[5] == "u") {
      tau <- rexp(1, k1[5])
      if(tau < 1) {
        states[5] <- "f"
        inA[5] <- inA[5]+tau
      } else {
        inA[5] <- inA[5]+1
      }
    }
    if(states[1] == "f") {
      tau <- rexp(1, km1[1])
      if(tau < 1) {
        states[1] <- "u"
        inA[1] <- inA[1]+1-tau
      }
    }
    if(states[2] == "f") {
      tau <- rexp(1, km1[2])
      if(tau < 1) {
        states[2] <- "u"
        inA[2] <- inA[2]+1-tau
      }
    }
    if(states[3] == "f") {
      tau <- rexp(1, km1[3])
      if(tau < 1) {
        states[3] <- "u"
        inA[3] <- inA[3]+1-tau
      }
    }
    if(states[4] == "f") {
      tau <- rexp(1, km1[4])
      if(tau < 1) {
        states[4] <- "u"
        inA[4] <- inA[4]+1-tau
      }
    }
    if(states[5] == "f") {
      tau <- rexp(1, km1[5])
      if(tau < 1) {
        states[5] <- "u"
        inA[5] <- inA[5]+1-tau
      }
    }
    if(i%%2==1) {
      rr <- runif(2)
      newids <- ids[1:2]
      newstates <- states[1:2]
      if(states[1]=="u" & states[2]=="f" & rr[1]<pUF[1]) {
        newids <- ids[2:1]
        newstates <- states[2:1]
      }
      if(states[1]=="f" & states[2]=="u" & rr[1]<pFU[1]) {
        newids <- ids[2:1]
        newstates <- states[2:1]
      }
      if(states[1]=="u" & states[2]=="u" & rr[1]<0.25) {
        newids <- ids[2:1]
        newstates <- states[2:1]
      }
      if(states[1]=="f" & states[2]=="f" & rr[1]<0.25) {
        newids <- ids[2:1]
        newstates <- states[2:1]
      }
      ids[1:2] <- newids
      states[1:2] <- newstates
      newids <- ids[3:4]
      newstates <- states[3:4]
      if(states[3]=="u" & states[4]=="f" & rr[2]<pUF[3]) {
        newids <- ids[4:3]
        newstates <- states[4:3]
      }
      if(states[3]=="f" & states[4]=="u" & rr[2]<pFU[3]) {
        newids <- ids[4:3]
        newstates <- states[4:3]
      }
      if(states[3]=="u" & states[4]=="u" & rr[2]<0.25) {
        newids <- ids[4:3]
        newstates <- states[4:3]
      }
      if(states[3]=="f" & states[4]=="f" & rr[2]<0.25) {
        newids <- ids[4:3]
        newstates <- states[4:3]
      }
      ids[3:4] <- newids
      states[3:4] <- newstates
    } else {
      rr <- runif(2)
      newids <- ids[2:3]
      newstates <- states[2:3]
      if(states[2]=="u" & states[3]=="f" & rr[1]<pUF[2]) {
        newids <- ids[3:2]
        newstates <- states[3:2]
      }
      if(states[2]=="f" & states[3]=="u" & rr[1]<pFU[2]) {
        newids <- ids[3:2]
        newstates <- states[3:2]
      }
      if(states[2]=="u" & states[3]=="u" & rr[1]<0.25) {
        newids <- ids[3:2]
        newstates <- states[3:2]
      }
      if(states[2]=="f" & states[3]=="f" & rr[1]<0.25) {
        newids <- ids[3:2]
        newstates <- states[3:2]
      }
      ids[2:3] <- newids
      states[2:3] <- newstates
      newids <- ids[4:5]
      newstates <- states[4:5]
      if(states[4]=="u" & states[5]=="f" & rr[2]<pUF[4]) {
        newids <- ids[5:4]
        newstates <- states[5:4]
      }
      if(states[4]=="f" & states[5]=="u" & rr[2]<pFU[4]) {
        newids <- ids[5:4]
        newstates <- states[5:4]
      }
      if(states[4]=="u" & states[5]=="u" & rr[2]<0.25) {
        newids <- ids[5:4]
        newstates <- states[5:4]
      }
      if(states[4]=="f" & states[5]=="f" & rr[2]<0.25) {
        newids <- ids[5:4]
        newstates <- states[5:4]
      }
      ids[4:5] <- newids
      states[4:5] <- newstates
    }
    if(states[which(ids %in% 1)] == "f" & fromu[1] == 1) {
      nA[1] <- nA[1] + 1
      fromu[1] <- 0
    }
    if(states[which(ids %in% 2)] == "f" & fromu[2] == 1) {
      nA[2] <- nA[2] + 1
      fromu[2] <- 0
    }
    if(states[which(ids %in% 3)] == "f" & fromu[3] == 1) {
      nA[3] <- nA[3] + 1
      fromu[3] <- 0
    }
    if(states[which(ids %in% 4)] == "f" & fromu[4] == 1) {
      nA[4] <- nA[4] + 1
      fromu[4] <- 0
    }
    if(states[which(ids %in% 5)] == "f" & fromu[5] == 1) {
      nA[5] <- nA[5] + 1
      fromu[5] <- 0
    }
    if(states[which(ids %in% 1)] == "u" & fromu[1] == 0) {
      nB[1] <- nB[1] + 1
      fromu[1] <- 1
    }
    if(states[which(ids %in% 2)] == "u" & fromu[2] == 0) {
      nB[2] <- nB[2] + 1
      fromu[2] <- 1
    }
    if(states[which(ids %in% 3)] == "u" & fromu[3] == 0) {
      nB[3] <- nB[3] + 1
      fromu[3] <- 1
    }
    if(states[which(ids %in% 4)] == "u" & fromu[4] == 0) {
      nB[4] <- nB[4] + 1
      fromu[4] <- 1
    }
    if(states[which(ids %in% 5)] == "u" & fromu[5] == 0) {
      nB[5] <- nB[5] + 1
      fromu[5] <- 1
    }
  }
  Ksc <- rbind(Ksc, nA*(nsteps-inA)/nB/inA)
  Ks <- rbind(Ks, (nsteps-inA)/inA)
}

png("plotc.png", height=6, width=5, units='cm', res=600, pointsize=6)
boxplot(-log(Ksc), ylim=c(-4,2), xlab="temperature", ylab="-log(K)", names=1:5, col="steelblue1")
for(i in 1:5) {
  lines(c(i-0.5,i+0.5), -log(rep(K[i],2)), col="red", lwd=2)
}
dev.off()
png("plot.png", height=6, width=5, units='cm', res=600, pointsize=6)
boxplot(-log(Ks), ylim=c(-4,2), xlab="temperature", ylab="-log(K)", col="tomato1", names=1:5)
for(i in 1:5) {
  lines(c(i-0.5,i+0.5), -log(rep(K[i],2)), col="red", lwd=2)
}
dev.off()

