replids <- rbind(c(1,2,3,4,5,6),
                 c(1,2,3,4,6,5),

                 c(1,3,2,6,4,5),
                 c(1,3,6,2,4,5),

                 c(1,3,6,4,2,5),
                 c(3,1,4,6,2,5),

                 c(3,4,1,2,6,5),
                 c(3,4,2,1,6,5),

                 c(3,2,4,6,1,5),
                 c(2,3,6,4,1,5),

                 c(2,3,6,1,4,5),
                 c(3,2,1,6,5,4),

                 c(3,1,2,5,6,4),
                 c(1,3,2,5,4,6),

                 c(1,2,3,5,4,6),
                 c(2,1,3,5,6,4),

                 c(2,1,3,6,5,4),
                 c(1,2,3,6,4,5),

                 c(1,2,3,4,6,5),
                 c(2,1,3,4,5,6))
png("plot.png", height=8, width=8, units='cm', res=600, pointsize=6)
par(fig=c(0,0.8,0,1), new=TRUE)
plot(0:(nrow(replids)-1), replids[,1], ylim=c(0.5,6.5), type="n",
     axes=F, xlab="time", ylab="temperature ID", main="temperatures")
axis(1, at=0:(nrow(replids)-1), labels=c(0,"",2,"",4,"",6,"",8,"",10,"",12,"",14,"",16,"",18,""))
axis(2, at=1:6, labels=0:5)
box()
for(i in 1:(nrow(replids)-1)) {
  from <- order(replids[i,])
  to <- order(replids[i+1,])
  lines(c(i-0.9, i-0.1), c(1,1), col=rainbow(9)[6], lwd=2)
  lines(c(i-0.9, i-0.1), c(2,2), col=rainbow(9)[5], lwd=2)
  lines(c(i-0.9, i-0.1), c(3,3), col=rainbow(9)[4], lwd=2)
  lines(c(i-0.9, i-0.1), c(4,4), col=rainbow(9)[3], lwd=2)
  lines(c(i-0.9, i-0.1), c(5,5), col=rainbow(9)[2], lwd=2)
  lines(c(i-0.9, i-0.1), c(6,6), col=rainbow(9)[1], lwd=2)
  lines(c(i-0.9, i-0.1), c(from[1],from[1]), col=rainbow(9)[7-from[1]], lwd=4)
  lines(c(i-0.1, i+0.1), c(from[1], to[1]), lwd=3)
  lines(c(i-0.1, i+0.1), c(from[2], to[2]), lwd=1)
  lines(c(i-0.1, i+0.1), c(from[3], to[3]), lwd=1)
  lines(c(i-0.1, i+0.1), c(from[4], to[4]), lwd=1)
  lines(c(i-0.1, i+0.1), c(from[5], to[5]), lwd=1)
  lines(c(i-0.1, i+0.1), c(from[6], to[6]), lwd=1)
  if(i < 10) {
    text(c(i-0.5), c(from[1]+0.3), labels="A", cex=1)
  } else {
    text(c(i-0.5), c(from[1]+0.3), labels="B", cex=1)
  }
  if(i < 6) {
    text(c(i-0.5), c(from[2]+0.3), labels="A", cex=0.5)
  } else {
    text(c(i-0.5), c(from[2]+0.3), labels="B", cex=0.5)
  }
  text(c(i-0.5), c(from[3]+0.3), labels="A", cex=0.5)
  text(c(i-0.5), c(from[4]+0.3), labels="A", cex=0.5)
  text(c(i-0.5), c(from[5]+0.3), labels="A", cex=0.5)
  text(c(i-0.5), c(from[6]+0.3), labels="A", cex=0.5)
}
text(c(5,9), c(5.5,5.5), labels=c("*","*"), cex=3)
dolu <- 0.11
par(fig=c(0.65,1,0.6,1),new=TRUE)
barplot(c(19,0), axes=F, ylim=c(0,19), col=rainbow(9)[1], main="population")
par(fig=c(0.65,1,0.6-dolu,1-dolu),new=TRUE)
barplot(c(17,2), axes=F, ylim=c(0,19), col=rainbow(9)[2])
par(fig=c(0.65,1,0.6-2*dolu,1-2*dolu),new=TRUE)
barplot(c(17,2), axes=F, ylim=c(0,19), col=rainbow(9)[3])
par(fig=c(0.65,1,0.6-3*dolu,1-3*dolu),new=TRUE)
barplot(c(15,4), axes=F, ylim=c(0,19), col=rainbow(9)[4])
par(fig=c(0.65,1,0.6-4*dolu,1-4*dolu),new=TRUE)
barplot(c(11,8), axes=F, ylim=c(0,19), col=rainbow(9)[5])
par(fig=c(0.65,1,0.6-5*dolu,1-5*dolu),new=TRUE)
barplot(c(11,8), axes=F, ylim=c(0,19), col=rainbow(9)[6], names.arg=c("A", "B"))
dev.off()

png("plot2.png", height=8, width=8, units='cm', res=600, pointsize=6)
par(fig=c(0,0.8,0,1), new=TRUE)
plot(0:(nrow(replids)-1), replids[,1], ylim=c(0.5,6.5), type="n",
     axes=F, xlab="time", ylab="replica ID", main="demultiplexed trajectories")
axis(1, at=0:(nrow(replids)-1), labels=c(0,"",2,"",4,"",6,"",8,"",10,"",12,"",14,"",16,"",18,""))
axis(2, at=1:6, labels=0:5)
box()
for(i in 1:(nrow(replids)-1)) {
  from <- order(replids[i,])
  to <- order(replids[i+1,])
  lines(c(i-0.9, i-0.1), c(1,1), col=rainbow(9)[7-from[1]], lwd=4)
  lines(c(i-0.9, i-0.1), c(2,2), col=rainbow(9)[7-from[2]], lwd=2)
  lines(c(i-0.9, i-0.1), c(3,3), col=rainbow(9)[7-from[3]], lwd=2)
  lines(c(i-0.9, i-0.1), c(4,4), col=rainbow(9)[7-from[4]], lwd=2)
  lines(c(i-0.9, i-0.1), c(5,5), col=rainbow(9)[7-from[5]], lwd=2)
  lines(c(i-0.9, i-0.1), c(6,6), col=rainbow(9)[7-from[6]], lwd=2)
  if(i < 10) {
    text(c(i-0.5), c(1.3), labels="A", cex=1)
  } else {
    text(c(i-0.5), c(1.3), labels="B", cex=1)
  }
  if(i < 6) {
    text(c(i-0.5), c(2.3), labels="A", cex=0.5)
  } else {
    text(c(i-0.5), c(2.3), labels="B", cex=0.5)
  }
  text(c(i-0.5), c(3.3), labels="A", cex=0.5)
  text(c(i-0.5), c(4.3), labels="A", cex=0.5)
  text(c(i-0.5), c(5.3), labels="A", cex=0.5)
  text(c(i-0.5), c(6.3), labels="A", cex=0.5)
}
text(c(5,9), c(2.5,1.5), labels=c("*","*"), cex=3)
dev.off()

