library(readxl)#to read excel files
library(dplyr) #needed for %>% function
library(stringr) #needed for str_detect function
library(ggplot2)
library(RColorBrewer)
library(png)
library(cowplot)


setwd("/Users/kimberly/Library/CloudStorage/GoogleDrive-kimberly.conteddu@ucdconnect.ie/My Drive/Desktop/PhD/PhD project /Literature review/Plotting coded variables")
#upload dataset of coded variables from bTB papers
coded_variables <- read_excel("coded_variables_literature review.xlsx", col_types = c("numeric", "numeric", "text", "text", "text", "text", "text", "text", "text", "text", "text", "text", "text", "text", "text", "text", "text", "text", "text", "text", "text", "text"))

#transform charactr variables into factors
coded_variables["country"] <- as.factor(coded_variables$country)
coded_variables["continent"] <- as.factor(coded_variables$continent)
coded_variables["study_type"] <- as.factor(coded_variables$study_type)
coded_variables["wildlife_species"] <- as.factor(coded_variables$wildlife_species)
coded_variables["management"] <- as.factor(coded_variables$management)
coded_variables["spatial_analysis_cattle"] <- as.factor(coded_variables$spatial_analysis_cattle)
coded_variables["spatial_analysis_wildlife"] <- as.factor(coded_variables$spatial_analysis_wildlife)
coded_variables["spatial_scale"] <- as.factor(coded_variables$spatial_scale)
coded_variables["temporal_scale"] <- as.factor(coded_variables$temporal_scale)
coded_variables["in_farm_environment"] <- as.factor(coded_variables$in_farm_environment)
coded_variables["around_farm_environment"] <- as.factor(coded_variables$around_farm_environment)
coded_variables["climate"] <- as.factor(coded_variables$climate)
coded_variables["human_perturbation"] <- as.factor(coded_variables$human_perturbation)
coded_variables["interactions"] <- as.factor(coded_variables$interactions)
coded_variables["interaction_type"] <- as.factor(coded_variables$interaction_type)
coded_variables["interaction_equipment"] <- as.factor(coded_variables$interaction_equipment)
coded_variables["interaction_methodology"] <- as.factor(coded_variables$interaction_methodology)
coded_variables["direction"] <- as.factor(coded_variables$direction)
coded_variables["epidemiological_modelling"] <- as.factor(coded_variables$epidemiological_modelling)
coded_variables["data_type"] <- as.factor(coded_variables$data_type)

summary(coded_variables)

###### PLOTTING #######

#plots of simple variables
plot(coded_variables$study_type)
plot(coded_variables$direction)
plot(coded_variables$climate)
plot(coded_variables$epidemiological_modelling)
plot(coded_variables$data_type)

##COUNTRY####

library(dplyr) #needed for %>% function
library(stringr) #needed for str_detect function

coded_variables <- coded_variables %>% 
  mutate(
    algeria = str_detect(country, "Algeria"),
    argentina = str_detect(country, "Argentina"),
    australia = str_detect(country, "Australia"),
    bangladesh = str_detect(country, "Bangladesh"),
    belgium = str_detect(country, "Belgium"),
    bosnia_and_herzegovina = str_detect(country, "Bosnia and Herzegovina"),
    brazil = str_detect(country, "Brazil"),
    cameroon = str_detect(country, "Cameroon"),
    canada = str_detect(country, "Canada"),
    china = str_detect(country, "China"),
    czech_republic = str_detect(country, "Czech Republic"),
    croatia = str_detect(country, "Croatia"),
    ecuador = str_detect(country, "Ecuador"),
    egypt = str_detect(country, "Egypt"),
    hungary = str_detect(country, "Hungary"),
    united_kingdom = str_detect(country, "England"),
    united_kingdom1 = str_detect(country, "Scotland"),
    united_kingdom2 = str_detect(country, "Wales"),
    denmark = str_detect(country, "Denmark"),
    eritrea = str_detect(country, "Eritrea"),
    ethiopia = str_detect(country, "Ethiopia"),
    fiji = str_detect(country, "Fiji"),
    france = str_detect(country, "France"),
    united_kingdom3 = str_detect(country, "Great Britain"),
    india = str_detect(country, "India"),
    indonesia = str_detect(country, "Indonesia"),
    iran = str_detect(country, "Iran"),
    iraq = str_detect(country, "Iraq"),
    israel = str_detect(country, "Israel"),
    italy = str_detect(country, "Italy"),
    kazakhstan = str_detect(country, "Kazakhstan"),
    macedonia = str_detect(country, "Macedonia"),
    malaysia = str_detect(country, "Malaysia"),
    mexico = str_detect(country, "Mexico"),
    morocco = str_detect(country, "Morocco"),
    mozambique = str_detect(country, "Mozambique"),
    netherlands = str_detect(country, "Netherlands"),
    new_zealand = str_detect(country, "New Zealand"),
    nigeria = str_detect(country, "Nigeria"),
    united_kingdom4 = str_detect(country, "Northern Ireland"),
    pakistan = str_detect(country, "Pakistan"),
    poland = str_detect(country, "Poland"),
    portugal = str_detect(country, "Portugal"),
    ireland = str_detect(country, "Republic of Ireland"),
    slovakia= str_detect(country, "Slovakia"),
    slovenia= str_detect(country, "Slovenia"),
    south_africa= str_detect(country, "South Africa"),
    spain = str_detect(country, "Spain"),
    united_kingdom5 = str_detect(country, "UK"),
    germany = str_detect(country, "Germany"),
    switzerland = str_detect(country, "Switzerland"),
    tanzania = str_detect(country, "Tanzania"),
    turkey = str_detect(country, "Turkey"),
    uganda = str_detect(country, "Uganda"),
    ukraine = str_detect(country, "Ukraine"),
    uruguay = str_detect(country, "Uruguay"),
    USA = str_detect(country, "USA"),
    zambia = str_detect(country, "Zambia")
  )

coded_variables$united_kingdom_all <- ifelse(coded_variables$united_kingdom == "TRUE" | coded_variables$united_kingdom1 == "TRUE" | coded_variables$united_kingdom2 == "TRUE" | coded_variables$united_kingdom3 == "TRUE" | coded_variables$united_kingdom4 == "TRUE" | coded_variables$united_kingdom5 == "TRUE", "TRUE", "FALSE")

countries <- data.frame(select(coded_variables, c("algeria", "argentina", "australia", "bangladesh", "belgium", "bosnia_and_herzegovina", "brazil", 
                                                  "cameroon", "canada", "china", "czech_republic", "croatia", "ecuador", "egypt", "hungary", "united_kingdom_all", 
                                                  "denmark", "eritrea", "ethiopia", "fiji", "france", "india", "indonesia", "iran", "iraq", "israel", "italy", "kazakhstan", 
                                                  "macedonia", "malaysia", "mexico", "morocco", "mozambique", "netherlands", "new_zealand", "nigeria", "pakistan", 
                                                  "poland", "portugal", "ireland", "slovenia", "south_africa", "spain", "germany", "switzerland",
                                                  "tanzania", "turkey", "uganda", "ukraine", "uruguay", "USA", "zambia")))

#Prepare dataset for plot of countries
countries[countries == "TRUE" ] <- 1
countries[countries == "FALSE" ] <- 0
countries <- sapply(countries, as.numeric)
country_n_papers <- data.frame(sort(colSums(countries), decreasing = TRUE))
country_n_papers$region <- rownames(country_n_papers)
colnames(country_n_papers)[1] <- "n_paper"

country_n_papers[country_n_papers == "bosnia_and_herzegovina"] <- "bosnia and herzegovina"
country_n_papers[country_n_papers == "czech_republic"] <- "czech republic"
country_n_papers[country_n_papers == "united_kingdom_all"] <- "united kingdom"
country_n_papers[country_n_papers == "new_zealand"] <- "new zealand"
country_n_papers[country_n_papers == "south_africa"] <- "south africa"
country_n_papers[country_n_papers == "USA"] <- "united states of america"
country_n_papers[country_n_papers == "tanzania"] <- "united republic of tanzania"

country_n_papers$value <- cut(country_n_papers$n_paper, breaks = c(0,1,2,5,11,24,59,170))

country_n_papers <- as.data.frame(country_n_papers[,c(2,3)])

library(choroplethr)#needed to plot number of papers by country in a map
library (choroplethrMaps)
library(ggplot2)
library(RColorBrewer)

display.brewer.all(n=NULL, type="all", select=NULL, exact.n=TRUE,colorblindFriendly=TRUE)

#mypal <- c("#FFF8DC", "cornsilk3", "#BFEFFF", "#63B8FF", "#4682B4", "#27408B", "#030303", "Black") # got from website  https://r-charts.com/colors/
library(wacolors)

mypal <- c("#BEE7DF", "#97C2C0", "#709EA6", "#457D90", "#025C83",
                    "#1A3761", "#1B1A22")

g <- country_choropleth(country_n_papers, num_colors = 7, legend = "papers")

g1 <- g + ggplot2::scale_fill_manual(values = mypal,aesthetics = "fill", na.value="white", name= "papers", labels = c("1", "2", "2-5", "5-11", "11-24", "24-59", "59-169", "None")) 

#note malta and liechtenstein is not on the list of countries

##CONTINENT####

coded_variables <- coded_variables %>% 
  mutate(
  Europe = str_detect(continent, "Europe"),
  Asia = str_detect(continent, "Asia"),
  Africa = str_detect(continent, "Africa"),
  North_America = str_detect(continent, "North America"),
  South_America = str_detect(continent, "South America"),
  Oceania = str_detect(continent, "Oceania")
  )

continent <- as.data.frame(coded_variables[,c("Asia", "Africa", "Europe", "North_America", "South_America", "Oceania")])

continent[continent == "TRUE" ] <- 1
continent[continent == "FALSE" ] <- 0

continent <- sapply(continent, as.numeric)
continent_n_papers <- data.frame(sort(colSums(continent)))
continent_n_papers$continent <- rownames(continent_n_papers)
colnames(continent_n_papers)[1] <- "n_paper"

continent_n_papers$continent <- as.factor(continent_n_papers$continent)

continent_n_papers$continent <- factor(continent_n_papers$continent, levels = c("Asia", "South_America", "North_America", "Oceania", "Africa", "Europe"))

NA_continent <- length(coded_variables$continent[coded_variables$continent=="NA"])

n_row_continent <- 532 - NA_continent

continent_n_papers$percentages <- round((100/n_row_continent) * (continent_n_papers$n_paper), 0)

continent_n_papers$continent <- factor(continent_n_papers$continent , levels = rev(as.character(continent_n_papers$continent)))


#plot Type 1
pie(continent_n_papers$n_paper, labels = c("Asia", "South America", "North America", "Oceania", "Africa", "Europe"), col = brewer.pal(6, "Paired"))

#plot Type 2
hsize <- 4

continent_n_papers <- continent_n_papers %>% 
  mutate(x = hsize)

ggplot(continent_n_papers, aes(x = hsize, y = n_paper, fill = continent)) +
  geom_col(color = "black") +
  geom_text(aes(label =  n_paper),
            position = position_stack(vjust = 0.5), cex = 6) +
  coord_polar(theta = "y") +
  scale_fill_brewer(palette = "Paired", labels = c("Europe", "Africa", "Oceania", "North America", "South America", "Asia")) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(1, 'cm'),
        legend.title = element_text(size=17, face = "bold"),
        legend.text = element_text(size=16)) + guides(fill=guide_legend(title='Continent', labels = c("Asia", "South America", "North America", "Oceania", "Africa", "Europe")))

#plot Type 3
hsize <- 4

continent_n_papers <- continent_n_papers %>% 
  mutate(x = hsize)


ggplot(continent_n_papers, aes(x = hsize, y = percentages, fill = continent)) +
  geom_col(color = "black") +
  geom_text(aes(label =  c("5%", "5%", "10%", "11%", "13%", "57%")),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("white", "white", "white", "black", "black", "black")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse=TRUE, labels = c("Europe (n = 303)", "Africa (n = 68)", "Oceania (n = 60)", "North America (n = 53)", "South America (n = 29)", "Asia (n = 26)")) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.key.size = unit(1, 'cm'),
        legend.title = element_text(size=15, face = "bold"),
        legend.text = element_text(size=14)) + guides(fill=guide_legend(title='Continent (n = 531)'))


##STUDY TYPE####

study_type <- as.data.frame(coded_variables %>% 
  group_by(study_type) %>%
  summarise(no_rows = length(study_type)))

#plot Type 1 
pie(study_type$no_rows, labels =study_type$study_type, col = brewer.pal(3, "Paired"))

#plot Type 2
hsize <- 4

study_type <- study_type %>% 
  mutate(x = hsize)

p <- ggplot(study_type, aes(x = hsize, y = no_rows, fill = study_type)) +
  geom_col(color = "black") +
  geom_text(aes(label = no_rows),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("black", "white", "white")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse=TRUE) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Study Species'))

library(png)
library(cowplot)
library(magick)
mypng <- readPNG('badger.png')

ggdraw(p) + 
  draw_image("badger.png", x = .68, y = .82, width = 0.12, height = 0.12) + draw_image("cattle.png", x = .03, y = .4, width = 0.15, height = 0.15) + 
  draw_image("badger.png", x = .72, y = .15, width = 0.12, height = 0.12) + draw_image("cattle.png", x = .75, y = .005, width = 0.15, height = 0.15) + draw_image("cervidae.png", x = .7, y = .7, width = 0.15, height = 0.15) + draw_image("cervidae.png", x = .62, y = .01, width = 0.15, height = 0.15)



##WILDLIFE SPECIES####

coded_variables <- coded_variables %>% 
  mutate(
  red_deer = str_detect(wildlife_species, "red deer"),
  roe_deer = str_detect(wildlife_species, "roe deer"),
  fallow_deer = str_detect(wildlife_species, "fallow deer"),
  white_tailed_deer= str_detect(wildlife_species, "white-tailed deer"),
  munjac_deer= str_detect(wildlife_species, "muntjac deer"),
  sika_deer= str_detect(wildlife_species, "sika deer"),
  badger = str_detect(wildlife_species, "badger"),
  wild_boar = str_detect(wildlife_species, "wild boar"),
  elk = str_detect(wildlife_species, "elk"),
  brush_tailed_possum = str_detect(wildlife_species, "brush-tailed possum"),
  buffalo = str_detect(wildlife_species, "buffalo"),
  cervid = str_detect(wildlife_species, "cervid")
  )


wild_species <- as.data.frame(coded_variables[,c("red_deer", "roe_deer", "fallow_deer", "white_tailed_deer", "munjac_deer", "sika_deer", "badger", "wild_boar", "elk", "brush_tailed_possum", "cervid", "buffalo")])

wild_species[wild_species == "TRUE" ] <- 1
wild_species[wild_species == "FALSE" ] <- 0

wild_species <- sapply(wild_species, as.numeric)
wild_species_n_papers <- data.frame(sort(colSums(wild_species)))
wild_species_n_papers$wild_species <- rownames(wild_species_n_papers)
colnames(wild_species_n_papers)[1] <- "n_paper"

#all cervid species together (switching to stable catehories for plots)
cervidae <- as.data.frame(as.numeric(nrow(coded_variables[ coded_variables$red_deer == "TRUE" | coded_variables$roe_deer == "TRUE" | coded_variables$fallow_deer == "TRUE"|coded_variables$white_tailed_deer == "TRUE" | coded_variables$elk == "TRUE"| coded_variables$cervid == "TRUE"| coded_variables$munjac_deer == "TRUE"| coded_variables$sika_deer == "TRUE",])))

cervidae$wild_species <- "cervid"
colnames(cervidae)[1] <- "n_paper"

#merging

wild_species_n_papers <- wild_species_n_papers[c("wild_boar", "badger", "brush_tailed_possum", "buffalo"),]

wild_species_n_papers_new <- rbind(wild_species_n_papers, cervidae)

wild_species_n_papers_new$wild_species <- factor(wild_species_n_papers_new$wild_species, levels = c("buffalo", "brush_tailed_possum", "wild_boar", "cervid", "badger"))

#plot 
hsize <- 4

wild_species_n_papers_new <- wild_species_n_papers_new %>% 
  mutate(x = hsize)

p1 <- ggplot(wild_species_n_papers_new, aes(x = hsize, y = n_paper, fill = wild_species)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("white", "white", "black", "black", "white")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse=TRUE, labels = c("buffalo", "brush-tailed possum", "wild boar", "cervid", "badger")) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Wildlife Species'))

library(png)
library(cowplot)

ggdraw(p1) + 
  draw_image("badger.png", x = .8, y = .5, width = 0.10, height = 0.10) + draw_image("wildboar.png", x = .1, y = .4, width = 0.10, height = 0.10) + 
  draw_image("cervidae.png", x = .32, y = .01, width = 0.13, height = 0.13) + 
  draw_image("possum.png", x = .2, y = .77, width = 0.11, height = 0.11) + 
  draw_image("buffalo.png", x = .25, y = .89, width = 0.4, height = 0.10) 

##STUDY AIM####

management <- as.data.frame(coded_variables %>% 
                        group_by(management) %>%
                        summarise(no_rows = length(management)))
management <- management[-c(1),]

management$type <- "management"

colnames(management)[1] <- "study_animal"

colnames(management)[2] <- "n_papers"

##percentage of management papers
management <- as.data.frame(coded_variables %>% 
                              group_by(management) %>%
                              summarise(no_rows = length(management)))

NA_continent <- length(coded_variables$management[coded_variables$management=="NA"])

management_n_rows <- 532 - NA_continent

management1 <- as.data.frame(management_n_rows - (management$no_rows))

colnames(management1)[1] <- "no_rows"

management1$type <- c("yes_management", "no_management")

#just management plot
hsize <- 4

management1 <- management1 %>% 
  mutate(x = hsize)

p2 <- ggplot(management1, aes(x = hsize, y = no_rows, fill = type)) +
  geom_col(color = "black") +
  geom_text(aes(label = no_rows),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("white", "black")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea,reverse = T, labels = c("no", "yes")) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Management'))

##DATA TYPE####

coded_variables <- coded_variables %>% 
  mutate(
    empirical = str_detect(data_type, "empirical"),
    simulation = str_detect(data_type, "simulation"),
    both = str_detect(data_type, "both")
  )

data_type <- as.data.frame(coded_variables[,c("empirical", "simulation", "both")])

data_type[data_type == "TRUE" ] <- 1
data_type[data_type == "FALSE" ] <- 0

data_type <- sapply(data_type, as.numeric)
data_type_n_papers <- data.frame(sort(colSums(data_type)))
data_type_n_papers$data_type <- rownames(data_type_n_papers)
colnames(data_type_n_papers)[1] <- "n_paper"


hsize <- 4

data_type_n_papers <- data_type_n_papers %>% 
  mutate(x = hsize)

p3 <- ggplot(data_type_n_papers, aes(x = hsize, y = n_paper, fill = data_type)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("white", "black", "white")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Data Type'))

##GENERAL CHARACTERISTICS PLOTS####

library(patchwork)
patchwork <- ggdraw(p) + ggdraw(p1) + ggdraw(p2) + ggdraw(p3) +
  draw_image("badger.png", x = -0.1, y = 1.18, width = 0.12, height = 0.12) + draw_image("cattle.png", x = -0.16, y = 1.3, width = 0.15, height = 0.15) + 
  draw_image("badger.png", x = -0.35, y = 1.85, width = 0.12, height = 0.12) + draw_image("cattle.png", x = -1, y = 1.38, width = 0.15, height = 0.15) + 
  draw_image("badger.png", x = .85, y = 1.5, width = 0.12, height = 0.12) + draw_image("cervidae.png", x = .03, y = 1.54, width = 0.15, height = 0.15) + 
  draw_image("wildboar.png", x = .25, y = 1.03, width = 0.12, height = 0.12) + draw_image("cervidae.png", x = -0.25, y = 1.18, width = 0.15, height = 0.15) + draw_image("cervidae.png", x = -0.28, y = 1.75, width = 0.15, height = 0.15)

patchwork + plot_annotation(tag_levels = 'a') & 
  theme(plot.tag = element_text(size = 25, hjust = -3, vjust = 3))

##SPATIAL ANALYSIS####

#cattle

coded_variables <- coded_variables %>% 
  mutate(
    cs_bTB_risk_or_probability_infection = str_detect(spatial_analysis_cattle, "yes, bTB risk/probability of infection"),
    cs_spatial_no = str_detect(spatial_analysis_cattle, "no"),
    cs_interaction_wildlife = str_detect(spatial_analysis_cattle, "yes, interaction with wildlife"),
    cs_interaction_wildlife_cattle = str_detect(spatial_analysis_cattle, "yes, interaction with wildlife and cattle"),
    cs_movement_in_farm = str_detect(spatial_analysis_cattle, "yes, movement of cows in farm"),
    cs_movement_outside_farm = str_detect(spatial_analysis_cattle, "yes, movement of cows outside of farm"),
    cs_spatial_distribution_samples = str_detect(spatial_analysis_cattle, "yes, spatial distribution of bTB positive samples")
  )

spatial_analysis_cattle <- as.data.frame(coded_variables[,c("cs_bTB_risk_or_probability_infection", "cs_spatial_no", "cs_interaction_wildlife", "cs_interaction_wildlife_cattle", "cs_movement_in_farm", "cs_movement_outside_farm", "cs_spatial_distribution_samples")])

spatial_analysis_cattle[spatial_analysis_cattle == "TRUE" ] <- 1

spatial_analysis_cattle <- sapply(spatial_analysis_cattle, as.numeric)
spatial_cattle_n_papers <- as.data.frame(sort(colSums(spatial_analysis_cattle)))
spatial_cattle_n_papers$type <- rownames(spatial_cattle_n_papers)
colnames(spatial_cattle_n_papers)[1] <- "n_paper"

spatial_cattle_n_papers$study_animal <- "cattle"

spatial_cattle_n_papers$type <- as.factor(spatial_cattle_n_papers$type)

spatial_cattle_n_papers$type <- factor(spatial_cattle_n_papers$type, levels = c("cs_interaction_wildlife_cattle", "cs_movement_in_farm",  "cs_spatial_distribution_samples", "cs_interaction_wildlife", "cs_movement_outside_farm", "cs_bTB_risk_or_probability_infection", "cs_spatial_no"))

cs <- ggplot(spatial_cattle_n_papers, aes(fill=type, y=n_paper, x=study_animal)) + geom_bar(position="stack", stat="identity")

cs1 <- cs + scale_fill_wa_d(wacolors$sea, reverse = T, labels = c("interaction with wildlife and cattle", "movement inside farm", "spatial distribution of bTB samples", "interaction with wildlife", "movement outside of farm", "bTB risk/probability of infection", "no spatial analysis")) + xlab("")

##spatial analysis following sensitivity analysis, just yes or no spatial analysis
coded_variables1 <- coded_variables %>% 
  mutate(
    no = str_detect(spatial_analysis_cattle, "no"),
    yes = str_detect(spatial_analysis_cattle, "yes"),
  )

spatial_analysis_cattle <- as.data.frame(coded_variables1[,c("no", "yes")])

spatial_analysis_cattle[spatial_analysis_cattle == "TRUE" ] <- 1

spatial_analysis_cattle <- sapply(spatial_analysis_cattle, as.numeric)
spatial_final <- as.data.frame(sort(colSums(spatial_analysis_cattle)))
spatial_final$type <- rownames(spatial_final)
colnames(spatial_final)[1] <- "n_paper"

spatial_final$study_animal <- "cattle"

spatial_final$type <- as.factor(spatial_final$type)

#final plot
hsize <- 4

spatial_final <- spatial_final %>% 
  mutate(x = hsize)

s <- ggplot(spatial_final, aes(x = hsize, y = n_paper, fill = type)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("white", "black")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Spatial Analysis Cattle'))


#wildlife

coded_variables <- coded_variables %>% 
  mutate(
  ws_spatial_no = str_detect(spatial_analysis_wildlife, "no"),
  ws_direct_observations = str_detect(spatial_analysis_wildlife, "direct"),
  ws_genetic_sample = str_detect(spatial_analysis_wildlife, "genetic"),
  ws_GPS = str_detect(spatial_analysis_wildlife, "GPS"),
  ws_camera_traps = str_detect(spatial_analysis_wildlife, "camera"),
  ws_prox_loggers = str_detect(spatial_analysis_wildlife, "proximity"),
  ws_VHF = str_detect(spatial_analysis_wildlife, "VHF"),
  ws_prediction = str_detect(spatial_analysis_wildlife, "prediction")
  )

spatial_analysis_wildlife <- as.data.frame(coded_variables[,c("ws_spatial_no", "ws_direct_observations", "ws_genetic_sample", "ws_GPS", "ws_camera_traps", "ws_prox_loggers", "ws_VHF", "ws_prediction")])

spatial_analysis_wildlife[spatial_analysis_wildlife == "TRUE" ] <- 1

spatial_analysis_wildlife <- sapply(spatial_analysis_wildlife, as.numeric)
spatial_wildlife_n_papers <- as.data.frame(sort(colSums(spatial_analysis_wildlife)))
spatial_wildlife_n_papers$type <- rownames(spatial_wildlife_n_papers)
colnames(spatial_wildlife_n_papers)[1] <- "n_paper"

spatial_wildlife_n_papers$study_animal <- "wildlife"

spatial_wildlife_n_papers$type <- as.factor(spatial_wildlife_n_papers$type)

spatial_wildlife_n_papers$type <- factor(spatial_wildlife_n_papers$type, levels = c("ws_prox_loggers", "ws_camera_traps", "ws_VHF", "ws_genetic_sample", "ws_GPS", "ws_prediction", "ws_direct_observations", "ws_spatial_no"))

ws <- ggplot(spatial_wildlife_n_papers, aes(fill=type, y=n_paper, x=study_animal)) + geom_bar(position="stack", stat="identity")

ws1 <- ws + scale_fill_wa_d(wacolors$sea, reverse = T, labels = c("proximity loggers", "camera traps", "genetic samples", "VHF", "GPS", "prediction", "direct observations", "no spatial analysis")) + xlab("")

#spatial analysis following sensitivity analysis, just yes and no spatial analysis
spatial_yes1 <- as.data.frame(as.numeric(nrow(coded_variables[ coded_variables$ws_direct_observations == "TRUE" | coded_variables$ws_genetic_sample == "TRUE"| coded_variables$ws_GPS == "TRUE"| coded_variables$ws_camera_traps == "TRUE"| coded_variables$ws_prox_loggers == "TRUE"| coded_variables$ws_prediction == "TRUE"| coded_variables$ws_VHF == "TRUE",])))

spatial_no1 <- as.data.frame(as.numeric(nrow(coded_variables[ coded_variables$ws_spatial_no == "TRUE", ])))

colnames(spatial_yes1)[1] <- "n_paper"

spatial_yes1$spatial_analysis <- "yes"

colnames(spatial_no1)[1] <- "n_paper"

spatial_no1$spatial_analysis <- "no"

spatial_final1 <- rbind(spatial_yes1, spatial_no1)

#final plot
hsize <- 4

spatial_final1 <- spatial_final1 %>% 
  mutate(x = hsize)

s1 <- ggplot(spatial_final1, aes(x = hsize, y = n_paper, fill = spatial_analysis)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("white", "black")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Spatial Analysis Wildlife'))


##SPATIAL SCALE####

coded_variables <- coded_variables %>% 
  mutate(
    farm = str_detect(spatial_scale, "farm"),
    point = str_detect(spatial_scale, "point"),
    regional = str_detect(spatial_scale, "regional"),
    global = str_detect(spatial_scale, "global"),
    grid = str_detect(spatial_scale, "grid"),
    group = str_detect(spatial_scale, "group"),
    herd = str_detect(spatial_scale, "herd"),
    individual = str_detect(spatial_scale, "individual"),
    national = str_detect(spatial_scale, "national"),
    buffer = str_detect(spatial_scale, "buffer"),
    no = str_detect(spatial_scale, "no")
  )

spatial_scale <- as.data.frame(coded_variables[,c("farm", "point", "individual", "regional", "global", "grid", "group", "herd", "national", "buffer", "no")])

spatial_scale[spatial_scale == "TRUE" ] <- 1
spatial_scale[spatial_scale == "FALSE" ] <- 0

spatial_scale <- sapply(spatial_scale, as.numeric)
spatial_scale_n_papers <- data.frame(sort(colSums(spatial_scale)))
spatial_scale_n_papers$spatial_scale <- rownames(spatial_scale_n_papers)
colnames(spatial_scale_n_papers)[1] <- "n_paper"

#plot Type 1
pie(spatial_scale_n_papers$n_paper, labels = c("buffer", "group", "national", "global", "herd", "farm", "point", "grid", "no", "regional"), col = brewer.pal(10, "Paired"))

#plot Type 2
hsize <- 4

spatial_scale_n_papers <- spatial_scale_n_papers %>% 
  mutate(x = hsize)

ggplot(spatial_scale_n_papers, aes(x = hsize, y = n_paper, fill = spatial_scale)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 6) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.key.size = unit(1, 'cm'),
        legend.title = element_text(size=17),
        legend.text = element_text(size=16)) + guides(fill=guide_legend(title='Spatial Scale'))

#plot Type 3
spatial_scale_n_papers$spatial_scale <- as.factor(spatial_scale_n_papers$spatial_scale)

spatial_scale_n_papers$spatial_scale <- factor(spatial_scale_n_papers$spatial_scale, levels = c("buffer", "global", "national", "group", "individual", "farm", "herd", "point", "grid", "no", "regional"))

spatial_scale_n_papers$variable <- "spatial_scale"

ws <- ggplot(spatial_scale_n_papers, aes(fill=spatial_scale, y=n_paper, x= "")) + geom_bar(position="fill", stat="identity")

ws1 <- ws + scale_fill_wa_d(wacolors$sea, reverse = T, labels = c("national", "global", "group", "herd", "farm", "point", "grid", "no", "regional")) + xlab("")

#spatial scale following sens. analysis: divided into regional and lower, no spatial scale and int&nat level

regional_andlower <- as.data.frame(as.numeric(nrow(coded_variables[ coded_variables$regional == "TRUE" | coded_variables$farm == "TRUE"| coded_variables$point == "TRUE"| coded_variables$grid == "TRUE"| coded_variables$group == "TRUE"| coded_variables$herd == "TRUE"| coded_variables$buffer == "TRUE"| coded_variables$individual == "TRUE",])))

nat_int <- as.data.frame(as.numeric(nrow(coded_variables[coded_variables$global == "TRUE" | coded_variables$national == "TRUE",])))

spatial_scale_no <- as.data.frame(as.numeric(nrow(coded_variables[ coded_variables$no == "TRUE", ])))

colnames(regional_andlower)[1] <- "n_paper"

regional_andlower$spatial_scale <- "regional and lower"

colnames(nat_int)[1] <- "n_paper"

nat_int$spatial_scale <- "national and international"

colnames(spatial_scale_no)[1] <- "n_paper"

spatial_scale_no$spatial_scale <- "no spatial scale"

spatial_scale_final <- rbind(spatial_scale_no, nat_int, regional_andlower)

#final plot
hsize <- 4

spatial_scale_final <- spatial_scale_final %>% 
  mutate(x = hsize)

s2 <- ggplot(spatial_scale_final, aes(x = hsize, y = n_paper, fill = spatial_scale)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("white", "black", "white")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Spatial Scale'))


##TEMPORAL SCALE####

coded_variables <- coded_variables %>% 
  mutate(
  daily = str_detect(temporal_scale, "daily"),
  interannual = str_detect(temporal_scale, "interannual"),
  intraannual = str_detect(temporal_scale, "intraannual"),
  predictions = str_detect(temporal_scale, "predictions"),
  snapshot = str_detect(temporal_scale, "snapshot"),
  unreported = str_detect(temporal_scale, "unreported")
  )

temporal_scale <- as.data.frame(coded_variables[,c("daily", "interannual", "intraannual", "predictions", "snapshot", "unreported")])

temporal_scale[temporal_scale == "TRUE" ] <- 1

temporal_scale[temporal_scale == "FALSE" ] <- 0

temporal_scale <- sapply(temporal_scale, as.numeric)
temporal_scale_n_papers <- data.frame(sort(colSums(temporal_scale)))
temporal_scale_n_papers$temporal_scale <- rownames(temporal_scale_n_papers)
colnames(temporal_scale_n_papers)[1] <- "n_paper"

temporal_scale_n_papers$temporal_scale <- as.factor(temporal_scale_n_papers$temporal_scale)

temporal_scale_n_papers$temporal_scale <- factor(temporal_scale_n_papers$temporal_scale, levels = rev(as.character(temporal_scale_n_papers$temporal_scale)))

#plot Type 1
pie(temporal_scale_n_papers$n_paper, labels = c("daily", "unreported", "predictions", "intraannual", "interannual", "snapshot"), col = brewer.pal(6, "Paired"))

#plot Type 2
hsize <- 4

temporal_scale_n_papers <- temporal_scale_n_papers %>% 
  mutate(x = hsize)

s3 <- ggplot(temporal_scale_n_papers, aes(x = hsize, y = n_paper, fill = temporal_scale)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("white", "white", "white", "black", "black", "black")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Temporal Scale'))

#plot Type 3
temporal_scale_n_papers$temporal_scale <- as.factor(temporal_scale_n_papers$temporal_scale)

temporal_scale_n_papers$temporal_scale <- factor(temporal_scale_n_papers$temporal_scale, levels = c("predictions", "unreported", "daily", "intraannual", "interannual", "snapshot"))

temporal_scale_n_papers$variable <- "temporal_scale"

ws <- ggplot(temporal_scale_n_papers, aes(fill=temporal_scale, y=n_paper, x= "")) + geom_bar(position="fill", stat="identity")

ws1 <- ws + scale_fill_wa_d(wacolors$sea, reverse = T, labels = c("predictions", "unreported", "daily", "intraannual", "interannual", "snapshot")) + xlab("")



##ENVIRONMENT IN FARM####

coded_variables <- coded_variables %>% 
  mutate(
  no_envinfarm= str_detect(in_farm_environment, "no"),
  herd_data = str_detect(in_farm_environment, "herd data"),
  environmental_condition = str_detect(in_farm_environment, "environmental condition of the farm"),
 farm_location_wildlife = str_detect(in_farm_environment, "wildlife"),
 farm_location_cattle = str_detect(in_farm_environment, "other farms")
  )

in_farm_environment <- as.data.frame(coded_variables[,c("no_envinfarm", "herd_data", "environmental_condition", "farm_location_wildlife", "farm_location_cattle")])

in_farm_environment[in_farm_environment == "TRUE" ] <- 1
in_farm_environment[in_farm_environment == "FALSE" ] <- 0

in_farm_environment <- sapply(in_farm_environment, as.numeric)
in_farm_environment_n_papers <- data.frame(sort(colSums(in_farm_environment)))
in_farm_environment_n_papers$in_farm_environment <- rownames(in_farm_environment_n_papers)
colnames(in_farm_environment_n_papers)[1] <- "n_paper"

in_farm_environment_n_papers$in_farm_environment <- as.factor(in_farm_environment_n_papers$in_farm_environment)

in_farm_environment_n_papers$in_farm_environment <- factor(in_farm_environment_n_papers$in_farm_environment, levels = c("farm_location_cattle", "farm_location_wildlife", "environmental_condition", "no_envinfarm", "herd_data"))

#plot Type 1
pie(in_farm_environment_n_papers$n_paper, labels = c("farm location in respect to other farms", "farm location in respect to wildlife", "environmental condition of farm", "no environmental variables", "herd data"), col = brewer.pal(5, "Paired"))

#plot Type 2
hsize <- 4

in_farm_environment_n_papers <- in_farm_environment_n_papers %>% 
  mutate(x = hsize)

ggplot(in_farm_environment_n_papers, aes(x = hsize, y = n_paper, fill = in_farm_environment)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 6) +
  coord_polar(theta = "y") +
  scale_fill_brewer(palette = "Paired", labels = c("farm location in respect to other farms", "farm location in respect to wildlife", "environmental condition of farm", "no environmental variables", "herd data")) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.key.size = unit(1, 'cm'),
        legend.title = element_text(size=17),
        legend.text = element_text(size=16)) + guides(fill=guide_legend(title='Farm Environment'))

#plot Type 3

in_farm_environment_n_papers$variable <- "in_farm_environment"

ws <- ggplot(in_farm_environment_n_papers, aes(fill=in_farm_environment, y=n_paper, x= "")) + geom_bar(position="fill", stat="identity")

ws1 <- ws + scale_fill_wa_d(wacolors$sea, reverse = T, labels = c("farm location in respect to wildlife", "farm location in respect to other farms", "environmental condition of farm", "no environmental variables", "herd data")) + xlab("")+ guides(fill=guide_legend(title="In Farm Environment"))

#doing plots following sensitivity analysis, no env in farm, herd data and other

other <- as.data.frame(as.numeric(nrow(coded_variables[coded_variables$farm_location_cattle == "TRUE"| coded_variables$environmental_condition == "TRUE"| coded_variables$farm_location_wildlife == "TRUE", ])))

herd_data <- as.data.frame(as.numeric(nrow(coded_variables[ coded_variables$herd_data == "TRUE", ])))

no_envinfarm <- as.data.frame(as.numeric(nrow(coded_variables[ coded_variables$no_envinfarm == "TRUE", ])))

colnames(other)[1] <- "n_paper"

other$in_farm_environment <- "other"

colnames(herd_data)[1] <- "n_paper"

herd_data$in_farm_environment <- "herd data"

colnames(no_envinfarm)[1] <- "n_paper"

no_envinfarm$in_farm_environment <- "no environmental variables"

in_farm_env_final <- rbind(other, herd_data, no_envinfarm)

#final plot
hsize <- 4

in_farm_env_final <- in_farm_env_final %>% 
  mutate(x = hsize)

s4 <- ggplot(in_farm_env_final, aes(x = hsize, y = n_paper, fill = in_farm_environment)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("white", "black", "white")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Farm Environment'))



##ENVIRONMENT AROUND FARM####

coded_variables <- coded_variables %>% 
  mutate(
    no_envaroundfarm= str_detect(around_farm_environment, "no"),
    yes_envaroundfarm_hab = str_detect(around_farm_environment, "habitat characteristics"),
    yes_envaroundfarm_varhab = str_detect(around_farm_environment, "variation of habitat around farm")
  )

around_farm_environment <- as.data.frame(coded_variables[,c("no_envaroundfarm", "yes_envaroundfarm_hab", "yes_envaroundfarm_varhab")])

around_farm_environment[around_farm_environment == "TRUE" ] <- 1
around_farm_environment[around_farm_environment == "FALSE" ] <- 0

around_farm_environment <- sapply(around_farm_environment, as.numeric)
around_farm_environment_n_papers <- data.frame(sort(colSums(around_farm_environment)))
around_farm_environment_n_papers$around_farm_environment <- rownames(around_farm_environment_n_papers)
colnames(around_farm_environment_n_papers)[1] <- "n_paper"



#plot Type 1
pie(around_farm_environment_n_papers$n_paper, labels = c("variation of habitat around farm", "habitat characteristics", "no"), col = brewer.pal(3, "Paired"))

#plot Type 2
hsize <- 4

around_farm_environment_n_papers <- around_farm_environment_n_papers %>% 
  mutate(x = hsize)

s5 <- ggplot(around_farm_environment_n_papers, aes(x = hsize, y = n_paper, fill = around_farm_environment)) +
  geom_col(color = "black") +
  geom_text(aes(x =c(3, 4, 4),label = n_paper),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("white", "white", "black")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T, labels = c("no", "habitat characteristics", "variation of habitat around farm")) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Outside Farm Environment'))

##ANTHROPOGENIC FACTORS####

coded_variables <- coded_variables %>% 
  mutate(
    no_humanpert = str_detect(human_perturbation, "no"),
    vaccination = str_detect(human_perturbation, "vaccination"),
    culling = str_detect(human_perturbation, "culling"),
    sterilisation = str_detect(human_perturbation, "sterilisation"),
    land_use_change = str_detect(human_perturbation, "land-use change"),
    hunting = str_detect(human_perturbation, "hunting"),
  )

human_perturbation <- as.data.frame(coded_variables[,c("no_humanpert", "vaccination", "culling", "sterilisation", "land_use_change", "hunting")])

human_perturbation[human_perturbation == "TRUE" ] <- 1
human_perturbation[human_perturbation == "FALSE" ] <- 0

human_perturbation <- sapply(human_perturbation, as.numeric)
human_perturbation_n_papers <- data.frame(sort(colSums(human_perturbation)))
human_perturbation_n_papers$human_perturbation <- rownames(human_perturbation_n_papers)
colnames(human_perturbation_n_papers)[1] <- "n_paper"

human_perturbation_n_papers$human_perturbation <- as.factor(human_perturbation_n_papers$human_perturbation)

human_perturbation_n_papers$human_perturbation <- factor(human_perturbation_n_papers$human_perturbation, levels = c("sterilisation", "land_use_change", "hunting", "vaccination", "culling", "no_humanpert"))

#plot Type 1
pie(human_perturbation_n_papers$n_paper, labels = c("sterilisation", "land_use_change", "vaccination", "culling", "no"), col = brewer.pal(5, "Paired"))

#plot Type 2
hsize <- 4

human_perturbation_n_papers <- human_perturbation_n_papers %>% 
  mutate(x = hsize)

ggplot(human_perturbation_n_papers, aes(x = hsize, y = n_paper, fill = human_perturbation)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 6) +
  coord_polar(theta = "y") +
  scale_fill_brewer(palette = "Paired", labels = c("sterlisation", "land_use_change", "hunting", "vaccination", "culling", "no")) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.key.size = unit(1, 'cm'),
        legend.title = element_text(size=17),
        legend.text = element_text(size=16)) + guides(fill=guide_legend(title='Human Perturbation'))

#do plots following sensitivity analysis, yes human perturbations or no

yes_humanpert <- as.data.frame(as.numeric(nrow(coded_variables[ coded_variables$vaccination == "TRUE"| coded_variables$culling == "TRUE"| coded_variables$sterilisation == "TRUE"| coded_variables$land_use_change == "TRUE"| coded_variables$hunting == "TRUE", ])))

no_humanpert <- as.data.frame(as.numeric(nrow(coded_variables[ coded_variables$no_humanpert == "TRUE", ])))

colnames(yes_humanpert)[1] <- "n_paper"

yes_humanpert$human_perturbations <- "yes"

colnames(no_humanpert)[1] <- "n_paper"

no_humanpert$human_perturbations <- "no"

human_pert_final <- rbind(yes_humanpert, no_humanpert)

#final plot
hsize <- 4

human_pert_final <- human_pert_final %>% 
  mutate(x = hsize)

s6 <- ggplot(human_pert_final, aes(x = hsize, y = n_paper, fill = human_perturbations)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("white", "black")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Human Perturbations'))

##CLIMATE####

climate <- as.data.frame(coded_variables %>% 
                              group_by(climate) %>%
                              summarise(no_rows = length(climate)))



colnames(climate)[1] <- "climate_variable"

colnames(climate)[2] <- "Count"

hsize <- 4

climate <- climate %>% 
  mutate(x = hsize)

s7 <- ggplot(climate, aes(x = hsize, y = Count, fill = climate_variable)) +
  geom_col(color = "black") +
  geom_text(aes(label = Count),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("black", "white")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Weather Variables'))

##DATA ANALYSIS PLOTS####
library(patchwork)

patchwork1 <- s + s1 + s2 + s3 

patchwork1 + plot_annotation(tag_levels = 'a') & 
  theme(plot.tag = element_text(size = 25, hjust = -3, vjust = -5, face = "bold"))

patchwork2 <- s4 + s5 + s6 + s7

patchwork2 + plot_annotation(tag_levels = 'a') & 
  theme(plot.tag = element_text(size = 25, hjust = -3, vjust = -5, face = "bold"))

library(colorBlindness)
cvdPlot(s5)

##INTERACTION####

coded_variables <- coded_variables %>% 
  mutate(
    no_inter = str_detect(interactions, "no"),
    inter_species = str_detect(interactions, "inter-species"),
    intra_species = str_detect(interactions, "intra-species")
  )

interactions <- as.data.frame(coded_variables[,c("no_inter", "inter_species", "intra_species")])
interactions[interactions == "TRUE" ] <- 1
interactions[interactions == "FALSE" ] <- 0

interactions <- sapply(interactions, as.numeric)
interactions_n_papers <- data.frame(sort(colSums(interactions)))
interactions_n_papers$interactions <- rownames(interactions_n_papers)
colnames(interactions_n_papers)[1] <- "n_paper"

interactions_n_papers$interactions <- as.factor(interactions_n_papers$interactions)

interactions_n_papers$interactions <- factor(interactions_n_papers$interactions, levels = c("inter_species", "intra_species", "no_inter"))

#plot Type 1
pie(interactions_n_papers$n_paper, labels = c("inter-species", "intra-species", "no"), col = brewer.pal(3, "Paired"))

#plot Type 2
hsize <- 4

interactions_n_papers <- interactions_n_papers %>% 
  mutate(x = hsize)

e <- ggplot(interactions_n_papers, aes(x = hsize, y = n_paper, fill = interactions)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("black", "white","white")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T, labels = c("inter-species", "intra-species", "no")) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Interactions'))


##INTERACTION TYPE####

coded_variables <- coded_variables %>% 
  mutate(
    direct = str_detect(interaction_type, "direct_"),
    indirect = str_detect(interaction_type, "indirect"),
    both = str_detect(interaction_type, "both")
  )

interaction_type <- as.data.frame(coded_variables[,c("direct", "indirect", "both")])

interaction_type[interaction_type == "TRUE" ] <- 1
interaction_type[interaction_type == "FALSE" ] <- 0

interaction_type <- sapply(interaction_type, as.numeric)
interaction_type_n_papers <- data.frame(sort(colSums(interaction_type)))
interaction_type_n_papers$interaction_type <- rownames(interaction_type_n_papers)
colnames(interaction_type_n_papers)[1] <- "n_paper"

interaction_type_n_papers$interaction_type <- as.factor(interaction_type_n_papers$interaction_type)

interaction_type_n_papers$interaction_type <- factor(interaction_type_n_papers$interaction_type, levels = c("indirect", "direct", "both"))

#plot Type 1
pie(interaction_type_n_papers$n_paper, labels = c("indirect", "both", "direct"), col = brewer.pal(3, "Paired"))

#plot Type 2
hsize <- 4

interaction_type_n_papers <- interaction_type_n_papers %>% 
  mutate(x = hsize)

ggplot(interaction_type_n_papers, aes(x = hsize, y = n_paper, fill = interaction_type)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 6) +
  coord_polar(theta = "y") +
  scale_fill_brewer(palette = "Paired", labels = c("indirect", "both", "direct")) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(1, 'cm'),
        legend.title = element_text(size=17),
        legend.text = element_text(size=16)) + guides(fill=guide_legend(title='Interaction Type'))

e1 <- ggplot(interaction_type_n_papers, aes(x = hsize, y = n_paper, fill = interaction_type)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 4.5, color = c("black", "white", "white")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Interaction Type'))



##INTERACTIONS DATA COLLECTION####

coded_variables <- coded_variables %>% 
  mutate(
     camera_traps = str_detect(interaction_equipment, "camera traps"),
     direct_obs = str_detect(interaction_equipment, "direct observations"),
     GPS = str_detect(interaction_equipment, "GPS"),
     VHF = str_detect(interaction_equipment, "VHF"),
     proximity_loggers = str_detect(interaction_equipment, "proximity"),
     genome_seq = str_detect(interaction_equipment, "genome sequencing"),
     simulation_equip = str_detect(interaction_equipment, "simulation")
  )

interaction_equipment <- as.data.frame(coded_variables[,c("camera_traps", "direct_obs", "GPS", "VHF", "proximity_loggers", "simulation_equip", "genome_seq")])

interaction_equipment[interaction_equipment == "TRUE" ] <- 1
interaction_equipment[interaction_equipment == "FALSE" ] <- 0

interaction_equipment <- sapply(interaction_equipment, as.numeric)
interaction_equipment_n_papers <- data.frame(sort(colSums(interaction_equipment)))
interaction_equipment_n_papers$interaction_equipment <- rownames(interaction_equipment_n_papers)
colnames(interaction_equipment_n_papers)[1] <- "n_paper"

interaction_equipment_n_papers$interaction_equipment <- as.factor(interaction_equipment_n_papers$interaction_equipment)

interaction_equipment_n_papers$interaction_equipment <- factor(interaction_equipment_n_papers$interaction_equipment, levels = c("VHF", "genome_seq", "proximity_loggers", "camera_traps", "GPS", "direct_obs", "simulation_equip"))

#plot Type 1
pie(interaction_equipment_n_papers$n_paper, labels = c("VHF", "genome_seq", "proximity loggers", "camera traps", "GPS", "direct observations", "simulation"), col = brewer.pal(7, "Paired"))

#plot Type 2
hsize <- 4

interaction_equipment_n_papers <- interaction_equipment_n_papers %>% 
  mutate(x = hsize)

ggplot(interaction_equipment_n_papers, aes(x = hsize, y = n_paper, fill = interaction_equipment)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 6) +
  coord_polar(theta = "y") +
  scale_fill_brewer(palette = "Paired", labels = c("VHF", "genome sequencing", "proximity loggers", "camera traps", "GPS", "direct observations", "simulation")) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.key.size = unit(1, 'cm'),
        legend.title = element_text(size=17),
        legend.text = element_text(size=16)) + guides(fill=guide_legend(title='Interaction Equipment'))

#do plot following sensitivity analysis, only technological tools, no, direct observations, simulation

tech_tools <- as.data.frame(as.numeric(nrow(coded_variables[ coded_variables$camera_traps == "TRUE"| coded_variables$GPS == "TRUE"| coded_variables$proximity_loggers == "TRUE"| coded_variables$VHF == "TRUE", ])))

simulation_equip <- as.data.frame(as.numeric(nrow(coded_variables[ coded_variables$simulation_equip == "TRUE", ])))

direct_obs <- as.data.frame(as.numeric(nrow(coded_variables[ coded_variables$direct_obs == "TRUE"| coded_variables$genome_seq == "TRUE", ])))

colnames(tech_tools)[1] <- "n_paper"

tech_tools$interaction_equipment <- "technological tools"

colnames(simulation_equip)[1] <- "n_paper"

simulation_equip$interaction_equipment <- "simulation"

colnames(direct_obs)[1] <- "n_paper"

direct_obs$interaction_equipment <- "direct observations"

inter_equip_final <- rbind(tech_tools, simulation_equip, direct_obs)

inter_equip_final$interaction_equipment <- as.factor(inter_equip_final$interaction_equipment)

inter_equip_final$interaction_equipment <- factor(inter_equip_final$interaction_equipment, levels = c("simulation", "direct observations", "technological tools"))

#final plot
hsize <- 4

inter_equip_final <- inter_equip_final %>% 
  mutate(x = hsize)

e2 <- ggplot(inter_equip_final, aes(x = hsize, y = n_paper, fill = interaction_equipment)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("white", "black", "white")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Interactions Data Collection'))



##INTERACTION METHODOLOGY####

coded_variables <- coded_variables %>% 
  mutate(
     descriptive_stat = str_detect(interaction_methodology, "descriptive"),
     diff_equations = str_detect(interaction_methodology, "differential"),
     linear_model = str_detect(interaction_methodology, "linear"),
     GAM = str_detect(interaction_methodology, "generalized"),
     logistic_model = str_detect(interaction_methodology, "logistic"),
     social_network = str_detect(interaction_methodology, "social network"),
     t_test = str_detect(interaction_methodology, "t-test"),
     ANOVA = str_detect(interaction_methodology, "ANOVA"),
     compos_analysis = str_detect(interaction_methodology, "compositional analysis"),
     stoch_model = str_detect(interaction_methodology, "stochastic model"),
     agent_based_model = str_detect(interaction_methodology, "agent-based model"),
     chi_squared_test = str_detect(interaction_methodology, "chi-square test"),
     contact_model = str_detect(interaction_methodology, "contact model"),
     latent_class_model = str_detect(interaction_methodology, "latent class model"),
     mcmc = str_detect(interaction_methodology, "mcmc"),
     RSF = str_detect(interaction_methodology, "resource selection function"),
     MW_test = str_detect(interaction_methodology, "Mann–Whitney"),
     bayesian_model = str_detect(interaction_methodology, "bayesian"),
     put_trans_cluster = str_detect(interaction_methodology, "putative")
  )

interaction_methodology <- as.data.frame(coded_variables[,c("descriptive_stat", "diff_equations", "linear_model", "GAM", "social_network", "t_test", "ANOVA", "compos_analysis", "stoch_model", "agent_based_model", "chi_squared_test", "contact_model", "latent_class_model", "mcmc", "RSF", "MW_test", "bayesian_model", "put_trans_cluster")])

interaction_methodology[interaction_methodology == "TRUE" ] <- 1
interaction_methodology[interaction_methodology == "FALSE" ] <- 0

interaction_methodology <- sapply(interaction_methodology, as.numeric)
interaction_methodology_n_papers <- data.frame(sort(colSums(interaction_methodology)))
interaction_methodology_n_papers$interaction_methodology <- rownames(interaction_methodology_n_papers)
colnames(interaction_methodology_n_papers)[1] <- "n_paper"

interaction_methodology_n_papers$interaction_methodology <- as.factor(interaction_methodology_n_papers$interaction_methodology)

interaction_methodology_n_papers$interaction_methodology <- factor(interaction_methodology_n_papers$interaction_methodology, levels = interaction_methodology_n_papers$interaction_methodology)
#plot Type 1
pie(interaction_methodology_n_papers$n_paper, labels = c("compos_analysis", "stoch_model",
                                                         "contact_model", "latent_class_model",
                                                         "mcmc","MW_test",           
                                                         "GAM","chi_squared_test",  
                                                         "RSF", "bayesian_model",    
                                                         "agent_based_model", "put_trans_cluster", 
                                                         "t_test", "ANOVA",             
                                                         "descriptive_stat", "linear_model",      
                                                         "social_network", "diff_equations"))

#plot Type 2
hsize <- 4

interaction_methodology_n_papers <- interaction_methodology_n_papers %>% 
  mutate(x = hsize)

ggplot(interaction_methodology_n_papers, aes(x = hsize, y = n_paper, fill = interaction_methodology)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 6) +
  coord_polar(theta = "y") +
  scale_fill_brewer(palette = "Paired", labels = c("compos_analysis", "stoch_model",
                                                   "contact_model", "latent_class_model",
                                                   "mcmc","MW_test",           
                                                   "GAM","chi_squared_test",  
                                                   "RSF", "bayesian_model",    
                                                   "agent_based_model", "put_trans_cluster", 
                                                   "t_test", "ANOVA",             
                                                   "descriptive_stat", "linear_model",      
                                                   "social_network", "diff_equations")) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.key.size = unit(1, 'cm'),
        legend.title = element_text(size=17),
        legend.text = element_text(size=16)) + guides(fill=guide_legend(title='Interaction Methodology'))

#do plots following sensitivity analysis, no interaction meth, other and social network
diff_equation <- as.data.frame(as.numeric(nrow(coded_variables[coded_variables$diff_equations == "TRUE", ])))

social_network <- as.data.frame(as.numeric(nrow(coded_variables[coded_variables$social_network == "TRUE", ])))

linear_model <- as.data.frame(as.numeric(nrow(coded_variables[coded_variables$linear_model == "TRUE", ])))

other_meth <- as.data.frame(as.numeric(165 - nrow(coded_variables[coded_variables$linear_model == "TRUE"| coded_variables$social_network == "TRUE"| coded_variables$diff_equations == "TRUE", ])))

colnames(social_network)[1] <- "n_paper"

social_network$interaction_methodology <- "social network analysis"

colnames(diff_equation)[1] <- "n_paper"

diff_equation$interaction_methodology <- "differential equations"

colnames(linear_model)[1] <- "n_paper"

linear_model$interaction_methodology <- "linear model"

colnames(other_meth)[1] <- "n_paper"

other_meth$interaction_methodology <- "other"

inter_meth_final <- rbind(diff_equation, social_network, linear_model, other_meth)

inter_meth_final$interaction_methodology <- as.factor(inter_meth_final$interaction_methodology)

inter_meth_final$interaction_methodology <- factor(inter_meth_final$interaction_methodology, levels = c("differential equations", "social network analysis","linear model", "other"))

#final plot
hsize <- 4

inter_meth_final <- inter_meth_final %>% 
  mutate(x = hsize)

e3 <- ggplot(inter_meth_final, aes(x = hsize, y = n_paper, fill = interaction_methodology)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("black", "black", "white", "white")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Interaction Methodology'))


##DIRECTION####

coded_variables <- coded_variables %>% 
  mutate(
    no_direction = str_detect(direction, "no"),
    yes_direction = str_detect(direction, "yes")
  )

direction <- as.data.frame(coded_variables[,c("no_direction", "yes_direction")])

direction[direction == "TRUE" ] <- 1
direction[direction == "FALSE" ] <- 0

direction <- sapply(direction, as.numeric)
direction_n_papers <- data.frame(sort(colSums(direction)))
direction_n_papers$direction <- rownames(direction_n_papers)
colnames(direction_n_papers)[1] <- "n_paper"


hsize <- 4

direction_n_papers <- direction_n_papers %>% 
  mutate(x = hsize)

e4 <- ggplot(direction_n_papers, aes(x = hsize, y = n_paper, fill = direction)) +
  geom_col(color = "black") +
  geom_text(aes(label = n_paper),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("white", "black")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T, labels = c("no", "yes")) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Direction of Transmission'))


##EPIDEMIOLOGICAL MODELLING####

epidemiological_modelling <- as.data.frame(coded_variables %>% 
                           group_by(epidemiological_modelling) %>%
                           summarise(no_rows = length(epidemiological_modelling)))



colnames(epidemiological_modelling)[1] <- "epidemiological_modelling"

colnames(epidemiological_modelling)[2] <- "Count"

hsize <- 4

epidemiological_modelling <- epidemiological_modelling %>% 
  mutate(x = hsize)

e5 <- ggplot(epidemiological_modelling, aes(x = hsize, y = Count, fill = epidemiological_modelling)) +
  geom_col(color = "black") +
  geom_text(aes(label = Count),
            position = position_stack(vjust = 0.5), cex = 4.5, col = c("black", "white")) +
  coord_polar(theta = "y") +
  scale_fill_wa_d(wacolors$sea, reverse = T) +
  xlim(c(0.2, hsize + 0.5)) +
  theme(panel.background = element_rect(fill = "white"),
        panel.grid = element_blank(),
        axis.title = element_blank(),
        axis.ticks = element_blank(),
        axis.text = element_blank(),
        legend.position = c(.5,.5),
        legend.key.size = unit(0.8, 'cm'),
        legend.title = element_text(size=15),
        legend.text = element_text(size=15)) + guides(fill=guide_legend(title='Epidemiological Modelling'))


##EPIDEMIOLOGY PLOTS####
library(patchwork)

patchwork3 <- e + e1 + e2 + e3 

patchwork3 + plot_annotation(tag_levels = 'a') & 
  theme(plot.tag = element_text(size = 25, hjust = -3, vjust = -5, face = "bold"))

patchwork4 <- e4 + e5

patchwork4 + plot_annotation(tag_levels = 'a') & 
  theme(plot.tag = element_text(size = 30, hjust = -3, vjust = -5, face = "bold"))

####Percentage Calculations####

#Figure 4a
cattle = 216
wildlife = 157
both = 159
tot = 532
NA_ = 0

#category 1, cattle
(100/tot)*cattle
#category 2, wildlife
(100/tot)*wildlife
#category 3, both
(100/tot)*both

#Figure 4b  
badger = 156
possum = 52
buffalo = 13
wildboar = 56
cervid = 87
red_deer = 42
white_tailed_deer = 35
fallow_deer = 17
roe_deer = 8
elk = 5
sika = 1
munjac = 1
NA_ = 3 #only would be considered if dividing the total to see how many papers studied wildlife
Tot_wildlife = 313
tot = 532

#category 1, badger
(100/313)*badger
#category 2, wild boar
(100/313)*wildboar
#category 3, possum
(100/313)*possum
#category 4, buffalo
(100/313)*buffalo
#category 5, cervid
#all
(100/313)*cervid
#red
(100/313)*red_deer
#white
(100/313)*white_tailed_deer
#fallow
(100/313)*fallow_deer
#roe
(100/313)*roe_deer
#elk
(100/313)*elk
#sika
(100/313)*sika
#munjac
(100/313)*munjac

#Figure 4c
management = 132
vaccination = 30
culling = 95
other = 27
NA_ = 0
tot = 532

#category 1, no
(100/tot)*(tot-management)
#category 2, yes
#all
(100/tot)*management
#vaccination
(100/tot)*vaccination
#culling
(100/tot)*culling
#other
(100/tot)*other

#Figure 4d
empirical = 422
simulation = 18
both = 92
NA_ = 0
tot = 532

#category 1, empirical
(100/tot)*empirical
#category 2, simualtion
(100/tot)*simulation
#category 3, both
(100/tot)*both

#Figure 5a
no = 382
yes = 149
risk = 87
int_wildlife = 24
pos_samples = 19
cattle_mov_outside = 17
cattle_mov_inside = 2
int_cattle = 8
NA_ = 1
tot = 532

#category 1, no
(100/(tot-NA_))*no
#category 2, yes
#all
(100/(tot-NA_))*yes
#risk
(100/yes)*risk
#interaction wildlife
(100/yes)*int_wildlife
#distribution positive samples
(100/yes)*pos_samples
#cattle movement outside the farm
(100/yes)*cattle_mov_outside
#cattle movement inside the farm
(100/yes)*cattle_mov_inside
#interaction cattle
(100/yes)*int_cattle

#Figure 5b
no = 371
yes = 161
direct = 58
GPS = 31
simulation = 31
VHF = 11
camera_trap = 11
genetic = 17
indirect = 2
prox_log = 7
NA_ = 0
tot = 532

#category 1, no
(100/tot)*no
#category 2, yes
#all
(100/tot)*yes
#direct
(100/yes)*direct
#GPS
(100/yes)*GPS
#simulation
(100/yes)*simulation
#VHF
(100/yes)*VHF
#camera_trap
(100/yes)*camera_trap
#genetic
(100/yes)*genetic
#indirect
(100/yes)*indirect
#prox_log
(100/yes)*prox_log

#Figure 5c
no = 127
regional_lower = 383
national_higher = 22
NA_ = 2
tot = 532

#no
(100/(tot-NA_))*no
#regional and lower
(100/(tot-NA_))*regional_lower
#national and higher
(100/(tot-NA_))*national_higher

#Figure 5d
unreported = 22
snapshot = 189
interannual = 187
intraannual = 88
daily = 19
prediction = 65
NA_ = 8
tot = 532

#unreported
(100/(tot-NA_))*unreported
#snapshot
(100/(tot-NA_))*snapshot
#interannual
(100/(tot-NA_))*interannual
#intraannual
(100/(tot-NA_))*intraannual
#daily
(100/(tot-NA_))*daily
#prediction
(100/(tot-NA_))*prediction

#Figure 6a
no = 231
yes = 300
herd = 266
other = 129
env_cond = 70
farm_wildlife = 31
farm_farm = 59
NA_ = 1
tot = 532

#category 1, no
(100/(tot-NA_))*no
#category 2, yes
#all
(100/(tot-NA_))*yes
#herd
(100/(tot-NA_))*herd
#other
(100/(tot-NA_))*other
#environment in the farm
(100/(tot-NA_))*env_cond
#farm location in respect to wildlife
(100/(tot-NA_))*farm_wildlife
#farm location in respect to other farms
(100/(tot-NA_))*farm_farm

#Figure 6b
no = 358
yes = 174
habitat = 173
variation = 2
NA_ = 0
tot = 532

#category 1, no
(100/tot)*no
#category 2, yes
#all
(100/tot)*yes

#Figure 6c
no = 509
yes = 23
NA_ = 0
tot = 532

#category 1, no weather variables
(100/tot)*no
#category 2, yes weather variables
(100/tot)*yes

#Figure 6d
no = 397
yes = 135
NA_ = 0
tot = 532

#category 1, no human perturbations
(100/tot)*no
#category 2, yes human perturbations
(100/tot)*yes

#Figure 7a
no = 366
yes_interaction = 166
intra = 133
inter = 72
NA_ = 0
tot = 532

#category 1, no interactions
(100/tot)*no
#category 2, yes interactions
#all
(100/tot)*yes_interaction
#intra species
(100/tot)*intra
#inter species
(100/tot)*inter

#Figure 7b
direct = 54
indirect = 28
both = 84
NA_ = 0
tot = 532
yes_interaction = 166

#direct
(100/yes_interaction)*direct
#indirect
(100/yes_interaction)*indirect
#both
(100/yes_interaction)*both

#Figure 7c
simulation = 64
tech_tools = 48
direct = 38
genetic = 11
NA_ = 1
tot = 532
yes_interaction = 166

#simulation
(100/(yes_interaction-NA_))*simulation
#technological tools
(100/(yes_interaction-NA_))*tech_tools
#direct observations
(100/(yes_interaction-NA_))*direct
#genetic samples
(100/(yes_interaction-NA_))*genetic
  
#Figure 7d
diff_equation = 47
SN = 32
linear = 30
other = 63
NA_ = 1
tot = 532
yes_interaction = 166

#differential equations
(100/(yes_interaction-NA_))*diff_equation
#social networks
(100/(yes_interaction-NA_))*SN
#linear models
(100/(yes_interaction-NA_))*linear
#other methodology
(100/(yes_interaction-NA_))*other

#Figure 8a
no = 491
yes = 41
NA_ = 0
tot = 532

#no direction
(100/tot)*no
#yes direction
(100/tot)*yes

#Figure 8b
no = 451
yes = 81
NA_ = 0
tot = 532

#no epidemiological modelling
(100/tot)*no
#yes epidemiological modelling
(100/tot)*yes




