######################################
#
# BUSCO summary figure
# @version 4.0.0
# @since BUSCO 2.0.0
# 
# Copyright (c) 2016-2021, Evgeny Zdobnov (ez@ezlab.org)
# Licensed under the MIT license. See LICENSE.md file.
#
######################################

# Load the required libraries
library(ggplot2)
library("grid")

# !!! CONFIGURE YOUR PLOT HERE !!! 
# Output
my_output <- paste("bsco_summaries/","busco_figure.png",sep="/") 
my_width <- 20
my_height <- 15
my_unit <- "cm"

# Colors
my_colors <- c("#56B4E9", "#3492C7", "#F0E442", "#F04442")
# Bar height ratio
my_bar_height <- 0.75

# Legend
my_title <- "BUSCO Assessment Results"

# Font
my_family <- "sans"
my_size_ratio <- 1

# !!! SEE YOUR DATA HERE !!! 
# Your data as generated by python, remove or add more
my_species <- c('Chordata_Petromyzon_marinus', 'Chordata_Petromyzon_marinus', 'Chordata_Petromyzon_marinus', 'Chordata_Petromyzon_marinus', 'Deuterostome_Ambulacraria_SKow', 'Deuterostome_Ambulacraria_SKow', 'Deuterostome_Ambulacraria_SKow', 'Deuterostome_Ambulacraria_SKow', 'Deuterostome_Chordata_HomoSapiens', 'Deuterostome_Chordata_HomoSapiens', 'Deuterostome_Chordata_HomoSapiens', 'Deuterostome_Chordata_HomoSapiens', 'Lophotrocozoa_Platynereis_dumerilii', 'Lophotrocozoa_Platynereis_dumerilii', 'Lophotrocozoa_Platynereis_dumerilii', 'Lophotrocozoa_Platynereis_dumerilii', 'Protostome_Ecdysozoa_Dmel_UP000000803_7227', 'Protostome_Ecdysozoa_Dmel_UP000000803_7227', 'Protostome_Ecdysozoa_Dmel_UP000000803_7227', 'Protostome_Ecdysozoa_Dmel_UP000000803_7227', 'Protostome_Ecdysozoa_Nematode_CelegUP000001940_6239', 'Protostome_Ecdysozoa_Nematode_CelegUP000001940_6239', 'Protostome_Ecdysozoa_Nematode_CelegUP000001940_6239', 'Protostome_Ecdysozoa_Nematode_CelegUP000001940_6239', 'Prrebilateria_Cnidaria_Alatina_alata_prot', 'Prrebilateria_Cnidaria_Alatina_alata_prot', 'Prrebilateria_Cnidaria_Alatina_alata_prot', 'Prrebilateria_Cnidaria_Alatina_alata_prot', 'Prrebilateria_Cnidaria_Clytia_hemisphaerica_prot', 'Prrebilateria_Cnidaria_Clytia_hemisphaerica_prot', 'Prrebilateria_Cnidaria_Clytia_hemisphaerica_prot', 'Prrebilateria_Cnidaria_Clytia_hemisphaerica_prot', 'Prrebilateria_Cnidaria_Corallium_rubrum_prot', 'Prrebilateria_Cnidaria_Corallium_rubrum_prot', 'Prrebilateria_Cnidaria_Corallium_rubrum_prot', 'Prrebilateria_Cnidaria_Corallium_rubrum_prot', 'Prrebilateria_Cnidaria_Exaiptasia_pallida', 'Prrebilateria_Cnidaria_Exaiptasia_pallida', 'Prrebilateria_Cnidaria_Exaiptasia_pallida', 'Prrebilateria_Cnidaria_Exaiptasia_pallida', 'Prrebilateria_Cnidaria_Hydra_vulgarisAEP', 'Prrebilateria_Cnidaria_Hydra_vulgarisAEP', 'Prrebilateria_Cnidaria_Hydra_vulgarisAEP', 'Prrebilateria_Cnidaria_Hydra_vulgarisAEP', 'Prrebilateria_Cnidaria_Nematostella_vectensis_combined_cdhit085', 'Prrebilateria_Cnidaria_Nematostella_vectensis_combined_cdhit085', 'Prrebilateria_Cnidaria_Nematostella_vectensis_combined_cdhit085', 'Prrebilateria_Cnidaria_Nematostella_vectensis_combined_cdhit085', 'Prrebilateria_Cnidaria_Polypodium_hydriforme_GBGH01', 'Prrebilateria_Cnidaria_Polypodium_hydriforme_GBGH01', 'Prrebilateria_Cnidaria_Polypodium_hydriforme_GBGH01', 'Prrebilateria_Cnidaria_Polypodium_hydriforme_GBGH01', 'Prrebilateria_Cnidaria_Rhopilema_esculentum_prot', 'Prrebilateria_Cnidaria_Rhopilema_esculentum_prot', 'Prrebilateria_Cnidaria_Rhopilema_esculentum_prot', 'Prrebilateria_Cnidaria_Rhopilema_esculentum_prot', 'Prrebilateria_Cnidaria_Staurozoa_Caladosia_cruxmelitensis', 'Prrebilateria_Cnidaria_Staurozoa_Caladosia_cruxmelitensis', 'Prrebilateria_Cnidaria_Staurozoa_Caladosia_cruxmelitensis', 'Prrebilateria_Cnidaria_Staurozoa_Caladosia_cruxmelitensis', 'Prrebilateria_Ctenophora_Pleurobrachia_bachei_prot', 'Prrebilateria_Ctenophora_Pleurobrachia_bachei_prot', 'Prrebilateria_Ctenophora_Pleurobrachia_bachei_prot', 'Prrebilateria_Ctenophora_Pleurobrachia_bachei_prot', 'Prrebilaterian_Ctenophore_mnemiopsisleydi_NIHtrinity_prot', 'Prrebilaterian_Ctenophore_mnemiopsisleydi_NIHtrinity_prot', 'Prrebilaterian_Ctenophore_mnemiopsisleydi_NIHtrinity_prot', 'Prrebilaterian_Ctenophore_mnemiopsisleydi_NIHtrinity_prot', 'Prrebilaterian_Ctenophores_Hormiphora_californiensis', 'Prrebilaterian_Ctenophores_Hormiphora_californiensis', 'Prrebilaterian_Ctenophores_Hormiphora_californiensis', 'Prrebilaterian_Ctenophores_Hormiphora_californiensis', 'Prrebilaterian_Placozoan_Hoilungahon_BRAKER1_proteins', 'Prrebilaterian_Placozoan_Hoilungahon_BRAKER1_proteins', 'Prrebilaterian_Placozoan_Hoilungahon_BRAKER1_proteins', 'Prrebilaterian_Placozoan_Hoilungahon_BRAKER1_proteins', 'Prrebilaterian_PlacozoanTrichoplaxAdrianoSenatore', 'Prrebilaterian_PlacozoanTrichoplaxAdrianoSenatore', 'Prrebilaterian_PlacozoanTrichoplaxAdrianoSenatore', 'Prrebilaterian_PlacozoanTrichoplaxAdrianoSenatore', 'Prrebilaterian_Porifera_EphydatiaMuAlbertaCdHiited096', 'Prrebilaterian_Porifera_EphydatiaMuAlbertaCdHiited096', 'Prrebilaterian_Porifera_EphydatiaMuAlbertaCdHiited096', 'Prrebilaterian_Porifera_EphydatiaMuAlbertaCdHiited096', 'Prrebilaterian_Porifera_Oscarella_carmella_prot', 'Prrebilaterian_Porifera_Oscarella_carmella_prot', 'Prrebilaterian_Porifera_Oscarella_carmella_prot', 'Prrebilaterian_Porifera_Oscarella_carmella_prot', 'Prrebilaterian_Porifera_Sycon_ciliatum', 'Prrebilaterian_Porifera_Sycon_ciliatum', 'Prrebilaterian_Porifera_Sycon_ciliatum', 'Prrebilaterian_Porifera_Sycon_ciliatum', 'Prrebilateria_porifera_Amphimedon_queenslandicaUP000007879_400682', 'Prrebilateria_porifera_Amphimedon_queenslandicaUP000007879_400682', 'Prrebilateria_porifera_Amphimedon_queenslandicaUP000007879_400682', 'Prrebilateria_porifera_Amphimedon_queenslandicaUP000007879_400682', 'Prrebilateria_Tethya_wilhelma_trinity_transdecoder', 'Prrebilateria_Tethya_wilhelma_trinity_transdecoder', 'Prrebilateria_Tethya_wilhelma_trinity_transdecoder', 'Prrebilateria_Tethya_wilhelma_trinity_transdecoder', 'zOUTGROUP_Choanoflagellatea_Monosiga_brevicollis_UP000001357_81824', 'zOUTGROUP_Choanoflagellatea_Monosiga_brevicollis_UP000001357_81824', 'zOUTGROUP_Choanoflagellatea_Monosiga_brevicollis_UP000001357_81824', 'zOUTGROUP_Choanoflagellatea_Monosiga_brevicollis_UP000001357_81824', 'zOUTGROUP_Choanoflagellatea_Salpingoeca_rosetta_UP000007799_946362', 'zOUTGROUP_Choanoflagellatea_Salpingoeca_rosetta_UP000007799_946362', 'zOUTGROUP_Choanoflagellatea_Salpingoeca_rosetta_UP000007799_946362', 'zOUTGROUP_Choanoflagellatea_Salpingoeca_rosetta_UP000007799_946362', 'zOutgroup_Filasterea_Capsaspora_owczarzaki_UP000008743_595528', 'zOutgroup_Filasterea_Capsaspora_owczarzaki_UP000008743_595528', 'zOutgroup_Filasterea_Capsaspora_owczarzaki_UP000008743_595528', 'zOutgroup_Filasterea_Capsaspora_owczarzaki_UP000008743_595528', 'zOutgroup_FILASTERIA_Tunicaraptor_prot', 'zOutgroup_FILASTERIA_Tunicaraptor_prot', 'zOutgroup_FILASTERIA_Tunicaraptor_prot', 'zOutgroup_FILASTERIA_Tunicaraptor_prot')
my_species <- factor(my_species)
my_species <- factor(my_species,levels(my_species)[c(length(levels(my_species)):1)]) # reorder your species here just by changing the values in the vector :
my_percentage <- c(60.8, 10.2, 11.4, 17.6, 91.4, 2.7, 3.5, 2.4, 97.6, 2.4, 0.0, 0.0, 87.5, 3.1, 5.5, 3.9, 99.6, 0.4, 0.0, 0.0, 96.9, 0.8, 0.8, 1.5, 76.5, 20.0, 2.4, 1.1, 56.5, 35.3, 5.5, 2.7, 56.5, 33.3, 4.7, 5.5, 77.3, 8.6, 10.2, 3.9, 96.1, 1.2, 1.6, 1.1, 92.5, 6.7, 0.8, -0.0, 13.7, 64.7, 14.5, 7.1, 62.4, 35.7, 1.2, 0.7, 64.7, 15.3, 14.9, 5.1, 30.2, 49.4, 13.7, 6.7, 83.5, 6.3, 5.1, 5.1, 39.6, 55.3, 1.6, 3.5, 89.0, 3.9, 2.4, 4.7, 98.8, 0.4, 0.4, 0.4, 81.2, 16.1, 1.6, 1.1, 87.1, 8.2, 2.7, 2.0, 91.0, 6.3, 2.0, 0.7, 88.2, 4.3, 7.1, 0.4, 62.4, 33.7, 1.2, 2.7, 78.8, 0.0, 7.5, 13.7, 83.1, 0.0, 6.7, 10.2, 92.9, 0.8, 2.4, 3.9, 64.7, 9.4, 16.5, 9.4)
my_values <- c(155, 26, 29, 45, 233, 7, 9, 6, 249, 6, 0, 0, 223, 8, 14, 10, 254, 1, 0, 0, 247, 2, 2, 4, 195, 51, 6, 3, 144, 90, 14, 7, 144, 85, 12, 14, 197, 22, 26, 10, 245, 3, 4, 3, 236, 17, 2, 0, 35, 165, 37, 18, 159, 91, 3, 2, 165, 39, 38, 13, 77, 126, 35, 17, 213, 16, 13, 13, 101, 141, 4, 9, 227, 10, 6, 12, 252, 1, 1, 1, 207, 41, 4, 3, 222, 21, 7, 5, 232, 16, 5, 2, 225, 11, 18, 1, 159, 86, 3, 7, 201, 0, 19, 35, 212, 0, 17, 26, 237, 2, 6, 10, 165, 24, 42, 24)

######################################
######################################
######################################
# Code to produce the graph
labsize = 1
if (length(levels(my_species)) > 10){
 labsize = 0.66
}
print("Plotting the figure ...")
category <- c(rep(c("S","D","F","M"),c(1)))
category <-factor(category)
category = factor(category,levels(category)[c(4,1,2,3)])
df = data.frame(my_species,my_percentage,my_values,category)

figure <- ggplot() + 
  
  geom_bar(aes(y = my_percentage, x = my_species, fill = category), position = position_stack(reverse = TRUE), data = df, stat="identity", width=my_bar_height) + 
  coord_flip() + 
  theme_gray(base_size = 8) + 
  scale_y_continuous(labels = c("0","20","40","60","80","100"), breaks = c(0,20,40,60,80,100)) + 
  scale_fill_manual(values = my_colors,labels =c(" Complete (C) and single-copy (S)  ",
                                                 " Complete (C) and duplicated (D)",
                                                 " Fragmented (F)  ",
                                                 " Missing (M)")) +   
  ggtitle(my_title) + 
  xlab("") + 
  ylab("\n%BUSCOs") + 

  theme(plot.title = element_text(family=my_family, hjust=0.5, colour = "black", size = rel(2.2)*my_size_ratio, face = "bold")) + 
  theme(legend.position="top",legend.title = element_blank()) + 
  theme(legend.text = element_text(family=my_family, size = rel(1.2)*my_size_ratio)) + 
  theme(panel.background = element_rect(color="#FFFFFF", fill="white")) + 
  theme(panel.grid.minor = element_blank()) + 
  theme(panel.grid.major = element_blank()) +
  theme(axis.text.y = element_text(family=my_family, colour = "black", size = rel(1.66)*my_size_ratio)) + 
  theme(axis.text.x = element_text(family=my_family, colour = "black", size = rel(1.66)*my_size_ratio)) + 
  theme(axis.line = element_line(size=1*my_size_ratio, colour = "black")) + 
  theme(axis.ticks.length = unit(.85, "cm")) + 
  theme(axis.ticks.y = element_line(colour="white", size = 0)) + 
  theme(axis.ticks.x = element_line(colour="#222222")) + 
  theme(axis.ticks.length = unit(0.4, "cm")) + 
  theme(axis.title.x = element_text(family=my_family, size=rel(1.2)*my_size_ratio)) + 
  
  guides(fill = guide_legend(override.aes = list(colour = NULL))) +
  guides(fill=guide_legend(nrow=2,byrow=TRUE))
  
  for(i in rev(c(1:length(levels(my_species))))){
    detailed_values <- my_values[my_species==my_species[my_species==levels(my_species)[i]]]
    total_buscos <- sum(detailed_values)
    figure <- figure + 
    annotate("text", label=paste("C:", detailed_values[1] + detailed_values[2], " [S:", detailed_values[1], ", D:", detailed_values[2], "], F:", detailed_values[3], ", M:", detailed_values[4], ", n:", total_buscos, sep=""), 
             y=3, x = i, size = labsize*4*my_size_ratio, colour = "black", hjust=0, family=my_family)
  }
  
ggsave(figure, file=my_output, width = my_width, height = my_height, unit = my_unit)
print("Done")
