# SPEI
rm(list=ls())
library(terra)
library(foreach)
library(doParallel)
library(TDPanalysis)   # date.to.DOY()
#===========================================================
#spei
speipath <- "D:/Work/Warming_cooling_aut/data/SPEI_base_resample/SPEI03/"

#dfs path, GIMMS SOS, raster
dfspath <- "D:/Work/Warming_cooling_aut/data/GIMMS_EOS/"

#out path
outpath <- "D:/Work/Warming_cooling_aut/process/process0611/GIMMS/6-spei/analyses/"
#===========================================================
yysrt <- 2004
yyend <- 2018
setwd("D:/Work/Warming_cooling_aut/process/process0611/GIMMS/1-sensitivity/spatial/")

data <- read.csv("predata.csv")
data <- data[,-1]
inf <- data[,c("grididx","gridlat","gridlon")]
geo <- inf
geo <- vect(geo,geom=c("gridlon","gridlat"),crs="+proj=longlat +datum=WGS84")

#DFS
setwd(dfspath)
phn <- paste0("EOS_mean_",c(yysrt:yyend),".tif")
phn <- rast(phn)
phn <- terra::extract(phn,geo)
phn <- data.frame(sapply(phn, function(x) ifelse(is.nan(x), NA, x)))
phn <- phn[,-1]
phn <- round(phn)
colnames(phn) <- paste0("EOS_",yysrt:yyend)
phnmean <- round(apply(phn,1,mean))
phn <- cbind(inf,phn)
rownames(phn) <- 1:dim(phn)[1]

#=============================
result.all <- inf
for (yy in yysrt:yyend){
  print(yy)
  #spei data
  dates <- seq(from=as.Date(paste0(yy,"-01-01")),to=as.Date(paste0(yy,"-12-31")),by='1 month')
  dates <- substr(gsub("-","_",dates),1,7)
  files <- paste0(speipath,"spei03_N30_",dates,".tif")
  
  spei <- rast(files)
  spei <- extract(spei,geo)
  spei <- data.frame(sapply(spei, function(x) ifelse(is.nan(x), NA, x)))
  spei <- spei[,-1]
  colnames(spei) <- paste0("spei_",dates)
  #===========================================================
  #do parallel calculation
  numcluster <- 50
  registerDoParallel(numcluster)
  print("parallel-start")
  result <- foreach (i=1:dim(phn)[1], .packages = c("TDPanalysis"), .combine=rbind) %dopar% {
    #----------------------------------------------------
    #SPEI, optimal length
    doy  <- phnmean[i]
    optlength <- data$optimallength_tmppart[i]
    srtdoy  <- doy - optlength + 1
    srtdate <- as.Date(paste(yy,srtdoy), format = "%Y %j")
    enddate <- as.Date(paste(yy,doy), format = "%Y %j")
    period <- seq(from=as.Date(srtdate),to=as.Date(enddate),by='1 day')
    period <- gsub("-","_",period)
    period <- substr(period,1,7)
    period <- unique(period)
    speidat <- spei[i,paste0("spei_",period)]
    spei03_m01 <- round(mean(as.numeric(speidat)),3)
    
    cf_data <- c(spei03_m01)
    
  }
  #===========================================================
  stopImplicitCluster()  #stop
  result <- as.data.frame(result)
  colnames(result) <- paste0("spei03","_",yy)
  #===========================================================
  result.all <- cbind(result.all,result)
}
rownames(result.all) <- 1:dim(result.all)[1]
write.csv(result.all,paste0(outpath,"spei03_GIMMS_",yysrt,"_",yyend,".csv"))
