# frost days
rm(list=ls())
library(terra)
library(foreach)
library(doParallel)
library(TDPanalysis)   # date.to.DOY()
#===========================================================
#daily mean temperature, MSWX daily data set
tmppath <- "F:/Data/Climate/MSWX_V100/daily/past/Temp/0.083deg/"

#daily maxmium temperature, MSWX daily data set
tmxpath <- "F:/Data/Climate/MSWX_V100/daily/past/Tmax/0.083deg/"

#daily minimum temperature, MSWX daily data set
tmnpath <- "F:/Data/Climate/MSWX_V100/daily/past/Tmin/0.083deg/"

#dfs path, GIMMS SOS, raster
dfspath <- "D:/Work/Warming_cooling_aut/data/GIMMS_EOS/"

#out path
outpath <- "D:/Work/Warming_cooling_aut/process/process0611/GIMMS/4-frost-days/analyses/"
#===========================================================
yysrt <- 2004
yyend <- 2018

setwd("D:/Work/Warming_cooling_aut/process/process0611/GIMMS/1-sensitivity/spatial/")
data <- read.csv("predata.csv")
data <- data[,-1]
inf <- data[,c("grididx","gridlat","gridlon")]
geo <- inf
geo <- vect(geo,geom=c("gridlon","gridlat"),crs="+proj=longlat +datum=WGS84")

#LSD
setwd(dfspath)
phn <- paste0("EOS_mean_",c(yysrt:yyend),".tif")
phn <- rast(phn)
phn <- terra::extract(phn,geo)
phn <- data.frame(sapply(phn, function(x) ifelse(is.nan(x), NA, x)))
phn <- phn[,-1]
phn <- round(phn)
colnames(phn) <- paste0("EOS_",yysrt:yyend)
phn <- cbind(inf,phn)
rownames(phn) <- 1:dim(phn)[1]
#=============================
result.all <- inf
for (yy in yysrt:yyend){
  print(yy)
  #date
  dates <- seq(from=as.Date(paste0(yy,"-01-01")),to=as.Date(paste0(yy,"-12-31")),by='1 day')
  dates <- gsub("-","/",dates)
  dates <- paste0(substr(dates,1,4),sprintf("%03d",date.to.DOY(dates, format = "yyyy/mm/dd")))
  #daily min temperature
  setwd(tmnpath)
  tminras   <- paste0(dates,".tif")
  tmin_dat <- rast(tminras)
  tmin_dat <- terra::extract(tmin_dat,geo)
  tmin_dat <- data.frame(sapply(tmin_dat, function(x) ifelse(is.nan(x), NA, x)))
  colnames(tmin_dat) <- c("ID",paste0("tmn_",dates))
  #===========================================================
  #do parallel calculation
  numcluster <- 50
  registerDoParallel(numcluster)
  print("parallel-start")
  result <- foreach (i=1:dim(phn)[1], .packages = c("TDPanalysis"), .combine=rbind) %dopar% {
    #----------------------------------------------------
    #frost days during optimal preseason
    doy  <- round(mean(as.numeric(phn[i,paste0("EOS_",2004:2018)])))
    optimallength <- data[i,"optimallength_tmppart"]
    srtdate <- as.Date(paste(yy,doy-optimallength), format = "%Y %j")
    enddate <- as.Date(paste(yy,doy), format = "%Y %j")
    period <- seq(from=as.Date(srtdate),to=as.Date(enddate),by='1 day')
    period <- gsub("-","/",period)
    period <- paste0(substr(period,1,4),sprintf("%03d",date.to.DOY(period, format = "yyyy/mm/dd")))
    tmin <- tmin_dat[i,paste0("tmn_",period)]
    #based temperature:0 deg
    tmin[tmin >= 0] <- 0
    tmin[tmin < 0] <- 1
    frost_m01 <- sum(tmin)

    cf_data <- c(frost_m01)
  }
  #===========================================================
  stopImplicitCluster()  #stop
  result <- as.data.frame(result)
  colnames(result) <- paste0("frost","_",yy)
  #===========================================================
  result.all <- cbind(result.all,result)
}
rownames(result.all) <- 1:dim(result.all)[1]
write.csv(result.all,paste0(outpath,"frost_days_GIMMS_preseason_",yysrt,"_",yyend,".csv"))