#Cold degree days
rm(list=ls())
library(terra)
library(foreach)
library(doParallel)
library(TDPanalysis)   # date.to.DOY()
#===========================================================
#daily mean temperature, MSWX daily data set
tmppath <- "F:/Data/Climate/MSWX_V100/daily/past/Temp/0.083deg/"

#daily maxmium temperature, MSWX daily data set
tmxpath <- "F:/Data/Climate/MSWX_V100/daily/past/Tmax/0.083deg/"

#daily minimum temperature, MSWX daily data set
tmnpath <- "F:/Data/Climate/MSWX_V100/daily/past/Tmin/0.083deg/"

#dfs path, PKU GIMMS EOS, raster
dfspath <- "D:/Work/Warming_cooling_aut/data/GIMMS_EOS/"

#out path
outpath <- "D:/Work/Warming_cooling_aut/process/process0611/GIMMS/2-cdd/analyses/"
#===========================================================
setwd("D:/Work/Warming_cooling_aut/process/process0611/GIMMS/1-sensitivity/spatial/")
yysrt <- 2004
yyend <- 2018

data <- read.csv("predata.csv")
data <- data[,-1]
inf <- data[,c("grididx","gridlat","gridlon")]
geo <- inf
geo <- vect(geo,geom=c("gridlon","gridlat"),crs="+proj=longlat +datum=WGS84")

#DFS
setwd(dfspath)
phn <- paste0("EOS_mean_",c(yysrt:yyend),".tif")
phn <- rast(phn)
phn <- terra::extract(phn,geo)
phn <- data.frame(sapply(phn, function(x) ifelse(is.nan(x), NA, x)))
phn <- phn[,-1]
phn <- round(phn)
colnames(phn) <- paste0("EOS_",yysrt:yyend)
phn <- cbind(inf,phn)
rownames(phn) <- 1:dim(phn)[1]
#=============================
result.all <- inf
for (yy in yysrt:yyend){
  print(yy)
  #temperature data
  dates <- seq(from=as.Date(paste0(yy,"-01-01")),to=as.Date(paste0(yy,"-12-31")),by='1 day')
  dates <- gsub("-","/",dates)
  dates <- paste0(substr(dates,1,4),sprintf("%03d",date.to.DOY(dates, format = "yyyy/mm/dd")))
  #daily mean temperature
  setwd(tmppath)
  tmpras   <- paste0(dates,".tif")
  tavg_dat <- rast(tmpras)
  tavg_dat <- terra::extract(tavg_dat,geo)
  tavg_dat <- data.frame(sapply(tavg_dat, function(x) ifelse(is.nan(x), NA, x)))
  colnames(tavg_dat) <- c("ID",paste0("tas_",dates))
  #===========================================================
  #do parallel calculation
  numcluster <- 50
  registerDoParallel(numcluster)
  print("parallel-start")
  result <- foreach (i=1:dim(phn)[1], .packages = c("TDPanalysis"), .combine=rbind) %dopar% {
    #----------------------------------------------------
    #Cold degree days since 1st July
    doy  <- phn[i,paste0("EOS_",yy)]
    srtdate <- paste0(yy,"-07-01") #from 1st July
    enddate <- as.Date(paste(yy,doy), format = "%Y %j")
    period <- seq(from=as.Date(srtdate),to=as.Date(enddate),by='1 day')
    period <- gsub("-","/",period)
    period <- paste0(substr(period,1,4),sprintf("%03d",date.to.DOY(period, format = "yyyy/mm/dd")))
    tavg <- tavg_dat[i,paste0("tas_",period)]
    

    #based temperature:5 deg
    tavg0 <- 5 - tavg
    tavg0[tavg0 <  0] <- 0
    cdd_m01 <- round(sum(tavg0),1)
    #based temperature:10 deg
    tavg0 <- 10 - tavg
    tavg0[tavg0 <  0]   <- 0
    cdd_m02 <- round(sum(tavg0),1)
    #based temperature:15 deg
    tavg0 <- 15 - tavg
    tavg0[tavg0 <  0]   <- 0
    cdd_m03 <- round(sum(tavg0),1)
   
    cf_data <- c(cdd_m01,cdd_m02,cdd_m03)
    
  }
  #===========================================================
  stopImplicitCluster()  #stop
  result <- as.data.frame(result)
  colnames(result) <- paste0(c("cdd_m01","cdd_m02","cdd_m03"),"_",yy)
  #===========================================================
  result.all <- cbind(result.all,result)
}
rownames(result.all) <- 1:dim(result.all)[1]
write.csv(result.all,paste0(outpath,"cdd_GIMMS_autumn_",yysrt,"_",yyend,".csv"))
