load('synchrosimulation.mat')
fs = 14;
lw = 2;
opotime = 10*log10(opotime*1000);
solitontime = 10*log10(solitontime*1000);
colormin = min([min(min(opotime)),min(min(solitontime))]);
colormax = max([max(max(opotime)),max(max(solitontime))]);
hf = figure('position',[100,500,350,350],'DefaultAxesFontName', 'Arial');
set(gcf,'units','inches');
figsize = get(gcf,'position');
set(gcf,'papersize',figsize(3:4));
[x,y] = meshgrid(tfast*1e12,tslow*1e9);
ht = tiledlayout(2,1,'tilespacing','tight');
nexttile
pcolor(x,y,opotime)
shading interp
set(gca,'fontsize',fs,'linewidth',lw,'xticklabel',[])
clim([colormin,colormax])
colormap hot

nexttile
pcolor(x,y,solitontime)
shading interp
set(gca,'fontsize',fs,'linewidth',lw)
clim([colormin,colormax])
colormap hot
xlabel(ht,'Fast Time (ps)','fontsize',fs)
ylabel(ht,'Slow Time (ns)','fontsize',fs)
cb = colorbar;
cb.Layout.Tile = 'east';
cb.YLabel.String = 'Intracavity Power (dBm)';
cb.YLabel.FontSize = fs;

% print -depsc SynchroColor
print -dpdf -vector SynchroColor
