filename = 'output3.txt';
lw = 2;
fs = 14;
fid = fopen(filename);
ntrack = 1;
subtrack = 0;
Nmax = 100000;
t = zeros(1,Nmax);
pcoupled = zeros(50,Nmax);
puncoupled = zeros(50,Nmax);
freq = zeros(1,50);
datalength = 0;
while ~feof(fid)
    str1 = fgetl(fid);
    if str1(1) == 'N'
        num = regexp(str1, '\d+\.?\d*', 'match');
        freq(ntrack) = str2num(num{1});
    elseif str1(1) == 'C'
        num = regexp(str1, '\d+\.?\d*', 'match');
        coupling = str2num(num{1});
        if coupling > 0
            coupled = true;
        else
            coupled = false;
        end
    elseif str1(1) == '#'
        if coupled
            ntrack = ntrack+1;
        end
        if datalength == 0
            datalength = subtrack;
        end
        subtrack = 0;
%         break
    elseif ~isnan(str2double(str1(1))) || str1(1) == '-'
        subtrack = subtrack+1;
        x = str2num(str1);
        t(subtrack) = x(1);
        if coupled
            pcoupled(ntrack,subtrack) = x(3);
        else
            puncoupled(ntrack,subtrack) = x(3);
        end
    end

end
fclose(fid);
pcoupled = pcoupled(1:ntrack-1,1:datalength);
puncoupled = puncoupled(1:ntrack-1,1:datalength);
freq = freq(1:ntrack-1);
t = t(1:datalength);
start = 500;
amp1 = zeros(1,ntrack-1);
amp2 = zeros(1,ntrack-1);
for ii = 1:ntrack-1
    tpick = t(start:end);
    phipick = pcoupled(ii,start:end)-mean(pcoupled(ii,start:end));
%     figure
%     plot(tpick,phipick)
    ft = fittype(['-a*cos(' num2str(2*pi*freq(ii)) '*x+b)+c']);
    fitresult = fit(tpick',phipick',ft,'startpoint',[0.001,0,mean(phipick)]);
%     hold on
%     plot(fitresult,'--')
    amp1(ii) = fitresult.a;
    phipick = puncoupled(ii,start:end)-mean(puncoupled(ii,start:end));
%     figure
%     plot(tpick,phipick)
    ft = fittype(['a*sin(' num2str(2*pi*freq(ii)) '*x+b)+c']);
    fitresult = fit(tpick',phipick',ft,'startpoint',[0.01,-pi/2,mean(phipick)]);
%     hold on
%     plot(fitresult,'--')
    amp2(ii) = fitresult.a;
end

factor = 20*log10(amp1./amp2);
factor(end-1:end) = 0;
figure('position',[100,500,300,340]);
set(gcf,'units','inches');
figsize = get(gcf,'position');
set(gcf,'papersize',figsize(3:4));
% figure('position',[100,500,350,300])
semilogx(freq,factor,'+-','linewidth',lw);
xlim([1e3,1e9])
ylim([-80,0])
set(gca,'linewidth',lw,'fontsize',fs,'xtick',[1e3,1e5,1e7,1e9],'ytick',-200:20:0)
xlabel('Offset Frequency (Hz)','fontsize',fs)
ylabel('Residue Noise (dB)','fontsize',fs)
grid on
% print -depsc SynchroBandwidth
print -dpdf -vector SynchroBandwidth
