fs = 14;
lw = 1.5;
colors = ["#0072BD","#D95319","#EDB120","#7E2F8E","#77AC30","#4DBEEE","#A2142F"];
load('Synchro220GHz_2.mat')
f = f1;
nsync = p1;
nunsync = p2;
ncold = p3;
nopo = p4;
npump = p5;
nsw = p6;
nlw = p7;
load('thermalnoise2.mat')
pick = f>1e2 & f<0.98e6;
pick2 = f1>3e3 & f1<0.98e6;
figure('position',[100,500,430,300])
set(gcf,'units','inches');
figsize = get(gcf,'position');
set(gcf,'papersize',figsize(3:4));
semilogx(f(pick),10*log10(npump(pick)./f(pick).^2),'linewidth',lw,'color',colors(3))
hold on
semilogx(f(pick),10*log10(nsw(pick)./f(pick).^2),'linewidth',lw,'color',colors(2))
semilogx(f(pick),10*log10(nopo(pick)./f(pick).^2),'linewidth',lw,'color',colors(1))
semilogx(f4(pick2),10*log10(noise4(pick2)./f4(pick2).^2),'linewidth',lw,'color',colors(4))
ylim([-105,15]);
set(gca,'linewidth',2,'fontsize',fs,'xtick',[1e3,1e4,1e5,1e6])
xlabel('Offset Frequency (Hz)','fontsize',fs)
ylabel('SSB Phase Noise (dBc/Hz)','fontsize',fs)
legend('Pump','Signal','Differential','Thermal','edgecolor','w','fontsize',fs)%
xlim([3e2,1e6])
grid on
% print -depsc SynchroOPO
print -dpdf -vector SynchroOPO

figure('position',[100,500,430,300])
set(gcf,'units','inches');
figsize = get(gcf,'position');
set(gcf,'papersize',figsize(3:4));
semilogx(f(pick),10*log10(nopo(pick)./f(pick).^2),'linewidth',lw,'color',colors(1))
hold on
semilogx(f(pick),10*log10(nunsync(pick)./f(pick).^2),'linewidth',lw,'color',colors(2))
semilogx(f(pick),10*log10(nsync(pick)./f(pick).^2),'linewidth',lw,'color',colors(4))
semilogx(f(pick),10*log10(ncold(pick)./f(pick).^2),'linewidth',lw,'color',colors(3))
ylim([-120,0]);
set(gca,'linewidth',2,'fontsize',fs,'xtick',[1e3,1e4,1e5,1e6])
xlabel('Offset Frequency (Hz)','fontsize',fs)
ylabel('SSB Phase Noise (dBc/Hz)','fontsize',fs)
legend('OPO','Free-Running','Synchronized','Unbiased','edgecolor','w','fontsize',fs)%
xlim([3e2,1e6])
grid on
% print -depsc SynchroSoliton
print -dpdf -vector SynchroSoliton
