heaterV = [2645, 2650, 2655, 2660, 2663, 2666, 2670, 2675, 2680, 2685, 2690];
Beat = [44.49, 33.31, 22.03, 12.65, 5.14, 0, 0, 10.98, 20.75, 28.15, 47.76];
heaterP = heaterV.^2/250/1e3;
x1 = heaterP(1:6);
y1 = Beat(1:6);
x2 = heaterP(7:end);
y2 = Beat(7:end);
p1 = polyfit(x1(1:end-1),y1(1:end-1),1);
p2 = polyfit(x2(2:end),y2(2:end),1);
figure('position', [100,500,270,300]);
set(gcf,'units','inches');
figsize = get(gcf,'position');
set(gcf,'papersize',figsize(3:4));
plot((heaterP-heaterP(1))*100, Beat,'o','markerfacecolor','b','markersize',8);
hold on
plot((x1-heaterP(1))*100,p1(1)*x1+p1(2),'r','linewidth',2);
plot((x2-heaterP(1))*100,p2(1)*x2+p2(2),'r','linewidth',2);

set(gca,'linewidth',2,'fontsize',14,'xtick',0:20:100)
xlabel('Comb Line Shift (MHz)','fontsize',14)
ylabel('Beat Frequency (MHz)','fontsize',14)
ylim([0,50])

% print -depsc LockingBandwidth2D
print -dpdf -vector LockingBandwidth2D