filepath = './';
filename = 'Beatnote__2645.txt';
heaterV = [2645, 2650, 2655, 2660, 2663, 2666, 2670, 2675, 2680, 2685, 2690];

p = zeros(length(heaterV),5000);
for ii = 1:length(heaterV)
    A = readtable(fullfile(filepath,['Beatnote__' num2str(heaterV(ii)) '.txt']));
    f = table2array(A(1,3:end));
    f_finer = linspace(f(1),f(end),5000);
    p(ii,:) = interp1(f,table2array(A(2,3:end)),f_finer);
end

[x,y] = meshgrid(f_finer/1e6,heaterV.^2/250/1e3);
figure('position',[100,500,430,330])
set(gcf,'units','inches');
figsize = get(gcf,'position');
set(gcf,'papersize',figsize(3:4));
hl = waterfall(x,y,p);
set(hl,'linewidth',1.5);
xlim([0,60])
% clim([-95,-60])
colormap jet
set(gca,'fontsize',14,'linewidth',2,'ytick',28:0.3:28.9)
hXLabel = xlabel('Frequency (MHz)','fontsize',14);
hYLabel = ylabel('Heater (mW)','fontsize',14);
zlabel('RF (dBm)','fontsize',14)
set(hYLabel,'rotation',96,'VerticalAlignment','middle')
set(hXLabel,'rotation',4,'HorizontalAlignment','center')
colorbar('eastoutside')
view(-5,80)
ylim([28,29])
% saveas(gcf,'evolution.eps')
% print -depsc -vector evolution
print -dpdf -vector evolution
