lw = 2;
fs = 14;
colors = ["#0072BD","#D95319","#EDB120","#7E2F8E","#77AC30","#4DBEEE","#A2142F"];
figure('Position',[100,500,320,230]);
set(gcf,'units','inches');
figsize = get(gcf,'position');
set(gcf,'papersize',figsize(3:4));

% hs1=subplot(2,1,1);
load('OPODemo.mat')
t = linspace(-pi,pi,length(cavityPulse));
cavityPulse = circshift(cavityPulse,floor(length(cavityPulse)/39));
plot(t,cavityPulse,'linewidth',lw,'color',colors(1))
hold on
% xlim([-pi,pi])
% ylim([0,40])
% set(gca,'fontsize',fs,'linewidth',lw,'xtick',[-pi,0,pi],'xticklabel',[],'yticklabel',[])
% hs2=subplot(2,1,2);
load('SolitonDemo.mat')
t = linspace(-pi,pi,length(cavityPulse));
plot(t,cavityPulse,'linewidth',lw,'color',colors(2))
xlim([-pi,pi])
ylim([0,60])
set(gca,'fontsize',fs,'linewidth',lw,'xtick',[-pi,-pi/2,0,pi/2,pi],'xticklabel',{'-\pi','-\pi/2','0','\pi/2','\pi'},'yticklabel',[])
xlabel('Angular Location','fontsize',fs)
ylabel('Power (arb. u.)','fontsize',fs)
% hs2.InnerPosition(2) = hs1.InnerPosition(2)-0.4;
legend('OPO in Cav.','Soliton in Cav.','box','off','fontsize',fs)
% print -depsc SynchroConcept
print -dpdf -vector SynchroConcept

load('Bifurcation.mat')
figure('Position',[100,500,200,210]);
set(gcf,'units','inches');
figsize = get(gcf,'position');
set(gcf,'papersize',figsize(3:4));

plot(a1,r1,'linewidth',lw,'color','k')
hold on
plot(a2,r2,'--','linewidth',lw,'color','k')
plot(a3,r3,'linewidth',lw,'color','k')
set(gca,'fontsize',fs,'linewidth',lw,'yticklabel',[])
xlabel('Normalized Detuning','fontsize',fs)
ylabel('Power (arb. u.)','fontsize',fs)
% print -depsc Bifurcation
print -dpdf -vector Bifurcation
