filepath = './';
filename = "OPOfullnoise7.txt";
fs = 14;
lw = 2;
A = readtable(fullfile(filepath,filename),'filetype','delimitedtext');
B = table2array(A);
freq = B(:,1);
signal = B(:,2);
idler = B(:,3);
diff = B(:,4);
pump = B(:,5);
therm = B(:,6);
figure('position',[100,500,360,340]);
set(gcf,'units','inches');
figsize = get(gcf,'position');
set(gcf,'papersize',figsize(3:4));
semilogx(freq,10*log10(therm./freq.^2),'linewidth',2);
hold on
semilogx(freq,10*log10(pump./freq.^2),'linewidth',2);
% semilogx(freq,10*log10(signal./freq.^2),'linewidth',2);
% semilogx(freq,10*log10(idler./freq.^2),'linewidth',2);
semilogx(freq,10*log10(diff./freq.^2),'linewidth',2);
%%STL
w_array = 10.^linspace(3,8,2000)*2*pi;
f_array = w_array/2/pi;
f_spec = linspace(-20,20,1000);
fwhmspec = 1.7*4;
spec = 4*pi*fwhmspec./w_array.^2;
linshape = 1./((f_spec*2/fwhmspec).^2+1);
semilogx(f_array,10*log10(spec),'--','linewidth',lw);
xlim([1e3,2e7])
% legend('TRN','Pump','Signal','Idler','Difference','STL','box','off','location','northeast')
legend('TRN','Pump','Differential','STL','edgecolor','w','location','northeast','fontsize',fs)
xlabel('Offset Frequency (Hz)','fontsize',fs)
ylabel('SSB Phase Noise (dBc/Hz)','fontsize',fs)
set(gca,'fontsize',fs,'linewidth',lw,'xtick',[1e3,1e4,1e5,1e6,1e7],'ytick',-200:20:0)
grid on
% print -depsc ClassicalSimulation
print -dpdf -vector ClassicalSimulation