filepath = './';
filename = 'W0008.CSV';
filename2 = 'WaveData20230815_018.csv';
colors = ["#0072BD","#D95319","#EDB120","#7E2F8E","#77AC30","#4DBEEE","#A2142F"];
fs = 14;
lw = 1;
calib1 = 10*log10(130)-7.9;
calib2 = 10*log10(560)-15.2;
A = readtable(fullfile(filepath,filename));
wl = A{22:end,1};
power = A{22:end,2}+calib1;
A = readtable(fullfile(filepath,filename2));
wl2 = A{29:end,1};
power2 = 10*log10(abs(A{29:end,2}))+calib2;
figure('position',[100,500,290,350],'DefaultAxesFontName', 'Arial')
set(gcf,'units','inches');
figsize = get(gcf,'position');
set(gcf,'papersize',figsize(3:4));

ht = tiledlayout(2,1,'tilespacing','tight');
nexttile
% hs1 = subplot(2,1,1);
plot(wl,power,'color',colors(1),'linewidth',lw);
% xlabel('Wavelength (nm)')
% ylabel('Power (dBm)')
xlim([1470,1650])
ylim([-40,30])
set(gca,'linewidth',2,'fontsize',fs,'xticklabel',[])
% hs2 = subplot(2,1,2);
nexttile
plot(wl2,power2,'color',colors(2),'linewidth',lw);
xlabel('Wavelength (nm)','fontsize',fs)
% ylabel('Power (dBm)')
xlim([1470,1650])
ylim([-40,30])
set(gca,'linewidth',2,'fontsize',fs)
ylabel(ht,'Optical Power (dBm)','fontsize',fs)
% print -depsc SynchroSpectrum
print -dpdf -vector SynchroSpectrum


