load('16GHzSynchro.mat')
figure('position',[100,500,500,330],'DefaultAxesFontName', 'Arial');
set(gcf,'units','inches');
figsize = get(gcf,'position');
set(gcf,'papersize',figsize(3:4));

semilogx(f4,10*log10(p4./f4.^2),'linewidth',1.5)
hold on
semilogx(f1,10*log10(p1./f1.^2),'linewidth',1.5)
semilogx(f2,p2,'linewidth',1.5)
semilogx(f3,p3,'linewidth',1.5)

legend('Pump, Self-Heterodyne','OPO, Self-Heterodyne','Free-Running, Electronic','Synchronized, Electronic', 'edgecolor','w','fontsize',14)
set(gca,'fontsize',14,'linewidth',2)
xlim([300,1e6])
ylim([-145,20])
xlabel('Offset Frequency (Hz)','fontsize',14)
ylabel('SSB Phase Noise (dBc/Hz)','fontsize',14)
grid on

% print -depsc 16GHzSync
print -dpdf -vector 16GHzSync