# The Rado Multiplicity Problem in Vector Spaces over Finite Fields

This repository contains the code accompanying the preprint "The Rado Multiplicity Problem in Vector Spaces over Finite Fields" by Juanjo Rué and Christoph Spiegel. In order to run the code, you need a working installation of [SageMath](http://www.sagemath.org/). I would recommend installing a version of `conda`, for example [Miniconda](https://conda.io/miniconda.html), and then creating a new environment containing all necessary packages through `conda create -n sage -c conda-forgePython=3.10 sage=9.8 numpy=1.24 tqdm` to install SageMath.

The code consists of a shared set of methods in `utilities.py` and a a script each to verify the upper and lower bounds presented in the paper. After activating your environment through `conda activate sage`, you can easily check all constructive upper bounds by running `python verify_upper_bounds.py`. The lower bounds can be verified by specifying one of the problems `Schur_q2_c3_N4`, `3AP_q3_c3_N2` (Theorem 1.2), and `4AP_q5_c2_N2` (Proposition 1.1) as an argument to `verify_lower_bounds.py` like `python verify_lower_bounds.py -p=4AP_q5_c2_N2`. Note that this will generate some files stored in your working directory that are used to cache the results of the computations. If you want to start from scratch, you can delete these files by running `rm *_colorings.npy *_densities.npy *_values.npy`.
