library(treeio)
library(paleotree)
library(strap)
library(phytools)
library(vioplot)
library(phangorn)
library(Claddis)
library(adephylo)
library(drc)

whichColor <- function(p, cols, breaks) {
        i <- 1
        while (p >= breaks[i] && p > breaks[i + 1]) i <- i + 
            1
        cols[i]
    }


########Also read in functions in supplementary data 7


##########
###
### Rates
###
##########

tree<-read.beast(file.choose()) ###### Read in tree and associated data



plot.tree<-tree@phylo##### extract phylogeny
plot.tree<-ladderize(plot.tree)

#####Fix root time with taxon of fixed age (Prolacerta)
prolacerta<-dateNodes(plot.tree)[which(plot.tree$tip.label=="Prolacerta_broomi")]
root<-max(dateNodes(plot.tree))
root.age <- root-prolacerta+251.69
plot.tree$root.time<-root.age




rates<-tree@data$rateIgrBrlens_mean##### extract rates
rates[rates=="-1.#IND00"]<-NA#####convert uncalculated rates to NA
rates<-as.numeric(rates)
rates<-log10(rates)


rate.nos<-as.numeric(tree@data$node)#####extract node numbers

######reorder rates to fit node numbers
plot.rates<-vector(length=0)
for(i in 1:nrow(plot.tree$edge))
{
		plot.rates<-c(plot.rates,rates[which(rate.nos==plot.tree$edge[i,2])])	
}


####
##Plot over tree
####

########assign colours to branches based on rate
cols <- colorRampPalette(c("blue","lightgrey","red"))
plot.rates[is.na(plot.rates)]<-min(plot.rates,na.rm=T)######unclaculated rates set to minimum (function can't plot NAs)
xlims <-range(plot.rates)
xlims[1]<-xlims[1]
xlims[2]<-xlims[2]
breaks <- 0:1000/1000 * (xlims[2] - xlims[1]) + xlims[1]
colors <- sapply(plot.rates, whichColor, cols = cols(1001), breaks = breaks)




geoscalePhylo(plot.tree,edge.col="black",boxes=F,units=c("Period","Epoch")
,cex.ts=0.8,cex.age=0.8,cex.tip=0.7,width=3
,direction="upwards",x.lim=c(320,220))


add.color.bar(20, cols(1001),title="Log Rates", lims=xlims,prompt=F)#, digits=digits,  prompt = FALSE)






####
#Rates through time
####

time<-seq(320,272)####Vector representing 1 my time clices


rates<-tree@data$rateIgrBrlens_mean#####extract rates
rates[rates=="-1.#IND00"]<-NA#####convert uncalculated rates to NA
rates<-as.numeric(rates)


####node ages of tree
node.ages<-dateNodes(plot.tree)
branch.ages<-matrix(nrow=nrow(plot.tree$edge), ncol=2)
for(i in 1:nrow(branch.ages))
{
	branch.ages[i,1]<-node.ages[plot.tree$edge[i,1]]
	branch.ages[i,2]<-node.ages[plot.tree$edge[i,2]]
}


######Branch rates
plot.rates<-vector(length=0)
for(i in 1:nrow(plot.tree$edge))
{
	plot.rates<-c(plot.rates,rates[which(rate.nos==plot.tree$edge[i,2])])	
}


#######Remove non-amniote rates
plot.rates[which(plot.tree$edge[,1]%in%99:102)]<-NA


#####Rates at each time slice
bin.rates<-vector(length=length(time),mode="list")
for(i in 1:length(time))
{
	bin.branch<-intersect(which(branch.ages[,1]>time[i]),which(branch.ages[,2]<time[i]))
	bin.rates[[i]]<-plot.rates[bin.branch]
}

med.rates<-unlist(lapply(bin.rates,median,na.rm=T))####median

####
##Plot through time
####


geoscaleBox(1,1,age.lim=c(max(time),min(time)),
data.lim=c(0.5,5),log=T,cex.age = 1,cex.ts=1,erotate=0,abbrev="age")

for(i in 1:length(plot.rates))
{
	if(is.na(plot.rates[i])==F)
	{
		lines(branch.ages[i,],c(plot.rates[i],plot.rates[i]))
	}
}


lines(time,med.rates,lwd=3)

long.rates<-loess(med.rates~time,data.frame(med.rates,time))
lines(time[4:49],predict(long.rates),lwd=5)




#######Synapsids vs reptiles


####Find synapsid and reptile nodes
rept.node<-getMRCA(plot.tree,c("Hylonomus_lyelli","Romeria_spp","Belebey_vegrandis"))
rept.nodes<-Descendants(plot.tree,rept.node,"all")
syn.node<-getMRCA(plot.tree,c("Casea_broilii","Dimetrodon_limbatus"))
syn.nodes<-Descendants(plot.tree,syn.node,"all")




####Rates in each clade
syn.bin.rates<-vector(length=length(time),mode="list")
rept.bin.rates<-vector(length=length(time),mode="list")

for(i in 1:length(time))
{
	bin.branch<-intersect(which(branch.ages[,1]>time[i]),which(branch.ages[,2]<time[i]))

	rept.bin.branch<-bin.branch[which(plot.tree$edge[bin.branch,2]%in%rept.nodes)]
	rept.bin.rates[[i]]<-plot.rates[rept.bin.branch]
	syn.bin.branch<-bin.branch[which(plot.tree$edge[bin.branch,2]%in%syn.nodes)]
	syn.bin.rates[[i]]<-plot.rates[syn.bin.branch]
}

####Median
syn.med.rates<-unlist(lapply(syn.bin.rates,median,na.rm=T))
rept.med.rates<-unlist(lapply(rept.bin.rates,median,na.rm=T))




#####Plot

geoscaleBox(1,1,age.lim=c(max(time),min(time)),
data.lim=c(0.9992,1.001),log=T,cex.age = 1,cex.ts=1,erotate=0,abbrev="age")
for(i in 1:length(plot.rates))
{
	if(is.na(plot.rates[i])==F)
	{
		if(plot.tree$edge[i,2]%in%rept.nodes)
		{
			lines(branch.ages[i,],c(plot.rates[i],plot.rates[i]),col="blue")
		}
		else if (plot.tree$edge[i,2]%in%syn.nodes)
		{
			lines(branch.ages[i,],c(plot.rates[i],plot.rates[i]),col="red")
		}
			
	}
}


lines(time,syn.med.rates,lwd=3,col="red")

syn.long.rates<-loess(syn.med.rates~time,data.frame(syn.med.rates,time))
lines(time[5:49],predict(syn.long.rates),lwd=5,col="red")

lines(time,rept.med.rates,lwd=3,col="blue")

rept.long.rates<-loess(rept.med.rates~time,data.frame(rept.med.rates,time))
lines(time[5:49],predict(rept.long.rates),lwd=5,col="blue")









################
###
### Analysis of Constraint
###
################


######
# Analysis preparation
######

timetree<-read.nexus(file.choose())####Read in time calibrated tree (only used for finding which taxa diverged within Carboniferous/Early Permian)
#####Fix root time with taxon of fixed age (Prolacerta)
prolacerta<-dateNodes(timetree)[which(timetree$tip.label=="Prolacerta_broomi")]
root<-max(dateNodes(timetree))
root.age <- root-prolacerta+251.69
timetree$root.time<-root.age


node.ages<-dateNodes (timetree)####node ages



morph.tree<-read.nexus(file.choose()) #####Read in tree where branch lengths represent 
morph.tree<-ladderize(morph.tree)


matrix<-ReadMorphNexus(file.choose()) #####Read in character taxon matrix
size<-read.csv(file.choose(),row.names=1)####Read in CSV of size data




dist<-MorphDistMatrix(matrix, Distance = "MORD",TransformDistances = "none")######Morphological distances
morph.dist<-TrimMorphDistMatrix(dist[[2]])[[1]]#####Trim out taxa with NAs




pat.dist<-as.matrix(distTips(morph.tree,method = "patristic"))####Patristic distances
pat.dist<-pat.dist[rownames(morph.dist),colnames(morph.dist)]






####Identify reptile and synapsid taxa

rept.node<-getMRCA(morph.tree,c("Hylonomus_lyelli","Romeria_spp","Belebey_vegrandis"))
rept.tax<-morph.tree$tip.label[Descendants(morph.tree,rept.node,"tips")[[1]]]
syn.node<-getMRCA(morph.tree,c("Casea_broilii","Dimetrodon_limbatus"))
syn.tax<-morph.tree$tip.label[Descendants(morph.tree,syn.node,"tips")[[1]]]


#####create matrix of clade groupings
clade<-matrix(nrow=length(morph.tree$tip.label),ncol=2,data=0) 
clade[,1]<-morph.tree$tip.label

clade[clade[,1]%in%syn.tax,2]<-1
clade[clade[,1]%in%rept.tax,2]<-2





####Create matrix of size groupings
size<-as.matrix(data.frame(rownames(size),size))
size[1:4,2]<-"0"#######those with state 0 are non-amniotes; not to be considered




#####
# Analysis
#####
######Pairwise comparisons
clade.pairs<-find.pairs(groups=clade,morph.dist,pat.dist)####clade groupings
size.pairs<-find.pairs(groups=size,morph.dist,pat.dist)####size groupings



#######Remove pairs which diverged after the Cisuralian
tbr<-vector(length=0)
for(i in 1:nrow(clade.pairs))
{
	anc<-findMRCA(timetree,c(as.character(clade.pairs[i,"Taxon 1"]),as.character(clade.pairs[i,"Taxon 2"])))
	anc.age<-node.ages[anc]
	if(anc.age<272.9)
	{
		tbr<-c(tbr,i)
	}
}
clade.pairs<-clade.pairs[-tbr,]

tbr<-vector(length=0)
for(i in 1:nrow(size.pairs))
{
	anc<-findMRCA(timetree,c(as.character(size.pairs[i,"Taxon 1"]),as.character(size.pairs[i,"Taxon 2"])))
	anc.age<-node.ages[anc]
	if(anc.age<272.9)
	{
		tbr<-c(tbr,i)
	}
}
size.pairs<-size.pairs[-tbr,]



#####Significant release/relaxation of constraints
sat.clade<-char.sat(morph.tree,matrix,clade.pairs,size,100)####clades
sat.size<-char.sat(morph.tree,matrix,size.pairs,size,100)

sat.clade#####remember, ignore state 0 (non-amniotes)
sat.size#####remember, ignore state 0 (non-amniotes)



############
####Plotting
############

####clade
plot.groups(data=clade.pairs,col.point=list(NULL,"red","blue"),col.line=list(NULL,"red","blue"),lwd.shadow=4,pch=16,lwd=2,cex=0.5)

legend("bottomright",legend=c("Synapsids","Reptiles"),
	fill=c("Red","Blue"),bty="n",cex=0.8)



####size
cols <- colorRampPalette(c( "goldenrod2", "dodgerblue2"))(4)


plot.groups(data=size.pairs,col.point=list(NULL,cols[1],cols[2],cols[3],cols[4])
	,col.line=list(NULL,cols[1],cols[2],cols[3],cols[4])
	,lwd.shadow=4,pch=16,lwd=2,cex=0.5)

legend("bottomright",legend=c("Small","Medium","Large","V. large"),
	fill=cols,bty="n",cex=0.8)







######Constraint over phylogeny
phylo.cons<-char.sat.phylo(morph.tree,matrix,clade.pairs,100)



####Plotting
par(mar=c(0,0,0,0))
plot(morph.tree,no.margin=T,direction="upwards")

nodelabels(node=phylo.cons$Released,pch=16,col="red")
nodelabels(node=phylo.cons$Constrained,pch=16,col="blue")





########
##
## Analysis of size evolution
##
########

timetree<-read.nexus(file.choose())####Read in time calibrated tree ]
#####Fix root time with taxon of fixed age (Prolacerta)
prolacerta<-dateNodes(timetree)[which(timetree$tip.label=="Prolacerta_broomi")]
root<-max(dateNodes(timetree))
root.age <- root-prolacerta+251.69
timetree$root.time<-root.age

size<-read.csv(file.choose(),row.names=1)####Read in CSV of size data






size.tree<-drop.tip(timetree,rownames(size)[is.na(size)])
size<-size[size.tree$tip.label,]
names(size)<-size.tree$tip.label




###########Model fitting

######Create a vector of reptile/synapsid affinity
clade<-size
clade[which(names(clade)%in%rept.tax)]<-1
clade[which(names(clade)%in%syn.tax)]<-2

#####Map reptile/synapsid over the tree
sim.tree<-make.simmap(size.tree, clade, model="ER")


#####Fit models
multi.ARD<-fitmultiMk(sim.tree, size, model="ARD")
multi.ER<-fitmultiMk(sim.tree, size, model="ER")

sing.ARD<-fitMk(size.tree,size,model="ARD")
sing.ER<-fitMk(size.tree,size,model="ER")



######Acestral state reconstruction
anc<-ace(size,size.tree,type="discrete",model="ARD")

####Plot Ancestral State reconstruction
cols <- colorRampPalette(c( "goldenrod2", "dodgerblue2"))(4)
plot(size.tree,direction="upwards",tip.col=cols[size],cex=0.5)
nodelabels(pie=anc$lik,piecol=cols,cex=0.4)
legend("bottomleft",legend=c("Small","Medium","Large","V. large"),fill=cols,cex=0.6)

